/*
 * Decompiled with CFR 0.152.
 */
class GraphicPatch
extends GimmickObject {
    public AnimationDrawer drawer;
    public static MFImage ropeImage;
    public static MFImage poalImage;
    public static Animation mapPatchAnimation;
    public static Animation holePatchAnimation;
    public static AnimationDrawer railPatchDrawer;
    public int moveDistance;
    public int direction;

    protected GraphicPatch(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        switch (this.iLeft) {
            case 0: {
                if (WaterFall.waterFallDrawer3 == null) {
                    WaterFall.waterFallDrawer3 = new Animation("/animation/sand_03").getDrawer(0, true, 0);
                    WaterFall.waterFallDrawer3.setPause(true);
                }
                this.drawer = WaterFall.waterFallDrawer3;
                break;
            }
            case 1: {
                if (TransPoint.caveAnimation == null) {
                    TransPoint.caveAnimation = new Animation("/animation/cave");
                }
                this.drawer = TransPoint.caveAnimation.getDrawer(1, true, 0);
                break;
            }
            case 2: {
                if (ropeImage != null) break;
                ropeImage = MFImage.createImage("/gimmick/rope_patch.png");
                break;
            }
            case 3: {
                if (mapPatchAnimation == null) {
                    mapPatchAnimation = new Animation(MapManager.image, "/animation/patch_st" + StageManager.getCurrentZoneId());
                }
                this.drawer = mapPatchAnimation.getDrawer(this.iTop, false, 0);
                this.mWidth = 12288;
                this.mHeight = 12288;
                break;
            }
            case 4: {
                if (holePatchAnimation == null) {
                    holePatchAnimation = new Animation("/animation/hole_patch");
                }
                this.drawer = holePatchAnimation.getDrawer(this.iTop, false, 0);
                this.posX += -32;
                this.posY += this.iTop == 0 ? -48 : -512;
                this.mWidth = 56;
                this.mHeight = 48;
                break;
            }
            case 5: {
                if (poalImage != null) break;
                poalImage = MFImage.createImage("/gimmick/poal_patch.png");
                break;
            }
            case 6: {
                if (railPatchDrawer == null) {
                    railPatchDrawer = new Animation("/animation/rail_patch_2").getDrawer();
                }
                this.direction = n6;
                this.moveDistance = n7;
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        block0 : switch (this.iLeft) {
            case 0: {
                MyAPI.setClip(mFGraphics, (this.collisionRect.x0 >> 6) - GameObject.camera.x, (this.collisionRect.y0 >> 6) - GameObject.camera.y, this.collisionRect.getWidth() >> 6, this.collisionRect.getHeight() >> 6);
                for (int i = this.collisionRect.y0; i < this.collisionRect.y1; i += 6144) {
                    this.drawInMap(mFGraphics, this.drawer, this.posX, i);
                }
                MyAPI.setClip(mFGraphics, 0, 0, Def.SCREEN_WIDTH, Def.SCREEN_HEIGHT);
                break;
            }
            case 1: {
                this.drawInMap(mFGraphics, this.drawer);
                break;
            }
            case 2: {
                int n = this.collisionRect.y0;
                int n2 = 0;
                while (n < this.collisionRect.y1) {
                    if (this.iTop == 0) {
                        this.drawInMap(mFGraphics, ropeImage, this.posX + n2, n, 20);
                    } else {
                        this.drawInMap(mFGraphics, ropeImage, 0, 0, MyAPI.zoomIn(ropeImage.getWidth(), true), MyAPI.zoomIn(ropeImage.getHeight(), true), 2, this.posX - n2 + this.mWidth, n, 24);
                    }
                    n += 512;
                    n2 += 1024;
                }
                break;
            }
            case 3: {
                this.drawInMap(mFGraphics, this.drawer, this.posX, this.posY);
                break;
            }
            case 4: {
                this.drawInMap(mFGraphics, this.drawer, this.posX - -32, this.posY - (this.iTop == 0 ? -48 : 0));
                break;
            }
            case 5: {
                MyAPI.setClip(mFGraphics, (this.collisionRect.x0 >> 6) - GameObject.camera.x, (this.collisionRect.y0 >> 6) - GameObject.camera.y, 512, this.collisionRect.getHeight() >> 6);
                for (int i = this.posY; i < this.posY + this.collisionRect.getHeight(); i += 1024) {
                    this.drawInMap(mFGraphics, poalImage, this.posX + 128, i, 17);
                }
                MyAPI.setClip(mFGraphics, 0, 0, Def.SCREEN_WIDTH, Def.SCREEN_HEIGHT);
                break;
            }
            case 6: {
                int n = this.posX + RollIsland.DIRECTION[this.direction][0] * (this.moveDistance / 1024 * 1024);
                int n3 = this.posY + RollIsland.DIRECTION[this.direction][1] * (this.moveDistance / 1024 * 1024);
                int n4 = this.posX;
                int n5 = this.posY;
                if (this.posX > n) {
                    n4 = n;
                    n5 = n3;
                    n = this.posX;
                    n3 = this.posY;
                } else if (this.posY > n3 && RollIsland.DIRECTION[this.direction][1] * RollIsland.DIRECTION[this.direction][0] != -1) {
                    n4 = n;
                    n5 = n3;
                    n = this.posX;
                    n3 = this.posY;
                }
                if (n4 == n) {
                    MyAPI.setClip(mFGraphics, 0, (n5 >> 6) - GameObject.camera.y, Def.SCREEN_WIDTH, Math.abs(n3 - n5) >> 6);
                } else if (n5 == n3) {
                    MyAPI.setClip(mFGraphics, (n4 >> 6) - GameObject.camera.x, 0, Math.abs(n - n4) >> 6, Def.SCREEN_HEIGHT);
                } else {
                    MyAPI.setClip(mFGraphics, (n4 >> 6) - GameObject.camera.x - 2, (Math.min(n5, n3) >> 6) - GameObject.camera.y - 2, (Math.abs(n - n4) >> 6) + 4, (Math.abs(n3 - n5) >> 6) + 4);
                }
                for (int i = 0; i < this.moveDistance; i += 1024) {
                    int n6;
                    int n7;
                    if (RollIsland.DIRECTION[this.direction][1] * RollIsland.DIRECTION[this.direction][0] == -1) {
                        n7 = n4 + RollIsland.DIRECTION[this.direction][0] * i;
                        n6 = n5 + RollIsland.DIRECTION[this.direction][1] * i;
                    } else {
                        n7 = n4 + (RollIsland.DIRECTION[this.direction][0] != 0 ? i : 0);
                        n6 = n5 + (RollIsland.DIRECTION[this.direction][1] != 0 ? i : 0);
                    }
                    switch (this.direction) {
                        case 2: 
                        case 6: {
                            railPatchDrawer.setActionId(0);
                            break;
                        }
                        case 0: 
                        case 4: {
                            railPatchDrawer.setActionId(1);
                            break;
                        }
                        case 3: 
                        case 7: {
                            railPatchDrawer.setActionId(6);
                            break;
                        }
                        case 1: 
                        case 5: {
                            railPatchDrawer.setActionId(7);
                        }
                    }
                    this.drawInMap(mFGraphics, railPatchDrawer, n7, n6);
                }
                MyAPI.setClip(mFGraphics, 0, 0, Def.SCREEN_WIDTH, Def.SCREEN_HEIGHT);
                switch (this.direction) {
                    case 2: 
                    case 6: {
                        railPatchDrawer.setActionId(3);
                        this.drawInMap(mFGraphics, railPatchDrawer, n4, n5);
                        railPatchDrawer.setActionId(2);
                        this.drawInMap(mFGraphics, railPatchDrawer, n, n3);
                        break block0;
                    }
                    case 0: 
                    case 4: {
                        railPatchDrawer.setActionId(5);
                        this.drawInMap(mFGraphics, railPatchDrawer, n4, n5);
                        railPatchDrawer.setActionId(4);
                        this.drawInMap(mFGraphics, railPatchDrawer, n, n3);
                        break block0;
                    }
                    case 3: 
                    case 7: {
                        railPatchDrawer.setActionId(8);
                        this.drawInMap(mFGraphics, railPatchDrawer, n4, n5);
                        railPatchDrawer.setActionId(9);
                        this.drawInMap(mFGraphics, railPatchDrawer, n, n3);
                        break block0;
                    }
                    case 1: 
                    case 5: {
                        railPatchDrawer.setActionId(10);
                        this.drawInMap(mFGraphics, railPatchDrawer, n4, n5);
                        railPatchDrawer.setActionId(11);
                        this.drawInMap(mFGraphics, railPatchDrawer, n, n3);
                    }
                }
            }
        }
    }

    public int getPaintLayer() {
        switch (this.iLeft) {
            case 1: 
            case 6: {
                return 0;
            }
            case 3: {
                if (this.iTop != 1) break;
                return 2;
            }
        }
        return super.getPaintLayer();
    }

    public void refreshCollisionRect(int n, int n2) {
        switch (this.iLeft) {
            case 3: {
                this.collisionRect.setRect(n + -6144, n2 + -2048, this.mWidth, this.mHeight);
                break;
            }
            case 6: {
                int n3 = this.posX + RollIsland.DIRECTION[this.direction][0] * this.moveDistance;
                int n4 = this.posY + RollIsland.DIRECTION[this.direction][1] * this.moveDistance;
                int n5 = this.posX;
                int n6 = this.posY;
                this.collisionRect.setRect(Math.min(n5, n3), Math.min(n6, n4), Math.abs(n5 - n3), Math.abs(n6 - n4));
                break;
            }
            default: {
                this.collisionRect.setRect(n, n2, this.mWidth, this.mHeight);
            }
        }
    }

    public void close() {
        this.drawer = null;
    }

    public static void releaseAllResource() {
        ropeImage = null;
        mapPatchAnimation = null;
        holePatchAnimation = null;
        poalImage = null;
        railPatchDrawer = null;
    }
}

