/*
 * Decompiled with CFR 0.152.
 */
class LightFont
extends GimmickObject {
    public static Animation[] lightFontAnimation;
    public AnimationDrawer drawer;
    public int logicDelay;

    protected LightFont(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (lightFontAnimation == null) {
            lightFontAnimation = new Animation[8];
        }
        if (lightFontAnimation[n4] == null) {
            try {
                MFImage mFImage = MFImage.createImage("/animation/light_font_" + n4 + ".png");
                LightFont.lightFontAnimation[n4] = new Animation(mFImage, "/animation/light_font");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.drawer = lightFontAnimation[n4].getDrawer(1, false, 0);
        this.drawer.setPause(true);
        this.logicDelay = n6;
    }

    public void logic() {
        this.drawer.moveOn();
        if (this.drawer.checkEnd()) {
            if (this.drawer.getActionId() == 0) {
                this.drawer.setActionId(1);
            } else if (this.drawer.getActionId() == 2) {
                this.drawer.setActionId(3);
            }
        }
        if ((GameObject.systemClock + 90L + 48L - (long)this.logicDelay) % 138L < 48L) {
            if (this.drawer.getActionId() == 1) {
                this.drawer.setActionId(2);
            }
        } else if (this.drawer.getActionId() == 3) {
            this.drawer.setActionId(0);
        }
        this.refreshCollisionRect(this.posX, this.posY);
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 768, n2 - 896, 1536, 1792);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.drawer.getActionId() == 3) {
            playerObject.cancelFootObject(this);
            return;
        }
        playerObject.beStop(this.collisionRect.x0, n, this);
    }

    public void close() {
        this.drawer = null;
    }

    public static void releaseAllResource() {
        if (lightFontAnimation != null) {
            for (int i = 0; i < lightFontAnimation.length; ++i) {
                LightFont.lightFontAnimation[i] = null;
            }
            lightFontAnimation = null;
        }
    }
}

