/*
 * Decompiled with CFR 0.152.
 */
class MonkeyBullet
extends BulletObject {
    public int state;
    public int boom_cnt;
    public int drop_cnt;
    public boolean isboom;
    public boolean isbooming;

    protected MonkeyBullet(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4, true);
        if (BulletObject.monkeybulletAnimation == null) {
            BulletObject.monkeybulletAnimation = new Animation("/animation/monkey_bullet");
        }
        this.drawer = BulletObject.monkeybulletAnimation.getDrawer(0, true, 0);
        this.isboom = false;
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (playerObject == GameObject.player && GameObject.player.canBeHurt()) {
            GameObject.player.beHurt();
            this.state = 1;
            this.boom_cnt = 10;
        }
    }

    public void bulletLogic() {
        int n = this.posX;
        int n2 = this.posY;
        switch (this.state) {
            case 0: {
                this.isbooming = false;
                this.drawer.setActionId(0);
                this.drawer.setLoop(true);
                this.boom_cnt = 0;
                this.posX += this.velX;
                this.velY += GameObject.GRAVITY;
                this.posY += this.velY;
                if (this.posY + 416 >= this.getGroundY(this.posX, this.posY)) {
                    this.posY = this.getGroundY(this.posX, this.posY) - 416;
                    switch (this.drop_cnt) {
                        case 0: {
                            this.velY = -450;
                            this.drop_cnt = 1;
                            break;
                        }
                        case 1: {
                            this.velY = -300;
                            this.drop_cnt = 2;
                            break;
                        }
                        case 2: {
                            this.state = 1;
                        }
                    }
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 1: {
                if (this.boom_cnt < 10) {
                    ++this.boom_cnt;
                } else {
                    this.drawer.setActionId(1);
                    this.drawer.setLoop(false);
                    this.isbooming = true;
                }
                if (this.drawer.checkEnd() && this.isbooming) {
                    this.isboom = true;
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
    }

    public boolean chkDestroy() {
        if (this.isbooming) {
            return this.isboom;
        }
        return super.chkDestroy();
    }

    public void draw(MFGraphics mFGraphics) {
        if (!this.isboom) {
            this.drawInMap(mFGraphics, this.drawer);
        }
        this.collisionRect.draw(mFGraphics, GameObject.camera);
    }

    public void refreshCollisionRect(int n, int n2) {
        if (!this.isbooming) {
            this.collisionRect.setRect(n - 320, n2 - 416, 640, 832);
        } else {
            this.collisionRect.setRect(n - 800, n2 - 800, 1600, 1600);
        }
    }
}

