/*
 * Decompiled with CFR 0.152.
 */
class RabbitFish
extends EnemyObject {
    public int velocity = 140;
    public int limitLeftX;
    public int limitRightX;
    public int starty;
    public static Animation fishAnimation;
    public int state;
    public int move_cnt = 0;
    public int defend_cnt = 0;
    public int defend_frame = 16;
    public int alert_state;

    public static void releaseAllResource() {
        fishAnimation = null;
    }

    protected RabbitFish(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.mWidth = 4096;
        this.limitLeftX = this.posX;
        this.limitRightX = this.posX + this.mWidth;
        this.posX += this.mWidth >> 1;
        this.starty = this.posY;
        if (fishAnimation == null) {
            fishAnimation = new Animation("/animation/rabbit_fish");
        }
        this.drawer = fishAnimation.getDrawer(0, true, 0);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.dead) {
            return;
        }
        if (playerObject == GameObject.player) {
            if (GameObject.player.isAttackingEnemy() && this.state == 0) {
                GameObject.player.doAttackPose(this, n);
                this.beAttack();
                SoundSystem.getInstance().playSe(2, false);
            } else {
                GameObject.player.beHurt();
            }
        }
    }

    public boolean IsFacetoPlayer() {
        return this.posX > GameObject.player.getFootPositionX() && this.velocity < 0 || this.posX < GameObject.player.getFootPositionX() && this.velocity > 0;
    }

    public void logic() {
        if (this.dead) {
            return;
        }
        int n = this.posX;
        int n2 = this.posY;
        switch (this.state) {
            case 0: {
                this.alert_state = this.checkPlayerInEnemyAlertRange(this.posX >> 6, this.posY >> 6, 80, 80);
                if (this.velocity > 0) {
                    this.posX += this.velocity;
                    this.move_cnt += Math.abs(this.velocity);
                    this.drawer.setActionId(0);
                    this.drawer.setTrans(2);
                    if (this.posX >= this.limitRightX) {
                        this.posX = this.limitRightX;
                        this.velocity = -this.velocity;
                    }
                } else {
                    this.posX += this.velocity;
                    this.move_cnt += Math.abs(this.velocity);
                    this.drawer.setActionId(0);
                    this.drawer.setTrans(0);
                    if (this.posX <= this.limitLeftX) {
                        this.posX = this.limitLeftX;
                        this.velocity = -this.velocity;
                    }
                }
                if (this.alert_state == 0 && this.IsFacetoPlayer() && this.move_cnt >= 5120) {
                    this.state = 1;
                    this.drawer.setActionId(1);
                    this.defend_cnt = 0;
                    this.move_cnt = 0;
                    if (this.velocity > 0) {
                        this.drawer.setTrans(2);
                    } else {
                        this.drawer.setTrans(0);
                    }
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
                break;
            }
            case 1: {
                if (this.defend_cnt < this.defend_frame) {
                    ++this.defend_cnt;
                } else {
                    this.state = 0;
                    this.drawer.setActionId(0);
                    if (this.velocity > 0) {
                        this.drawer.setTrans(2);
                    } else {
                        this.drawer.setTrans(0);
                    }
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.dead) {
            return;
        }
        this.drawInMap(mFGraphics, this.drawer);
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 768, n2 - 768, 1536, 1536);
    }
}

