/*
 * Decompiled with CFR 0.152.
 */
class Ship
extends GimmickObject {
    public static MFImage shipImage;
    public ShipSystem system;

    protected Ship(int n, int n2, int n3, ShipSystem shipSystem) {
        super(n, n2, n3, 0, 0, 0, 0);
        this.system = shipSystem;
        if (shipImage == null) {
            try {
                shipImage = MFImage.createImage("/gimmick/ship.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void logic() {
        this.system.getNewShipPosition(this);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 2112, n2 + 768, 4224, 192);
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, shipImage, this.posX, this.posY + 768 + 192, 40);
        this.drawInMap(mFGraphics, shipImage, 0, 0, MyAPI.zoomIn(shipImage.getHeight()), MyAPI.zoomIn(shipImage.getWidth()), 2, this.posX, this.posY + 768 + 192, 36);
        this.drawCollisionRect(mFGraphics);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (GameObject.player.isFootOnObject(this)) {
            return;
        }
        switch (n) {
            case 1: {
                playerObject.beStop(this.collisionRect.y0, n, this);
            }
        }
    }

    public void close() {
        this.system = null;
    }

    public static void releaseAllResource() {
        shipImage = null;
    }
}

