/*
 * Decompiled with CFR 0.152.
 */
class UpArm
extends GimmickObject {
    public int upLimit;
    public static MFImage image;
    public int waitCount;
    public byte state;
    public CollisionRect collisionRect2;

    protected UpArm(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.upLimit = this.posY - 7680;
        this.posX += 128;
        if (image == null) {
            try {
                image = MFImage.createImage("/gimmick/up_arm.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        int n;
        for (n = this.upLimit; n < this.posY - 896 - 2048; n += 2048) {
            this.drawInMap(mFGraphics, image, 10, 0, 4, 32, 0, this.posX, n, 17);
        }
        if (n < this.posY - 896) {
            this.drawInMap(mFGraphics, image, 10, 0, 4, this.posY - 896 - n >> 6, 0, this.posX, n, 17);
        }
        this.drawInMap(mFGraphics, image, 0, 32, 24, 19, 0, this.posX, this.posY - 896, 17);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.collisionRect2.collisionChk(playerObject.collisionRect)) {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    playerObject.setOutOfControl(this);
                    GameObject.player.doPullMotion(this.posX, this.posY + 128);
                }
            }
        }
    }

    public void logic() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        switch (this.state) {
            case 1: {
                this.posY -= 250;
                if (this.posY < this.upLimit) {
                    this.posY = this.upLimit;
                }
                GameObject.player.doPullMotion(this.posX, this.posY + 128);
                if (!Key.press(Key.gUp | 0x1000000)) break;
                GameObject.player.outOfControl = false;
                GameObject.player.doJump();
                this.state = (byte)2;
                this.waitCount = 15;
                break;
            }
            case 2: {
                if (this.waitCount != 0) break;
                this.state = (byte)3;
                break;
            }
            case 3: {
                this.posY += 250;
                if (this.posY < this.upLimit + 7680) break;
                this.posY = this.upLimit + 7680;
                this.state = 0;
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 768, this.upLimit, 1536, n2 - this.upLimit <= 0 ? 1 : n2 - this.upLimit);
        if (this.collisionRect2 == null) {
            this.collisionRect2 = new CollisionRect();
        }
        this.collisionRect2.setRect(n - 448, n2, 896, 320);
    }
}

