/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public abstract class GLLib
extends Canvas
implements Runnable {
    public static Graphics g = null;
    private static Graphics s_lastPaintGraphics = null;
    static boolean s_game_isPaused;
    static int s_game_state;
    private static long s_game_timeWhenFrameStart;
    private static long s_game_lastFrameTime;
    static boolean s_game_interruptNotify;
    static int s_screenWidth;
    static int s_screenHeight;
    private static Display s_display;
    private static boolean s_game_isInPaint;
    private static MIDlet s_application;
    private static int m_FPSLimiter;
    private long m_frameCoheranceTimer;
    private static int m_customSleepTime;
    private static Image m_imgBackBuffer;
    private static Graphics m_gBackBuffer;
    private static boolean m_bBackBufferEnabled;
    static int s_game_frameDT;
    private static long s_game_frameDTTimer;
    private static int s_game_totalExecutionTime;
    static int s_game_currentFrameNB;
    static GLLib s_gllib_instance;
    private static int m_keys_pressed;
    private static int m_keys_released;
    private static int m_keys_state;
    private static int m_current_keys_state;
    private static int m_current_keys_pressed;
    private static int m_current_keys_released;
    private static int m_last_key_pressed;
    private static int s_keysDisabledTimer;
    private static Hashtable standardKeyTable;
    private static Hashtable gameActionKeyTable;
    static final int s_math_F_1;
    private static Random s_math_random;
    static int s_math_bezierX;
    static int s_math_bezierY;
    private static int[] s_math_cosTable;
    private static int[] s_math_aTanTable;
    static final int Math_AngleMUL;
    static final int Math_Angle90;
    private static int Math_Angle180;
    private static int Math_Angle270;
    private static int Math_Angle360;
    private static int Math_FixedPoint_PI;
    private static String s_pack_filename;
    private static InputStream s_pack_is;
    private static int s_pack_curOffset;
    private static short s_pack_nbData;
    private static int[] s_pack_offset;
    private static short s_pack_subPack_nbOf;
    private static short[] s_pack_subPack_fat;
    private static int s_pack_subPack_curSubPack;
    static int s_pack_lastDataReadMimeType;
    private static boolean s_pack_lastDataIsCompress;
    private static byte[] s_Pack_SkipBuffer;
    private static byte[][] MIME_type;
    private static int Stream_readOffset;
    private static int text_nbString;
    private static String text_encoding;
    private static byte[] text_array;
    private static int[] text_arrayOffset;
    private static String[] text_stringCacheArray;
    private static RecordStore s_rs;
    private static int s_alphaRectCurrentARGB;
    private static int[] s_alphaRectARGBData;
    private static boolean pfx_usingScreenBuffer;
    static final boolean pfx_useSpriteEffects;
    private static boolean s_PFX_initializd;
    static int s_PFX_type;
    static int[][] s_PFX_params;
    private static Image s_PFX_screenBuffer;
    private static Graphics s_PFX_screenBufferG;
    private static int s_PFX_enableScreenBuffer;
    private static int s_PFX_enableScreenBufferThisFrame;

    abstract void Game_update() throws Exception;

    public GLLib(Object object, Object object2) {
        s_gllib_instance = this;
        s_game_state = -1;
        s_game_isInPaint = true;
        s_application = (MIDlet)object;
        s_display = (Display)object2;
        this.SetupDisplay();
        gameActionKeyTable = new Hashtable();
        standardKeyTable = new Hashtable<Integer, Integer>();
        standardKeyTable.put(new Integer(48), new Integer(6));
        standardKeyTable.put(new Integer(49), new Integer(7));
        standardKeyTable.put(new Integer(50), new Integer(1));
        standardKeyTable.put(new Integer(51), new Integer(9));
        standardKeyTable.put(new Integer(52), new Integer(3));
        standardKeyTable.put(new Integer(53), new Integer(5));
        standardKeyTable.put(new Integer(54), new Integer(4));
        standardKeyTable.put(new Integer(55), new Integer(13));
        standardKeyTable.put(new Integer(56), new Integer(2));
        standardKeyTable.put(new Integer(57), new Integer(15));
        standardKeyTable.put(new Integer(35), new Integer(17));
        standardKeyTable.put(new Integer(42), new Integer(16));
        if (GLLibConfig.softkeyOKOnLeft) {
            standardKeyTable.put(new Integer(GLLibConfig.keycodeLeftSoftkey), new Integer(18));
            standardKeyTable.put(new Integer(GLLibConfig.keycodeRightSoftkey), new Integer(19));
        } else {
            standardKeyTable.put(new Integer(GLLibConfig.keycodeLeftSoftkey), new Integer(19));
            standardKeyTable.put(new Integer(GLLibConfig.keycodeRightSoftkey), new Integer(18));
        }
        gameActionKeyTable.put(new Integer(GLLibConfig.keycodeFire), new Integer(5));
        gameActionKeyTable.put(new Integer(GLLibConfig.keycodeUp), new Integer(1));
        gameActionKeyTable.put(new Integer(GLLibConfig.keycodeDown), new Integer(2));
        gameActionKeyTable.put(new Integer(GLLibConfig.keycodeLeft), new Integer(3));
        gameActionKeyTable.put(new Integer(GLLibConfig.keycodeRight), new Integer(4));
        this.m_frameCoheranceTimer = s_game_frameDTTimer = System.currentTimeMillis();
    }

    protected final void Init() {
        if (s_game_state >= 0) {
            return;
        }
        s_screenWidth = GLLibConfig.screenWidth;
        s_screenHeight = GLLibConfig.screenHeight;
        long l = System.currentTimeMillis();
        if (s_math_random == null) {
            s_math_random = new Random(l);
        } else {
            s_math_random.setSeed(l);
        }
        s_game_state = 0;
        if (GLLibConfig.useCallSerially) {
            if (s_display != null) {
                s_display.callSerially((Runnable)this);
                return;
            }
        } else {
            new Thread(this).start();
        }
    }

    protected static void Pause() {
        if (!s_game_isPaused) {
            s_game_isPaused = true;
            GLLibPlayer.Snd_PauseNotify();
        }
    }

    protected final void Resume() {
        if (s_game_isPaused) {
            long l;
            s_game_timeWhenFrameStart = l = System.currentTimeMillis();
            s_game_frameDTTimer = l;
            this.m_frameCoheranceTimer = l;
            s_game_isPaused = false;
            this.SetupDisplay();
            s_game_interruptNotify = true;
            if (GLLibConfig.useRepaintAtResume && !s_game_isInPaint) {
                this.repaint();
            }
            GLLib.ResetKey();
        }
    }

    public void hideNotify() {
        GLLib.Pause();
    }

    public void showNotify() {
        this.Resume();
    }

    public void sizeChanged(int n, int n2) {
        s_screenWidth = n;
        s_screenHeight = n2;
    }

    private void SetupDisplay() {
        if (s_display != null && s_display.getCurrent() != this) {
            s_display.setCurrent((Displayable)this);
        }
        this.setFullScreenMode(true);
    }

    public void run() {
        try {
            if (!GLLibConfig.useCallSerially) {
                this.SetupDisplay();
            }
            s_game_isInPaint = false;
            while (s_game_state >= 0) {
                if (!s_game_isPaused) {
                    this.repaint();
                    if (GLLibConfig.useServiceRepaints) {
                        this.serviceRepaints();
                    }
                    s_game_interruptNotify = false;
                    long l = System.currentTimeMillis();
                    this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, l);
                    if (GLLibConfig.useSleepInsteadOfYield) {
                        Thread.sleep(Math.max(1L, (long)m_FPSLimiter - (l - this.m_frameCoheranceTimer)));
                    } else {
                        while (l - this.m_frameCoheranceTimer < (long)m_FPSLimiter) {
                            Thread.yield();
                            l = System.currentTimeMillis();
                            this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, l);
                        }
                    }
                    this.m_frameCoheranceTimer = System.currentTimeMillis();
                } else {
                    this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, System.currentTimeMillis());
                    if (GLLibConfig.useSleepInsteadOfYield) {
                        Thread.sleep(GLLibConfig.sleepDurationWhenSuspended);
                    } else {
                        Thread.yield();
                    }
                }
                if (!GLLibConfig.useCallSerially) continue;
                s_display.callSerially((Runnable)this);
                return;
            }
        }
        catch (Exception exception) {
            s_game_state = -1;
        }
        MIME_type = null;
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
        s_application.notifyDestroyed();
    }

    public void paint(Graphics graphics) {
        if (GLLibConfig.useFakeInterruptHandling) {
            long l = System.currentTimeMillis() - s_game_lastFrameTime;
            s_game_lastFrameTime = System.currentTimeMillis();
            if (l > (long)GLLibConfig.FakeInterruptThreshold && s_game_lastFrameTime != 0L) {
                GLLib.Pause();
                this.Resume();
            }
        }
        if (s_game_isPaused || s_game_isInPaint) {
            return;
        }
        s_game_isInPaint = true;
        m_keys_pressed = m_current_keys_pressed;
        m_keys_released = m_current_keys_released;
        m_keys_state = m_current_keys_state;
        m_current_keys_pressed = 0;
        m_current_keys_released = 0;
        if (s_keysDisabledTimer > 0) {
            if (GLLibConfig.useFrameDT && s_keysDisabledTimer != Integer.MAX_VALUE) {
                s_keysDisabledTimer -= s_game_frameDT;
            }
            GLLib.ResetKey();
        }
        s_game_timeWhenFrameStart = System.currentTimeMillis();
        if (GLLibConfig.useFrameDT) {
            s_game_frameDT = (int)(s_game_timeWhenFrameStart - s_game_frameDTTimer);
            if (s_game_frameDT < 0) {
                s_game_frameDT = 0;
            }
            if (s_game_frameDT > 1000) {
                s_game_frameDT = 1000;
            }
            s_game_frameDTTimer = s_game_timeWhenFrameStart;
            s_game_totalExecutionTime += s_game_frameDT;
        }
        ++s_game_currentFrameNB;
        try {
            if (pfx_usingScreenBuffer && s_PFX_enableScreenBuffer != 0) {
                s_lastPaintGraphics = null;
                g = null;
            } else {
                g = s_lastPaintGraphics = graphics;
            }
            this.Game_update();
        }
        catch (Exception exception) {
            s_game_state = -1;
        }
        s_game_isInPaint = false;
    }

    protected void keyPressed(int n) {
        int n2 = 1 << GLLib.Game_TranslateKeyCode(n);
        m_current_keys_pressed |= n2;
        m_current_keys_state |= n2;
    }

    protected void keyReleased(int n) {
        int n2 = 1 << GLLib.Game_TranslateKeyCode(n);
        m_current_keys_released |= n2;
        m_current_keys_state &= ~n2;
    }

    public static void Game_KeySetKeyCode(boolean bl, int n, int n2) {
        Hashtable hashtable = standardKeyTable;
        Integer n3 = new Integer(n);
        Integer n4 = (Integer)hashtable.get(n3);
        if (n4 != null) {
            hashtable.remove(n3);
        }
        hashtable.put(n3, new Integer(n2));
    }

    private static byte Game_TranslateKeyCode(int n) {
        Integer n2 = new Integer(n);
        if (standardKeyTable == null) {
            return 0;
        }
        Integer n3 = (Integer)standardKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        n3 = (Integer)gameActionKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        return 0;
    }

    public static void ResetKey() {
        m_keys_pressed = 0;
        m_keys_released = 0;
        m_keys_state = 0;
        m_current_keys_state = 0;
        m_current_keys_pressed = 0;
        m_current_keys_released = 0;
    }

    public static boolean IsKeyDown(int n) {
        return (m_keys_state & 1 << n) != 0;
    }

    public static int WasAnyKeyPressed() {
        if (m_keys_pressed == 0) {
            return -1;
        }
        int n = 24;
        while (--n >= 0) {
            if ((m_keys_pressed & 1 << n) == 0) continue;
            return n;
        }
        return -1;
    }

    public static int WasAnyKeyReleased() {
        if (m_keys_released == 0) {
            return -1;
        }
        int n = 24;
        while (--n >= 0) {
            if ((m_keys_released & 1 << n) == 0) continue;
            return n;
        }
        return -1;
    }

    public static boolean WasKeyPressed(int n) {
        return (m_keys_pressed & 1 << n) != 0;
    }

    public static boolean WasKeyReleased(int n) {
        return (m_keys_released & 1 << n) != 0;
    }

    static void Math_Init(String string, int n, int n2) throws Exception {
        GLLib.Pack_Open(string);
        s_math_cosTable = (int[])GLLib.Pack_ReadArray(0);
        GLLib.Pack_ReadArray(1);
        GLLib.Pack_Close();
    }

    static int Math_Rand(int n, int n2) {
        if (n2 != n) {
            int n3 = s_math_random.nextInt();
            if (n3 < 0) {
                n3 = -n3;
            }
            return n + n3 % (n2 - n);
        }
        return n2;
    }

    static int Math_Cos(int n) {
        if (n < 0) {
            n = -n;
        }
        if ((n &= Math_Angle360 - 1) <= Math_Angle90) {
            return s_math_cosTable[n];
        }
        if (n < Math_Angle180) {
            n = Math_Angle180 - n;
            return -s_math_cosTable[n];
        }
        if (n <= Math_Angle270) {
            return -s_math_cosTable[n -= Math_Angle180];
        }
        n = Math_Angle360 - n;
        return s_math_cosTable[n];
    }

    private static int Math_Tan(int n) {
        int n2 = GLLib.Math_Cos(n);
        if (n2 == 0) {
            return Integer.MAX_VALUE;
        }
        n = GLLib.Math_Cos(Math_Angle90 - n);
        return (n << GLLibConfig.math_fixedPointBase) / n2;
    }

    private static int Math_AtanSlow(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            if (GLLib.Math_Tan(i) > n3 || n3 >= GLLib.Math_Tan(i + 1)) continue;
            return i;
        }
        if (n == Math_Angle90 || n2 == Math_Angle90) {
            return Math_Angle90;
        }
        if (n == Math_Angle270 || n2 == Math_Angle270) {
            return Math_Angle270;
        }
        return 0;
    }

    private static int Math_AtanSlow(int n, int n2) {
        if (n > 0) {
            if (n2 > 0) {
                return GLLib.Math_AtanSlow(0, Math_Angle90, n2 * s_math_F_1 / n);
            }
            if (n2 == 0) {
                return 0;
            }
            return GLLib.Math_AtanSlow(Math_Angle270, Math_Angle360, n2 * s_math_F_1 / n);
        }
        if (n == 0) {
            if (n2 > 0) {
                return Math_Angle90;
            }
            if (n2 == 0) {
                return 0;
            }
            return Math_Angle270;
        }
        if (n2 > 0) {
            return GLLib.Math_AtanSlow(Math_Angle90, Math_Angle180, n2 * s_math_F_1 / n);
        }
        if (n2 == 0) {
            return Math_Angle180;
        }
        return GLLib.Math_AtanSlow(Math_Angle180, Math_Angle270, n2 * s_math_F_1 / n);
    }

    static int Math_Atan(int n, int n2) {
        if (GLLibConfig.math_AtanUseCacheTable) {
            int n3;
            if (s_math_aTanTable == null) {
                s_math_aTanTable = new int[s_math_F_1 + 1];
                for (n3 = 0; n3 < s_math_F_1 + 1; ++n3) {
                    GLLib.s_math_aTanTable[n3] = GLLib.Math_AtanSlow(s_math_F_1, n3);
                }
            }
            if (n == 0) {
                if (n2 > 0) {
                    return Math_Angle90;
                }
                if (n2 == 0) {
                    return 0;
                }
                return Math_Angle270;
            }
            if (n > 0) {
                if (n2 >= 0) {
                    if (n >= n2) {
                        n3 = n2 * s_math_F_1 / n;
                        return s_math_aTanTable[n3];
                    }
                    n3 = n * s_math_F_1 / n2;
                    return Math_Angle90 - s_math_aTanTable[n3];
                }
                if (n >= (n2 = -n2)) {
                    n3 = n2 * s_math_F_1 / n;
                    return Math_Angle360 - s_math_aTanTable[n3];
                }
                n3 = n * s_math_F_1 / n2;
                return Math_Angle270 + s_math_aTanTable[n3];
            }
            n = -n;
            if (n2 >= 0) {
                if (n >= n2) {
                    n3 = n2 * s_math_F_1 / n;
                    return Math_Angle180 - s_math_aTanTable[n3];
                }
                n3 = n * s_math_F_1 / n2;
                return Math_Angle90 + s_math_aTanTable[n3];
            }
            if (n >= (n2 = -n2)) {
                n3 = n2 * s_math_F_1 / n;
                return Math_Angle180 + s_math_aTanTable[n3];
            }
            n3 = n * s_math_F_1 / n2;
            return Math_Angle270 - s_math_aTanTable[n3];
        }
        return GLLib.Math_AtanSlow(n, n2);
    }

    private static final int Math_BezierUtility(int n, int n2, int n3, int n4, int n5, int n6) {
        return (n * n5 + n2 * 2 * n4 + n3 * n6) / (1 << (GLLibConfig.math_fixedPointBase << 1));
    }

    static void Math_Bezier2D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n7 * n7;
        int n9 = s_math_F_1 - n7;
        int n10 = n9 * n9;
        s_math_bezierX = GLLib.Math_BezierUtility(n, n3, n5, n9 *= n7, n10, n8);
        s_math_bezierY = GLLib.Math_BezierUtility(n2, n4, n6, n9, n10, n8);
    }

    static void Pack_Open(String string) {
        if (s_pack_filename != null && string.compareTo(s_pack_filename) == 0) {
            return;
        }
        GLLib.Pack_Close();
        s_pack_filename = string;
        s_pack_is = GLLib.Pack_GetInputStreamFromName(s_pack_filename);
        s_pack_nbData = (short)GLLib.Pack_Read16();
        s_pack_subPack_nbOf = (short)GLLib.Pack_Read16();
        s_pack_subPack_fat = new short[s_pack_subPack_nbOf];
        for (int i = 0; i < s_pack_subPack_nbOf; ++i) {
            GLLib.s_pack_subPack_fat[i] = (short)GLLib.Pack_Read16();
        }
        s_pack_subPack_curSubPack = 0;
        GLLib.Pack_GetDataOffset();
    }

    private static InputStream Pack_GetInputStreamFromName(String object) {
        InputStream inputStream = "".getClass().getResourceAsStream((String)object);
        object = inputStream;
        object = inputStream;
        return inputStream;
    }

    private static void Pack_GetDataOffset() {
        int n = s_pack_subPack_curSubPack == s_pack_subPack_nbOf - 1 ? s_pack_nbData - s_pack_subPack_fat[s_pack_subPack_curSubPack] : s_pack_subPack_fat[s_pack_subPack_curSubPack + 1] - s_pack_subPack_fat[s_pack_subPack_curSubPack];
        s_pack_offset = new int[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            GLLib.s_pack_offset[i] = GLLib.Pack_Read() & 0xFF | (GLLib.Pack_Read() & 0xFF) << 8 | ((GLLib.Pack_Read() & 0xFF) << 16 | (GLLib.Pack_Read() & 0xFF) << 24);
        }
    }

    static void Pack_Close() {
        if (s_pack_is != null) {
            try {
                s_pack_is.close();
            }
            catch (Exception exception) {}
            s_pack_is = null;
        }
        s_pack_curOffset = 0;
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
    }

    private static int Pack_PositionAtData(int n) {
        int n2;
        for (n2 = s_pack_subPack_nbOf - 1; n2 >= 0 && s_pack_subPack_fat[n2] > n; --n2) {
        }
        if (s_pack_subPack_curSubPack != n2) {
            s_pack_subPack_curSubPack = n2;
            GLLib.Pack_Close();
            if (s_pack_subPack_curSubPack == 0) {
                String string = s_pack_filename;
                s_pack_filename = null;
                GLLib.Pack_Open(string);
            } else {
                s_pack_is = GLLib.Pack_GetInputStreamFromName(s_pack_filename + "." + s_pack_subPack_curSubPack);
                GLLib.Pack_GetDataOffset();
            }
        } else if (s_pack_is == null) {
            if (s_pack_subPack_curSubPack == 0) {
                String string = s_pack_filename;
                s_pack_filename = null;
                GLLib.Pack_Open(string);
            } else {
                s_pack_is = GLLib.Pack_GetInputStreamFromName(s_pack_filename + "." + s_pack_subPack_curSubPack);
            }
        }
        int n3 = s_pack_offset[n -= s_pack_subPack_fat[s_pack_subPack_curSubPack]];
        n = s_pack_offset[n + 1] - s_pack_offset[n];
        if (s_pack_curOffset != n3) {
            if (s_pack_curOffset > n3) {
                GLLib.Pack_Close();
                s_pack_is = s_pack_subPack_curSubPack == 0 ? GLLib.Pack_GetInputStreamFromName(s_pack_filename) : GLLib.Pack_GetInputStreamFromName(s_pack_filename + "." + s_pack_subPack_curSubPack);
            } else {
                n3 -= s_pack_curOffset;
            }
            GLLib.Pack_Skip(n3);
        }
        s_pack_lastDataIsCompress = false;
        if (n > 0) {
            s_pack_lastDataReadMimeType = GLLib.Pack_Read() & 0xFF;
            --n;
        }
        return n;
    }

    static byte[] Pack_ReadData(int n) {
        n = GLLib.Pack_PositionAtData(n);
        byte[] byArray = null;
        byArray = new byte[n];
        GLLib.Pack_ReadFully(byArray, 0, byArray.length);
        return byArray;
    }

    private static void Pack_Skip(int n) {
        if (n == 0) {
            return;
        }
        if (GLLibConfig.pack_skipbufferSize == 0) {
            s_pack_curOffset += n;
            try {
                while (n > 0) {
                    n = (int)((long)n - s_pack_is.skip(n));
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (s_Pack_SkipBuffer == null) {
            s_Pack_SkipBuffer = new byte[GLLibConfig.pack_skipbufferSize];
        }
        while (n > GLLibConfig.pack_skipbufferSize) {
            GLLib.Pack_ReadFully(s_Pack_SkipBuffer, 0, GLLibConfig.pack_skipbufferSize);
            n -= GLLibConfig.pack_skipbufferSize;
        }
        if (n > 0) {
            GLLib.Pack_ReadFully(s_Pack_SkipBuffer, 0, n);
        }
    }

    private static int Pack_Read() {
        int n = 0;
        try {
            n = s_pack_is.read();
        }
        catch (Exception exception) {}
        ++s_pack_curOffset;
        return n;
    }

    private static int Pack_Read16() {
        return GLLib.Pack_Read() & 0xFF | (GLLib.Pack_Read() & 0xFF) << 8;
    }

    private static int Pack_ReadFully(byte[] byArray, int n, int n2) {
        n = 0;
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = s_pack_is.read(byArray, n, n3);
                n3 -= n4;
                n += n4;
            }
        }
        catch (Exception exception) {}
        s_pack_curOffset += n2;
        return n2;
    }

    static Object Pack_ReadArray(int n) {
        GLLib.Pack_PositionAtData(n);
        Stream_readOffset = 0;
        Object object = GLLib.Mem_ReadArray(s_pack_is);
        s_pack_curOffset += Stream_readOffset;
        return object;
    }

    static void Pack_LoadMIME(String string) {
        if (MIME_type == null) {
            InputStream inputStream = s_pack_is;
            s_pack_is = GLLib.Pack_GetInputStreamFromName(string);
            int n = GLLib.Pack_Read();
            MIME_type = new byte[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = GLLib.Pack_Read();
                GLLib.MIME_type[i] = new byte[n2];
                GLLib.Pack_ReadFully(MIME_type[i], 0, n2);
            }
            try {
                s_pack_is.close();
            }
            catch (Exception exception) {}
            s_pack_is = inputStream;
        }
    }

    static String GetMIME(int n) {
        if (n >= MIME_type.length) {
            return "";
        }
        try {
            return new String(MIME_type[n], "UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    static final int GetClipX(Graphics graphics) {
        return graphics.getClipX();
    }

    static final int GetClipY(Graphics graphics) {
        return graphics.getClipY();
    }

    static final int GetClipWidth(Graphics graphics) {
        return graphics.getClipWidth();
    }

    static final int GetClipHeight(Graphics graphics) {
        return graphics.getClipHeight();
    }

    static final void ClipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.clipRect(n, n2, n3, n4);
    }

    static final void SetClip(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
    }

    static final boolean IsClipValid(Graphics graphics) {
        return graphics != null;
    }

    static final void DrawLine(int n, int n2, int n3, int n4) {
        g.drawLine(n, n2, n3, n4);
    }

    static final void FillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.fillRect(n, n2, n3, n4);
    }

    static final void DrawRect(int n, int n2, int n3, int n4) {
        g.drawRect(n, n2, n3, n4);
    }

    static final void FillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        g.fillArc(n, n2, 400, 400, 90, n6);
    }

    static final void DrawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7) {
        if (n7 != 0) {
            if ((n7 & 4) != 0) {
                n2 = n5;
                n5 = n6;
                n6 = n2;
                n2 = n5;
            }
            nArray = ASprite.TransformRGB(nArray, n5, n6, n7);
        }
        graphics.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    public static final Image CreateImage(byte[] byArray, int n, int n2) {
        return Image.createImage((byte[])byArray, (int)n, (int)n2);
    }

    static int Mem_SetShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)s;
        byArray[n++] = (byte)(s >>> 8);
        return n;
    }

    static int Mem_SetInt(byte[] byArray, int n, int n2) {
        byArray[1186] = (byte)n2;
        byArray[1187] = (byte)(n2 >>> 8);
        byArray[1188] = (byte)(n2 >>> 16);
        byArray[1189] = (byte)(n2 >>> 24);
        return 1190;
    }

    static short Mem_GetShort(byte[] byArray, int n) {
        return (short)(byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8);
    }

    static int Mem_GetInt(byte[] byArray, int n) {
        return byArray[1186] & 0xFF | (byArray[1187] & 0xFF) << 8 | (byArray[1188] & 0xFF) << 16 | (byArray[1189] & 0xFF) << 24;
    }

    private static void Mem_ArrayCopy(Object object, int n, Object object2, int n2, int n3) throws Exception {
        System.arraycopy(object, n, object2, n2, n3);
    }

    static int Mem_SetArray(byte[] byArray, int n, byte[] byArray2) throws Exception {
        GLLib.Mem_ArrayCopy(byArray2, 0, byArray, n, byArray2.length);
        return n + byArray2.length;
    }

    static int Mem_GetArray(byte[] byArray, int n, byte[] byArray2) throws Exception {
        GLLib.Mem_ArrayCopy(byArray, n, byArray2, 0, byArray2.length);
        return n + byArray2.length;
    }

    private static Object Mem_ReadArray(InputStream inputStream) {
        Object[] objectArray = null;
        try {
            int n = GLLib.Stream_Read(inputStream);
            int n2 = n >> 4;
            int n3 = n & 7;
            n = (n & 8) != 0 ? GLLib.Stream_Read16(inputStream) : GLLib.Stream_Read(inputStream);
            switch (n3) {
                case 0: {
                    byte[] byArray = new byte[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        byArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                    }
                    objectArray = byArray;
                    break;
                }
                case 1: {
                    short[] sArray = new short[n];
                    if (n2 == 0) {
                        for (n2 = 0; n2 < n; ++n2) {
                            sArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            sArray[n2] = (short)GLLib.Stream_Read16(inputStream);
                        }
                    }
                    objectArray = sArray;
                    break;
                }
                case 2: {
                    int[] nArray = new int[n];
                    if (n2 == 0) {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = (byte)GLLib.Stream_Read(inputStream);
                        }
                    } else if (n2 == 1) {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = (short)GLLib.Stream_Read16(inputStream);
                        }
                    } else {
                        for (n2 = 0; n2 < n; ++n2) {
                            nArray[n2] = GLLib.Stream_Read32(inputStream);
                        }
                    }
                    objectArray = nArray;
                    break;
                }
                default: {
                    Object[] objectArray2;
                    switch (n3 &= 3) {
                        case 0: {
                            Object object;
                            if (n2 == 2) {
                                object = new byte[n][];
                                objectArray2 = (Object[])object;
                                break;
                            }
                            byte[][][] byArrayArray = new byte[n][][];
                            object = byArrayArray;
                            objectArray2 = (Object[])byArrayArray;
                            break;
                        }
                        case 1: {
                            Object object;
                            if (n2 == 2) {
                                short[][] sArrayArray = new short[n][];
                                object = sArrayArray;
                                objectArray2 = (Object[])sArrayArray;
                                break;
                            }
                            short[][][] sArrayArray = new short[n][][];
                            object = sArrayArray;
                            objectArray2 = (Object[])sArrayArray;
                            break;
                        }
                        default: {
                            Object object;
                            if (n2 == 2) {
                                int[][] nArrayArray = new int[n][];
                                object = nArrayArray;
                                objectArray2 = (Object[])nArrayArray;
                                break;
                            }
                            int[][][] nArrayArray = new int[n][][];
                            object = nArrayArray;
                            objectArray2 = (Object[])nArrayArray;
                        }
                    }
                    for (int i = 0; i < n; ++i) {
                        objectArray2[i] = GLLib.Mem_ReadArray(inputStream);
                    }
                    objectArray = objectArray2;
                    break;
                }
            }
        }
        catch (Exception exception) {}
        return objectArray;
    }

    private static int Stream_Read(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        if (n >= 0) {
            ++Stream_readOffset;
        }
        return n;
    }

    private static int Stream_Read16(InputStream inputStream) throws Exception {
        return GLLib.Stream_Read(inputStream) & 0xFF | (GLLib.Stream_Read(inputStream) & 0xFF) << 8;
    }

    private static int Stream_Read32(InputStream inputStream) throws Exception {
        return GLLib.Stream_Read(inputStream) & 0xFF | (GLLib.Stream_Read(inputStream) & 0xFF) << 8 | ((GLLib.Stream_Read(inputStream) & 0xFF) << 16 | (GLLib.Stream_Read(inputStream) & 0xFF) << 24);
    }

    private static int Stream_ReadFully(InputStream inputStream, byte[] byArray, int n, int n2) {
        n = 0;
        int n3 = n2;
        try {
            while (n3 > 0) {
                int n4 = inputStream.read(byArray, n, n3);
                n3 -= n4;
                n += n4;
            }
        }
        catch (Exception exception) {}
        Stream_readOffset += n2;
        return n2;
    }

    private static int Text_LoadTextFromStream(InputStream inputStream) {
        try {
            text_nbString = GLLib.Stream_Read32(inputStream);
            text_arrayOffset = new int[text_nbString + 1];
            for (int i = 1; i < text_nbString + 1; ++i) {
                GLLib.text_arrayOffset[i] = GLLib.Stream_Read32(inputStream);
            }
            text_array = new byte[text_arrayOffset[text_nbString]];
            GLLib.Stream_ReadFully(inputStream, text_array, 0, text_array.length);
        }
        catch (Exception exception) {}
        return text_array.length + (text_nbString + 1 << 2);
    }

    static void Text_LoadTextFromPack(String stringArray, int n) {
        if (text_stringCacheArray != null) {
            for (int i = 0; i < text_nbString; ++i) {
                GLLib.text_stringCacheArray[i] = null;
            }
            text_stringCacheArray = null;
        }
        text_arrayOffset = null;
        text_array = null;
        text_nbString = 0;
        GLLib.Pack_Open((String)stringArray);
        GLLib.Pack_PositionAtData(n);
        GLLib.Text_LoadTextFromStream(s_pack_is);
        GLLib.Pack_Close();
        if (GLLibConfig.text_useStringCache) {
            stringArray = new String[text_nbString];
            for (n = 0; n < text_nbString; ++n) {
                stringArray[n] = GLLib.Text_GetString(n);
            }
            text_stringCacheArray = stringArray;
            text_arrayOffset = null;
            text_array = null;
            if (GLLibConfig.useSystemGc) {
                System.gc();
            }
        }
    }

    private static String Text_FromUTF8(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = n;
        n += n2;
        while (n4 < n) {
            if ((byArray[n4] & 0x80) == 0) {
                cArray[n3++] = (char)byArray[n4++];
                continue;
            }
            if ((byArray[n4] & 0xE0) == 224 && n4 + 2 < n && (byArray[n4 + 1] & 0xC0) == 128 && (byArray[n4 + 2] & 0xC0) == 128) {
                cArray[n3++] = (char)((byArray[n4] & 0xF) << 12 | (byArray[n4 + 1] & 0x3F) << 6 | byArray[n4 + 2] & 0x3F);
                n4 += 3;
                continue;
            }
            if ((byArray[n4] & 0xC0) == 192 && n4 + 1 < n && (byArray[n4 + 1] & 0xC0) == 128) {
                cArray[n3++] = (char)((byArray[n4] & 0x1F) << 6 | byArray[n4 + 1] & 0x3F);
                n4 += 2;
                continue;
            }
            return "";
        }
        return new String(cArray, 0, n3);
    }

    static String Text_GetString(int n) {
        if (GLLibConfig.text_useStringCache && text_stringCacheArray != null) {
            return text_stringCacheArray[n];
        }
        try {
            int n2 = text_arrayOffset[n + 1] - text_arrayOffset[n];
            if (n2 == 0) {
                return null;
            }
            if (GLLibConfig.text_useInternalUTF8Converter) {
                if (!text_encoding.equals("UTF-8")) {
                    return new String(text_array, text_arrayOffset[n], n2, text_encoding);
                }
                return GLLib.Text_FromUTF8(text_array, text_arrayOffset[n], n2);
            }
            return new String(text_array, text_arrayOffset[n], n2, text_encoding);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void Rms_Close() {
        if (s_rs == null) {
            return;
        }
        try {
            s_rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {}
        s_rs = null;
    }

    private static void Rms_Open(String string) throws RecordStoreException {
        s_rs = RecordStore.openRecordStore((String)string, (boolean)true);
    }

    static byte[] Rms_Read(String string) {
        if (GLLibConfig.rms_maxRecordSize > 0) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            try {
                while (!bl) {
                    GLLib.Rms_Open(string + n);
                    if (s_rs.getNumRecords() > 0) {
                        n2 += s_rs.getRecordSize(1);
                        ++n;
                    } else {
                        bl = true;
                    }
                    GLLib.Rms_Close();
                }
            }
            catch (Exception exception) {
                new StringBuffer().append("ERROR! Failed reading from RMS: ").append(exception);
            }
            if (n2 > 0) {
                byte[] byArray = new byte[n2];
                n2 = 0;
                for (int i = 0; i < n; ++i) {
                    byte[] byArray2 = GLLib.Rms_Read(string + i);
                    System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                    n2 += byArray2.length;
                }
                return byArray;
            }
            return null;
        }
        return GLLib.Rms_Read_Single(string);
    }

    private static byte[] Rms_Read_Single(String string) {
        byte[] byArray = null;
        try {
            GLLib.Rms_Open(string);
            if (s_rs.getNumRecords() > 0) {
                byArray = s_rs.getRecord(1);
            }
        }
        catch (RecordStoreException recordStoreException) {
            new StringBuffer().append("ERROR! Failed reading from RMS: ").append((Object)recordStoreException);
            byArray = null;
        }
        GLLib.Rms_Close();
        return byArray;
    }

    static void Rms_Write(String string, byte[] byArray) {
        if (GLLibConfig.rms_maxRecordSize > 0) {
            int n = 0;
            int n2 = byArray.length;
            int n3 = 0;
            while (n2 > 0) {
                GLLib.Rms_Write_Single(string + n3, byArray, n, GLLibConfig.rms_maxRecordSize < n2 ? GLLibConfig.rms_maxRecordSize : n2);
                n += GLLibConfig.rms_maxRecordSize;
                n2 -= GLLibConfig.rms_maxRecordSize;
                ++n3;
            }
            return;
        }
        GLLib.Rms_Write_Single(string, byArray, 0, byArray.length);
    }

    private static void Rms_Write_Single(String string, byte[] byArray, int n, int n2) {
        try {
            GLLib.Rms_Open(string);
            if (s_rs.getNumRecords() > 0) {
                s_rs.setRecord(1, byArray, n, n2);
            } else {
                s_rs.addRecord(byArray, n, n2);
            }
        }
        catch (RecordStoreException recordStoreException) {}
        GLLib.Rms_Close();
    }

    public static void AlphaRect_SetColor(int n) {
        if (n != s_alphaRectCurrentARGB || s_alphaRectARGBData == null) {
            s_alphaRectCurrentARGB = n;
            if (s_alphaRectARGBData == null) {
                s_alphaRectARGBData = new int[GLLibConfig.alphaRectBufferSize * GLLibConfig.alphaRectBufferSize];
            }
            int n2 = GLLibConfig.alphaRectBufferSize * GLLibConfig.alphaRectBufferSize;
            while (n2 > 0) {
                GLLib.s_alphaRectARGBData[--n2] = n;
            }
        }
    }

    public static void AlphaRect_Draw(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics;
        int n5 = graphics2.getClipX();
        graphics2 = graphics;
        int n6 = graphics2.getClipY();
        graphics2 = graphics;
        int n7 = graphics2.getClipWidth();
        graphics2 = graphics;
        int n8 = graphics2.getClipHeight();
        int n9 = n > n5 ? n : n5;
        int n10 = n2 > n6 ? n2 : n6;
        n3 = (n + n3 < n5 + n7 ? n + n3 : n5 + n7) - n9;
        n4 = (n2 + n4 < n6 + n8 ? n2 + n4 : n6 + n8) - n10;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        GLLib.SetClip(graphics, n9, n10, n3, n4);
        if (n3 * n4 < GLLibConfig.alphaRectBufferSize * GLLibConfig.alphaRectBufferSize) {
            int n11 = n9;
            int n12 = n10;
            int n13 = n4;
            n10 = n3;
            n9 = n12;
            n4 = n11;
            int[] nArray = s_alphaRectARGBData;
            Graphics graphics3 = graphics;
            GLLib.DrawRGB(graphics3, nArray, 0, n3, n4, n9, n10, n13, true, true, 0);
        } else {
            n3 += n9;
            n4 += n10;
            for (n = n9; n < n3; n += GLLibConfig.alphaRectBufferSize) {
                for (n2 = n10; n2 < n4; n2 += GLLibConfig.alphaRectBufferSize) {
                    int n14 = GLLibConfig.alphaRectBufferSize;
                    int n15 = GLLibConfig.alphaRectBufferSize;
                    int n16 = n2;
                    int n17 = n;
                    int n18 = GLLibConfig.alphaRectBufferSize;
                    int[] nArray = s_alphaRectARGBData;
                    Graphics graphics4 = graphics;
                    GLLib.DrawRGB(graphics4, nArray, 0, n18, n17, n16, n15, n14, true, true, 0);
                }
            }
        }
        GLLib.SetClip(graphics, n5, n6, n7, n8);
    }

    static {
        s_screenWidth = GLLibConfig.screenWidth;
        s_screenHeight = GLLibConfig.screenHeight;
        m_FPSLimiter = 1000 / GLLibConfig.FPSLimiter;
        m_customSleepTime = -1;
        m_imgBackBuffer = null;
        m_gBackBuffer = null;
        m_bBackBufferEnabled = true;
        m_last_key_pressed = -9999;
        s_math_F_1 = 1 << GLLibConfig.math_fixedPointBase;
        Math_AngleMUL = 1 << GLLibConfig.math_angleFixedPointBase;
        Math_Angle90 = 90 * Math_AngleMUL / 360;
        Math_Angle180 = 180 * Math_AngleMUL / 360;
        Math_Angle270 = 270 * Math_AngleMUL / 360;
        Math_Angle360 = 360 * Math_AngleMUL / 360;
        Math_FixedPoint_PI = 1686629713 >> 29 - GLLibConfig.math_fixedPointBase;
        Stream_readOffset = 0;
        text_encoding = "UTF-8";
        pfx_usingScreenBuffer = false;
        pfx_useSpriteEffects = false;
        s_PFX_initializd = false;
        s_PFX_type = 0;
        s_PFX_params = null;
        s_PFX_screenBuffer = null;
        s_PFX_screenBufferG = null;
        s_PFX_enableScreenBuffer = 0;
        s_PFX_enableScreenBufferThisFrame = 0;
    }
}

