/*
 * Decompiled with CFR 0.152.
 */
package STH2P1_S40P1;

import STH2P1_S40P1.Debug;
import STH2P1_S40P1.Device;
import STH2P1_S40P1.DeviceImage;
import STH2P1_S40P1.Engine;
import STH2P1_S40P1.ResourceMaster;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class FontMgr
implements Debug {
    public static final int FONT_DISABLED = -1;
    public static final int FONT_TYPE_BMP = 0;
    public static final int FONT_TYPE_MIDP = 1;
    public static final int MIDP_FONT_FACE = 0;
    public static final int MIDP_FONT_COLOR = 1;
    public static final int BMP_FONT_FACE = 0;
    public static final int BMP_FONT_PALETTE = 1;
    public static final int PROP_BASELINE = 0;
    public static final int PROP_BELOW_BASELINE = 1;
    public static final int PROP_BELOW_DESCENDER = 2;
    public static final int PROP_ASCENDER_SPACE = 3;
    public static final int NO_PALETTE = -1;
    public static final int NO_COLOUR = -1;
    private static int[] FONT_CHAR_HEIGHT = new int[Device.MIDP_FONT_FACES.length];
    private static int[] FONT_LINE_HEIGHT = new int[Device.MIDP_FONT_FACES.length];
    private static DeviceImage[][] font_img = new DeviceImage[2][];
    private static char[][] font_chars = new char[2][];
    private static int[] uniform_spacing = new int[2];
    public static int[] maxCharWidth = new int[2];
    public static int[] charHeight = new int[2];
    public static int[] lineHeight = new int[2];

    FontMgr() {
    }

    public static void realise(int n) {
        if (Device.FONT_TYPE[n] == 0) {
            if (font_img[n] != null) {
                return;
            }
            try {
                Object[] objectArray;
                DeviceImage deviceImage;
                int n2;
                int n3 = Device.BMP_FONT_COMPOSITIONS[(n << 1) + 0];
                int n4 = Device.BMP_FONT_FACES[(n3 << 1) + 1];
                byte[] byArray = ResourceMaster.getResourceAsBytes(n4);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                byArray = null;
                FontMgr.uniform_spacing[n] = dataInputStream.readByte();
                FontMgr.maxCharWidth[n] = dataInputStream.readUnsignedByte();
                FontMgr.charHeight[n] = dataInputStream.readUnsignedByte();
                int n5 = dataInputStream.readUnsignedByte();
                FontMgr.lineHeight[n] = charHeight[n] + n5;
                int n6 = dataInputStream.readUnsignedByte();
                String string = dataInputStream.readUTF();
                FontMgr.font_chars[n] = string.toCharArray();
                byte[] byArray2 = new byte[n6];
                short[] sArray = new short[n6 * 2];
                for (n2 = 0; n2 < n6; ++n2) {
                    byArray2[n2] = dataInputStream.readByte();
                }
                for (n2 = 0; n2 < n6 * 2; ++n2) {
                    sArray[n2] = dataInputStream.readShort();
                }
                n2 = Device.BMP_FONT_FACES[n3 << 1];
                byte[] byArray3 = ResourceMaster.getResourceAsBytes(n2);
                int n7 = Device.BMP_FONT_COMPOSITIONS[(n << 1) + 1];
                if (n7 == -1) {
                    deviceImage = new DeviceImage(byArray3, "font " + n);
                } else {
                    objectArray = ResourceMaster.getResourceAsBytes(n7);
                    deviceImage = new DeviceImage(Engine.insertPLTE(byArray3, objectArray), "font " + n + " plt " + n7);
                }
                objectArray = new DeviceImage[n6];
                for (int i = 0; i < objectArray.length; ++i) {
                    byte by = byArray2[i];
                    short s = sArray[i << 1];
                    short s2 = sArray[(i << 1) + 1];
                    objectArray[i] = (byte)new DeviceImage(deviceImage, s, s2, by, charHeight[n], false);
                }
                FontMgr.font_img[n] = (DeviceImage[])objectArray;
                dataInputStream.close();
                dataInputStream = null;
            }
            catch (Exception exception) {}
        } else {
            int n8 = Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0];
            FontMgr.charHeight[n] = FONT_CHAR_HEIGHT[n8];
            FontMgr.lineHeight[n] = FONT_LINE_HEIGHT[n8];
            FontMgr.maxCharWidth[n] = Device.MIDP_FONT_FACES[n8].charWidth('W');
        }
    }

    public static void release(int n) {
    }

    private static int getCharIndex(int n, char c) {
        return -1;
    }

    public static int charWidth(int n, char c) {
        if (Device.FONT_TYPE[n] == -1) {
            return Font.getDefaultFont().charWidth(c);
        }
        Font font = Engine.MIDP_FONT_FACES[Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0]];
        return font.charWidth(c);
    }

    public static int stringWidth(int n, String string) {
        if (Device.FONT_TYPE[n] == -1) {
            return Font.getDefaultFont().stringWidth(string);
        }
        Font font = Engine.MIDP_FONT_FACES[Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0]];
        return font.stringWidth(string);
    }

    public static int substringWidth(int n, String string, int n2, int n3) {
        return FontMgr.stringWidth(n, string.substring(n2, n3));
    }

    public static void drawString(int n, Graphics graphics, String string, int n2, int n3, int n4) {
        int n5;
        if (Device.FONT_TYPE[n] == -1) {
            return;
        }
        if (string == null) {
            string = "";
        }
        if ((n5 = Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 1]) != -1) {
            graphics.setColor(n5);
        }
        int n6 = Device.MIDP_FONT_COMPOSITIONS[(n << 1) + 0];
        Font font = Device.MIDP_FONT_FACES[n6];
        if ((n4 & 1) > 0) {
            int n7 = FontMgr.stringWidth(n6, string);
            n2 -= n7 >> 1;
        } else if ((n4 & 8) > 0) {
            int n8 = FontMgr.stringWidth(n6, string);
            n2 = n2 - n8 + 1;
        }
        if ((n4 & 0x40) > 0) {
            n3 -= charHeight[n];
        } else if ((n4 & 0x20) > 0) {
            n3 -= charHeight[n] + 2;
        }
        if ((n4 & 2) > 0) {
            n3 -= charHeight[n] >> 1;
        }
        graphics.setFont(font);
        graphics.drawString(string, n2, n3 - Device.MIDP_FONT_PROPS[n6 * 4 + 3], 20);
    }

    static {
        for (int i = 0; i < Device.MIDP_FONT_FACES.length; ++i) {
            int n = i * 4;
            int n2 = Device.MIDP_FONT_PROPS[n + 0];
            int n3 = Device.MIDP_FONT_PROPS[n + 1];
            int n4 = Device.MIDP_FONT_PROPS[n + 3];
            int n5 = Device.MIDP_FONT_PROPS[n + 2];
            int n6 = n3 - n5;
            FontMgr.FONT_CHAR_HEIGHT[i] = n2 - n4 + n5;
            FontMgr.FONT_LINE_HEIGHT[i] = n2 - n4 + n3 + 1;
        }
    }
}

