/*
 * Decompiled with CFR 0.152.
 */
package com.appon.gladiatorescape.ui;

import com.appon.gladiatorescape.ui.GallaryScreen;
import com.appon.util.Util;
import com.appon.util.serilize.Serilize;
import com.indiagames.runnergame.Constant;
import com.indiagames.runnergame.KnightTestEngine;
import com.indiagames.runnergame.TempleRunCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class ChallengesMenu {
    public GallaryScreen gallaryScreen = new GallaryScreen(Constant.SCREEN_WIDTH, Constant.SCREEN_HEIGHT);

    public ChallengesMenu(String lsk, String rsk, String title) {
    }

    public void reset() {
        this.gallaryScreen.reset();
    }

    public void updateChallange(int level) {
        System.out.println("MAX_UNLOCKED_LEVELS : " + Constant.MAX_UNLOCKED_LEVELS);
        if (level == Constant.MAX_UNLOCKED_LEVELS) {
            Constant.MAX_UNLOCKED_LEVELS = level + 1;
            if (TempleRunCanvas.challangeMode == 0) {
                ++Constant.MAX_UNLOACK_LEVEL_EASY;
            } else {
                ++Constant.MAX_UNLOACK_LEVEL_HARD;
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Serilize.serialize(new Integer(Constant.MAX_UNLOACK_LEVEL_EASY), bos);
                Serilize.serialize(new Integer(Constant.MAX_UNLOACK_LEVEL_HARD), bos);
                bos.flush();
                Util.updateRecord(Constant.CHALLANGE_RMS_NAME, bos.toByteArray());
                bos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadchallagesScreen() {
        byte[] data = Util.getRmsData(Constant.CHALLANGE_RMS_NAME);
        if (data == null) {
            Constant.MAX_UNLOACK_LEVEL_EASY = 1;
            Constant.MAX_UNLOACK_LEVEL_HARD = 1;
        } else {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                Constant.MAX_UNLOACK_LEVEL_EASY = (Integer)Serilize.deserialize(bis, null);
                Constant.MAX_UNLOACK_LEVEL_HARD = (Integer)Serilize.deserialize(bis, null);
                bis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Constant.MAX_UNLOCKED_LEVELS = TempleRunCanvas.challangeMode == 0 ? Constant.MAX_UNLOACK_LEVEL_EASY : Constant.MAX_UNLOACK_LEVEL_HARD;
        this.gallaryScreen.selectedIndex = Constant.MAX_UNLOCKED_LEVELS - 1;
        this.gallaryScreen.loadRequiredImages();
    }

    public void unload() {
        this.gallaryScreen.unload();
    }

    public void paint(Graphics g) {
        int alpha = 128;
        g.drawImage(Constant.BGIMAGE_A_2.getImage(), 0, 0, 0);
        if (TempleRunCanvas.challangeMode == 0) {
            Constant.SMALLFONT.drawString(g, "Easy Levels", (Constant.SCREEN_WIDTH >> 1) - (Constant.SMALLFONT.getStringWidth("Easy Levels") >> 1), Constant.HUD_POS_Y << 1, 20);
        } else {
            Constant.SMALLFONT.drawString(g, "Hard Levels", (Constant.SCREEN_WIDTH >> 1) - (Constant.SMALLFONT.getStringWidth("Hard Levels") >> 1), Constant.HUD_POS_Y << 1, 20);
        }
        this.gallaryScreen.paint(g, TempleRunCanvas.isTouchScreen);
        this.paintSoftKey(g);
    }

    public void keyReleased(int keycode, int gameKey) {
        if (!Util.isLeftPressed(gameKey)) {
            this.gallaryScreen.keyReleased(keycode, gameKey);
        }
    }

    public void keyRepeated(int keycode, int gameKey) {
        if (!Util.isLeftPressed(gameKey)) {
            this.gallaryScreen.keyRepeated(keycode, gameKey);
        }
    }

    public void keyPressed(int keycode, int gameKey) {
        if (Util.isLeftSoftkeyPressed(keycode)) {
            KnightTestEngine.getInstance().levelGenerator.setInLevelMode(false);
            TempleRunCanvas.getInstance().setGameState(8);
        } else {
            this.gallaryScreen.keyPressed(keycode, gameKey);
        }
    }

    public void paintSoftKey(Graphics g) {
        g.drawImage(Constant.IMG_SMALL_BUTTON.getImage(), 0, Constant.SCREEN_HEIGHT - Constant.IMG_SMALL_BUTTON.getHeight(), 0);
        g.drawImage(Constant.IMG_BACK_ICON.getImage(), Constant.IMG_SMALL_BUTTON.getWidth() - Constant.IMG_BACK_ICON.getWidth() >> 1, Constant.SCREEN_HEIGHT - Constant.IMG_SMALL_BUTTON.getHeight() + (Constant.IMG_SMALL_BUTTON.getHeight() - Constant.IMG_BACK_ICON.getHeight() >> 1), 0);
    }

    public void handlePointerPressed(int x, int y) {
        if (Util.isInRect(0, Constant.SCREEN_HEIGHT - Constant.IMG_SMALL_BUTTON.getHeight(), Constant.IMG_SMALL_BUTTON.getWidth(), Constant.IMG_SMALL_BUTTON.getHeight(), x, y)) {
            TempleRunCanvas.getInstance().setGameState(6);
        } else {
            this.gallaryScreen.pointerPressed(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (Util.isInRect(0, Constant.SCREEN_HEIGHT - Constant.IMG_SMALL_BUTTON.getHeight(), Constant.IMG_SMALL_BUTTON.getWidth(), Constant.IMG_SMALL_BUTTON.getHeight(), x, y)) {
            TempleRunCanvas.getInstance().setGameState(6);
        } else {
            this.gallaryScreen.pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (Util.isInRect(0, Constant.SCREEN_HEIGHT - Constant.IMG_SMALL_BUTTON.getHeight(), Constant.IMG_SMALL_BUTTON.getWidth(), Constant.IMG_SMALL_BUTTON.getHeight(), x, y)) {
            TempleRunCanvas.getInstance().setGameState(6);
        } else {
            this.gallaryScreen.pointerReleased(x, y);
        }
    }

    public void levelSelected() {
        if (this.gallaryScreen.selectedIndex < Constant.MAX_UNLOCKED_LEVELS) {
            KnightTestEngine.getInstance().levelGenerator.setInLevelMode(true);
            if (TempleRunCanvas.challangeMode == 0) {
                KnightTestEngine.getInstance().levelGenerator.setCurrentLevel(this.gallaryScreen.selectedIndex);
            } else {
                KnightTestEngine.getInstance().levelGenerator.setCurrentLevel(this.gallaryScreen.selectedIndex);
            }
            TempleRunCanvas.getInstance().setGameState(9);
        }
    }
}

