/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework;

import com.appon.gtantra.GraphicsUtil;
import com.appon.miniframework.Util;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CornersPNGBox {
    private Image leftTopImage;
    private Image topImage;
    private Image leftImage;
    private Image baseImage;
    private int color;
    private int leftTopResourceIndex;
    private int topResourceIndex;
    private int leftResourceIndex;
    private int baseResourceIndex = -1;

    public Image getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(Image baseBitmap) {
        this.baseImage = baseBitmap;
    }

    public Image getLeftImage() {
        return this.leftImage;
    }

    public void setLeftImage(Image leftBitmap) {
        this.leftImage = leftBitmap;
    }

    public Image getLeftTopImage() {
        return this.leftTopImage;
    }

    public void setLeftTopImage(Image leftTopBitmap) {
        this.leftTopImage = leftTopBitmap;
    }

    public Image getTopImage() {
        return this.topImage;
    }

    public void setTopImage(Image topBitmap) {
        this.topImage = topBitmap;
    }

    public CornersPNGBox(Image leftTopImage, Image topImage, Image leftImage, int color, Image baseBitmap) {
        this.leftTopImage = leftTopImage;
        this.topImage = topImage;
        this.leftImage = leftImage;
        this.color = color;
        this.baseImage = baseBitmap;
    }

    public CornersPNGBox() {
    }

    public void setBaseResourceIndex(int baseResourceIndex) {
        this.baseResourceIndex = baseResourceIndex;
    }

    public int getBaseResourceIndex() {
        return this.baseResourceIndex;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        int i;
        int i2;
        if (this.leftImage == null || this.topImage == null || this.leftTopImage == null) {
            return;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int startX = x + Util.getImageWidth(this.leftTopImage);
        int endX = x + width - Util.getImageWidth(this.leftTopImage);
        g.setClip(startX, y, width - Util.getImageWidth(this.leftTopImage) * 2, height);
        for (i2 = startX; i2 < endX; i2 += Util.getImageWidth(this.topImage)) {
            Util.drawImage(g, this.topImage, i2, y);
        }
        startX = x + Util.getImageWidth(this.leftTopImage);
        endX = x + width - Util.getImageWidth(this.leftTopImage);
        for (i2 = startX; i2 < endX; i2 += Util.getImageWidth(this.topImage)) {
            GraphicsUtil.drawRegion(g, this.topImage, i2, y + height - Util.getImageHeight(this.topImage), 2, 0);
        }
        int startY = y + Util.getImageHeight(this.leftTopImage);
        int endY = y + height - Util.getImageHeight(this.leftTopImage);
        g.setClip(x, startY, width, height - Util.getImageHeight(this.leftTopImage) * 2);
        for (i = startY; i < endY; i += Util.getImageHeight(this.leftImage)) {
            Util.drawImage(g, this.leftImage, x, i);
        }
        startY = y + Util.getImageHeight(this.leftTopImage);
        endY = y + height - Util.getImageHeight(this.leftTopImage);
        for (i = startY; i < endY; i += Util.getImageHeight(this.leftImage)) {
            GraphicsUtil.drawRegion(g, this.leftImage, x + width - Util.getImageWidth(this.leftImage), i, 8, 0);
        }
        g.setClip(x + Util.getImageWidth(this.leftImage), y + Util.getImageHeight(this.topImage), width - Util.getImageWidth(this.leftImage) - Util.getImageWidth(this.leftImage), height - Util.getImageHeight(this.topImage) - Util.getImageHeight(this.topImage));
        if (this.color != -1) {
            g.setColor(Util.getColor(this.color));
            g.fillRect(x + Util.getImageWidth(this.leftImage), y + Util.getImageHeight(this.topImage), width - Util.getImageWidth(this.leftImage) - Util.getImageWidth(this.leftImage), height - Util.getImageHeight(this.topImage) - Util.getImageHeight(this.topImage));
        }
        if (this.baseImage != null) {
            this.fillImageRect(g, x + Util.getImageWidth(this.leftImage), y + Util.getImageHeight(this.topImage), width - Util.getImageWidth(this.leftImage) - Util.getImageWidth(this.leftImage), height - Util.getImageHeight(this.topImage) - Util.getImageHeight(this.topImage), this.baseImage);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        Util.drawImage(g, this.leftTopImage, x, y);
        GraphicsUtil.drawRegion(g, this.leftTopImage, x + width - Util.getImageWidth(this.leftTopImage), y, 8, 0);
        GraphicsUtil.drawRegion(g, this.leftTopImage, x, y + height - Util.getImageHeight(this.leftTopImage), 10, 0);
        GraphicsUtil.drawRegion(g, this.leftTopImage, x + width - Util.getImageWidth(this.leftTopImage), y + height - Util.getImageHeight(this.leftTopImage), 2, 0);
    }

    private void fillImageRect(Graphics g, int x, int y, int width, int height, Image image) {
        int _maxW = x + width + Util.getImageWidth(image);
        int w = Util.getImageWidth(image);
        int _maxH = y + height + Util.getImageHeight(image);
        int h = Util.getImageHeight(image);
        for (int i = x; i <= _maxW; i += w) {
            for (int j = y; j <= _maxH; j += h) {
                Util.drawImage(g, image, i, j);
            }
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getLeftResourceIndex() {
        return this.leftResourceIndex;
    }

    public void setLeftResourceIndex(int leftResourceIndex) {
        this.leftResourceIndex = leftResourceIndex;
    }

    public int getLeftTopResourceIndex() {
        return this.leftTopResourceIndex;
    }

    public void setLeftTopResourceIndex(int leftTopResourceIndex) {
        this.leftTopResourceIndex = leftTopResourceIndex;
    }

    public int getTopResourceIndex() {
        return this.topResourceIndex;
    }

    public void setTopResourceIndex(int topResourceIndex) {
        this.topResourceIndex = topResourceIndex;
    }

    public void cleanup() {
        this.baseImage = null;
        this.leftImage = null;
        this.topImage = null;
        this.leftTopImage = null;
    }
}

