/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.util.KeyEvent;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Util {
    public static boolean isPortraitMode = false;
    public static Random random = new Random();

    public static int getRandomNumber(int min, int max) {
        if (max == min) {
            return 0;
        }
        int randomNum = Math.abs(random.nextInt());
        return min + Math.abs(randomNum % (max - min));
    }

    public static int getSlope(int x1, int y1, int x2, int y2) {
        int angle;
        int x = x2 - x1;
        int y = y2 - y1;
        if (y == 0) {
            if (x1 < x2) {
                return 0;
            }
            return 180;
        }
        int coeff_1 = 12873;
        int coeff_2 = 38619;
        int abs_y = Math.abs(y);
        if (x >= 0) {
            angle = coeff_1 * (x - abs_y) / (x + abs_y);
            angle = coeff_1 - angle;
        } else {
            angle = coeff_1 * (x + abs_y) / (abs_y - x);
            angle = coeff_2 - angle;
        }
        int result = y < 0 ? -angle : angle;
        result = 57 * result >> 14;
        if (result < 0) {
            result = 360 + result;
        }
        return result;
    }

    public static int getSlope1(int x1, int y1, int x2, int y2) {
        int angle;
        int x = x2 - x1;
        int y = y2 - y1;
        if (y == 0) {
            if (x1 < x2) {
                return 0;
            }
            return 180;
        }
        int coeff_1 = 12873;
        int coeff_2 = 38619;
        int abs_y = Math.abs(y);
        if (x >= 0) {
            angle = coeff_1 * (x - abs_y) / (x + abs_y);
            angle = coeff_1 - angle;
        } else {
            angle = coeff_1 * (x + abs_y) / (abs_y - x);
            angle = coeff_2 - angle;
        }
        int result = y < 0 ? angle : -angle;
        result = 57 * result >> 14;
        if (result < 0) {
            result = 360 + result;
        }
        return result;
    }

    public static boolean isInRect(int xPos, int yPos, int width, int height, int x, int y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    public static boolean isRectCollision(int xPos1, int ypos1, int width1, int height1, int xPos2, int ypos2, int width2, int height2) {
        return Util.isInRect(xPos1, ypos1, width1, height1, xPos2, ypos2) || Util.isInRect(xPos1, ypos1, width1, height1, xPos2 + width2, ypos2) || Util.isInRect(xPos1, ypos1, width1, height1, xPos2, ypos2 + height2) || Util.isInRect(xPos1, ypos1, width1, height1, xPos2 + width2, ypos2 + height2);
    }

    public static Image resizeImageWithTransperency(Image image, int newWidth, int newHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] argbData = new int[image.getWidth() * image.getHeight()];
        image.getRGB(argbData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int[] out = new int[newWidth * newHeight];
        for (int yy = 0; yy < newHeight; ++yy) {
            int dy = yy * height / newHeight;
            for (int xx = 0; xx < newWidth; ++xx) {
                int dx = xx * width / newWidth;
                out[newWidth * yy + xx] = argbData[width * dy + dx];
            }
        }
        return Image.createRGBImage((int[])out, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public static void deleteRMS(String rms) {
        try {
            RecordStore.deleteRecordStore((String)rms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRecord(String rmsname, byte[] data) {
        Util.deleteRMS(rmsname);
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)rmsname, (boolean)true);
            rs.addRecord(data, 0, data.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] getRmsData(String rmsName) {
        try {
            RecordEnumeration enu;
            RecordStore rs = RecordStore.openRecordStore((String)rmsName, (boolean)false);
            if (rs.getNumRecords() > 0 && (enu = rs.enumerateRecords(null, null, false)).hasNextElement()) {
                byte[] data = enu.nextRecord();
                enu.destroy();
                rs.closeRecordStore();
                return data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void portArray(int[] array, int percent) {
        for (int s = 0; s < array.length; ++s) {
            array[s] = Util.getScaleValue(array[s], percent);
        }
    }

    public static int getScaleValue(int value, int scale) {
        if (scale < 0) {
            scale = Math.abs(scale);
            value -= Math.abs(value) * scale / 100;
        } else {
            value += value * scale / 100;
        }
        return value;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1.toLowerCase().equals(str2.toLowerCase());
    }

    public static boolean isRightPressed(int gamekey) {
        return isPortraitMode ? gamekey == 6 : gamekey == 5;
    }

    public static boolean isDownPressed(int gamekey) {
        return isPortraitMode ? gamekey == 2 : gamekey == 6;
    }

    public static boolean isFirePressed(int gamekey) {
        return gamekey == 8;
    }

    public static boolean isUpPressed(int gamekey) {
        return isPortraitMode ? gamekey == 5 : gamekey == 1;
    }

    public static boolean isRightSoftkeyPressed(int keycode) {
        return isPortraitMode ? keycode == KeyEvent.KEY_SOFT_LEFT : keycode == KeyEvent.KEY_SOFT_RIGHT;
    }

    public static boolean isLeftSoftkeyPressed(int keycode) {
        return isPortraitMode ? keycode == KeyEvent.KEY_SOFT_RIGHT : keycode == KeyEvent.KEY_SOFT_LEFT;
    }

    public static boolean isLeftPressed(int gamekey) {
        return isPortraitMode ? gamekey == 1 : gamekey == 2;
    }
}

