/*
 * Decompiled with CFR 0.152.
 */
package com.appon.runner.model;

import com.appon.runner.model.AddedShape;
import com.appon.runner.model.Shape;
import com.appon.runner.util.Util;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class LineShape
extends Shape {
    int x1;
    int y1;
    int x2;
    int y2;

    public void paint(Graphics g, int x, int y) {
        g.setColor(0xFF0000);
        g.drawLine(this.x1 + x, this.y1 + y, this.x2 + x, this.y1 + y);
    }

    public void deserilize(InputStream bis) throws Exception {
        super.deserilize(bis);
        this.x1 = Util.read(bis, 4);
        this.x2 = Util.read(bis, 4);
        this.y1 = Util.read(bis, 4);
        this.y2 = Util.read(bis, 4);
    }

    public void setCoordinate(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public int getWidth() {
        return Math.max(this.x1, this.x2);
    }

    public int getHeight() {
        return Math.max(this.y1, this.y2);
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape addedShape) {
        if (Util.lineToRectangle(this.x1 + addedShape.getX() + addedShape.getAdditionalX(), this.y1 + addedShape.getY() + addedShape.getAdditionalY(), this.x2 + addedShape.getX() + addedShape.getAdditionalX(), this.y2 + addedShape.getY() + addedShape.getAdditionalY(), rectX, rectY, rectWidth, rectHeight)) {
            return addedShape;
        }
        return null;
    }
}

