/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.layout;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.Layout;
import com.appon.miniframework.Position;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;

public class PropotionLayout
implements Layout {
    private Hashtable storedVales = new Hashtable();
    private boolean scaleX = true;
    private boolean scaleY = true;

    public void applyLayout(Container parent, Control currentContainer) {
        if (!(currentContainer instanceof Container)) {
            throw new RuntimeException("Linear layout can be applied only on Container");
        }
        Container container = (Container)currentContainer;
        int xScale = Util.getScaleX();
        int yScale = Util.getScaleY();
        for (int i = 0; i < container.getSize(); ++i) {
            Control c = container.getChild(i);
            Position pos = (Position)this.storedVales.get(c.getId() + "");
            if (pos == null) {
                pos = new Position();
                pos.setX(c.getX());
                pos.setY(c.getY());
                this.storedVales.put(c.getId() + "", pos);
            }
            if (this.isScaleX()) {
                c.setX(Util.getScaleValue(pos.getX(), xScale));
            }
            if (!this.isScaleY()) continue;
            c.setY(Util.getScaleValue(pos.getY(), yScale));
        }
    }

    public void setScaleX(boolean scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(boolean scaleY) {
        this.scaleY = scaleY;
    }

    public boolean isScaleX() {
        return this.scaleX;
    }

    public boolean isScaleY() {
        return this.scaleY;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.setScaleX(Util.readBoolean(bis));
        this.setScaleY(Util.readBoolean(bis));
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 1008;
    }

    public void port() {
    }

    public int getPreferedWidth(Container parent) {
        throw new RuntimeException("Not supported yet.");
    }

    public int getPreferedHeight(Container parent) {
        throw new RuntimeException("Not supported yet.");
    }
}

