/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.gtantra.GFont;
import com.appon.miniframework.Control;
import com.appon.miniframework.EventQueue;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Settings;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import javax.microedition.lcdui.Graphics;

public class TextControl
extends Control {
    private GFont font;
    private GFont selectionFont;
    private String text = "";
    public static final int LEFT_ALLIGN = 0;
    public static final int CENTER_ALLIGN = 1;
    public static final int RIGHT_ALLIGN = 2;
    public static final int TOP_ALLIGN = 0;
    public static final int BOTTOM_ALLIGN = 2;
    private int xAllign = 0;
    private int yAllign = 0;
    private int pallate = 0;
    private int selectionPallate = 0;
    private int fontResourceId = -1;
    private int selectionFontResourceId = -1;
    private int localTextId = -1;
    private int tintColor = -1;

    public TextControl() {
        super(-1);
    }

    public TextControl(int id) {
        super(id);
    }

    public void setLocalTextId(int localTextId) {
        this.localTextId = localTextId;
    }

    public int getPreferredWidth() {
        if (this.getCurrentFont() == null) {
            return 50;
        }
        return this.getCurrentFont().getStringWidth(this.text) + this.getLeftInBound() + this.getRightInBound();
    }

    public void setSelectionFontResourceId(int selectionFontResourceId) {
        this.selectionFontResourceId = selectionFontResourceId;
    }

    public void setFontResourceId(int fontResourceId) {
        this.fontResourceId = fontResourceId;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int tintColor) {
        this.tintColor = tintColor;
    }

    public int getFontResourceId() {
        return this.fontResourceId;
    }

    public int getSelectionFontResourceId() {
        return this.selectionFontResourceId;
    }

    public GFont getSelectionFont() {
        return this.selectionFont;
    }

    public int getXAllign() {
        return this.xAllign;
    }

    public int getYAllign() {
        return this.yAllign;
    }

    public void setSelectionFont(GFont selectionFont) {
        if (selectionFont != null) {
            this.selectionFont = selectionFont;
        }
    }

    public int getSelectionPallate() {
        return this.selectionPallate;
    }

    public int getPallate() {
        return this.pallate;
    }

    public void setSelectionPallate(int selectionPallate) {
        this.selectionPallate = selectionPallate;
    }

    public void setPallate(int pallate) {
        this.pallate = pallate;
        if (this.getSelectionPallate() == -1) {
            this.setSelectionPallate(pallate);
        }
    }

    public int getPreferredHeight() {
        if (this.getCurrentFont() == null) {
            return 20;
        }
        return this.getCurrentFont()._iCharCommanHeight + this.getTopInBound() + this.getBottomInBound();
    }

    public void setXAllign(int xAllign) {
        this.xAllign = xAllign;
    }

    public void setYAllign(int yAllign) {
        this.yAllign = yAllign;
    }

    public void setFont(GFont font) {
        this.font = font;
        if (this.getSelectionFont() == null) {
            this.setSelectionFont(font);
        }
    }

    public GFont getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    private GFont getCurrentFont() {
        GFont font = null;
        if (!this.isSelected()) {
            font = this.font;
            if (this.pallate == -1) {
                this.pallate = 0;
            }
            if (font != null) {
                font.setColor(this.pallate);
            }
        } else {
            font = this.selectionFont;
            if (this.selectionPallate == -1) {
                this.selectionPallate = 0;
            }
            if (font != null) {
                font.setColor(this.selectionPallate);
            }
        }
        return font;
    }

    public void paint(Graphics g) {
        GFont font = this.getCurrentFont();
        if (font == null) {
            return;
        }
        int _x = 0;
        int _y = 0;
        if (this.xAllign == 2) {
            _x = this.getBoundWidth() - this.getPreferredWidth();
        } else if (this.xAllign == 1) {
            _x = this.getBoundWidth() - this.getPreferredWidth() >> 1;
        }
        if (this.yAllign == 2) {
            _y = this.getBoundHeight() - this.getPreferredHeight();
        } else if (this.yAllign == 1) {
            _y = this.getBoundHeight() - this.getPreferredHeight() >> 1;
        }
        font.drawString(g, this.text, _x, _y, 20);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "TextControl- " + this.getId();
    }

    public int getClassCode() {
        return 1000;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.setText(Util.readString(bis));
        this.setFontResourceId(Util.readInt(bis, 1));
        this.setFont(ResourceManager.getInstance().getFontResource(this.getFontResourceId()));
        this.setSelectionFontResourceId(Util.readInt(bis, 1));
        this.setSelectionFont(ResourceManager.getInstance().getFontResource(this.getSelectionFontResourceId()));
        this.setPallate(Util.readInt(bis, 1));
        this.setSelectionPallate(Util.readInt(bis, 1));
        this.setXAllign(Util.readInt(bis, 1));
        this.setYAllign(Util.readInt(bis, 1));
        if (Settings.VERSION_NUMBER_FOUND >= 4) {
            this.setTintColor(Util.readColor(bis));
        }
        bis.close();
        return null;
    }

    public void cleanup() {
        super.cleanup();
        this.selectionFont = null;
        this.font = null;
        this.text = null;
    }

    public void showNotify() {
        if (EventQueue.getInstance().getLocalText(this.localTextId) != null) {
            this.setText(EventQueue.getInstance().getLocalText(this.localTextId));
        }
        super.showNotify();
    }
}

