/*
 * Decompiled with CFR 0.152.
 */
package com.appon.gladiatorescape.ui;

import com.appon.util.Util;
import com.indiagames.runnergame.Constant;
import com.indiagames.runnergame.KnightTestEngine;
import com.indiagames.runnergame.TempleRunCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GallaryScreen {
    int key_selectedIndex = 0;
    private final boolean VERTICAL_PADDING_FIXED;
    private final boolean HORIZONTAL_PADDING_FIXED;
    private final boolean DRAW_DOTS;
    public static final int MAX_COLUMNS = 5;
    public static final int MAX_ROWS = 2;
    private static int TOP_START_Y;
    private static int LEFT_START_X;
    private int VERTICAL_PADDING = 25;
    private int HORIZONTAL_PADDING = 15;
    private static Image boxImage;
    private static Image selectedDotImage;
    private static Image unselectedDotImage;
    private int screenWidth;
    private int screenHeight;
    private int DOTS_Y_POSITION;
    private int currentScreen = 0;
    private static int MOVEMENT_THREASHHOLD;
    private int lastX;
    private int draggedX;
    private int diffX;
    private boolean pointerReleased = false;
    private boolean hasSwitchedScreen = false;
    int max_screens;
    int totalBoxes;
    private boolean isAnimating = false;
    private static int ANIMATION_MOVEMENT_SPEED;
    private static final int PADDING_OF_DOTS = 30;
    public StringBuffer strMedalsType = new StringBuffer();
    public int selectedIndex = 0;
    private int maxChallenges;
    private int modeX;
    private int modeY;
    private int _y;
    int screen_Id = 0;
    int total_Screen_Id;
    private int totalCells;
    public static final int TOTAL_ROWS = 2;
    public static final int TOTAL_COLUMNS = 5;
    public static int MENU_PADDING_Y;
    public static int MENU_PADDING_X;
    private static int MAX_UNLOCKED_LEVELS;
    public static int TOTAL_LEVELS;
    private String title;
    int distance;
    private static int UNLOCKED_LEVELS_COUNTER_PADDING;
    public static int MAIN_MENU_START_Y;
    private int[] levelWiseHeart = new int[50];
    int boxHeight;
    private boolean isFromPointerPress;

    public GallaryScreen(int screenWidth, int screenHeight) {
        this.VERTICAL_PADDING_FIXED = true;
        this.HORIZONTAL_PADDING_FIXED = true;
        this.DRAW_DOTS = true;
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
        this.maxChallenges = TOTAL_LEVELS;
        this.totalCells = 10;
        this.total_Screen_Id = this.maxChallenges / this.totalCells;
        this.title = this.title;
        this.portCalculations();
    }

    public void loadRequiredImages() {
        Constant.IMG_CHALLENGE_BOX.loadImage();
        Constant.IMG_SELECTED_DOT.loadImage();
        Constant.IMG_UNSELECTED_DOT.loadImage();
        Constant.IMG_CHALLENGE_BOX_SELECTION.loadImage();
        Constant.IMG_CHALLENGE_LOCK.loadImage();
        boxImage = Constant.IMG_CHALLENGE_BOX.getImage();
        selectedDotImage = Constant.IMG_SELECTED_DOT.getImage();
        unselectedDotImage = Constant.IMG_UNSELECTED_DOT.getImage();
        MAIN_MENU_START_Y = Constant.IMG_CHALLENGE_BOX.getHeight() >> 1;
        this.modeX = Constant.SCREEN_WIDTH - Constant.IMG_CHALLAGE_MODE.getWidth() >> 1;
        this.modeY = 2;
        this.boxHeight = (Constant.IMG_CHALLENGE_BOX.getHeight() << 2) + (Constant.IMG_CHALLENGE_BOX.getHeight() >> 1);
        this.calculateParameters();
        MAX_UNLOCKED_LEVELS = TempleRunCanvas.challangeMode == 0 ? Constant.MAX_UNLOACK_LEVEL_EASY : Constant.MAX_UNLOACK_LEVEL_HARD;
        this.screen_Id = MAX_UNLOCKED_LEVELS / this.totalCells;
        this.selectedIndex = 0;
        this.screen_Id = 0;
        this.totalBoxes = 10;
        this.max_screens = Constant.TOTAL_LEVELS_PER_CHALLANGE / this.totalBoxes;
    }

    public void unload() {
        Constant.IMG_UNSELECTED_DOT.clear();
        Constant.IMG_SELECTED_DOT.clear();
        Constant.IMG_CHALLENGE_LOCK.clear();
        Constant.IMG_CHALLENGE_BOX.clear();
    }

    private void portCalculations() {
        ANIMATION_MOVEMENT_SPEED = this.screenWidth / 4;
        MOVEMENT_THREASHHOLD = this.screenWidth * 15 / 100;
        System.out.println("Vertical Padding: " + this.VERTICAL_PADDING);
        this.VERTICAL_PADDING = Util.getScaleValue(this.VERTICAL_PADDING, Constant.yScale);
        System.out.println("Vertical Padding --: " + this.VERTICAL_PADDING);
        System.out.println("HORIZONTAL_PADDING : " + this.HORIZONTAL_PADDING);
        this.HORIZONTAL_PADDING = Util.getScaleValue(this.HORIZONTAL_PADDING, Constant.xScale);
        System.out.println("HORIZONTAL_PADDING --: " + this.HORIZONTAL_PADDING);
    }

    private void calculateParameters() {
        TOP_START_Y = this.screenHeight - (boxImage.getHeight() * 2 + this.VERTICAL_PADDING * 1) >> 1;
        LEFT_START_X = this.screenWidth - (boxImage.getWidth() * 5 + this.HORIZONTAL_PADDING * 4) >> 1;
        this.totalBoxes = 10;
        this.max_screens = Constant.TOTAL_LEVELS_PER_CHALLANGE / this.totalBoxes;
        this.DOTS_Y_POSITION = this.screenHeight - TOP_START_Y + (TOP_START_Y - Constant.IMG_SELECTED_DOT.getHeight() >> 1);
    }

    public void reset() {
        this.currentScreen = 0;
        this.diffX = 0;
        this.hasSwitchedScreen = false;
        this.isAnimating = false;
        this.isFromPointerPress = false;
    }

    public void paintNewSoftKey(Graphics g) {
        g.drawImage(Constant.IMG_SMALL_BUTTON.getImage(), 0, Constant.SCREEN_HEIGHT - Constant.IMG_SMALL_BUTTON.getHeight(), 0);
        g.drawImage(Constant.IMG_BACK_ICON.getImage(), Constant.IMG_SMALL_BUTTON.getWidth() - Constant.IMG_BACK_ICON.getWidth() >> 1, Constant.SCREEN_HEIGHT - Constant.IMG_SMALL_BUTTON.getHeight() + (Constant.IMG_SMALL_BUTTON.getHeight() - Constant.IMG_BACK_ICON.getHeight() >> 1), 0);
    }

    public void paint(Graphics canvas, boolean isTouch) {
        if (!isTouch) {
            canvas.drawImage(Constant.BGIMAGE_A_2.getImage(), 0, 0, 0);
            this._y = MAIN_MENU_START_Y;
            int paddingY = (this.boxHeight - Constant.SMALLFONT.getFontHeight() - MENU_PADDING_Y * 3 - 2 * Constant.IMG_CHALLENGE_BOX.getHeight()) / 1;
            int initialPaddingX = Constant.IMG_CHALLENGE_BOX.getWidth() * 5 + 4 * MENU_PADDING_X;
            int drawX = initialPaddingX = Constant.SCREEN_WIDTH - initialPaddingX >> 1;
            int startIndex = this.screen_Id * this.totalCells;
            int endIndex = startIndex + this.totalCells;
            if (endIndex > this.maxChallenges) {
                endIndex = this.maxChallenges;
            }
            if (this.selectedIndex < startIndex) {
                this.selectedIndex = startIndex;
            }
            if (this.selectedIndex > endIndex) {
                this.selectedIndex = endIndex - 1;
            }
            if (this.screen_Id <= this.total_Screen_Id) {
                this._y += MENU_PADDING_Y;
                if (TempleRunCanvas.challangeMode == 0) {
                    Constant.SMALLFONT.drawString(canvas, "Easy Levels", (Constant.SCREEN_WIDTH >> 1) - (Constant.SMALLFONT.getStringWidth("Easy Levels") >> 1), this._y, 20);
                } else {
                    Constant.SMALLFONT.drawString(canvas, "Hard Levels", (Constant.SCREEN_WIDTH >> 1) - (Constant.SMALLFONT.getStringWidth("Hard Levels") >> 1), this._y, 20);
                }
                this._y += MENU_PADDING_Y + Constant.SMALLFONT.getFontHeight();
                int counter = 0;
                this._y += Constant.IMG_CHALLENGE_BOX.getImage().getHeight();
                for (int i = startIndex; i < endIndex; ++i) {
                    canvas.drawImage(Constant.IMG_CHALLENGE_BOX.getImage(), drawX, this._y, 20);
                    if (i == this.selectedIndex) {
                        canvas.drawImage(Constant.IMG_CHALLENGE_BOX_SELECTION.getImage(), drawX - (Constant.IMG_CHALLENGE_BOX_SELECTION.getWidth() - Constant.IMG_CHALLENGE_BOX_SELECTION.getWidth() >> 1), this._y - (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.IMG_CHALLENGE_BOX.getHeight() >> 1) - 1, 20);
                    }
                    if (i < MAX_UNLOCKED_LEVELS) {
                        Constant.SMALLFONT.setColor(0);
                        Constant.SMALLFONT.drawString(canvas, "" + (i + 1), drawX + Math.abs(Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.SMALLFONT.getStringWidth("" + (i + 1)) >> 1), this._y + (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.SMALLFONT.getStringHeight("" + (i + 1)) >> 1), 20);
                    } else {
                        canvas.drawImage(Constant.IMG_CHALLENGE_LOCK.getImage(), drawX + (Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.IMG_CHALLENGE_LOCK.getWidth() >> 1), this._y + (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.IMG_CHALLENGE_LOCK.getHeight() >> 1), 0);
                    }
                    drawX += Constant.IMG_CHALLENGE_BOX.getWidth() + MENU_PADDING_X;
                    if (++counter % 5 == 0) {
                        this._y += Constant.IMG_CHALLENGE_BOX.getHeight() + paddingY;
                        this._y -= Constant.IMG_CHALLENGE_BOX.getImage().getHeight();
                    }
                    if (counter % 5 != 0) continue;
                    drawX = initialPaddingX;
                }
            }
            this.drawDots(canvas);
            this.paintNewSoftKey(canvas);
        } else {
            if (this.currentScreen < 0 || this.currentScreen >= this.max_screens) {
                this.reset();
            }
            if (Math.abs(this.diffX) > 0) {
                if (this.diffX > 0) {
                    this.paintGallaryBox(canvas, this.diffX, 0, this.currentScreen);
                    if (this.currentScreen > 0) {
                        this.paintGallaryBox(canvas, this.diffX - this.screenWidth, 0, this.currentScreen - 1);
                    }
                } else {
                    this.paintGallaryBox(canvas, this.diffX, 0, this.currentScreen);
                    if (this.currentScreen < this.max_screens) {
                        this.paintGallaryBox(canvas, this.diffX + this.screenWidth, 0, this.currentScreen + 1);
                    }
                }
                if (this.pointerReleased) {
                    this.isAnimating = true;
                    if (!this.hasSwitchedScreen) {
                        int lastSign = this.diffX / Math.abs(this.diffX);
                        if (this.diffX > 0) {
                            this.diffX -= ANIMATION_MOVEMENT_SPEED;
                        } else if (this.diffX < 0) {
                            this.diffX += ANIMATION_MOVEMENT_SPEED;
                        }
                        if (this.diffX == 0 || lastSign != this.diffX / Math.abs(this.diffX)) {
                            this.isAnimating = false;
                            this.diffX = 0;
                        }
                    } else {
                        int lastSign = this.diffX / Math.abs(this.diffX);
                        this.diffX = this.diffX < 0 ? (this.diffX -= ANIMATION_MOVEMENT_SPEED) : (this.diffX += ANIMATION_MOVEMENT_SPEED);
                        if (Math.abs(this.diffX) >= this.screenWidth) {
                            this.currentScreen = this.diffX < 0 ? ++this.currentScreen : --this.currentScreen;
                            this.diffX = 0;
                            this.isAnimating = false;
                        }
                    }
                }
            } else {
                this.paintGallaryBox(canvas, 0, 0, this.currentScreen);
            }
            this.drawDots(canvas);
        }
    }

    private void drawDots(Graphics c) {
        if (TempleRunCanvas.isTouchScreen) {
            int totalConsumedWidth = this.max_screens * unselectedDotImage.getWidth() + this.max_screens * 30 + selectedDotImage.getWidth();
            int _x = this.screenWidth - totalConsumedWidth >> 1;
            for (int i = 0; i < this.max_screens; ++i) {
                if (i == this.currentScreen) {
                    c.drawImage(selectedDotImage, _x, this.DOTS_Y_POSITION, 0);
                    _x += selectedDotImage.getWidth() + 30;
                    continue;
                }
                c.drawImage(unselectedDotImage, _x, this.DOTS_Y_POSITION, 0);
                _x += unselectedDotImage.getWidth() + 30;
            }
        } else {
            int totalConsumedWidth = this.max_screens * unselectedDotImage.getWidth() + this.max_screens * 30 + selectedDotImage.getWidth();
            int _x = this.screenWidth - totalConsumedWidth >> 1;
            for (int i = 0; i < this.max_screens; ++i) {
                if (i == this.screen_Id) {
                    c.drawImage(selectedDotImage, _x, this.DOTS_Y_POSITION, 0);
                    _x += selectedDotImage.getWidth() + 30;
                    continue;
                }
                c.drawImage(unselectedDotImage, _x, this.DOTS_Y_POSITION, 0);
                _x += unselectedDotImage.getWidth() + 30;
            }
        }
    }

    private void paintGallaryBox(Graphics canvas, int x, int y, int screenIndex) {
        int _x = x + LEFT_START_X;
        int _y = y + TOP_START_Y;
        int startIndex = this.totalBoxes * screenIndex;
        int endIndex = this.totalBoxes * screenIndex + this.totalBoxes;
        for (int i = startIndex; i < endIndex && i < Constant.TOTAL_LEVELS_PER_CHALLANGE; ++i) {
            int row = (i - startIndex) / 5;
            int col = (i - startIndex) % 5;
            int calculatedX = _x + col * (boxImage.getWidth() + this.HORIZONTAL_PADDING);
            int calculatedY = _y + row * (boxImage.getHeight() + this.VERTICAL_PADDING);
            if (i < 0) continue;
            this.drawBox(canvas, calculatedX, calculatedY, i, i > Constant.MAX_UNLOCKED_LEVELS);
        }
    }

    private void drawBox(Graphics g, int x, int y, int index, boolean isLocaked) {
        if (index < Constant.MAX_UNLOCKED_LEVELS) {
            g.drawImage(Constant.IMG_CHALLENGE_BOX.getImage(), x, y, 20);
            Constant.SMALLFONT.setColor(0);
            Constant.SMALLFONT.drawString(g, "" + (index + 1), x + Math.abs(Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.SMALLFONT.getStringWidth("" + (index + 1)) >> 1), y + (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.SMALLFONT.getFontHeight() >> 1), 20);
        } else {
            g.drawImage(Constant.IMG_CHALLENGE_BOX.getImage(), x, y, 0);
            g.drawImage(Constant.IMG_CHALLENGE_LOCK.getImage(), x + (Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.IMG_CHALLENGE_LOCK.getWidth() >> 1), y + (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.IMG_CHALLENGE_LOCK.getHeight() >> 1), 0);
        }
    }

    public int getRatting(int levelId, int starsCollected) {
        int totalCount = 20;
        if (levelId != 0 && levelId < 10) {
            totalCount = 200;
        } else if (levelId >= 10) {
            totalCount = 300;
        }
        return starsCollected * 100 / totalCount;
    }

    public static boolean isInRect(int xPos, int yPos, int width, int height, int x, int y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    private void itemSelected(int index) {
        TempleRunCanvas.getInstance().chalengsMenu.levelSelected();
    }

    private void checkSelectedBox(int clickX, int clickY) {
        int _x = LEFT_START_X;
        int _y = TOP_START_Y;
        int startIndex = this.totalBoxes * this.currentScreen;
        int endIndex = this.totalBoxes * this.currentScreen + this.totalBoxes;
        for (int i = startIndex; i < endIndex && i < Constant.TOTAL_LEVELS_PER_CHALLANGE; ++i) {
            int calculatedY;
            int row = (i - startIndex) / 5;
            int col = (i - startIndex) % 5;
            int calculatedX = _x + col * (boxImage.getWidth() + this.HORIZONTAL_PADDING);
            if (!GallaryScreen.isInRect(calculatedX, calculatedY = _y + row * (boxImage.getHeight() + this.VERTICAL_PADDING), boxImage.getWidth(), boxImage.getHeight(), clickX, clickY)) continue;
            this.selectedIndex = i;
            this.itemSelected(i);
            break;
        }
    }

    public void pointerPressed(int x, int y) {
        int _x = LEFT_START_X;
        int _y = TOP_START_Y;
        this.isFromPointerPress = true;
        if (this.isAnimating) {
            return;
        }
        this.pointerReleased = false;
        this.lastX = x;
        this.draggedX = x;
        this.diffX = 0;
        this.pointerReleasedForDots(x, y);
        int startIndex = this.totalBoxes * this.currentScreen;
        int endIndex = this.totalBoxes * this.currentScreen + this.totalBoxes;
        for (int i = startIndex; i < endIndex && i < Constant.TOTAL_LEVELS_PER_CHALLANGE; ++i) {
            int calculatedY;
            int row = (i - startIndex) / 5;
            int col = (i - startIndex) % 5;
            int calculatedX = _x + col * (boxImage.getWidth() + this.HORIZONTAL_PADDING);
            if (!GallaryScreen.isInRect(calculatedX, calculatedY = _y + row * (boxImage.getHeight() + this.VERTICAL_PADDING), boxImage.getWidth(), boxImage.getHeight(), x, y)) continue;
            this.selectedIndex = i;
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.isFromPointerPress) {
            return;
        }
        if (this.isAnimating) {
            return;
        }
        this.draggedX = x;
        this.diffX = this.draggedX - this.lastX;
        if (this.diffX > 0 && this.currentScreen == 0 && Math.abs(this.diffX) > this.screenWidth >> 1) {
            this.diffX = this.screenWidth >> 1;
        }
        if (this.diffX < 0 && this.currentScreen >= this.max_screens && Math.abs(this.diffX) > this.screenWidth >> 1) {
            this.diffX = -(this.screenWidth >> 1);
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.isFromPointerPress) {
            return;
        }
        if (this.isAnimating) {
            return;
        }
        this.pointerReleased = true;
        this.lastX = 0;
        this.draggedX = 0;
        if (Math.abs(this.diffX) < 10) {
            this.checkSelectedBox(x, y);
        }
        this.hasSwitchedScreen = Math.abs(this.diffX) > MOVEMENT_THREASHHOLD ? (this.currentScreen > 0 && this.diffX > 0 ? true : this.currentScreen <= this.max_screens && this.diffX < 0) : false;
    }

    private void pointerReleasedForDots(int x, int y) {
        int totalConsumedWidth = this.max_screens * unselectedDotImage.getWidth() + this.max_screens * 30 + selectedDotImage.getWidth();
        int _x = this.screenWidth - totalConsumedWidth >> 1;
        for (int i = 0; i < this.max_screens; ++i) {
            if (i == this.currentScreen) {
                if (Util.isInRect(_x - (selectedDotImage.getWidth() >> 1), this.DOTS_Y_POSITION - (selectedDotImage.getHeight() >> 1), selectedDotImage.getWidth() * 2, selectedDotImage.getHeight() * 2, x, y)) {
                    this.currentScreen = i;
                }
                _x += selectedDotImage.getWidth() + 30;
                continue;
            }
            if (Util.isInRect(_x - (selectedDotImage.getWidth() >> 1), this.DOTS_Y_POSITION - (selectedDotImage.getHeight() >> 1), selectedDotImage.getWidth() * 2, selectedDotImage.getHeight() * 2, x, y)) {
                if (this.currentScreen < i) {
                    this.selectedIndex = this.selectedIndex + 10 * (i - this.currentScreen) < Constant.MAX_UNLOCKED_LEVELS ? (this.selectedIndex += 10 * (i - this.currentScreen)) : Constant.MAX_UNLOCKED_LEVELS - 1;
                } else if (this.currentScreen > i) {
                    this.selectedIndex = this.selectedIndex - 10 * (this.currentScreen - i) > 0 ? (this.selectedIndex -= 10 * (this.currentScreen - i)) : 0;
                }
                this.currentScreen = i;
            }
            _x += unselectedDotImage.getWidth() + 30;
        }
    }

    public int getColFromIndex(int index) {
        return index % 5;
    }

    public int getRowFromIndex(int index) {
        return index / 5;
    }

    public void keyPressed(int keyCode, int gameKey) {
        int row = this.getRowFromIndex(this.selectedIndex);
        int col = this.getColFromIndex(this.selectedIndex);
        if (Util.isLeftSoftkeyPressed(keyCode)) {
            KnightTestEngine.getInstance().levelGenerator.setInLevelMode(false);
            TempleRunCanvas.getInstance().setGameState(8);
        }
        if (Util.isUpPressed(gameKey)) {
            if (row > 2 * (this.screen_Id - 1) + 2 && row < 2 * this.screen_Id + 2) {
                --row;
            }
            this.selectedIndex = row * 5 + col;
        } else if (Util.isDownPressed(gameKey)) {
            if (row < 2 * this.screen_Id + 2 - 1 && row > 2 * (this.screen_Id - 1) + 2 - 1) {
                ++row;
            }
            this.selectedIndex = row * 5 + col;
        } else if (Util.isLeftPressed(gameKey)) {
            if (col > -1) {
                --col;
            }
            if (col == -1) {
                --this.screen_Id;
                col = 4;
                row = this.screen_Id * 2 + 2 - 1;
            }
            if (this.screen_Id == -1) {
                this.screen_Id = 0;
                row = 0;
                col = 0;
            }
            this.selectedIndex = row * 5 + col;
        } else if (Util.isRightPressed(gameKey)) {
            if (col < 5) {
                ++col;
            }
            if (col == 5) {
                ++this.screen_Id;
                col = 0;
                row = this.screen_Id * 2;
            }
            if (this.screen_Id == this.total_Screen_Id) {
                this.screen_Id = 0;
                col = 0;
                row = 0;
            }
            this.selectedIndex = row * 5 + col;
        } else if (Util.isFirePressed(gameKey)) {
            this.itemSelected(this.selectedIndex);
        }
    }

    public void keyReleased(int keyCode, int gameKey) {
    }

    public void keyRepeated(int keyCode, int gameKey) {
    }

    static {
        MENU_PADDING_Y = 8;
        MENU_PADDING_X = 8;
        MAX_UNLOCKED_LEVELS = 1;
        TOTAL_LEVELS = 30;
        UNLOCKED_LEVELS_COUNTER_PADDING = 10;
    }
}

