/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.util.Resources;
import javax.microedition.lcdui.Image;

public class ImageLoadInfo {
    String imageName;
    private byte resizeOption;
    private boolean clear;

    public ImageLoadInfo(String name, byte resizeOption, boolean clear) {
        this(name, resizeOption);
        this.clear = clear;
    }

    public ImageLoadInfo(String name, byte resizeOption) {
        this.imageName = name;
        this.resizeOption = resizeOption;
    }

    public void clear() {
        Resources.getInstance().setImage(this.imageName, null);
    }

    public boolean isNull() {
        return Resources.getInstance().getImage(this.imageName) == null;
    }

    public Image getImage() {
        if (this.clear) {
            Image img = Resources.getInstance().getImage(this.imageName);
            this.clear();
            return img;
        }
        return Resources.getInstance().getImage(this.imageName);
    }

    public int getWidth() {
        return this.getImage().getWidth();
    }

    public int getHeight() {
        return this.getImage().getHeight();
    }

    public void loadImage() {
        if (!this.isNull()) {
            return;
        }
        switch (this.resizeOption) {
            case 0: {
                Resources.getInstance().setImage(this.imageName, Resources.loadResizeImage(this.imageName, -1, -1));
                break;
            }
            case 1: {
                Resources.getInstance().setImage(this.imageName, Resources.loadResizeImage(this.imageName, 128, -1));
                break;
            }
            case 2: {
                Resources.getInstance().setImage(this.imageName, Resources.loadResizeImage(this.imageName, -1, 160));
                break;
            }
            case 3: {
                Resources.getInstance().setImage(this.imageName, Resources.loadResizeImage(this.imageName, 128, 160));
            }
        }
    }
}

