/*
 * Decompiled with CFR 0.152.
 */
package com.appon.runner.model;

import com.appon.runner.RunnerManager;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.runner.model.Shape;
import com.appon.runner.util.Util;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class ShapeGroup
extends Shape {
    private Vector shapeGroup = new Vector();
    int width;
    int height;
    private Vector sortedVector = new Vector();
    private boolean isPorted = false;

    public void addShape(AddedShape shape) {
        if (!this.equals(shape.getShape())) {
            shape.setParent(this);
            this.shapeGroup.addElement(shape);
        }
    }

    public ShapeGroup clone() {
        ShapeGroup gp = new ShapeGroup();
        gp.setId(this.id);
        gp.width = this.width;
        gp.height = this.height;
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            gp.addShape(((AddedShape)this.shapeGroup.elementAt(i)).clone());
        }
        return gp;
    }

    public void deserilize(InputStream bis) throws Exception {
        super.deserilize(bis);
        int size = Util.read(bis, 2);
        for (int i = 0; i < size; ++i) {
            AddedShape addedShape = new AddedShape();
            addedShape.deserilize(bis);
            this.shapeGroup.addElement(addedShape);
        }
    }

    public void paint(Graphics g, int x, int y) {
        this.sortedVector.removeAllElements();
        this.sortedVector = RunnerManager.getManager().getSortedObjects(this.shapeGroup);
        if (this.shapeGroup.size() == 0) {
            return;
        }
        for (int i = 0; i < this.sortedVector.size(); ++i) {
            AddedShape object = (AddedShape)this.sortedVector.elementAt(i);
            object.setParent(this);
            object.setAdditionalX(x);
            object.setAdditionalY(y);
            if (!object.getShape().isIsVisible() || !object.isIsVisible()) continue;
            object.paint(g, 0);
        }
    }

    public void calculateHeight(AddedShape parent) {
        int maxY = 0;
        if (this.shapeGroup.size() == 0) {
            this.height = 10;
            return;
        }
        maxY = Integer.MIN_VALUE;
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            AddedShape object = (AddedShape)this.shapeGroup.elementAt(i);
            if (maxY >= object.getY() + object.getShape().getHeight()) continue;
            maxY = object.getY() + object.getShape().getHeight();
        }
        this.height = maxY;
    }

    public void update(AddedShape shape) {
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            AddedShape object = (AddedShape)this.shapeGroup.elementAt(i);
            if (!object.getShape().isIsVisible() || !object.isIsVisible()) continue;
            object.update();
        }
    }

    public boolean isContaineBGShape() {
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            AddedShape object = (AddedShape)this.shapeGroup.elementAt(i);
            if (!RunnerManager.getManager().isShapeFromBg(object.getShape())) continue;
            return true;
        }
        return false;
    }

    public void calculateWidth(AddedShape parent) {
        int maxX = 0;
        if (this.shapeGroup.size() == 0) {
            this.width = 20;
            return;
        }
        maxX = Integer.MIN_VALUE;
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            AddedShape object = (AddedShape)this.shapeGroup.elementAt(i);
            if (maxX >= object.getX() + object.getShape().getWidth()) continue;
            maxX = object.getX() + object.getShape().getWidth();
        }
        this.width = maxX;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Vector getShapeGroup() {
        return this.shapeGroup;
    }

    public void reset(AddedShape parent) {
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            AddedShape object = (AddedShape)this.shapeGroup.elementAt(i);
            object.setCollisionOccured(false);
            object.setIsVisible(true);
            if (!(object.getShape() instanceof CustomShape)) continue;
            ((CustomShape)object.getShape()).reset();
        }
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape parent) {
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            AddedShape object = (AddedShape)this.shapeGroup.elementAt(i);
            AddedShape value = object.shape.checkCollision(rectX, rectY, rectWidth, rectHeight, object);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public void rescale(float persent) {
        if (this.isPorted) {
            return;
        }
        this.isPorted = true;
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            AddedShape object = (AddedShape)this.shapeGroup.elementAt(i);
            object.rescale(persent);
        }
    }
}

