/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.util.ImageLoadInfo;
import com.appon.util.Util;
import java.util.Hashtable;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class Resources {
    public static final int DEFAULT_IMAGE_WIDTH_RESOLUTION = 128;
    public static final int DEFAULT_IMAGE_HEIGHT_RESOLUTION = 160;
    private static Resources instance;
    static byte counter;
    private Hashtable images = new Hashtable();
    public static final byte RESIZE_NONE = 0;
    public static final byte RESIZE_ONLY_WIDTH = 1;
    public static final byte RESIZE_ONLY_HEIGHT = 2;
    public static final byte RESIZE_BOTH = 3;
    private static int screenWidth;
    private static int screenHeight;

    public static synchronized Resources getInstance() {
        if (instance == null) {
            instance = new Resources();
        }
        return instance;
    }

    public static Image loadResizeImage(String str, int width, int height) {
        if (screenHeight == 0 || screenWidth == 0) {
            throw new RuntimeException("Please initilize the Resource class, by calling init method.");
        }
        try {
            int newWidth = 0;
            int newHeight = 0;
            Image img = Image.createImage((String)("/" + str + ".png"));
            if (screenWidth == width && screenHeight == height) {
                return img;
            }
            newWidth = width == -1 ? img.getWidth() : img.getWidth() * screenWidth / width;
            newHeight = height == -1 ? img.getHeight() : img.getHeight() * screenHeight / height;
            return Util.resizeImageWithTransperency(img, newWidth, newHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setImage(String id, Image image) {
        if (image == null) {
            this.images.remove("" + id);
        } else {
            this.images.put("" + id, image);
        }
    }

    public Image getImageFromKey(String id) {
        if (this.images.get(id) == null) {
            throw new RuntimeException("Image not loaded yet.");
        }
        return (Image)this.images.get(id);
    }

    protected Image getImage(String id) {
        return (Image)this.images.get(id);
    }

    public Image getImage(ImageLoadInfo id) {
        return id.getImage();
    }

    public void init(Displayable canvas) {
        if (Util.isPortraitMode) {
            screenWidth = canvas.getHeight();
            screenHeight = canvas.getWidth();
        } else {
            screenWidth = canvas.getWidth();
            screenHeight = canvas.getHeight();
        }
    }
}

