/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_SCORE = 2;
    public static final int COMP_ID_ABOUT = 3;
    public static final int COMP_ID_SETTINGS = 4;
    public static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_OPTIONS = 6;
    public static final int COMP_ID_RIGHT_FK = 7;
    public static final int COMP_ID_LEFT_FK = 8;
    public static final int COMP_ID_MODE = 9;
    public static final int COMP_ID_NONE = 10;
    private static final int TOTAL_COMP_IDS = 11;
    public static final int COMP_ID_PLAY_TXT = 0;
    public static final int COMP_ID_INSTRUCTIONS_TXT = 1;
    public static final int COMP_ID_SCORE_TXT = 2;
    public static final int COMP_ID_ABOUT_TXT = 3;
    public static final int COMP_ID_NONE_TXT = 6;
    private static final int TOTAL_COMP_IDS_TXT = 7;
    private int actualSceen = 0;
    private static final int SCREEN_MAIN_MENU = 0;
    private static final int SCREEN_INSTRUCTIONS = 1;
    private static final int SCREEN_ABOUT = 2;
    private static final int SCREEN_START_GAME = 3;
    private static final int SCREEN_QUIT_GAME = 4;
    private static final int SCREEN_OPTIONS = 5;
    private static final int SCREEN_TOPSCORES = 6;
    private Rectangle[] rectItems = new Rectangle[11];
    private Rectangle[] rectItems_TXT = new Rectangle[7];
    private int[][] _animationSequence = new int[7][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[15];
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectTopBig;
    private Rectangle rectTopLittle;
    private Rectangle rectTopLittleTXT;
    private Rectangle rectTitle;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private boolean needRepaint = false;
    private boolean activeButton = true;
    PreparedText menuItem;
    PreparedText navigationKeysBB;
    PreparedText title;
    PreparedText instruction;
    PreparedText versionOfGame;
    PreparedText _ptDifficulty;
    private int textOffsetY;
    private Image _imgGameLogo;
    private Image _imgCorpLogo;
    private Image _imgMenuBg;
    private Sprite _sprArrows;
    private Sprite _sprIconPlay;
    private Sprite _sprIconPlaySelector;
    private Sprite _sprIconsFk;
    private Sprite _sprIconsMenu;
    private Sprite _sprIconsMenuSelector;
    private Sprite _sprWindow;
    private Sprite _sprTxtSelector;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private static int _totalRowTiles = 0;
    private static int _totalColTiles = 0;
    boolean check = false;
    int _iColorBg = 15691352;
    private int _iMode = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int musicControler = 0;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    int a;
    private boolean releasedTouch = false;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;
    private int force = this.selectedCompId;
    int posX = 0;
    int posY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenMenu(MainCanvas mainCanvas, int selectedItem, int _imode) {
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this.actualSceen = 0;
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = selectedItem;
        this.selectorCompId = selectedItem;
        this._iMode = _imode;
        try {
            if (MainCanvas.soundManager.IsSoundOn()) {
                MainCanvas.soundManager.SetSoundOn(true);
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (MainCanvas.soundManager.IsSoundOn()) {
                MainCanvas.soundManager.SetSoundOn(true);
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            }
        }
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initTxt();
        this.calculatePositions();
        this.prepareTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.initMode();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{0, 1, 2, 3, 4, 5, 6});
        Resources.loadSprites(new int[]{13, 7, 8, 12, 11, 16, 9, 4, 5, 6, 16});
        Resources.loadGFont(0);
        Resources.loadGFont(1);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{0, 1, 2, 3, 4, 5, 6});
        Resources.freeSprites(new int[]{13, 7, 8, 12, 11, 16, 9, 4, 5, 6, 16});
        Resources.freeGFont(0);
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[1];
        this._imgCorpLogo = Resources.resImgs[0];
        this._imgMenuBg = Resources.resImgs[4];
    }

    private void initSprites() {
        this._sprArrows = Resources.resSprs[13];
        this._sprIconPlay = Resources.resSprs[7];
        this._sprIconPlaySelector = Resources.resSprs[8];
        this._sprIconsFk = Resources.resSprs[12];
        this._sprIconsMenu = Resources.resSprs[11];
        this._sprIconsMenuSelector = Resources.resSprs[16];
        this._sprTxtSelector = Resources.resSprs[9];
        if (this._sprWindow == null) {
            this._sprWindow = Resources.resSprs[5];
        }
        if (this._sprWindow == null) {
            this._sprWindow = Resources.resSprs[6];
        }
        if (this._sprWindow == null) {
            this._sprWindow = Resources.resSprs[4];
        }
    }

    public void initTxt() {
        this.menuItem = new PreparedText(Resources.resGFonts[0]);
        this.versionOfGame = new PreparedText(Resources.resGFonts[1]);
        this.instruction = new PreparedText(Resources.resGFonts[1]);
        this.navigationKeysBB = new PreparedText(Resources.resGFonts[1]);
        this._ptDifficulty = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[0][3] = 3;
        this._animationSequence[0][4] = 4;
        this._animationSequence[0][5] = 5;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[5][0] = 6;
        this._animationSequence[5][1] = 7;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = 0;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[1][0] = 9;
        this._animationSequence[1][1] = 11;
        this._animationSequence[1][2] = -1;
        this._animationSequence[1][3] = -1;
        this._animationSequence[1][4] = -1;
        this._animationSequence[1][5] = -1;
        this._animationSequence[1][6] = -1;
        this._animationSequence[1][7] = -1;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[2][0] = 8;
        this._animationSequence[2][1] = 11;
        this._animationSequence[2][2] = -1;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 9;
        this._animationSequence[4][1] = 11;
        this._animationSequence[4][2] = 10;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[9], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[0], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectItems[1], _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(0);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(2);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this.rectItems[7], _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(1);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectItems[8], _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6].startShowAnimation(0);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(2);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(1);
        this._animationComponents[11].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(3);
        this._animationComponents[6].startHideAnimation(0);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(2);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(1);
        this._animationComponents[11].startHideAnimation(0);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
        this._imgCorpLogo = null;
        this._imgMenuBg = null;
        this._sprArrows = null;
        this._sprIconPlay = null;
        this._sprIconPlaySelector = null;
        this._sprIconsFk = null;
        this._sprIconsMenu = null;
        this._sprIconsMenuSelector = null;
        this._sprWindow = null;
        this._sprTxtSelector = null;
    }

    public void prepareTxt() {
        String controls = "";
        this.textOffsetY = 0;
        controls = Resources.resTexts[0].getHashedString(16);
        this.versionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this.instruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this.instruction.setLineHeightCorrection(-2);
    }

    private void initMode() {
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        if (this._iMode == 1) {
            this._imgGameLogo = Resources.resImgs[2];
            this._imgMenuBg = Resources.resImgs[5];
            this._iColorBg = 2187646;
        } else if (this._iMode == 2) {
            this._imgGameLogo = Resources.resImgs[3];
            this._imgMenuBg = Resources.resImgs[6];
            this._iColorBg = 7521170;
        } else {
            this._imgGameLogo = Resources.resImgs[1];
            this._imgMenuBg = Resources.resImgs[4];
            this._iColorBg = 15691352;
        }
    }

    private void changeGraphicsForMode() {
        ++this._iMode;
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        if (this._iMode == 1) {
            this._imgGameLogo = Resources.resImgs[2];
            this._imgMenuBg = Resources.resImgs[5];
            this._iColorBg = 2187646;
        } else if (this._iMode == 2) {
            this._imgGameLogo = Resources.resImgs[3];
            this._imgMenuBg = Resources.resImgs[6];
            this._iColorBg = 7521170;
        } else {
            this._imgGameLogo = Resources.resImgs[1];
            this._imgMenuBg = Resources.resImgs[4];
            this._iColorBg = 15691352;
        }
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int itemHeight = Resources.resGFonts[0].getHeight();
        int itemWidth = _WIDTH;
        int posX = _WIDTH >> 1;
        int posY = (_HEIGHT >> 1) - (itemHeight << 1);
        if (this._sprWindow == null) {
            this._sprWindow = Resources.resSprs[4];
        }
        int rectTextOffsetX = this._sprIconsFk.getWidth();
        int rectTextOffsetY = this._sprIconsFk.getHeight();
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        this.rectTitle = new Rectangle(posX, itemHeight / 2, itemWidth, itemHeight);
        this.rectItems[7] = this.rectLeftFk = new Rectangle(0, _HEIGHT - (this._sprIconsFk.getHeight() << 1), this._sprIconsFk.getWidth() * 2, this._sprIconsFk.getHeight() * 2);
        this.rectBB_BACK = new Rectangle(0, MainCanvas.HEIGHT - itemHeight, _WIDTH - this._sprIconsFk.getWidth(), itemHeight);
        this.rectItems[8] = this.rectRightFk = new Rectangle(this.mainCanvas.getWidth() - (this._sprIconsFk.getWidth() << 1), _HEIGHT - (this._sprIconsFk.getHeight() << 1), this._sprIconsFk.getWidth() * 2, this._sprIconsFk.getHeight() * 2);
        this.rectBB_MENU = new Rectangle(this._sprIconsFk.getWidth(), MainCanvas.HEIGHT - itemHeight, _WIDTH, itemHeight);
        this.rectItems[0] = new Rectangle((_WIDTH >> 1) - (this._sprIconPlay.getWidth() >> 1), _HEIGHT - this._sprIconPlay.getHeight() - (this._sprIconsMenu.getHeight() << 1), this._sprIconPlay.getWidth(), this._sprIconPlay.getHeight());
        this.rectItems[9] = new Rectangle(0, this.rectItems[0].y - itemHeight - (itemHeight >> 1), _WIDTH, itemHeight);
        int pX = (_WIDTH >> 1) - (this._sprIconsMenu.getWidth() >> 1);
        int pXoffset = this._sprIconsMenu.getWidth() + (this._sprIconsMenu.getWidth() >> 1);
        int pY = this.rectItems[0].y + this.rectItems[0].height + (this._sprIconsMenu.getWidth() >> 2);
        this.rectItems[2] = new Rectangle(pX, pY, this._sprIconsMenu.getWidth(), this._sprIconsMenu.getHeight());
        this.rectItems[6] = new Rectangle(pX - pXoffset, pY, this._sprIconsMenu.getWidth(), this._sprIconsMenu.getHeight());
        this.rectItems[5] = new Rectangle(pX + pXoffset, pY, this._sprIconsMenu.getWidth(), this._sprIconsMenu.getHeight());
        posX = 0;
        posY = (_HEIGHT >> 1) - (itemHeight >> 1);
        this.rectItems[1] = new Rectangle(posX, posY, _WIDTH, itemHeight);
        this.rectItems[3] = new Rectangle(posX, posY += itemHeight << 1, _WIDTH, itemHeight);
        this.rectTopBig = new Rectangle(_WIDTH >> 1, this.rectItems[9].y >> 1, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
    }

    public void update(long lastRunLenght) {
        this.musicInteruptUpdate();
        this.animationController();
        this.animationComponentsUpdate();
        if (this.actualSceen == 1) {
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.actualSceen].length; ++i) {
            if (this._animationSequence[this.actualSceen][i] == -1 || this._animationComponents[this._animationSequence[this.actualSceen][i]] == null || this._animationComponents[this._animationSequence[this.actualSceen][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.actualSceen][i]].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 3) {
                    this.startGameScreen();
                }
                this._sequence = this._sequenceShow;
                this.actualSceen = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startGameScreen() {
        ScreenGame sg = new ScreenGame(this.mainCanvas, this._iMode);
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
        this.mainCanvas.changeLastActiveScreen(sg);
    }

    private void musicInteruptUpdate() {
        if (MainCanvas.interuption_nokia == 0) {
            if (this.cycle > 0) {
                --this.cycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                if (this.musicControler == 1) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    this.musicControler = 0;
                }
                this.cycle = 10;
            }
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.actualSceen) {
            case 0: {
                this.paintGameLogo(g);
                this.paintMainMenuDialogItems(g);
                break;
            }
            case 1: {
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 5: {
                this.paintGameLogo(g);
                this.paintOptionDialogItems(g);
                break;
            }
            case 2: {
                this.paintAboutLogo(g);
                break;
            }
            case 4: {
                this.paintQuit(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        g.setColor(this._iColorBg);
        g.fillRect(0, 0, this.mainCanvas.getWidth(), this.mainCanvas.getHeight());
        g.drawImage(this._imgMenuBg, _WIDTH >> 1, _HEIGHT >> 1, 3);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this.rectTopBig.x, this.rectTopBig.y, 3);
    }

    private void paintInstrusctionTxt(Graphics g) {
        this.instruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectText.y - this._sprArrows.getHeight() - (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectText.y + this.rectText.height + this._sprArrows.getWidth());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectText.y - this._sprArrows.getHeight() - (this._sprArrows.getHeight() >> 1));
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrows.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectText.y + this.rectText.height + this._sprArrows.getWidth());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        }
    }

    private void paintAboutLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this.rectPanel.getCenterX(), this.rectPanel.getCenterY(), 3);
        this.versionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this.versionOfGame.drawText(g, this.rectPanel, this._sprIconsFk.getHeight(), 33);
    }

    private void paintQuit(Graphics g) {
        this.versionOfGame.prepareText(Resources.resTexts[0].getHashedString(2), _WIDTH);
        this.versionOfGame.drawText(g, this.rectText, 0, 3);
    }

    private void paintFK(Graphics g) {
        if (this.actualSceen == 4) {
            this._sprIconsFk.setFrame(4);
            this._sprIconsFk.setPosition(this.rectItems[7].x, this.rectItems[7].y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
            this._sprIconsFk.setFrame(5);
            this._sprIconsFk.setPosition(this.rectItems[8].x + this._sprIconsFk.getWidth(), this.rectItems[8].y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        } else if (this.actualSceen != 0) {
            this._sprIconsFk.setFrame(6);
            this._sprIconsFk.setPosition(this.rectItems[8].x + this._sprIconsFk.getWidth(), this.rectItems[8].y + this._sprIconsFk.getHeight());
            this._sprIconsFk.paint(g);
        }
    }

    private void paintMainMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 0) {
            this.paintGraphicsButton(g, this.selectedCompId, 0, true);
        } else {
            this.paintGraphicsButton(g, 0, 0, false);
        }
        if (this.selectedCompId == 2) {
            this.paintGraphicsButton(g, this.selectedCompId, MainCanvas.soundManager.IsSoundOn() ? 0 : 1, true);
        } else {
            this.paintGraphicsButton(g, 2, MainCanvas.soundManager.IsSoundOn() ? 0 : 1, false);
        }
        if (this.selectedCompId == 6) {
            this.paintGraphicsButton(g, this.selectedCompId, 3, true);
        } else {
            this.paintGraphicsButton(g, 6, 3, false);
        }
        if (this.selectedCompId == 5) {
            this.paintGraphicsButton(g, this.selectedCompId, 2, true);
        } else {
            this.paintGraphicsButton(g, 5, 2, false);
        }
        if (this.selectedCompId == 9) {
            this.paintTextButton(g, this.selectedCompId, 0, true);
        } else {
            this.paintTextButton(g, 9, 0, false);
        }
    }

    private void paintOptionDialogItems(Graphics g) {
        if (this.selectedCompId == 1) {
            this.paintTextButton(g, this.selectedCompId, 0, true);
        } else {
            this.paintTextButton(g, 1, 0, false);
        }
        if (this.selectedCompId == 3) {
            this.paintTextButton(g, this.selectedCompId, 0, true);
        } else {
            this.paintTextButton(g, 3, 0, false);
        }
    }

    private void paintGraphicsButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            if (_type == 0) {
                this._sprIconPlay.setFrame(frame);
                this._sprIconPlay.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprIconPlay.paint(g);
                this._sprIconPlaySelector.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprIconPlaySelector.paint(g);
            } else if (this.rectItems[_type] != null) {
                this._sprIconsMenu.setFrame(frame);
                this._sprIconsMenu.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprIconsMenu.paint(g);
                if (this._sprIconsMenuSelector == null) {
                    // empty if block
                }
                this._sprIconsMenuSelector.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                this._sprIconsMenuSelector.paint(g);
            }
        } else if (_type == 0) {
            this._sprIconPlay.setFrame(frame);
            this._sprIconPlay.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            this._sprIconPlay.paint(g);
        } else {
            this._sprIconsMenu.setFrame(frame);
            this._sprIconsMenu.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            this._sprIconsMenu.paint(g);
        }
    }

    private void paintTextButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            this.menuItem.prepareText(this.getButtonName(_type), this.rectItems[_type].width);
            this.menuItem.drawText(g, this.rectItems[_type], 0, 3);
            int _iStart = this.rectItems[_type].getCenterX() - this._sprTxtSelector.getWidth() - (this._sprTxtSelector.getWidth() >> 1);
            int _iLenght = _iStart + this._sprTxtSelector.getWidth() * 3;
            for (int _iDx = _iStart; _iDx < _iLenght; _iDx += this._sprTxtSelector.getWidth()) {
                this._sprTxtSelector.setPosition(_iDx, this.rectItems[_type].y + this.rectItems[_type].height);
                this._sprTxtSelector.paint(g);
            }
        } else {
            this.menuItem.prepareText(this.getButtonName(_type), this.rectItems[_type].width);
            this.menuItem.drawText(g, this.rectItems[_type], 0, 3);
        }
    }

    private String getButtonName(int _idx) {
        if (_idx == 9) {
            if (this._iMode == 0) {
                return Resources.resTexts[0].getHashedString(81);
            }
            if (this._iMode == 1) {
                return Resources.resTexts[0].getHashedString(82);
            }
            return Resources.resTexts[0].getHashedString(80);
        }
        if (_idx == 1) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(23);
        }
        if (_idx == 2) {
            return Resources.resTexts[0].getHashedString(10);
        }
        return "NAN";
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this.activeButton) {
            if (Keys.isFKRightCode(keyCode)) {
                switch (this.actualSceen) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 5);
                        this.selectedCompId = 1;
                        this.selectorCompId = 1;
                        this.textOffsetY = 0;
                        break;
                    }
                    case 5: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 5);
                        this.selectorCompId = 3;
                        break;
                    }
                    case 4: {
                        this.startAnimation(true, 0);
                        this.selectorCompId = 0;
                    }
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                if (this.actualSceen == 4) {
                    X.quitApp();
                }
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this.actualSceen) {
                        case 0: {
                            switch (this.selectedCompId) {
                                case 9: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.changeGraphicsForMode();
                                    break;
                                }
                                case 0: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 3);
                                    break;
                                }
                                case 6: {
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 5);
                                    this.selectedCompId = 1;
                                    this.selectorCompId = 1;
                                    return;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 6;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 4);
                                    break;
                                }
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 9;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 6;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    if (MainCanvas.soundManager.IsSoundOn()) {
                                        MainCanvas.soundManager.SetSoundOn(false);
                                        MainCanvas.soundManager.Stop();
                                        break;
                                    }
                                    MainCanvas.soundManager.SetSoundOn(true);
                                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                                }
                            }
                            break;
                        }
                        case 1: {
                            if (Keys.isActionGeneratedByKey(1, keyCode) || !Keys.isActionGeneratedByKey(2, keyCode)) break;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 5: {
                            switch (this.selectedCompId) {
                                case 1: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 1);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.startAnimation(true, 2);
                                }
                            }
                            break;
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
                this.force = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    private boolean getButtonPerScreen(int _iItem) {
        switch (this.actualSceen) {
            case 0: {
                if (_iItem == 0) {
                    return true;
                }
                if (_iItem == 2) {
                    return true;
                }
                if (_iItem == 5) {
                    return true;
                }
                if (_iItem == 6) {
                    return true;
                }
                if (_iItem != 9) break;
                return true;
            }
            case 5: {
                if (_iItem == 1) {
                    return true;
                }
                if (_iItem == 3) {
                    return true;
                }
                if (_iItem == 7) {
                    return true;
                }
                if (_iItem != 8) break;
                return true;
            }
            case 1: {
                if (_iItem == 7) {
                    return true;
                }
                if (_iItem != 8) break;
                return true;
            }
            case 2: {
                if (_iItem == 7) {
                    return true;
                }
                if (_iItem != 8) break;
                return true;
            }
            case 4: {
                if (_iItem == 7) {
                    return true;
                }
                if (_iItem != 8) break;
                return true;
            }
        }
        return false;
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (i == 10) {
                this.selectorCompId = this.selectedCompId = 10;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 10 || this.rectItems[i] == null || !this.rectItems[i].contains(x, y) || !this.getButtonPerScreen(i)) continue;
            this.selectedCompId = i;
            this.s = i;
            switch (this.selectedCompId) {
                case 5: {
                    this.force = 5;
                    this.selectedCompId = 5;
                    i = 5;
                    this.selectorCompId = 5;
                    this.a = this.selectedCompId;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 8: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.actualSceen == 1) {
            if (this.posY > y) {
                if (Resources.sysFont) {
                    this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY < 0) {
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                }
                this.needRepaint = true;
            } else if (this.posY < y) {
                int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
                if (Resources.sysFont) {
                    this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY > maxOffsetY) {
                    this.textOffsetY = maxOffsetY;
                    this.scrollUP = true;
                    this.scrollDOWN = false;
                }
                this.needRepaint = true;
            }
        }
        if (this.selectedCompId != 10) {
            if (!this.rectItems[this.selectedCompId].contains(x, y)) {
                switch (this.selectedCompId) {
                    case 4: {
                        break;
                    }
                    case 8: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    case 7: {
                        Keys.keyReleased(-6);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this.selectorCompId = this.selectedCompId = 10;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.selectedCompId != 10) {
            switch (this.selectedCompId) {
                case 5: {
                    this.activeButton = true;
                    this.selectedCompId = this.force;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 4: {
                    if (this.actualSceen != 4) break;
                    X.quitApp();
                    break;
                }
                case 8: {
                    this.activeButton = true;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    this.activeButton = true;
                    this.keyReleased(-6);
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this.selectorCompId = this.selectedCompId = 10;
        this.mainCanvas.repaint();
    }

    private void textMove() {
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
    }
}

