/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.util.Rectangle;

public class Bird {
    private int STATE_READY = 0;
    private int STATE_PLAY = 1;
    private int STATE_FINISH = 2;
    private int _iActualState = this.STATE_READY;
    private int _WIDTH;
    private int _HEIGHT;
    private int _iPositionX;
    private int _iPositionY;
    private int _iSteps = 10;
    private int _iShiftY;
    private boolean _isInited = false;
    private Sprite _sprBird;
    private Sprite _sprShadow;
    private Rectangle _rectBird;
    private World _world;

    public Bird(World world, int _iWidth, int _iHeight) {
        this._world = world;
        this._WIDTH = _iWidth;
        this._HEIGHT = _iHeight;
        this.init();
    }

    private void init() {
        this._sprBird = Resources.resSprs[44];
        this._sprShadow = Resources.resSprs[45];
        this._sprBird.setTransform(6);
        this._sprShadow.setTransform(6);
        this._iShiftY = this._HEIGHT / this._iSteps;
        this._iPositionY = -this._sprShadow.getHeight();
        this._rectBird = new Rectangle(this._iPositionX, this._iPositionY, this._sprBird.getWidth(), this._sprBird.getHeight());
    }

    private void setBirdToPosition() {
        if (this._isInited) {
            return;
        }
        this._isInited = true;
    }

    public void reset() {
        this._iActualState = this.STATE_READY;
        this.init();
    }

    public void update() {
        if (this._iActualState == this.STATE_PLAY) {
            this._rectBird.y += this._iShiftY;
            if (this._world.getCharacter().get_rectChar().getCenterY() <= this._rectBird.getCenterY()) {
                this._world.getCharacter().get_rectChar().y += this._iShiftY;
            }
            if (this._rectBird.y + this._sprShadow.getHeight() > this._HEIGHT) {
                this.stopBirdAnimation();
                this._iActualState = this.STATE_FINISH;
            }
        }
    }

    public void paint(Graphics g) {
        if (this._iActualState == this.STATE_PLAY) {
            this.paintShadow(g);
            this.paintBird(g);
        }
    }

    private void paintShadow(Graphics g) {
        this._sprShadow.setPosition(this._rectBird.x + (this._sprShadow.getWidth() >> 2), this._rectBird.y + (this._sprShadow.getHeight() >> 2));
        this._sprShadow.paint(g);
    }

    private void paintBird(Graphics g) {
        this._sprBird.setPosition(this._rectBird.x, this._rectBird.y);
        this._sprBird.paint(g);
    }

    public void startBirdAnimation(int _iPosX) {
        this._rectBird.x = _iPosX - (this._sprShadow.getWidth() >> 1);
        this._iActualState = this.STATE_PLAY;
    }

    private void stopBirdAnimation() {
        this.reset();
    }

    public boolean isFinish() {
        return this._iActualState == this.STATE_FINISH;
    }
}

