/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Bird;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.World;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    private static final int _STATUS_GAMEOVER_ANIMATION = 4;
    public static Rectangle rectGameArea;
    private Rectangle _rectTxt;
    private int _CONTROL_UP = 0;
    private int _CONTROL_DOWN = 1;
    private int _CONTROL_LEFT = 2;
    private int _CONTROL_RIGHT = 3;
    private Rectangle[] _rectControls = new Rectangle[4];
    private int _iStatus;
    private int _iScore;
    private int _WIDTH;
    private int _HEIGHT;
    private World _world;
    private Bird _bird;
    private PreparedText _tapToStart;
    private int c;
    int PosX = 0;
    int PosY = 0;
    private boolean _pressed = false;

    public void restartGame(int _iWidth, int _iHeight, Sprite _sprCharacterUP, Sprite _sprCharacterRIGHT) {
        this._iStatus = 0;
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._rectTxt = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this._world = new World(_iWidth, _iHeight, _sprCharacterUP, _sprCharacterRIGHT);
        this._bird = new Bird(this._world, _iWidth, _iHeight);
        this._rectControls[this._CONTROL_UP] = new Rectangle(0, 0, _iWidth, _iHeight / 4);
        this._rectControls[this._CONTROL_LEFT] = new Rectangle(0, _iHeight / 4, _iWidth / 2, _iHeight / 2);
        this._rectControls[this._CONTROL_RIGHT] = new Rectangle(_iWidth / 2, _iHeight / 4, _iWidth / 2, _iHeight / 2);
        this._rectControls[this._CONTROL_DOWN] = new Rectangle(0, _iHeight / 4 + _iHeight / 2, _iWidth, _iHeight / 4);
        this._iScore = 0;
    }

    public void update(long lastRunLenght) {
        if (this._iStatus == 0) {
            this._world.updateWorld(lastRunLenght, true);
        } else if (this._iStatus == 4) {
            if (this._bird.isFinish()) {
                this._iStatus = 3;
            } else {
                this._bird.update();
            }
        } else if (this._iStatus == 3) {
            this._iStatus = 3;
        } else {
            this._world.updateWorld(lastRunLenght, false);
            if (this._world.isGameOver() && this._world.isBirdAnim()) {
                this._iStatus = 4;
                this._bird.startBirdAnimation(this._world.getCharacter().get_rectChar().getCenterX());
            } else if (this._world.getCharacter().checkGameOver()) {
                this._iStatus = 3;
            } else if (this._world.isGameOver()) {
                this._iStatus = 3;
            }
        }
        this._world.updateWorld(lastRunLenght, true);
        this.updateTouch();
    }

    public void paint(Graphics g, int status) {
        this.paintWorld(g);
        if (this._iStatus == 0) {
            // empty if block
        }
        if (this._iStatus == 3 || status == 0) {
            // empty if block
        }
        if (this._iStatus == 4) {
            this.paintGameOverAnimation(g);
        }
        this.c = g.getColor();
    }

    private void paintWorld(Graphics g) {
        this._world.paint(g);
    }

    private void paintGameOverAnimation(Graphics g) {
        this._bird.paint(g);
    }

    private void checkScore() {
    }

    public void startUpdate() {
        if (this._iStatus == 0) {
            this._iStatus = 1;
            return;
        }
    }

    public void DragOrDrop() {
    }

    public int getScore() {
        this._iScore = this._world.getMoves();
        return this._iScore;
    }

    public int getEarnedCoins() {
        return this._world.getEarnedCoins();
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public boolean isInitGame() {
        return this._iStatus == 0;
    }

    public void moveUp() {
        this.startUpdate();
        this._world.characterMoveUp();
        System.out.println("$move: UP");
    }

    public void moveDown() {
        this.startUpdate();
        this._world.characterMoveDown();
        System.out.println("$move: DOWN");
    }

    public void moveLeft() {
        this.startUpdate();
        this._world.characterMoveLeft();
        System.out.println("$move: LEFT");
    }

    public void moveRight() {
        this.startUpdate();
        this._world.characterMoveRight();
        System.out.println("$move: RIGHT");
    }

    public void pointerPressed(int x, int y) {
        this._pressed = true;
        this.PosX = x;
        this.PosY = y;
    }

    public void pointerReleased(int x, int y) {
    }

    void updateTouch() {
    }

    public void pointerDrraged(int x, int y) {
        if (this.PosX == -9999) {
            return;
        }
        if (this.PosY == -9999) {
            return;
        }
        if (this._pressed) {
            this._pressed = false;
            System.out.println("Math.abs(x-PosX): " + Math.abs(x - this.PosX));
            System.out.println("Math.abs(y-PosY: " + Math.abs(y - this.PosY));
            System.out.println(Math.abs(x - this.PosX) > Math.abs(y - this.PosY));
            if (Math.abs(x - this.PosX) > Math.abs(y - this.PosY)) {
                if (this.PosX > x) {
                    this.moveLeft();
                    this.resetpos();
                    return;
                }
                if (this.PosX < x) {
                    this.moveRight();
                    this.resetpos();
                    return;
                }
            } else {
                if (this.PosY > y) {
                    this.moveUp();
                    this.resetpos();
                    return;
                }
                if (this.PosY < y) {
                    this.moveDown();
                    this.resetpos();
                    return;
                }
            }
            this.resetpos();
            return;
        }
    }

    void resetpos() {
        this.PosX = -9999;
        this.PosY = -9999;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }
}

