/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.menu;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.IFont;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class LabelsAtlas {
    private Hashtable labels = new Hashtable();
    private Texture2D[] textures;
    private VertexBuffer vertices;
    private Appearance appearance;
    private Label[] digits = new Label[10];
    private int[] itoaBuffer = new int[10];
    private Transform transform = new Transform();

    public void addLabel(String labelId, String textId, IFont font) {
        if (!this.labels.containsKey(labelId)) {
            this.labels.put(labelId, new Label(textId, font));
        }
    }

    public int labelWidth(String labelId) {
        Label label = (Label)this.labels.get(labelId);
        if (label != null) {
            return label.width;
        }
        Debug.error("Missing label " + labelId);
        return -1;
    }

    public int labelHeight(String labelId) {
        Label label = (Label)this.labels.get(labelId);
        if (label != null) {
            return label.height;
        }
        Debug.error("Missing label " + labelId);
        return -1;
    }

    public void drawLabel(Graphics3D g3d, String labelId, Transform transform) {
        Label label = (Label)this.labels.get(labelId);
        this.vertices.setDefaultColor(-1);
        this.appearance.setTexture(0, this.textures[label.textureIndex]);
        g3d.render(this.vertices, label.indices, this.appearance, transform);
    }

    public void drawLabel(Graphics3D g3d, String labelId, Transform transform, int color) {
        Label label = (Label)this.labels.get(labelId);
        this.vertices.setDefaultColor(color);
        this.appearance.setTexture(0, this.textures[label.textureIndex]);
        g3d.render(this.vertices, label.indices, this.appearance, transform);
    }

    public void drawLabel(Graphics3D g, String labelId, float x, float y, float scale, int color, boolean center) {
        Label label = (Label)this.labels.get(labelId);
        this.vertices.setDefaultColor(color);
        this.transform.setIdentity();
        this.transform.postTranslate(x, y, 0.0f);
        if (center) {
            this.transform.postTranslate((float)(-label.width) * scale / 2.0f, (float)label.height * scale / 2.0f, 0.0f);
        }
        this.transform.postScale(scale, scale, 1.0f);
        this.appearance.setTexture(0, this.textures[label.textureIndex]);
        g.render(this.vertices, label.indices, this.appearance, this.transform);
    }

    public void drawLabel(Graphics3D g, String labelId, float x, float y, float scale, boolean center) {
        this.drawLabel(g, labelId, x, y, scale, -1, center);
    }

    public void drawInteger(Graphics3D g3d, int value, Transform transform, int color) {
        this.vertices.setDefaultColor(color);
        int len = this.itoa(value);
        for (int i = 0; i < len; ++i) {
            Label label = this.digits[this.itoaBuffer[i]];
            this.vertices.setDefaultColor(color);
            this.appearance.setTexture(0, this.textures[label.textureIndex]);
            g3d.render(this.vertices, label.indices, this.appearance, transform);
            transform.postTranslate((float)label.width + 1.0f, 0.0f, 0.0f);
        }
    }

    public void drawInteger(Graphics3D g3d, int value, float x, float y, int color) {
        this.vertices.setDefaultColor(color);
        int len = this.itoa(value);
        this.transform.setIdentity();
        this.transform.postTranslate(x, y, 0.0f);
        for (int i = 0; i < len; ++i) {
            Label label = this.digits[this.itoaBuffer[i]];
            this.vertices.setDefaultColor(color);
            this.appearance.setTexture(0, this.textures[label.textureIndex]);
            g3d.render(this.vertices, label.indices, this.appearance, this.transform);
            this.transform.postTranslate((float)label.width + 1.0f, 0.0f, 0.0f);
        }
    }

    public void addDigits(IFont font) {
        for (int i = 0; i <= 9; ++i) {
            String textAndId = Integer.toString(i);
            this.addLabel(textAndId, textAndId, font);
            this.digits[i] = (Label)this.labels.get(textAndId);
        }
    }

    public void rebuildTexture() {
        if (this.textures != null) {
            this.textures = null;
            System.gc();
        }
        int maxWidth = 0;
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            Label label = (Label)enumeration.nextElement();
            label.width = (short)label.font.stringWidth(label.textId);
            label.height = (short)label.font.height();
            maxWidth = Math.max(label.width, maxWidth);
        }
        int v = 0;
        int u = 0;
        int maxHeight = 0;
        int texturesNum = 0;
        Enumeration enumeration2 = this.labels.elements();
        while (enumeration2.hasMoreElements()) {
            Label label = (Label)enumeration2.nextElement();
            if (u + label.width >= 256) {
                if (v + maxHeight >= 230) {
                    u = 0;
                    v = 0;
                } else {
                    u = 0;
                    v += maxHeight;
                }
                maxHeight = 0;
            }
            label.u = (short)u;
            label.v = (short)v;
            label.textureIndex = ++texturesNum;
            u += label.width;
            maxHeight = Math.max(maxHeight, label.height);
        }
        ++texturesNum;
        Image img = Image.createImage((int)256, (int)256);
        Graphics g = img.getGraphics();
        int lastTextureIndex = -1;
        byte[] atlasData = new byte[131072];
        int[] pixelBuffer = new int[1];
        this.textures = new Texture2D[texturesNum];
        Enumeration enumeration3 = this.labels.elements();
        while (enumeration3.hasMoreElements()) {
            Label label = (Label)enumeration3.nextElement();
            if (label.textureIndex != lastTextureIndex) {
                if (lastTextureIndex != -1) {
                    this.textures[lastTextureIndex] = this.makeTextureFromImage(img, atlasData, pixelBuffer);
                }
                g.setColor(0);
                g.fillRect(0, 0, 256, 256);
            }
            label.font.drawString(g, label.textId, label.u, label.v, 20);
            lastTextureIndex = label.textureIndex;
        }
        this.textures[lastTextureIndex] = this.makeTextureFromImage(img, atlasData, pixelBuffer);
        Debug.trace("Labels textures num " + texturesNum);
        this.appearance = new Appearance();
        CompositingMode compositingMode = new CompositingMode();
        compositingMode.setDepthTestEnable(false);
        compositingMode.setDepthWriteEnable(false);
        compositingMode.setBlending(64);
        this.appearance.setCompositingMode(compositingMode);
        PolygonMode polyMode = new PolygonMode();
        polyMode.setCulling(162);
        this.appearance.setPolygonMode(polyMode);
        VertexArray positions = new VertexArray(this.labels.size() * 4, 3, 2);
        VertexArray uvs = new VertexArray(this.labels.size() * 4, 2, 2);
        int[] sizes = new int[1];
        short[] pos = new short[12];
        short[] uv = new short[8];
        int vertexNum = 0;
        int scale = 256;
        Enumeration enumeration4 = this.labels.elements();
        while (enumeration4.hasMoreElements()) {
            Label label = (Label)enumeration4.nextElement();
            pos[0] = 0;
            pos[1] = 0;
            pos[2] = 1;
            uv[0] = this.scaleU(label.u, scale);
            uv[1] = this.scaleV(label.v, scale);
            pos[3] = label.width;
            pos[4] = 0;
            pos[5] = 1;
            uv[2] = this.scaleU(label.u + label.width, scale);
            uv[3] = this.scaleV(label.v, scale);
            pos[6] = 0;
            pos[7] = label.height;
            pos[8] = 1;
            uv[4] = this.scaleU(label.u, scale);
            uv[5] = this.scaleV(label.v + label.height, scale);
            pos[9] = label.width;
            pos[10] = label.height;
            pos[11] = 1;
            uv[6] = this.scaleU(label.u + label.width, scale);
            uv[7] = this.scaleV(label.v + label.height, scale);
            sizes[0] = 4;
            label.indices = new TriangleStripArray(vertexNum, sizes);
            positions.set(vertexNum, 4, pos);
            uvs.set(vertexNum, 4, uv);
            vertexNum += 4;
        }
        this.vertices = new VertexBuffer();
        this.vertices.setPositions(positions, 1.0f, null);
        this.vertices.setTexCoords(0, uvs, 1.0f / (float)scale, null);
    }

    private Texture2D makeTextureFromImage(Image img, byte[] atlasData, int[] pixelBuffer) {
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                img.getRGB(pixelBuffer, 0, 1, x, y, 1, 1);
                if ((pixelBuffer[0] & 0xFFFFFF) != 0) {
                    atlasData[(x + y * 256) * 2] = (byte)(pixelBuffer[0] >> 16 & 0xFF);
                    atlasData[(x + y * 256) * 2 + 1] = -1;
                    continue;
                }
                atlasData[(x + y * 256) * 2] = 0;
                atlasData[(x + y * 256) * 2 + 1] = 0;
            }
        }
        Image2D img2d = new Image2D(98, 256, 256, atlasData);
        return new Texture2D(img2d);
    }

    private short scaleU(int u, int scale) {
        return (short)(u * scale / 256);
    }

    private short scaleV(int v, int scale) {
        return (short)(v * scale / 256);
    }

    private int itoa(int n) {
        if (n < 0) {
            n = -n;
        }
        int len = 0;
        boolean flag = false;
        if (n == 0) {
            this.itoaBuffer[len++] = 0;
        } else {
            for (int k = 10000; k > 0; k /= 10) {
                int r = n / k;
                if (flag || r > 0) {
                    this.itoaBuffer[len++] = r;
                    flag = true;
                }
                n -= r * k;
            }
        }
        return len;
    }

    private class Label {
        public String textId;
        public IFont font;
        public short u;
        public short v;
        public short width;
        public short height;
        public IndexBuffer indices;
        public int textureIndex;

        public Label(String textId, IFont font) {
            this.textId = textId;
            this.font = font;
        }
    }
}

