/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.textdisplay;

public class Tokenizer {
    public static final int STRING = 0;
    public static final int LEFT_BRACE = 1;
    public static final int RIGHT_BRACE = 2;
    public static final int EOF = 3;
    private static final String DELIMITERS = " \t\r\n";
    private static final String SPECIAL_TOKENS = "[]";
    private char current;
    private int index;
    private String src;
    private int srcLen;
    private boolean stop;
    private StringBuffer tokenBuffer = new StringBuffer();
    private String tokenString;
    private int token;

    public void tokenize(String in) {
        this.src = in;
        this.srcLen = in.length();
        this.index = 0;
        this.stop = false;
        this.readChar();
    }

    public int nextToken() {
        this.skipWhite();
        if (this.index == this.srcLen) {
            this.token = 3;
        } else if (this.current == '[') {
            this.readChar();
            this.token = 1;
        } else if (this.current == ']') {
            this.readChar();
            this.token = 2;
        } else {
            this.readString();
            this.token = 0;
            this.tokenString = this.tokenBuffer.toString();
        }
        return this.token;
    }

    public int token() {
        return this.token;
    }

    public String stringToken() {
        return this.tokenString;
    }

    private void readString() {
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append(this.current);
        while (true) {
            this.readChar();
            if (this.stop || DELIMITERS.indexOf(this.current) != -1 || SPECIAL_TOKENS.indexOf(this.current) != -1) break;
            this.tokenBuffer.append(this.current);
        }
        this.tokenString = this.tokenBuffer.toString();
    }

    private void skipWhite() {
        while (!this.stop && DELIMITERS.indexOf(this.current) != -1) {
            this.readChar();
        }
    }

    private void readChar() {
        if (this.index == this.srcLen) {
            this.stop = true;
            return;
        }
        this.current = this.src.charAt(this.index++);
    }
}

