/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.game.Color;
import com.gamelion.speedx.game.Vector3f;
import java.util.Random;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class ObstacleMeshManager {
    public static final int OBSTACLE_CUBE = 0;
    public static final int OBSTACLE_BEAM = 1;
    public static final int OBSTACLE_SPIKE = 2;
    public static final int OBSTACLE_TYPES_COUNT = 3;
    public static final int VERTICES_PER_CUBE = 24;
    public static final int VERTICES_PER_BEAM = 56;
    public static final int VERTICES_PER_SPIKE = 5;
    public static final int MAX_OBSTACLES = 50;
    public static final float BEAM_PARTS_LEN = 0.33f;
    public static final float SPIKE_HEIGHT = 0.9f;
    public static final float EXPLOSION_DURATION = 0.75f;
    private static Vector3f t1 = new Vector3f();
    private static Vector3f t = new Vector3f();
    private static Vector3f u = new Vector3f();
    private static Vector3f v = new Vector3f();
    private Random rng;
    private BeamsSet beams;
    private CubesSet cubes;
    private SpikesSet spikes;

    static Vector3f cubeMesh(float[] dest, Vector3f[] base, float size) {
        ObstacleMeshManager.u.x = base[2].x - base[0].x;
        ObstacleMeshManager.u.y = base[2].y - base[0].y;
        ObstacleMeshManager.u.z = base[2].z - base[0].z;
        ObstacleMeshManager.v.x = base[1].x - base[0].x;
        ObstacleMeshManager.v.y = base[1].y - base[0].y;
        ObstacleMeshManager.v.z = base[1].z - base[0].z;
        Vector3f.cross(t1, u, v);
        t1.normalize();
        ObstacleMeshManager.t.x = ObstacleMeshManager.t1.x * size;
        ObstacleMeshManager.t.y = ObstacleMeshManager.t1.y * size;
        ObstacleMeshManager.t.z = ObstacleMeshManager.t1.z * size;
        float bfx1 = base[0].x;
        float bfy1 = base[0].y;
        float bfz1 = base[0].z;
        float bfx2 = base[1].x;
        float bfy2 = base[1].y;
        float bfz2 = base[1].z;
        float bbx1 = base[2].x;
        float bby1 = base[2].y;
        float bbz1 = base[2].z;
        float bbx2 = base[3].x;
        float bby2 = base[3].y;
        float bbz2 = base[3].z;
        float bfx1_tx = bfx1 + ObstacleMeshManager.t.x;
        float bfy1_ty = bfy1 + ObstacleMeshManager.t.y;
        float bfz1_tz = bfz1 + ObstacleMeshManager.t.z;
        float bfx2_tx = bfx2 + ObstacleMeshManager.t.x;
        float bfy2_ty = bfy2 + ObstacleMeshManager.t.y;
        float bfz2_tz = bfz2 + ObstacleMeshManager.t.z;
        float bbx1_tx = bbx1 + ObstacleMeshManager.t.x;
        float bby1_ty = bby1 + ObstacleMeshManager.t.y;
        float bbz1_tz = bbz1 + ObstacleMeshManager.t.z;
        float bbx2_tx = bbx2 + ObstacleMeshManager.t.x;
        float bby2_ty = bby2 + ObstacleMeshManager.t.y;
        float bbz2_tz = bbz2 + ObstacleMeshManager.t.z;
        int i = 0;
        dest[i++] = bfx1;
        dest[i++] = bfy1;
        dest[i++] = bfz1;
        dest[i++] = bfx2;
        dest[i++] = bfy2;
        dest[i++] = bfz2;
        dest[i++] = bbx1;
        dest[i++] = bby1;
        dest[i++] = bbz1;
        dest[i++] = bbx2;
        dest[i++] = bby2;
        dest[i++] = bbz2;
        dest[i++] = bfx1_tx;
        dest[i++] = bfy1_ty;
        dest[i++] = bfz1_tz;
        dest[i++] = bfx2_tx;
        dest[i++] = bfy2_ty;
        dest[i++] = bfz2_tz;
        dest[i++] = bbx1_tx;
        dest[i++] = bby1_ty;
        dest[i++] = bbz1_tz;
        dest[i++] = bbx2_tx;
        dest[i++] = bby2_ty;
        dest[i++] = bbz2_tz;
        dest[i++] = bfx1;
        dest[i++] = bfy1;
        dest[i++] = bfz1;
        dest[i++] = bfx2;
        dest[i++] = bfy2;
        dest[i++] = bfz2;
        dest[i++] = bfx1_tx;
        dest[i++] = bfy1_ty;
        dest[i++] = bfz1_tz;
        dest[i++] = bfx2_tx;
        dest[i++] = bfy2_ty;
        dest[i++] = bfz2_tz;
        dest[i++] = bbx1;
        dest[i++] = bby1;
        dest[i++] = bbz1;
        dest[i++] = bbx2;
        dest[i++] = bby2;
        dest[i++] = bbz2;
        dest[i++] = bbx1_tx;
        dest[i++] = bby1_ty;
        dest[i++] = bbz1_tz;
        dest[i++] = bbx2_tx;
        dest[i++] = bby2_ty;
        dest[i++] = bbz2_tz;
        dest[i++] = bfx1;
        dest[i++] = bfy1;
        dest[i++] = bfz1;
        dest[i++] = bbx1;
        dest[i++] = bby1;
        dest[i++] = bbz1;
        dest[i++] = bfx1_tx;
        dest[i++] = bfy1_ty;
        dest[i++] = bfz1_tz;
        dest[i++] = bbx1_tx;
        dest[i++] = bby1_ty;
        dest[i++] = bbz1_tz;
        dest[i++] = bfx2;
        dest[i++] = bfy2;
        dest[i++] = bfz2;
        dest[i++] = bbx2;
        dest[i++] = bby2;
        dest[i++] = bbz2;
        dest[i++] = bfx2_tx;
        dest[i++] = bfy2_ty;
        dest[i++] = bfz2_tz;
        dest[i++] = bbx2_tx;
        dest[i++] = bby2_ty;
        dest[i++] = bbz2_tz;
        return t1;
    }

    static Vector3f beamMesh(float[] dest, Vector3f[] base, float size) {
        ObstacleMeshManager.u.x = base[2].x - base[0].x;
        ObstacleMeshManager.u.y = base[2].y - base[0].y;
        ObstacleMeshManager.u.z = base[2].z - base[0].z;
        ObstacleMeshManager.v.x = base[1].x - base[0].x;
        ObstacleMeshManager.v.y = base[1].y - base[0].y;
        ObstacleMeshManager.v.z = base[1].z - base[0].z;
        Vector3f.cross(t, u, v);
        t.normalize();
        float bfx1 = base[0].x;
        float bfy1 = base[0].y;
        float bfz1 = base[0].z;
        float bfx2 = base[1].x;
        float bfy2 = base[1].y;
        float bfz2 = base[1].z;
        float bbx1 = base[2].x;
        float bby1 = base[2].y;
        float bbz1 = base[2].z;
        float bbx2 = base[3].x;
        float bby2 = base[3].y;
        float bbz2 = base[3].z;
        float size1 = 0.1f * size;
        float size2 = 0.9f * size;
        float tx1 = size1 * ObstacleMeshManager.t.x;
        float ty1 = size1 * ObstacleMeshManager.t.y;
        float tz1 = size1 * ObstacleMeshManager.t.z;
        float tx2 = size2 * ObstacleMeshManager.t.x;
        float ty2 = size2 * ObstacleMeshManager.t.y;
        float tz2 = size2 * ObstacleMeshManager.t.z;
        float tx3 = size * ObstacleMeshManager.t.x;
        float ty3 = size * ObstacleMeshManager.t.y;
        float tz3 = size * ObstacleMeshManager.t.z;
        int i = 0;
        dest[i++] = bfx1;
        dest[i++] = bfy1;
        dest[i++] = bfz1;
        dest[i++] = bfx2;
        dest[i++] = bfy2;
        dest[i++] = bfz2;
        dest[i++] = bbx1;
        dest[i++] = bby1;
        dest[i++] = bbz1;
        dest[i++] = bbx2;
        dest[i++] = bby2;
        dest[i++] = bbz2;
        dest[i++] = bfx1 + tx3;
        dest[i++] = bfy1 + ty3;
        dest[i++] = bfz1 + tz3;
        dest[i++] = bfx2 + tx3;
        dest[i++] = bfy2 + ty3;
        dest[i++] = bfz2 + tz3;
        dest[i++] = bbx1 + tx3;
        dest[i++] = bby1 + ty3;
        dest[i++] = bbz1 + tz3;
        dest[i++] = bbx2 + tx3;
        dest[i++] = bby2 + ty3;
        dest[i++] = bbz2 + tz3;
        dest[i++] = bfx1;
        dest[i++] = bfy1;
        dest[i++] = bfz1;
        dest[i++] = bfx2;
        dest[i++] = bfy2;
        dest[i++] = bfz2;
        dest[i++] = bfx1 + tx1;
        dest[i++] = bfy1 + ty1;
        dest[i++] = bfz1 + tz1;
        dest[i++] = bfx2 + tx1;
        dest[i++] = bfy2 + ty1;
        dest[i++] = bfz2 + tz1;
        dest[i++] = bfx1 + tx1;
        dest[i++] = bfy1 + ty1;
        dest[i++] = bfz1 + tz1;
        dest[i++] = bfx2 + tx1;
        dest[i++] = bfy2 + ty1;
        dest[i++] = bfz2 + tz1;
        dest[i++] = bfx1 + tx2;
        dest[i++] = bfy1 + ty2;
        dest[i++] = bfz1 + tz2;
        dest[i++] = bfx2 + tx2;
        dest[i++] = bfy2 + ty2;
        dest[i++] = bfz2 + tz2;
        dest[i++] = bfx1 + tx2;
        dest[i++] = bfy1 + ty2;
        dest[i++] = bfz1 + tz2;
        dest[i++] = bfx2 + tx2;
        dest[i++] = bfy2 + ty2;
        dest[i++] = bfz2 + tz2;
        dest[i++] = bfx1 + tx3;
        dest[i++] = bfy1 + ty3;
        dest[i++] = bfz1 + tz3;
        dest[i++] = bfx2 + tx3;
        dest[i++] = bfy2 + ty3;
        dest[i++] = bfz2 + tz3;
        dest[i++] = bbx1;
        dest[i++] = bby1;
        dest[i++] = bbz1;
        dest[i++] = bbx2;
        dest[i++] = bby2;
        dest[i++] = bbz2;
        dest[i++] = bbx1 + tx1;
        dest[i++] = bby1 + ty1;
        dest[i++] = bbz1 + tz1;
        dest[i++] = bbx2 + tx1;
        dest[i++] = bby2 + ty1;
        dest[i++] = bbz2 + tz1;
        dest[i++] = bbx1 + tx1;
        dest[i++] = bby1 + ty1;
        dest[i++] = bbz1 + tz1;
        dest[i++] = bbx2 + tx1;
        dest[i++] = bby2 + ty1;
        dest[i++] = bbz2 + tz1;
        dest[i++] = bbx1 + tx2;
        dest[i++] = bby1 + ty2;
        dest[i++] = bbz1 + tz2;
        dest[i++] = bbx2 + tx2;
        dest[i++] = bby2 + ty2;
        dest[i++] = bbz2 + tz2;
        dest[i++] = bbx1 + tx2;
        dest[i++] = bby1 + ty2;
        dest[i++] = bbz1 + tz2;
        dest[i++] = bbx2 + tx2;
        dest[i++] = bby2 + ty2;
        dest[i++] = bbz2 + tz2;
        dest[i++] = bbx1 + tx3;
        dest[i++] = bby1 + ty3;
        dest[i++] = bbz1 + tz3;
        dest[i++] = bbx2 + tx3;
        dest[i++] = bby2 + ty3;
        dest[i++] = bbz2 + tz3;
        dest[i++] = bfx1;
        dest[i++] = bfy1;
        dest[i++] = bfz1;
        dest[i++] = bbx1;
        dest[i++] = bby1;
        dest[i++] = bbz1;
        dest[i++] = bfx1 + tx1;
        dest[i++] = bfy1 + ty1;
        dest[i++] = bfz1 + tz1;
        dest[i++] = bbx1 + tx1;
        dest[i++] = bby1 + ty1;
        dest[i++] = bbz1 + tz1;
        dest[i++] = bfx1 + tx1;
        dest[i++] = bfy1 + ty1;
        dest[i++] = bfz1 + tz1;
        dest[i++] = bbx1 + tx1;
        dest[i++] = bby1 + ty1;
        dest[i++] = bbz1 + tz1;
        dest[i++] = bfx1 + tx2;
        dest[i++] = bfy1 + ty2;
        dest[i++] = bfz1 + tz2;
        dest[i++] = bbx1 + tx2;
        dest[i++] = bby1 + ty2;
        dest[i++] = bbz1 + tz2;
        dest[i++] = bfx1 + tx2;
        dest[i++] = bfy1 + ty2;
        dest[i++] = bfz1 + tz2;
        dest[i++] = bbx1 + tx2;
        dest[i++] = bby1 + ty2;
        dest[i++] = bbz1 + tz2;
        dest[i++] = bfx1 + tx3;
        dest[i++] = bfy1 + ty3;
        dest[i++] = bfz1 + tz3;
        dest[i++] = bbx1 + tx3;
        dest[i++] = bby1 + ty3;
        dest[i++] = bbz1 + tz3;
        dest[i++] = bfx2;
        dest[i++] = bfy2;
        dest[i++] = bfz2;
        dest[i++] = bbx2;
        dest[i++] = bby2;
        dest[i++] = bbz2;
        dest[i++] = bfx2 + tx1;
        dest[i++] = bfy2 + ty1;
        dest[i++] = bfz2 + tz1;
        dest[i++] = bbx2 + tx1;
        dest[i++] = bby2 + ty1;
        dest[i++] = bbz2 + tz1;
        dest[i++] = bfx2 + tx1;
        dest[i++] = bfy2 + ty1;
        dest[i++] = bfz2 + tz1;
        dest[i++] = bbx2 + tx1;
        dest[i++] = bby2 + ty1;
        dest[i++] = bbz2 + tz1;
        dest[i++] = bfx2 + tx2;
        dest[i++] = bfy2 + ty2;
        dest[i++] = bfz2 + tz2;
        dest[i++] = bbx2 + tx2;
        dest[i++] = bby2 + ty2;
        dest[i++] = bbz2 + tz2;
        dest[i++] = bfx2 + tx2;
        dest[i++] = bfy2 + ty2;
        dest[i++] = bfz2 + tz2;
        dest[i++] = bbx2 + tx2;
        dest[i++] = bby2 + ty2;
        dest[i++] = bbz2 + tz2;
        dest[i++] = bfx2 + tx3;
        dest[i++] = bfy2 + ty3;
        dest[i++] = bfz2 + tz3;
        dest[i++] = bbx2 + tx3;
        dest[i++] = bby2 + ty3;
        dest[i++] = bbz2 + tz3;
        return t;
    }

    static Vector3f spikeMesh(float[] dest, Vector3f[] base, float size) {
        ObstacleMeshManager.v.x = base[1].x - base[0].x;
        ObstacleMeshManager.v.y = base[1].y - base[0].y;
        ObstacleMeshManager.v.z = base[1].z - base[0].z;
        ObstacleMeshManager.u.x = base[2].x - base[0].x;
        ObstacleMeshManager.u.y = base[2].y - base[0].y;
        ObstacleMeshManager.u.z = base[2].z - base[0].z;
        Vector3f.cross(t, u, v);
        t.normalize();
        ObstacleMeshManager.t.x = ObstacleMeshManager.t.x * 0.9f * size + (ObstacleMeshManager.u.x + ObstacleMeshManager.v.x) * 0.5f;
        ObstacleMeshManager.t.y = ObstacleMeshManager.t.y * 0.9f * size + (ObstacleMeshManager.u.y + ObstacleMeshManager.v.y) * 0.5f;
        ObstacleMeshManager.t.z = ObstacleMeshManager.t.z * 0.9f * size + (ObstacleMeshManager.u.z + ObstacleMeshManager.v.z) * 0.5f;
        float bfx1 = base[0].x;
        float bfy1 = base[0].y;
        float bfz1 = base[0].z;
        float bfx2 = base[1].x;
        float bfy2 = base[1].y;
        float bfz2 = base[1].z;
        float bbx1 = base[2].x;
        float bby1 = base[2].y;
        float bbz1 = base[2].z;
        float bbx2 = base[3].x;
        float bby2 = base[3].y;
        float bbz2 = base[3].z;
        int i = 0;
        dest[i++] = bfx1 + ObstacleMeshManager.t.x;
        dest[i++] = bfy1 + ObstacleMeshManager.t.y;
        dest[i++] = bfz1 + ObstacleMeshManager.t.z;
        dest[i++] = bfx1;
        dest[i++] = bfy1;
        dest[i++] = bfz1;
        dest[i++] = bfx2;
        dest[i++] = bfy2;
        dest[i++] = bfz2;
        dest[i++] = bbx2;
        dest[i++] = bby2;
        dest[i++] = bbz2;
        dest[i++] = bbx1;
        dest[i++] = bby1;
        dest[i++] = bbz1;
        return t;
    }

    public ObstacleMeshManager(Random rng) {
        this.rng = rng;
        this.beams = new BeamsSet();
        this.cubes = new CubesSet();
        this.spikes = new SpikesSet();
    }

    public void add(int type, Vector3f[] base, Color col, float size) {
        this.add(this.getObstaclesSet(type), base, col, size);
    }

    public void explode(int type, float now, Vector3f origin, Color col, int ndx) {
        Debug.error("explode");
    }

    public void addExplosion(int type, float now, Vector3f origin, Color col, float[] vertices) {
        Debug.error("Add explozion");
    }

    public void clear() {
        this.cubes.clear();
        this.beams.clear();
        this.spikes.clear();
    }

    public void remove(int type, int count) {
        this.getObstaclesSet(type).removeFromBegining(count);
    }

    public void update(float now) {
        this.cubes.update(now);
        this.spikes.update(now);
        this.beams.update(now);
    }

    public void render(Graphics3D g3d, int type, Appearance appearance, Transform transform, Color color) {
        this.getObstaclesSet(type).render(g3d, appearance, transform, color);
    }

    public static Vector3f createCubeMesh(float[] dst, Vector3f[] base, float size) {
        return ObstacleMeshManager.cubeMesh(dst, base, size);
    }

    public void reset() {
        this.cubes.reset();
        this.spikes.reset();
        this.beams.reset();
    }

    private ObstaclesSet getObstaclesSet(int type) {
        switch (type) {
            case 0: {
                return this.cubes;
            }
            case 1: {
                return this.beams;
            }
            case 2: {
                return this.spikes;
            }
        }
        return null;
    }

    private void add(ObstaclesSet set, Vector3f[] base, Color color, float size) {
        set.add(base, color, size);
    }

    private class SpikesSet
    extends ObstaclesSetStorage {
        public SpikesSet() {
            super(5, 4, 1);
            int pos = 0;
            int lenPos = 0;
            for (int j = 0; j < 4; ++j) {
                int last = 2 + j;
                if (last == 5) {
                    last = 1;
                }
                this.indicesLen[lenPos++] = 3;
                this.indices[pos++] = 0;
                this.indices[pos++] = 1 + j;
                this.indices[pos++] = last;
            }
            for (int i = 0; i < 50; ++i) {
                pos = 0;
                this.texCoords[i][pos++] = 0.5f;
                this.texCoords[i][pos++] = 0.0f;
                for (int j = 0; j < 4; ++j) {
                    this.texCoords[i][pos++] = j % 2 != 0 ? 1.0f : 0.0f;
                    this.texCoords[i][pos++] = 1.0f;
                }
            }
        }

        public void add(Vector3f[] base, Color color, float size) {
            this.fillColor(this.obstaclesCount, color);
            ObstacleMeshManager.spikeMesh(this.obstacleVertices(this.obstaclesCount++), base, size);
            this.createIndexBuffer();
        }

        public void addExplosion(Random rng, float now, Vector3f origin, Color color, float[] vertices) {
        }
    }

    private class BeamsSet
    extends ObstaclesSetStorage {
        public BeamsSet() {
            super(56, 28, 2);
            int pos = 0;
            int lenPos = 0;
            for (int i = 0; i < 14; ++i) {
                int base = 4 * i;
                this.indicesLen[lenPos++] = 3;
                this.indices[pos++] = base + 0;
                this.indices[pos++] = base + 1;
                this.indices[pos++] = base + 2;
                this.indicesLen[lenPos++] = 3;
                this.indices[pos++] = base + 1;
                this.indices[pos++] = base + 2;
                this.indices[pos++] = base + 3;
            }
            float bottomV = 0.33f;
            float centerV = 0.66999996f;
            for (int i = 0; i < 50; ++i) {
                int j;
                int pos2 = 0;
                for (j = 0; j < 2; ++j) {
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                }
                for (j = 0; j < 4; ++j) {
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.33f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 0.33f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.33f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 0.33f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.66999996f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 0.66999996f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.66999996f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 0.66999996f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                }
            }
        }

        public void add(Vector3f[] base, Color color, float size) {
            this.fillColor(this.obstaclesCount, color);
            ObstacleMeshManager.beamMesh(this.vertices[this.obstaclesCount++], base, size);
            this.createIndexBuffer();
        }

        public void addExplosion(Random rng, float now, Vector3f origin, Color color, float[] vertices) {
        }
    }

    private class CubesSet
    extends ObstaclesSetStorage {
        public CubesSet() {
            super(24, 12, 2);
            int i;
            int pos = 0;
            int lenPos = 0;
            for (i = 0; i < 6; ++i) {
                int base = 4 * i;
                this.indicesLen[lenPos++] = 3;
                this.indices[pos++] = base + 0;
                this.indices[pos++] = base + 1;
                this.indices[pos++] = base + 2;
                this.indicesLen[lenPos++] = 3;
                this.indices[pos++] = base + 1;
                this.indices[pos++] = base + 2;
                this.indices[pos++] = base + 3;
            }
            for (i = 0; i < 50; ++i) {
                int pos2 = 0;
                for (int j = 0; j < 6; ++j) {
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 0.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                    this.texCoords[i][pos2++] = 1.0f;
                }
            }
        }

        public void add(Vector3f[] base, Color color, float size) {
            this.fillColor(this.obstaclesCount, color);
            ObstacleMeshManager.cubeMesh(this.vertices[this.obstaclesCount++], base, size);
            this.createIndexBuffer();
        }

        public void addExplosion(Random rng, float now, Vector3f origin, Color color, float[] vertices) {
        }
    }

    private abstract class ObstaclesSetStorage
    extends ObstaclesSet {
        private short[] posConvertBuffer;
        private byte[] uvConvertBuffer;
        private byte[] colorConvertBuffer;
        protected float[][] vertices;
        protected byte[][] colors;
        protected float[][] texCoords;
        protected int[] indices;
        protected int[] indicesLen;
        protected int obstaclesCount;
        protected Vector explosions = new Vector();
        protected VertexBuffer vertexBuffer;
        protected VertexArray verticesArray;
        protected VertexArray uvArray;
        protected VertexArray colorArray;
        protected IndexBuffer indexBuffer;
        protected int verticesCount;

        public ObstaclesSetStorage(int verticesPerObstacle, int facesPerObstacle, int explosionPartFacesCount) {
            this.verticesCount = verticesPerObstacle;
            this.vertices = new float[50][3 * verticesPerObstacle];
            this.colors = new byte[50][4 * verticesPerObstacle];
            this.texCoords = new float[50][2 * verticesPerObstacle];
            this.indices = new int[3 * facesPerObstacle];
            this.indicesLen = new int[facesPerObstacle];
            this.posConvertBuffer = new short[verticesPerObstacle * 3];
            this.uvConvertBuffer = new byte[verticesPerObstacle * 2];
            this.colorConvertBuffer = new byte[verticesPerObstacle * 4];
            this.vertexBuffer = new VertexBuffer();
            this.verticesArray = new VertexArray(verticesPerObstacle, 3, 2);
            this.uvArray = new VertexArray(verticesPerObstacle, 2, 1);
            this.colorArray = new VertexArray(verticesPerObstacle, 4, 1);
        }

        public void createIndexBuffer() {
            this.indexBuffer = new TriangleStripArray(this.indices, this.indicesLen);
        }

        public void removeAt(int ndx) {
            --this.obstaclesCount;
            if (ndx == this.vertices.length - 1) {
                return;
            }
            byte[] removedColors = this.colors[ndx];
            float[] removedVerts = this.vertices[ndx];
            for (int i = ndx; i < this.vertices.length - 1; ++i) {
                this.vertices[i] = this.vertices[i + 1];
                this.colors[i] = this.colors[i + 1];
            }
            this.vertices[this.vertices.length - 1] = removedVerts;
            this.colors[this.colors.length - 1] = removedColors;
        }

        public void removeFromBegining(int count) {
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.removeAt(0);
                }
            }
        }

        public void clear() {
            this.obstaclesCount = 0;
        }

        public void reset() {
            this.obstaclesCount = 0;
            this.explosions.removeAllElements();
        }

        public void update(float now) {
            Debug.error("remove explosions");
        }

        public void render(Graphics3D g3d, Appearance appearance, Transform transform, Color color) {
            if (this.obstaclesCount > 0) {
                for (int i = 0; i < this.obstaclesCount; ++i) {
                    int posIndex = 0;
                    int uvIndex = 0;
                    for (int j = 0; j < this.verticesCount; ++j) {
                        this.posConvertBuffer[posIndex] = (short)(this.vertices[i][posIndex] * 64.0f);
                        this.posConvertBuffer[++posIndex] = (short)(this.vertices[i][posIndex] * 64.0f);
                        this.posConvertBuffer[++posIndex] = (short)(this.vertices[i][posIndex] * 64.0f);
                        ++posIndex;
                        this.uvConvertBuffer[uvIndex] = (byte)(this.texCoords[i][uvIndex] * 64.0f);
                        this.uvConvertBuffer[++uvIndex] = (byte)(this.texCoords[i][uvIndex] * 64.0f);
                        ++uvIndex;
                    }
                    this.verticesArray.set(0, this.verticesCount, this.posConvertBuffer);
                    this.uvArray.set(0, this.verticesCount, this.uvConvertBuffer);
                    this.colorArray.set(0, this.verticesCount, this.colors[i]);
                    this.vertexBuffer.setPositions(this.verticesArray, 0.015625f, null);
                    this.vertexBuffer.setTexCoords(0, this.uvArray, 0.015625f, null);
                    this.vertexBuffer.setColors(this.colorArray);
                    g3d.render(this.vertexBuffer, this.indexBuffer, appearance, transform);
                }
                Debug.trace("render explozions");
            }
        }

        public float[] obstacleVertices(int ndx) {
            return this.vertices[ndx];
        }

        public void fillColor(int ndx, Color color) {
            byte a = (byte)(color.a * 255.0f);
            byte r = (byte)(color.r * 255.0f);
            byte g = (byte)(color.g * 255.0f);
            byte b = (byte)(color.b * 255.0f);
            byte[] dst = this.colors[ndx];
            int i = 0;
            while (i < dst.length) {
                dst[i++] = r;
                dst[i++] = g;
                dst[i++] = b;
                dst[i++] = a;
            }
        }
    }

    private class Explosion {
        Vector3f[] centers;
        Vector3f[] axes;
        float[] rotations;
        Vector3f[] translate;
        float animationCoeff;
        float rotationSpeed;
        Vector3f origin = new Vector3f();
        Color color = new Color();
        float[] vertices;
        int[][] indices;
        float timestamp;
        int _VerticesPerExplosion;
        int _ExplosionParts;
        int _PartIndices;

        public Explosion(Random rng, float timestamp, Vector3f origin, Color color, float[] verts, int[][] indices, int _VerticesPerExplosion, int _ExplosionParts, int _PartIndices) {
            int i;
            this.timestamp = timestamp;
            this.origin.set(origin);
            this.color.set(color);
            this._VerticesPerExplosion = _VerticesPerExplosion;
            this._ExplosionParts = _ExplosionParts;
            this._PartIndices = _PartIndices;
            this.indices = indices;
            this.axes = new Vector3f[_ExplosionParts];
            this.translate = new Vector3f[_ExplosionParts];
            this.rotations = new float[_ExplosionParts];
            this.centers = new Vector3f[_ExplosionParts];
            for (i = 0; i < _ExplosionParts; ++i) {
                this.axes[i] = new Vector3f();
                this.translate[i] = new Vector3f();
                this.centers[i] = new Vector3f();
                this.axes[i].set(rng.nextFloat(), rng.nextFloat(), rng.nextFloat());
                this.axes[i].normalize();
                this.rotations[i] = 400.0f + 400.0f * rng.nextFloat();
            }
            this.vertices = new float[_VerticesPerExplosion * 3];
            for (i = 0; i < _VerticesPerExplosion * 3; ++i) {
                this.vertices[i] = verts[i];
            }
        }

        public boolean update(float now) {
            if (now - this.timestamp > 0.75f) {
                return true;
            }
            this.animationCoeff = (now - this.timestamp) / 0.75f;
            for (int i = 0; i < this._ExplosionParts; ++i) {
                this.translate[i].x = this.centers[i].x - this.origin.x;
                this.translate[i].y = this.centers[i].y - this.origin.y;
                this.translate[i].z = this.centers[i].z - this.origin.z;
                this.translate[i].normalize();
                this.translate[i].x = this.translate[i].x * 10.0f * this.animationCoeff + this.centers[i].x;
                this.translate[i].y = this.translate[i].y * 10.0f * this.animationCoeff + this.centers[i].y;
                this.translate[i].z = this.translate[i].z * 10.0f * this.animationCoeff + this.centers[i].z;
            }
            return false;
        }

        public void render() {
            Debug.trace("Render explosion");
        }
    }

    private abstract class ObstaclesSet {
        private ObstaclesSet() {
        }

        public abstract void removeAt(int var1);

        public abstract void removeFromBegining(int var1);

        public abstract void clear();

        public abstract void update(float var1);

        public abstract void render(Graphics3D var1, Appearance var2, Transform var3, Color var4);

        public abstract void add(Vector3f[] var1, Color var2, float var3);

        public abstract void addExplosion(Random var1, float var2, Vector3f var3, Color var4, float[] var5);

        public abstract float[] obstacleVertices(int var1);
    }
}

