/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Fonts {
    static Font font = null;
    static Font fontLarge = null;
    static Font fontMedium = null;
    static Font fontSmall = null;
    static GFont font_g_1 = null;
    static GFont font_g_2 = null;
    static GFont font_g_3 = null;
    static BmpFont gf1 = null;
    static BmpFont gf2 = null;
    static int iFontHeight;
    static boolean bUseGraphicFont;

    Fonts() {
    }

    static final void initFont(int w, int h) {
        fontLarge = Font.getFont((int)0, (int)0, (int)16);
        fontMedium = Font.getFont((int)0, (int)0, (int)0);
        fontSmall = Font.getFont((int)0, (int)0, (int)8);
        Fonts.setFontSize(8);
    }

    private static int getSpaceSize(int space) {
        if (Defines.WIDTH <= 176) {
            return 3 * space >> 2;
        }
        if (Defines.WIDTH == 320) {
            return 3 * space >> 2;
        }
        return space;
    }

    private static GFont createGFontMain(Image gFontImg, char[] fontChars, short[] fontCharsWidth) {
        int spaceBetweenChars = Defines.WIDTH == 128 ? 0 : 1;
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, Fonts.getSpaceSize(fontCharsWidth[0]));
    }

    static final void prepareFonts() {
        if (Defines.WIDTH == 128) {
            gf1 = new BmpFont(Common.createImage("/fnt1.png"), Fnt.charset_menu_txt, Fnt.char_menu_x, Fnt.char_menu_w, -2, false);
            gf2 = new BmpFont(Common.createImage("/fnt2.png"), Fnt.charset_inst_txt, Fnt.char_inst_x, Fnt.char_inst_w, 1, false);
        }
        if (Defines.WIDTH == 176) {
            gf1 = new BmpFont(Common.createImage("/fnt1.png"), Fnt.charset_menu_txt, Fnt.char_menu_x, Fnt.char_menu_w, -2, false);
            gf2 = new BmpFont(Common.createImage("/fnt2.png"), Fnt.charset_inst_txt, Fnt.char_inst_x, Fnt.char_inst_w, 1, false);
        } else {
            gf1 = new BmpFont(Common.createImage("/fnt1.png"), Fnt.charset_menu_txt, Fnt.char_menu_x, Fnt.char_menu_w, -1, false);
            gf2 = new BmpFont(Common.createImage("/fnt2.png"), Fnt.charset_inst_txt, Fnt.char_inst_x, Fnt.char_inst_w, 1, false);
        }
    }

    static final void drawString(Graphics g, int x, int y, String str, int fnt) {
        if (fnt == 0) {
            gf1.DrawText(g, x, y, str);
        } else {
            gf2.DrawText(g, x, y, str);
        }
    }

    static final int getFontHeight(int fnt) {
        if (fnt == 0) {
            return font_g_1.getHeight();
        }
        if (fnt == 1) {
            return font_g_2.getHeight();
        }
        if (fnt == 2) {
            return font_g_3.getHeight();
        }
        return font.getHeight();
    }

    static final BmpFont getFont(int idx) {
        return idx == 0 ? gf1 : gf2;
    }

    static final int getStringWidth(String str, int fnt) {
        if (fnt == 0) {
            return font_g_1.stringWidth(str.toCharArray());
        }
        if (fnt == 1) {
            return font_g_2.stringWidth(str.toCharArray());
        }
        if (fnt == 2) {
            return font_g_3.stringWidth(str.toCharArray());
        }
        return font.stringWidth(str);
    }

    static final int stringWidth(String txt, int iType) {
        if (iType == 0 && font != null) {
            return font.stringWidth(txt);
        }
        if (iType == 0) {
            return gf1.GetTextWidth(txt);
        }
        if (iType == 1) {
            return gf2.GetTextWidth(txt);
        }
        return 0;
    }

    static final int getGraphicsFontH(int iType) {
        if (iType == 0 && font != null) {
            return font.getHeight();
        }
        if (iType == 0) {
            return Fonts.gf1.iHeight;
        }
        if (iType == 1) {
            return Fonts.gf2.iHeight;
        }
        return 0;
    }

    static final void setFontSize(int size) {
        bUseGraphicFont = true;
        switch (size) {
            case 8: {
                font = fontSmall;
                break;
            }
            case 0: {
                font = fontMedium;
                break;
            }
            case 16: {
                font = fontLarge;
            }
        }
        iFontHeight = font.getHeight();
    }

    static {
        bUseGraphicFont = true;
    }
}

