/*
 * Decompiled with CFR 0.152.
 */
package org.albite.font;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import org.albite.font.AlbiteFont;
import org.albite.font.AlbiteFontException;
import org.albite.font.Glyph;
import org.albite.image.AlbiteImageException;
import org.albite.image.AlbiteImageMono;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AlbiteBitmapFont
extends AlbiteFont {
    public final int lineHeight;
    public final int lineSpacing;
    public final int maximumWidth;
    private final Glyph[] a;
    private final AlbiteImageMono a;
    private final byte[] a;
    private final int a;
    private int[] a;
    public final int spaceWidth;
    public final int dashWidth;
    public final int questionWidth;

    public AlbiteBitmapFont(String string) {
        String string2 = "/res/font/" + string;
        InputStream inputStream = this.getClass().getResourceAsStream(string2 + ".alf");
        if (inputStream == null) {
            throw new IOException("Font " + string + "was not found!");
        }
        if (((DataInputStream)(inputStream = new DataInputStream(inputStream))).readInt() != 1095516742) {
            throw new AlbiteFontException("ALF file is corrupted.");
        }
        this.lineSpacing = ((DataInputStream)inputStream).readByte();
        this.lineHeight = ((DataInputStream)inputStream).readByte();
        this.a = new Glyph[((DataInputStream)inputStream).readInt() + 1];
        this.maximumWidth = ((DataInputStream)inputStream).readShort();
        int n2 = ((DataInputStream)inputStream).readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = ((DataInputStream)inputStream).readInt();
            short s2 = ((DataInputStream)inputStream).readShort();
            short s3 = ((DataInputStream)inputStream).readShort();
            short s4 = ((DataInputStream)inputStream).readShort();
            short s5 = ((DataInputStream)inputStream).readShort();
            short s6 = ((DataInputStream)inputStream).readShort();
            short s7 = ((DataInputStream)inputStream).readShort();
            short s8 = ((DataInputStream)inputStream).readShort();
            this.a[n3] = new Glyph(s2, s3, s4, s5, s6, s7, s8);
        }
        ((FilterInputStream)inputStream).close();
        inputStream = this.getClass().getResourceAsStream(string2 + ".ali");
        if (inputStream == null) {
            throw new AlbiteFontException("Missing graphics for font " + string);
        }
        try {
            this.a = new AlbiteImageMono(inputStream);
        }
        catch (AlbiteImageException albiteImageException) {
            throw new AlbiteFontException("Could not load graphics for font " + string);
        }
        this.a = this.a.getData();
        this.a = this.a.getWidth();
        this.a.getHeight();
        this.a = new int[this.lineHeight * this.maximumWidth];
        this.spaceWidth = 32 < this.a.length && this.a[32] != null ? (int)this.a[32].g : 0;
        this.dashWidth = 45 < this.a.length && this.a[45] != null ? (int)this.a[45].g : 0;
        this.questionWidth = 63 < this.a.length && this.a[63] != null ? (int)this.a[63].g : 0;
        this.a[0] = this.a[32];
    }

    public final int charWidth(char c2) {
        if (c2 < this.a.length) {
            Glyph glyph = this.a[c2];
            if (glyph == null) {
                return this.questionWidth;
            }
            return glyph.g;
        }
        return this.questionWidth;
    }

    public final void drawChars(Graphics graphics, int n2, char[] cArray, int n3, int n4, int n5, int n6) {
        n6 = n5 + n6;
        int n7 = this.a.length;
        for (int i2 = n5; i2 < n6; ++i2) {
            n5 = cArray[i2];
            Glyph glyph = n5 < n7 ? this.a[n5] : this.a[63];
            if (glyph == null) {
                glyph = this.a[63];
            }
            this.a(graphics, n2, glyph, n3, n4);
            n3 += glyph.g;
        }
    }

    private void a(Graphics graphics, int n2, Glyph glyph, int n3, int n4) {
        int n5 = this.a;
        short s2 = glyph.c;
        int n6 = glyph.d;
        int n7 = glyph.a;
        int n8 = glyph.b;
        int n9 = n5 - s2;
        n7 = n8 * n5 + n7;
        n8 = 0;
        for (int i2 = 0; i2 < n6; ++i2) {
            n5 = n7 + s2;
            while (n7 < n5) {
                this.a[n8] = (this.a[n7] << 24) + n2;
                ++n8;
                ++n7;
            }
            n7 += n9;
        }
        graphics.drawRGB(this.a, 0, (int)s2, n3 + glyph.e, n4 + glyph.f, (int)s2, n6, true);
    }

    public final void drawChar(Graphics graphics, int n2, char c2, int n3, int n4) {
        Glyph glyph;
        if (c2 < this.a.length && (glyph = this.a[c2]) != null) {
            this.a(graphics, n2, glyph, n3, n4);
        }
    }

    public int getLineHeight() {
        return this.lineHeight;
    }
}

