/*
 * Decompiled with CFR 0.152.
 */
package digger;

import digger.Bags;
import digger.Drawing;
import digger.Input;
import digger.Main;
import digger.Monster;
import digger.NewSound;
import digger.Pc;
import digger.Scores;
import digger.Sound;
import digger.Sprite;
import general.display.MemoryDisplayUpdater;
import general.ui.ExtendedGameCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DiggerCanvas
extends ExtendedGameCanvas
implements Runnable {
    static int MAX_RATE = 200;
    static int MIN_RATE = 66;
    int width = 320;
    int height = 200;
    int frametime = 80;
    boolean rotated;
    String subaddr;
    Image pic;
    Bags Bags;
    Main Main;
    Sound Sound;
    NewSound newSound;
    Monster Monster;
    Scores Scores;
    Sprite Sprite;
    Drawing Drawing;
    Input Input;
    Pc Pc;
    boolean killed = false;
    private CommandListener menuPressListener = null;
    private Command menuPressCommand = null;
    int diggerx = 0;
    int diggery = 0;
    int diggerh = 0;
    int diggerv = 0;
    int diggerrx = 0;
    int diggerry = 0;
    int digmdir = 0;
    int digdir = 0;
    int digtime = 0;
    int rechargetime = 0;
    int firex = 0;
    int firey = 0;
    int firedir = 0;
    int expsn = 0;
    int deathstage = 0;
    int deathbag = 0;
    int deathani = 0;
    int deathtime = 0;
    int startbonustimeleft = 0;
    int bonustimeleft = 0;
    int eatmsc = 0;
    int emocttime = 0;
    int emmask = 0;
    byte[] emfield = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    boolean digonscr = false;
    boolean notfiring = false;
    boolean bonusvisible = false;
    boolean bonusmode = false;
    boolean diggervisible = false;
    long time;
    long ftime = 50L;
    int[] embox = new int[]{8, 12, 12, 9, 16, 12, 6, 9};
    int[] deatharc = new int[]{3, 5, 6, 6, 5, 3, 0};
    boolean paused = false;

    public DiggerCanvas() {
        super(false);
        this.setFullScreenMode(true);
        this.Bags = new Bags(this);
        this.Main = new Main(this);
        this.Sound = new Sound(this);
        this.newSound = new NewSound();
        this.Monster = new Monster(this);
        this.Scores = new Scores(this);
        this.Sprite = new Sprite(this);
        this.Drawing = new Drawing(this);
        this.Input = new Input(this);
        this.Pc = new Pc(this);
        this.rotated = false;
    }

    void changeDrawingArea(int drawingWidth, int drawingHeight) {
        this.Pc.displayUpdater.changeActiveArea(drawingWidth, drawingHeight);
    }

    boolean checkdiggerunderbag(int h, int v) {
        return !(this.digmdir != 2 && this.digmdir != 6 || (this.diggerx - 12) / 20 != h || (this.diggery - 18) / 18 != v && (this.diggery - 18) / 18 + 1 != v);
    }

    int countem() {
        int n = 0;
        for (int x = 0; x < 15; ++x) {
            for (int y = 0; y < 10; ++y) {
                if ((this.emfield[y * 15 + x] & this.emmask) == 0) continue;
                ++n;
            }
        }
        return n;
    }

    void createbonus() {
        this.bonusvisible = true;
        this.Drawing.drawbonus(292, 18);
    }

    void diggerdie() {
        switch (this.deathstage) {
            case 1: {
                if (this.Bags.bagy(this.deathbag) + 6 > this.diggery) {
                    this.diggery = this.Bags.bagy(this.deathbag) + 6;
                }
                this.Drawing.drawdigger(15, this.diggerx, this.diggery, false);
                this.Main.incpenalty();
                if (this.Bags.getbagdir(this.deathbag) + 1 != 0) break;
                this.Sound.soundddie();
                this.deathtime = 5;
                this.deathstage = 2;
                this.deathani = 0;
                this.diggery -= 6;
                break;
            }
            case 2: {
                if (this.deathtime != 0) {
                    --this.deathtime;
                    break;
                }
                if (this.deathani == 0) {
                    this.Sound.music(2);
                }
                int clbits = this.Drawing.drawdigger(14 - this.deathani, this.diggerx, this.diggery, false);
                this.Main.incpenalty();
                if (this.deathani == 0 && (clbits & 0x3F00) != 0) {
                    this.Monster.killmonsters(clbits);
                }
                if (this.deathani < 4) {
                    ++this.deathani;
                    this.deathtime = 2;
                    break;
                }
                this.deathstage = 4;
                if (this.Sound.musicflag) {
                    this.deathtime = 60;
                    break;
                }
                this.deathtime = 10;
                break;
            }
            case 3: {
                this.deathstage = 5;
                this.deathani = 0;
                this.deathtime = 0;
                break;
            }
            case 5: {
                if (this.deathani < 0 || this.deathani > 6) break;
                this.Drawing.drawdigger(15, this.diggerx, this.diggery - this.deatharc[this.deathani], false);
                if (this.deathani == 6) {
                    this.Sound.musicoff();
                }
                this.Main.incpenalty();
                ++this.deathani;
                if (this.deathani == 1) {
                    this.Sound.soundddie();
                }
                if (this.deathani != 7) break;
                this.deathtime = 5;
                this.deathani = 0;
                this.deathstage = 2;
                break;
            }
            case 4: {
                if (this.deathtime != 0) {
                    --this.deathtime;
                    break;
                }
                this.Main.setdead(true);
            }
        }
    }

    void dodigger() {
        this.newframe();
        if (this.expsn != 0) {
            this.drawexplosion();
        } else {
            this.updatefire();
        }
        if (this.diggervisible) {
            if (this.digonscr) {
                if (this.digtime != 0) {
                    this.Drawing.drawdigger(this.digmdir, this.diggerx, this.diggery, this.notfiring && this.rechargetime == 0);
                    this.Main.incpenalty();
                    --this.digtime;
                } else {
                    this.updatedigger();
                }
            } else {
                this.diggerdie();
            }
        }
        if (this.bonusmode && this.digonscr) {
            this.newSound.stopNormalBackgroundMusic();
            if (this.bonustimeleft != 0) {
                --this.bonustimeleft;
                if (this.startbonustimeleft != 0 || this.bonustimeleft < 20) {
                    --this.startbonustimeleft;
                    if ((this.bonustimeleft & 1) != 0) {
                        this.Pc.ginten(0);
                        this.Sound.soundbonus();
                        this.newSound.stopBonusBackgroundMusic();
                        this.newSound.startBonusPulse();
                    } else {
                        this.newSound.stopBonusBackgroundMusic();
                        this.newSound.startBonusPulse();
                        this.Pc.ginten(1);
                        this.Sound.soundbonus();
                    }
                    if (this.startbonustimeleft == 0) {
                        this.newSound.endBonusPulse();
                        this.Sound.music(0);
                        this.Sound.soundbonusoff();
                        this.Pc.ginten(1);
                        this.newSound.startBonusBackgroundMusic();
                    }
                }
            } else {
                this.endbonusmode();
                this.Sound.soundbonusoff();
                this.Sound.music(1);
                this.newSound.endBonusPulse();
                this.newSound.stopBonusBackgroundMusic();
                this.newSound.startNormalBackgroundMusic();
            }
        }
        if (this.bonusmode && !this.digonscr) {
            this.endbonusmode();
            this.newSound.endBonusPulse();
            this.newSound.stopBonusBackgroundMusic();
            this.newSound.startNormalBackgroundMusic();
            this.Sound.soundbonusoff();
            this.Sound.music(1);
        }
        if (this.emocttime > 0) {
            --this.emocttime;
        }
    }

    void drawemeralds() {
        this.emmask = 1 << this.Main.getcplayer();
        for (int x = 0; x < 15; ++x) {
            for (int y = 0; y < 10; ++y) {
                if ((this.emfield[y * 15 + x] & this.emmask) == 0) continue;
                this.Drawing.drawemerald(x * 20 + 12, y * 18 + 21);
            }
        }
    }

    void drawexplosion() {
        switch (this.expsn) {
            case 1: {
                this.newSound.fireEnd();
                this.Sound.soundexplode();
                this.newSound.playExplode();
            }
            case 2: 
            case 3: {
                this.Drawing.drawfire(this.firex, this.firey, this.expsn);
                this.Main.incpenalty();
                ++this.expsn;
                break;
            }
            default: {
                this.killfire();
                this.expsn = 0;
            }
        }
    }

    void endbonusmode() {
        this.bonusmode = false;
        this.Pc.ginten(0);
    }

    void erasebonus() {
        if (this.bonusvisible) {
            this.bonusvisible = false;
            this.Sprite.erasespr(14);
        }
        this.Pc.ginten(0);
    }

    void erasedigger() {
        this.Sprite.erasespr(0);
        this.diggervisible = false;
    }

    public String getAppletInfo() {
        return "The Digger Remastered -- http://www.digger.org, Copyright (c) Andrew Jenner & Marek Futrega / MAF";
    }

    boolean getfirepflag() {
        return this.Input.firepflag;
    }

    boolean hitemerald(int x, int y, int rx, int ry, int dir) {
        boolean hit = false;
        if (dir < 0 || dir > 6 || (dir & 1) != 0) {
            return hit;
        }
        if (dir == 0 && rx != 0) {
            ++x;
        }
        if (dir == 6 && ry != 0) {
            ++y;
        }
        int r = dir == 0 || dir == 4 ? rx : ry;
        if ((this.emfield[y * 15 + x] & this.emmask) != 0) {
            if (r == this.embox[dir]) {
                this.Drawing.drawemerald(x * 20 + 12, y * 18 + 21);
                this.Main.incpenalty();
            }
            if (r == this.embox[dir + 1]) {
                this.Drawing.eraseemerald(x * 20 + 12, y * 18 + 21);
                this.Main.incpenalty();
                hit = true;
                int n = y * 15 + x;
                this.emfield[n] = (byte)(this.emfield[n] & ~this.emmask);
            }
        }
        return hit;
    }

    public void init() {
        this.Pc.pixels = new int[65536];
        this.Pc.displayUpdater = new MemoryDisplayUpdater(this, this.getGraphics(), this.rotated, this.Pc.pixels, this.Pc.width, this.Pc.height, 2);
        this.Pc.displayUpdater.setPallete(0, this.Pc.pal[0][0], this.Pc.pal[0][1], this.Pc.pal[0][2]);
        this.Pc.displayUpdater.setPallete(1, this.Pc.pal[1][0], this.Pc.pal[1][1], this.Pc.pal[1][2]);
    }

    void initbonusmode() {
        this.bonusmode = true;
        this.erasebonus();
        this.Pc.ginten(1);
        this.bonustimeleft = 250 - this.Main.levof10() * 20;
        this.startbonustimeleft = 20;
        this.eatmsc = 1;
    }

    void initdigger() {
        this.diggerv = 9;
        this.digmdir = 4;
        this.diggerh = 7;
        this.diggerx = this.diggerh * 20 + 12;
        this.digdir = 0;
        this.diggerrx = 0;
        this.diggerry = 0;
        this.digtime = 0;
        this.digonscr = true;
        this.deathstage = 1;
        this.diggervisible = true;
        this.diggery = this.diggerv * 18 + 18;
        this.Sprite.movedrawspr(0, this.diggerx, this.diggery);
        this.notfiring = true;
        this.emocttime = 0;
        this.bonusmode = false;
        this.bonusvisible = false;
        this.Input.firepressed = false;
        this.expsn = 0;
        this.rechargetime = 0;
    }

    protected void keyPressed(int key) {
        try {
            if (!this.rotated) {
                switch (this.getGameAction(key)) {
                    case 2: {
                        this.Input.processkey(75);
                        break;
                    }
                    case 5: {
                        this.Input.processkey(77);
                        break;
                    }
                    case 1: {
                        this.Input.processkey(72);
                        break;
                    }
                    case 6: {
                        this.Input.processkey(80);
                        break;
                    }
                    case 8: {
                        this.Input.processkey(59);
                        break;
                    }
                    case 900: 
                    case 901: {
                        if (this.menuPressListener == null) break;
                        this.menuPressListener.commandAction(this.menuPressCommand, (Displayable)this);
                    }
                }
            }
            if (this.rotated) {
                switch (this.getGameAction(key)) {
                    case 1: {
                        this.Input.processkey(75);
                        break;
                    }
                    case 6: {
                        this.Input.processkey(77);
                        break;
                    }
                    case 5: {
                        this.Input.processkey(72);
                        break;
                    }
                    case 2: {
                        this.Input.processkey(80);
                        break;
                    }
                    case 8: {
                        this.Input.processkey(59);
                        break;
                    }
                    case 900: 
                    case 901: {
                        if (this.menuPressListener == null) break;
                        this.menuPressListener.commandAction(this.menuPressCommand, (Displayable)this);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void keyReleased(int key) {
        try {
            if (!this.rotated) {
                switch (this.getGameAction(key)) {
                    case 2: {
                        this.Input.processkey(203);
                        break;
                    }
                    case 5: {
                        this.Input.processkey(205);
                        break;
                    }
                    case 1: {
                        this.Input.processkey(200);
                        break;
                    }
                    case 6: {
                        this.Input.processkey(208);
                        break;
                    }
                    case 8: {
                        this.Input.processkey(187);
                    }
                }
            }
            if (this.rotated) {
                switch (this.getGameAction(key)) {
                    case 1: {
                        this.Input.processkey(203);
                        break;
                    }
                    case 6: {
                        this.Input.processkey(205);
                        break;
                    }
                    case 5: {
                        this.Input.processkey(200);
                        break;
                    }
                    case 2: {
                        this.Input.processkey(208);
                        break;
                    }
                    case 8: {
                        this.Input.processkey(187);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void killdigger(int stage, int bag) {
        if (this.deathstage < 2 || this.deathstage > 4) {
            this.newSound.stopNormalBackgroundMusic();
            this.newSound.stopBonusBackgroundMusic();
            this.newSound.playDeath();
            this.digonscr = false;
            this.deathstage = stage;
            this.deathbag = bag;
        }
    }

    void killemerald(int x, int y) {
        if ((this.emfield[y * 15 + x + 15] & this.emmask) != 0) {
            int n = y * 15 + x + 15;
            this.emfield[n] = (byte)(this.emfield[n] & ~this.emmask);
            this.Drawing.eraseemerald(x * 20 + 12, (y + 1) * 18 + 21);
        }
    }

    void killfire() {
        if (!this.notfiring) {
            this.notfiring = true;
            this.Sprite.erasespr(15);
            this.Sound.soundfireoff();
            this.newSound.fireEnd();
        }
    }

    void makeemfield() {
        this.emmask = 1 << this.Main.getcplayer();
        for (int x = 0; x < 15; ++x) {
            for (int y = 0; y < 10; ++y) {
                if (this.Main.getlevch(x, y, this.Main.levplan()) == 67) {
                    int n = y * 15 + x;
                    this.emfield[n] = (byte)(this.emfield[n] | this.emmask);
                    continue;
                }
                int n = y * 15 + x;
                this.emfield[n] = (byte)(this.emfield[n] & ~this.emmask);
            }
        }
    }

    void newframe() {
        this.Input.checkkeyb();
        this.time += (long)this.frametime;
        long l = this.time - this.Pc.gethrt();
        if (l > 0L) {
            try {
                Thread.sleep((int)l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.Pc.displayUpdater.flush();
    }

    public void paint(Graphics g) {
        if (this.Pc.displayUpdater != null) {
            this.Pc.displayUpdater.repaint();
        }
    }

    void endgame() {
        this.Input.escape = true;
    }

    void pauseState(boolean state) {
        this.paused = state;
        this.newSound.changePauseState(state);
    }

    int reversedir(int dir) {
        switch (dir) {
            case 0: {
                return 4;
            }
            case 4: {
                return 0;
            }
            case 2: {
                return 6;
            }
            case 6: {
                return 2;
            }
        }
        return dir;
    }

    public void run() {
        this.init();
        this.Main.main();
    }

    void setRotation(boolean newRotationState) {
        this.rotated = newRotationState;
        this.Pc.displayUpdater.setRotation(newRotationState);
    }

    boolean getRotation() {
        return this.rotated;
    }

    void stop() {
    }

    void updatedigger() {
        boolean push = false;
        this.Input.readdir();
        int dir = this.Input.getdir();
        int ddir = dir == 0 || dir == 2 || dir == 4 || dir == 6 ? dir : -1;
        if (this.diggerrx == 0 && (ddir == 2 || ddir == 6)) {
            this.digdir = this.digmdir = ddir;
        }
        if (this.diggerry == 0 && (ddir == 4 || ddir == 0)) {
            this.digdir = this.digmdir = ddir;
        }
        this.digmdir = dir == -1 ? -1 : this.digdir;
        if (this.diggerx == 292 && this.digmdir == 0 || this.diggerx == 12 && this.digmdir == 4 || this.diggery == 180 && this.digmdir == 6 || this.diggery == 18 && this.digmdir == 2) {
            this.digmdir = -1;
        }
        int diggerox = this.diggerx;
        int diggeroy = this.diggery;
        if (this.digmdir != -1) {
            this.Drawing.eatfield(diggerox, diggeroy, this.digmdir);
        }
        switch (this.digmdir) {
            case 0: {
                this.Drawing.drawrightblob(this.diggerx, this.diggery);
                this.diggerx += 4;
                break;
            }
            case 4: {
                this.Drawing.drawleftblob(this.diggerx, this.diggery);
                this.diggerx -= 4;
                break;
            }
            case 2: {
                this.Drawing.drawtopblob(this.diggerx, this.diggery);
                this.diggery -= 3;
                break;
            }
            case 6: {
                this.Drawing.drawbottomblob(this.diggerx, this.diggery);
                this.diggery += 3;
            }
        }
        if (this.hitemerald((this.diggerx - 12) / 20, (this.diggery - 18) / 18, (this.diggerx - 12) % 20, (this.diggery - 18) % 18, this.digmdir)) {
            this.Scores.scoreemerald();
            this.Sound.soundem();
            this.Sound.soundemerald(this.emocttime);
            this.newSound.playEatEmerald(this.emocttime <= 0);
            this.emocttime = 9;
        }
        int clbits = this.Drawing.drawdigger(this.digdir, this.diggerx, this.diggery, this.notfiring && this.rechargetime == 0);
        this.Main.incpenalty();
        if ((this.Bags.bagbits() & clbits) != 0) {
            if (this.digmdir == 0 || this.digmdir == 4) {
                push = this.Bags.pushbags(this.digmdir, clbits);
                ++this.digtime;
            } else if (!this.Bags.pushudbags(clbits)) {
                push = false;
            }
            if (!push) {
                this.diggerx = diggerox;
                this.diggery = diggeroy;
                this.Drawing.drawdigger(this.digmdir, this.diggerx, this.diggery, this.notfiring && this.rechargetime == 0);
                this.Main.incpenalty();
                this.digdir = this.reversedir(this.digmdir);
            }
        }
        if ((clbits & 0x3F00) != 0 && this.bonusmode) {
            for (int nmon = this.Monster.killmonsters(clbits); nmon != 0; --nmon) {
                this.Sound.soundeatm();
                this.Scores.scoreeatm();
                this.newSound.playMonsterEat();
            }
        }
        if ((clbits & 0x4000) != 0) {
            this.Scores.scorebonus();
            this.initbonusmode();
        }
        this.diggerh = (this.diggerx - 12) / 20;
        this.diggerrx = (this.diggerx - 12) % 20;
        this.diggerv = (this.diggery - 18) / 18;
        this.diggerry = (this.diggery - 18) % 18;
    }

    void updatefire() {
        int pix = 0;
        if (this.notfiring) {
            if (this.rechargetime != 0) {
                --this.rechargetime;
            } else if (this.getfirepflag() && this.digonscr) {
                this.rechargetime = this.Main.levof10() * 3 + 60;
                this.notfiring = false;
                switch (this.digdir) {
                    case 0: {
                        this.firex = this.diggerx + 8;
                        this.firey = this.diggery + 4;
                        break;
                    }
                    case 4: {
                        this.firex = this.diggerx;
                        this.firey = this.diggery + 4;
                        break;
                    }
                    case 2: {
                        this.firex = this.diggerx + 4;
                        this.firey = this.diggery;
                        break;
                    }
                    case 6: {
                        this.firex = this.diggerx + 4;
                        this.firey = this.diggery + 8;
                    }
                }
                this.firedir = this.digdir;
                this.Sprite.movedrawspr(15, this.firex, this.firey);
                this.Sound.soundfire();
                this.newSound.fireStart();
            }
        } else {
            switch (this.firedir) {
                case 0: {
                    this.firex += 8;
                    pix = this.Pc.ggetpix(this.firex, this.firey + 4) | this.Pc.ggetpix(this.firex + 4, this.firey + 4);
                    break;
                }
                case 4: {
                    this.firex -= 8;
                    pix = this.Pc.ggetpix(this.firex, this.firey + 4) | this.Pc.ggetpix(this.firex + 4, this.firey + 4);
                    break;
                }
                case 2: {
                    this.firey -= 7;
                    pix = (this.Pc.ggetpix(this.firex + 4, this.firey) | this.Pc.ggetpix(this.firex + 4, this.firey + 1) | this.Pc.ggetpix(this.firex + 4, this.firey + 2) | this.Pc.ggetpix(this.firex + 4, this.firey + 3) | this.Pc.ggetpix(this.firex + 4, this.firey + 4) | this.Pc.ggetpix(this.firex + 4, this.firey + 5) | this.Pc.ggetpix(this.firex + 4, this.firey + 6)) & 0xC0;
                    break;
                }
                case 6: {
                    this.firey += 7;
                    pix = (this.Pc.ggetpix(this.firex, this.firey) | this.Pc.ggetpix(this.firex, this.firey + 1) | this.Pc.ggetpix(this.firex, this.firey + 2) | this.Pc.ggetpix(this.firex, this.firey + 3) | this.Pc.ggetpix(this.firex, this.firey + 4) | this.Pc.ggetpix(this.firex, this.firey + 5) | this.Pc.ggetpix(this.firex, this.firey + 6)) & 3;
                }
            }
            int clbits = this.Drawing.drawfire(this.firex, this.firey, 0);
            this.Main.incpenalty();
            if ((clbits & 0x3F00) != 0) {
                int mon = 0;
                int b = 256;
                while (mon < 6) {
                    if ((clbits & b) != 0) {
                        this.Monster.killmon(mon);
                        this.Scores.scorekill();
                        this.expsn = 1;
                    }
                    ++mon;
                    b <<= 1;
                }
            }
            if ((clbits & 0x40FE) != 0) {
                this.expsn = 1;
            }
            switch (this.firedir) {
                case 0: {
                    if (this.firex > 296) {
                        this.expsn = 1;
                        break;
                    }
                    if (pix == 0 || clbits != 0) break;
                    this.expsn = 1;
                    this.firex -= 8;
                    this.Drawing.drawfire(this.firex, this.firey, 0);
                    break;
                }
                case 4: {
                    if (this.firex < 16) {
                        this.expsn = 1;
                        break;
                    }
                    if (pix == 0 || clbits != 0) break;
                    this.expsn = 1;
                    this.firex += 8;
                    this.Drawing.drawfire(this.firex, this.firey, 0);
                    break;
                }
                case 2: {
                    if (this.firey < 15) {
                        this.expsn = 1;
                        break;
                    }
                    if (pix == 0 || clbits != 0) break;
                    this.expsn = 1;
                    this.firey += 7;
                    this.Drawing.drawfire(this.firex, this.firey, 0);
                    break;
                }
                case 6: {
                    if (this.firey > 183) {
                        this.expsn = 1;
                        break;
                    }
                    if (pix == 0 || clbits != 0) break;
                    this.expsn = 1;
                    this.firey -= 7;
                    this.Drawing.drawfire(this.firex, this.firey, 0);
                }
            }
        }
    }

    protected void hideNotify() {
        this.pauseState(true);
    }

    public boolean canCatchMenu() {
        return this.canDetect(900) || this.canDetect(901);
    }

    public void setMenuPressAction(CommandListener listener, Command command) {
        this.menuPressListener = listener;
        this.menuPressCommand = command;
    }
}

