/*
 * Decompiled with CFR 0.152.
 */
package general.sound;

import general.sound.NoteSeriallizer;
import general.sound.TunePlayer;

public class NoteSequenceTunePlayer
implements TunePlayer {
    private final int tempo;
    private final int resolution;
    private final byte[] sequence;
    private int priority;
    private int volume;
    private int position;
    private boolean playing;
    private boolean loop;
    private boolean closed;
    private Thread playingThread;
    private Object lock = new Object();
    private final Runnable runner = new Runnable(){

        public void run() {
            NoteSequenceTunePlayer.this.playingThreadRun();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void playingThreadRun() {
        try {
            while (!this.closed) {
                while (this.playing) {
                    int waitPeriod = 0;
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.playing) {
                            break;
                        }
                        byte note = this.sequence[this.position];
                        byte noteDuration = this.sequence[this.position + 1];
                        int timeDuration = noteDuration * 60 * 1000 / (this.resolution * this.tempo);
                        if (note != -1) {
                            waitPeriod = NoteSeriallizer.getInstance().playNote(note, timeDuration, this.volume, this.priority);
                            if (waitPeriod == -1) {
                                waitPeriod = timeDuration;
                            }
                        } else {
                            waitPeriod = timeDuration;
                        }
                        this.position = (this.position + 2) % this.sequence.length;
                        if (this.position == 0 && !this.loop) {
                            this.playing = false;
                        }
                        if (waitPeriod <= 0) continue;
                    }
                    Thread.sleep(waitPeriod);
                }
                Object waitPeriod = this.lock;
                synchronized (waitPeriod) {
                    if (!this.playing) {
                        this.lock.wait();
                    }
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public NoteSequenceTunePlayer(byte[] sequence, int tempo) {
        this(sequence, tempo, 64);
    }

    public NoteSequenceTunePlayer(byte[] sequence, int tempo, int resolution) {
        this.tempo = tempo;
        this.resolution = resolution;
        this.sequence = sequence;
        this.volume = 50;
        this.position = 0;
        this.priority = 0;
        this.playing = false;
        this.closed = false;
        this.loop = false;
        this.playingThread = new Thread(this.runner);
        this.playingThread.start();
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playInLoop() {
        Object object = this.lock;
        synchronized (object) {
            this.loop = true;
            if (!this.playing) {
                this.playing = true;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSingle() {
        Object object = this.lock;
        synchronized (object) {
            this.loop = false;
            if (!this.playing) {
                this.playing = true;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlaying() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
            this.position = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pausePlaying() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() {
        Object object = this.lock;
        synchronized (object) {
            this.position = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
            this.closed = true;
            if (this.playing) {
                this.playing = false;
            } else {
                this.lock.notify();
            }
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }
}

