/*
 * Decompiled with CFR 0.152.
 */
package general.sound;

import general.sound.MobileMediaAPINotePlayer;
import general.sound.NotePlayer;
import general.sound.NotePlayingException;

public final class NoteSeriallizer {
    private boolean haveNoteWaiting = false;
    private int lastNote = 0;
    private int lastDuration = 0;
    private int lastVolume = 0;
    private int lastPriority = 0;
    private Object lock = new Object();
    NotePlayer notePlayer = MobileMediaAPINotePlayer.getInstance();
    private static NoteSeriallizer instance = new NoteSeriallizer();
    public static final int DEFAULT_PRIORITY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeNotes() {
        try {
            while (true) {
                int volumeToPlay;
                int durationToPlay;
                int noteToPlay;
                Object object = this.lock;
                synchronized (object) {
                    if (!this.haveNoteWaiting) {
                        this.lock.wait();
                    }
                    noteToPlay = this.lastNote;
                    durationToPlay = this.lastDuration;
                    volumeToPlay = this.lastVolume;
                    this.haveNoteWaiting = false;
                }
                this.notePlayer.playNote(noteToPlay, durationToPlay, volumeToPlay);
                if (this.notePlayer.isBlocking()) continue;
                Thread.sleep(this.lastDuration + this.notePlayer.assumedDelay());
            }
        }
        catch (NotePlayingException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private NoteSeriallizer() {
        Thread consumerThread = new Thread(new Runnable(){

            public void run() {
                NoteSeriallizer.this.consumeNotes();
            }
        });
        consumerThread.start();
    }

    public static NoteSeriallizer getInstance() {
        return instance;
    }

    public void setNotePlayer(NotePlayer notePlayer) {
        this.notePlayer = notePlayer;
    }

    public int playNote(int note, int duration, int volume) {
        return this.playNote(note, duration, volume, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playNote(int note, int duration, int volume, int priority) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.haveNoteWaiting) {
                this.lastNote = note;
                this.lastDuration = duration;
                this.lastVolume = volume;
                this.lastPriority = priority;
                this.haveNoteWaiting = true;
                this.lock.notify();
                return duration + this.notePlayer.assumedDelay();
            }
            if (priority < this.lastPriority) {
                return -1;
            }
            this.lastNote = note;
            this.lastDuration = duration;
            this.lastVolume = volume;
            this.lastPriority = priority;
            return duration + this.notePlayer.assumedDelay();
        }
    }
}

