/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import overthehill.dustdigger.DiggerGame;
import overthehill.dustdigger.DustDigger;
import overthehill.dustdigger.TextUtils;

public final class DiggerMain
extends Canvas
implements Runnable,
CommandListener {
    private static final Command cmdOK = new Command("Ok", 8, 1);
    private static final Command cmdStart = new Command("Start", 8, 1);
    private static final Command cmdExit = new Command("Exit", 8, 1);
    private static final Command cmdBack = new Command("Back", 8, 1);
    private static final Command cmdAbout = new Command("About", 8, 1);
    private static final Command cmdGiveUp = new Command("Give up", 8, 1);
    private static final String StrPleaseWait = "Please wait...";
    private MIDlet BaseMidlet;
    private static DiggerGame GameCore;
    private Image OffScreenImage;
    private int GameState = 0;
    private int GameLoopDelay = 100;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private long DebounceItemTimer;
    private boolean AboutInfoFlag;
    private boolean ClearAllScreen;
    private int AppInfoScroll;
    private int AppInfoDirection;
    private int AppInfoDelay;
    private final boolean CmdItemWorkAround = DustDigger.AppPlatform.indexOf("SAMSUNG") != -1;
    private Image AppImage;

    public DiggerMain(MIDlet rmidlet, boolean ColoredDisp, int NumColors) {
        this.PlayfieldWidth = this.getWidth();
        this.PlayfieldHeight = this.getHeight();
        this.DebounceItemTimer = System.currentTimeMillis();
        this.BaseMidlet = rmidlet;
        this.OffScreenImage = Image.createImage((int)this.PlayfieldWidth, (int)this.PlayfieldHeight);
        this.addCommand(cmdStart);
        this.addCommand(cmdExit);
        this.addCommand(cmdAbout);
        this.setCommandListener(this);
        GameCore = new DiggerGame(this, "/overthehill/dustdigger", this.PlayfieldWidth, this.PlayfieldHeight, ColoredDisp, NumColors);
        this.GameState = 1;
    }

    public final void paint(Graphics gfx) {
        Graphics OffScreenGfx = gfx;
        if (this.ClearAllScreen) {
            this.ClearAllScreen = false;
            gfx.setColor(0);
            gfx.fillRect(0, 0, gfx.getClipWidth(), gfx.getClipHeight());
            return;
        }
        if (this.OffScreenImage != null) {
            OffScreenGfx = this.OffScreenImage.getGraphics();
        }
        if (this.AboutInfoFlag) {
            this.GameLoopDelay = 50;
            this.PaintAppInfo(OffScreenGfx);
        } else {
            switch (this.GameState) {
                case 1: {
                    this.GameLoopDelay = 50;
                    OffScreenGfx.setColor(0);
                    OffScreenGfx.fillRect(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
                    this.GameState = 2;
                    break;
                }
                case 2: {
                    this.GameLoopDelay = 50;
                    GameCore.PaintTitle(OffScreenGfx);
                    break;
                }
                case 3: {
                    this.GameLoopDelay = 50;
                    GameCore.PaintGame(OffScreenGfx, gfx);
                    if (this.OffScreenImage != null) {
                        gfx.drawImage(this.OffScreenImage, 0, 0, 20);
                        gfx.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
                        GameCore.PaintBorder(gfx);
                    }
                    return;
                }
            }
        }
        if (this.OffScreenImage != null) {
            gfx.setClip(0, 0, this.OffScreenImage.getWidth(), this.OffScreenImage.getHeight());
            gfx.drawImage(this.OffScreenImage, 0, 0, 20);
        }
    }

    public final void keyPressed(int code) {
        if (this.AboutInfoFlag) {
            this.HideAboutScreen();
            return;
        }
        switch (this.getGameAction(code)) {
            case 1: {
                GameCore.MoveUp(true);
                break;
            }
            case 6: {
                GameCore.MoveDown(true);
                break;
            }
            case 2: {
                GameCore.MoveLeft(true);
                break;
            }
            case 5: {
                GameCore.MoveRight(true);
                break;
            }
            case 8: {
                if (this.GameState != 2) break;
                this.addCommand(cmdGiveUp);
                this.addCommand(cmdBack);
                this.GameState = 3;
                break;
            }
        }
    }

    public final void keyRepeated(int code) {
        this.keyPressed(code);
    }

    public final void pointerDragged(int x, int y) {
        GameCore.StylusMove(x, y);
    }

    public final void pointerPressed(int x, int y) {
        if (this.AboutInfoFlag) {
            return;
        }
        if (this.GameState == 2) {
            this.addCommand(cmdGiveUp);
            this.addCommand(cmdBack);
            this.GameState = 3;
        }
    }

    public final void pointerReleased(int x, int y) {
        if (this.AboutInfoFlag) {
            this.HideAboutScreen();
            return;
        }
        GameCore.StylusRelease();
    }

    public final void showNotify() {
        switch (this.GameState) {
            case 2: {
                this.GameState = 1;
                break;
            }
            case 3: {
                GameCore.NotifyGameInterupption();
                break;
            }
        }
    }

    public final void run() {
        while (this.GameState != 6) {
            long loopStartTime = System.currentTimeMillis();
            this.repaint();
            this.serviceRepaints();
            Thread.yield();
            long loopEndTime = System.currentTimeMillis();
            int loopTime = (int)(loopEndTime - loopStartTime);
            if (loopTime >= this.GameLoopDelay) continue;
            try {
                Thread.sleep(this.GameLoopDelay - loopTime);
            }
            catch (InterruptedException ie) {}
        }
    }

    public final void DestroyGame() {
        this.GameState = 6;
    }

    public final void commandAction(Command ncmd, Displayable ndisp) {
        long CurrentTimeInMillis = System.currentTimeMillis();
        if (CurrentTimeInMillis - this.DebounceItemTimer > 250L) {
            this.DebounceItemTimer = CurrentTimeInMillis;
            if (this.AboutInfoFlag) {
                this.HideAboutScreen();
                return;
            }
            try {
                if (ncmd.equals(cmdStart) && this.GameState != 3) {
                    this.addCommand(cmdGiveUp);
                    this.addCommand(cmdBack);
                    this.GameState = 3;
                }
                if (ncmd.equals(cmdBack)) {
                    this.WorkaroundForMenuBug();
                    this.removeCommand(cmdBack);
                    this.removeCommand(cmdGiveUp);
                    GameCore.ReStartGame();
                    this.GameState = 1;
                }
                if (ncmd.equals(cmdExit)) {
                    this.DestroyGame();
                    this.BaseMidlet.notifyDestroyed();
                }
                if (ncmd.equals(cmdAbout)) {
                    this.ShowAboutInfo();
                }
                if (ncmd.equals(cmdGiveUp) && this.GameState == 3) {
                    GameCore.GiveUpLive();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public final void ShowAboutInfo() {
        String IconName = this.PlayfieldWidth >= 480 ? "/DustDigger_48.png" : (this.PlayfieldWidth >= 240 ? "/DustDigger_32.png" : "/DustDigger_24.png");
        try {
            this.AppImage = Image.createImage((String)IconName);
        }
        catch (IOException e) {
            this.AppImage = null;
        }
        this.WorkaroundForMenuBug();
        this.removeCommand(cmdBack);
        this.removeCommand(cmdGiveUp);
        this.removeCommand(cmdStart);
        this.removeCommand(cmdExit);
        this.removeCommand(cmdAbout);
        this.addCommand(cmdOK);
        this.AppInfoScroll = 0;
        this.AppInfoDirection = 1;
        this.AppInfoDelay = 10;
        this.AboutInfoFlag = true;
        GameCore.SetClrBorder();
    }

    public final void HideAboutScreen() {
        this.AboutInfoFlag = false;
        GameCore.ResetSnapShotTable();
        this.WorkaroundForMenuBug();
        this.removeCommand(cmdOK);
        this.addCommand(cmdStart);
        this.addCommand(cmdExit);
        this.addCommand(cmdAbout);
        if (this.GameState == 3) {
            this.addCommand(cmdGiveUp);
            this.addCommand(cmdBack);
        }
    }

    protected final void sizeChanged(int newWidth, int newHeight) {
        if (GameCore != null) {
            this.ClearAllScreen = true;
            this.repaint();
            this.serviceRepaints();
            int wd = this.getWidth();
            int hg = this.getHeight();
            if (this.PlayfieldWidth != wd || this.PlayfieldHeight != hg) {
                this.PlayfieldWidth = wd;
                this.PlayfieldHeight = hg;
                this.OffScreenImage = Image.createImage((int)this.PlayfieldWidth, (int)this.PlayfieldHeight);
                GameCore.sizeChanged(this.PlayfieldWidth, this.PlayfieldHeight);
            }
        }
    }

    public final Image Get_AboutImage() {
        return this.AppImage;
    }

    private final void PaintAppInfo(Graphics gfx) {
        int i;
        int hw;
        int hg;
        gfx.setColor(0xFFFFFF);
        gfx.fillRect(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
        int tx = this.PlayfieldWidth >> 5;
        int ty = this.PlayfieldHeight >> 5;
        int dh = gfx.getFont().getHeight();
        int th = ty;
        Image TitleIcon = this.Get_AboutImage();
        if (TitleIcon != null) {
            hg = TitleIcon.getHeight();
            hw = TitleIcon.getWidth();
        } else {
            hg = 16;
            hw = 16;
        }
        int n = (dh << 1) + 2;
        if (n > hg) {
            th += n - hg >> 1;
            hg = n;
        }
        if (TitleIcon != null) {
            gfx.drawImage(TitleIcon, tx, th, 20);
        }
        th = (ty << 1) + hg;
        int cl = 0xFFFFFF;
        for (i = 0; i < this.PlayfieldWidth; ++i) {
            if (i < this.PlayfieldWidth - 51) {
                if (cl > 255) {
                    cl -= 328960;
                }
            } else if (cl < 0xFFFFFF) {
                cl += 328960;
            }
            gfx.setColor(cl);
            gfx.drawRect(i, th, 1, 1);
        }
        int bg = th = (ty << 2) + hg;
        int bt = this.PlayfieldHeight - dh - 2;
        gfx.setClip(0, th, this.PlayfieldWidth, this.PlayfieldHeight - th);
        th -= this.AppInfoScroll;
        gfx.setColor(0);
        String[] WordBreakedText = TextUtils.getWordBreakStringArray("Copyright \u00a92005 Roy Schneider\nFREEWARE\nE-Mail: royspa@overthehill.de\nTo get to the next level, you have to collect all diamonds while avoiding getting crushed by the rocks or caught by spiders.", gfx.getFont(), this.PlayfieldWidth - (tx << 1));
        if (WordBreakedText != null) {
            for (i = 0; i < WordBreakedText.length; ++i) {
                if (WordBreakedText[i] != null) {
                    n = 0;
                    if (th < bg) {
                        n = bg - th << 1;
                    }
                    if (th > bt) {
                        n = th - bt << 1;
                    }
                    if (n > 13) {
                        n = 13;
                    }
                    gfx.setColor(0x111111 * n);
                    gfx.drawString(WordBreakedText[i], tx, th, 20);
                }
                if ((th += dh) >= this.PlayfieldHeight) break;
            }
            if (this.AppInfoScroll != 0 && th < this.PlayfieldHeight && i >= WordBreakedText.length) {
                if (this.AppInfoDirection != -1) {
                    this.AppInfoDelay = 15;
                }
                this.AppInfoDirection = -1;
            }
            if (this.AppInfoScroll != 0 || th >= this.PlayfieldHeight) {
                if (this.AppInfoDelay == 0) {
                    this.AppInfoScroll += this.AppInfoDirection;
                } else {
                    --this.AppInfoDelay;
                }
                if (this.AppInfoScroll < 0) {
                    if (this.AppInfoDirection != 1) {
                        this.AppInfoDelay = 15;
                    }
                    this.AppInfoScroll = 0;
                    this.AppInfoDirection = 1;
                }
            }
        }
        gfx.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
        tx = (tx << 1) + hw + 1;
        ty = ty + (hg >> 1) - dh;
        gfx.setColor(0);
        String TitleString = "Version 1.7.0 (08-2013)";
        n = gfx.getFont().substringWidth(TitleString, 0, TitleString.length());
        if (tx + n > this.PlayfieldWidth && (n = TitleString.indexOf(40)) >= 0) {
            TitleString = TitleString.substring(0, n - 1);
        }
        gfx.drawString(TitleString, tx, ty + dh + 1, 20);
        gfx.setFont(gfx.getFont());
        gfx.setColor(0xCCCCCC);
        TitleString = "Dust Digger";
        gfx.drawString(TitleString, tx, ty, 20);
        gfx.setColor(0);
        gfx.drawString(TitleString, --tx, --ty, 20);
    }

    private final void WorkaroundForMenuBug() {
        Alert TempDisplay;
        if (this.CmdItemWorkAround && (TempDisplay = new Alert(StrPleaseWait)) != null) {
            TempDisplay.setTimeout(50);
            DustDigger.GameDisplay.setCurrent(TempDisplay, (Displayable)this);
        }
    }

    public final class CoreState {
        public static final int STATE_INIT = 0;
        public static final int STATE_PREPARE = 1;
        public static final int STATE_TITLE = 2;
        public static final int STATE_GAME = 3;
        public static final int STATE_OVER = 4;
        public static final int STATE_FINAL = 5;
        public static final int STATE_DESTROY = 6;
    }
}

