/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import overthehill.dustdigger.DiggerMain;
import overthehill.dustdigger.DiggerPlayfield;
import overthehill.dustdigger.JoyPad;
import overthehill.dustdigger.LineVector;
import overthehill.dustdigger.StarWay3D;

public final class DiggerGame {
    private Image TitleImage;
    private Image OverImage;
    private Image BlockImage;
    private Image SymbolImage;
    private StarWay3D TitleStars;
    private LineVector VectorObj;
    private DiggerPlayfield GamePlayfield;
    private final DiggerMain BaseCanvas;
    private final String GameResourcePath;
    private int TitleHeight;
    private int OverHeight;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private int WelcomeDirect;
    private int X_Angle;
    private int Y_Angle;
    private int Z_Angle;
    private int ObjZoom;
    private int MaxObjZoom;
    private int ObjRGB;
    private boolean ColoredDisplay;
    private boolean ShowVectorObj;
    private int NumColorsDisplay;
    public static Font GameFont;
    public static final String[] WelcomeTexts;
    public static final String AboutText = "Copyright \u00a92005 Roy Schneider\nFREEWARE\nE-Mail: royspa@overthehill.de\nTo get to the next level, you have to collect all diamonds while avoiding getting crushed by the rocks or caught by spiders.";
    public static final String AboutVersion = "Version 1.7.0 (08-2013)";

    public DiggerGame(DiggerMain rCanvas, String GameRootPath, int dWidth, int dHeight, boolean bColored, int NumColors) {
        this.BaseCanvas = rCanvas;
        this.ColoredDisplay = bColored;
        this.NumColorsDisplay = NumColors;
        this.GameResourcePath = GameRootPath;
        this.InitGame(dWidth, dHeight);
    }

    public final void InitGame(int dWidth, int dHeight) {
        int BlockSize = 0;
        int SymbXSize = 0;
        int SymbYSize = 0;
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.WelcomeDirect = 0;
        String GfxRootPath = new String(this.GameResourcePath);
        GfxRootPath = GfxRootPath + "/images";
        this.LoadTitleGraphics(GfxRootPath, dWidth, dHeight, this.ColoredDisplay, this.NumColorsDisplay);
        this.LoadOverGraphics(GfxRootPath, dWidth, dHeight, this.ColoredDisplay, this.NumColorsDisplay);
        this.ShowVectorObj = this.PlayfieldWidth >= 100 || this.PlayfieldHeight >= 100;
        try {
            if (dWidth >= 400 && dHeight >= 400) {
                GfxRootPath = GfxRootPath + "/largest";
                BlockSize = 64;
                SymbXSize = 32;
                SymbYSize = 32;
            } else if (dWidth >= 192 && dHeight >= 192) {
                GfxRootPath = GfxRootPath + "/large";
                BlockSize = 32;
                SymbXSize = 16;
                SymbYSize = 16;
            } else {
                GfxRootPath = GfxRootPath + "/small";
                BlockSize = 16;
                SymbXSize = 8;
                SymbYSize = 8;
                if (!this.ColoredDisplay && this.NumColorsDisplay < 16) {
                    GfxRootPath = GfxRootPath + "/bw";
                }
            }
            this.BlockImage = Image.createImage((String)(GfxRootPath + "/blocks.png"));
            if (this.ColoredDisplay) {
                this.SymbolImage = Image.createImage((String)(GfxRootPath + "/syms.png"));
            }
        }
        catch (IOException e) {
            this.BaseCanvas.DestroyGame();
        }
        GameFont = this.PlayfieldHeight < 160 ? null : (this.PlayfieldHeight >= 220 ? Font.getFont((int)0, (int)1, (int)16) : Font.getFont((int)0, (int)0, (int)0));
        int cnt = this.PlayfieldWidth >> 1;
        if (cnt < 48) {
            cnt = 48;
        }
        this.TitleStars = new StarWay3D(cnt, this.PlayfieldWidth, this.PlayfieldHeight, this.ColoredDisplay);
        this.VectorObj = new LineVector();
        this.VectorObj.Set_Polygons(LineVector.m_vec_crystal_line_obj);
        this.X_Angle = 0;
        this.Y_Angle = 0;
        this.Z_Angle = 0;
        this.ObjZoom = 0;
        this.ObjRGB = 0;
        this.MaxObjZoom = 0;
        if (this.GamePlayfield != null) {
            this.GamePlayfield.sizeChanged(this.BlockImage, this.SymbolImage, this.OverImage, this.PlayfieldWidth, this.PlayfieldHeight, this.OverHeight, BlockSize, SymbXSize, SymbYSize);
        } else {
            this.GamePlayfield = new DiggerPlayfield(this.BlockImage, this.SymbolImage, this.OverImage, this.PlayfieldWidth, this.PlayfieldHeight, this.OverHeight, BlockSize, SymbXSize, SymbYSize);
            if (this.CheckForManipulation()) {
                this.BaseCanvas.DestroyGame();
            }
        }
    }

    private final void LoadTitleGraphics(String ImageRootPath, int dWidth, int dHeight, boolean ColoredDisp, int NumColors) {
        try {
            String GfxRootPath = new String(ImageRootPath);
            if (dWidth >= 320 && dHeight >= 220) {
                GfxRootPath = GfxRootPath + "/largest";
                this.TitleHeight = 178;
            } else if (dWidth >= 176 && dHeight >= 160) {
                GfxRootPath = GfxRootPath + "/large";
                this.TitleHeight = 130;
            } else {
                GfxRootPath = GfxRootPath + "/small";
                this.TitleHeight = 65;
                if (!ColoredDisp && NumColors < 16) {
                    GfxRootPath = GfxRootPath + "/bw";
                    this.TitleHeight = 15;
                }
            }
            this.TitleImage = Image.createImage((String)(GfxRootPath + "/title.png"));
        }
        catch (IOException e) {
            this.BaseCanvas.DestroyGame();
        }
    }

    private final void LoadOverGraphics(String ImageRootPath, int dWidth, int dHeight, boolean ColoredDisp, int NumColors) {
        try {
            String GfxRootPath = new String(ImageRootPath);
            if (dWidth >= 320 && dHeight >= 220) {
                GfxRootPath = GfxRootPath + "/largest";
                this.OverHeight = 147;
            } else if (dWidth >= 176 && dHeight >= 160) {
                GfxRootPath = GfxRootPath + "/large";
                this.OverHeight = 108;
            } else {
                GfxRootPath = GfxRootPath + "/small";
                this.OverHeight = 54;
                if (!ColoredDisp && NumColors < 16) {
                    return;
                }
            }
            this.OverImage = Image.createImage((String)(GfxRootPath + "/gameover.png"));
        }
        catch (IOException e) {
            this.BaseCanvas.DestroyGame();
        }
    }

    public final void PaintTitle(Graphics gfx) {
        if (gfx != null) {
            int WelcomeColor;
            gfx.setColor(0);
            gfx.fillRect(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
            int TitlePos = this.PlayfieldHeight / 3 - (this.TitleHeight >> 1) - 4;
            if (TitlePos < 0) {
                TitlePos = 0;
            }
            if (GameFont != null) {
                gfx.setFont(GameFont);
            }
            int FontHeight = gfx.getFont().getHeight();
            int WelcomeIndex = this.WelcomeDirect >> 4 & 0xFE;
            if (this.NumColorsDisplay >= 16) {
                WelcomeColor = (this.WelcomeDirect & 0xF) + 1;
                WelcomeColor = (this.WelcomeDirect & 0x10) == 0 ? (WelcomeColor > 7 ? 0xFFFFFF : WelcomeColor * 0x222222) : (WelcomeColor > 15 ? 0 : 0xFFFFFF - WelcomeColor * 0x111111);
            } else {
                WelcomeColor = 0xFFFFFF;
            }
            int TextPos = TitlePos + this.TitleHeight;
            int Height = this.PlayfieldHeight - TextPos;
            int CursorLineA = TextPos + (Height * 35 >> 7) - (FontHeight >> 1);
            int CursorLineB = TextPos + (Height * 85 >> 7) - (FontHeight >> 1);
            if (CursorLineB + FontHeight > this.PlayfieldHeight) {
                CursorLineB = this.PlayfieldHeight - FontHeight;
            }
            if (CursorLineB < (TextPos = CursorLineA + FontHeight + 2)) {
                CursorLineA -= TextPos - CursorLineB;
            }
            this.TitleStars.Paint(gfx);
            gfx.drawImage(this.TitleImage, this.PlayfieldWidth >> 1, TitlePos, 17);
            gfx.setColor(WelcomeColor);
            gfx.drawString(WelcomeTexts[WelcomeIndex], this.PlayfieldWidth >> 1, CursorLineA, 17);
            gfx.drawString(WelcomeTexts[WelcomeIndex + 1], this.PlayfieldWidth >> 1, CursorLineB, 17);
            if (++this.WelcomeDirect >= WelcomeTexts.length << 4) {
                this.WelcomeDirect = 0;
            }
            if (this.ShowVectorObj) {
                if (this.MaxObjZoom == 0) {
                    this.MaxObjZoom = this.PlayfieldHeight > this.PlayfieldWidth ? 512 * this.PlayfieldWidth / 100 : 512 * this.PlayfieldHeight / 100;
                }
                this.ObjZoom = this.ObjZoom < this.MaxObjZoom ? (this.ObjZoom += 31) : this.MaxObjZoom;
                if (this.ObjRGB < 65280) {
                    this.ObjRGB += 4352;
                }
                this.X_Angle += 3;
                if (this.X_Angle >= 360) {
                    this.X_Angle -= 360;
                }
                this.Y_Angle += 5;
                if (this.Y_Angle >= 360) {
                    this.Y_Angle -= 360;
                }
                this.Z_Angle += 7;
                if (this.Z_Angle >= 360) {
                    this.Z_Angle -= 360;
                }
                this.VectorObj.CalcPolygons(this.X_Angle, this.Y_Angle, this.Z_Angle, this.ObjZoom);
                this.VectorObj.DrawObject(gfx, this.PlayfieldWidth >> 1, this.PlayfieldHeight * 65 / 100, this.ObjRGB, 64);
            }
        }
    }

    public final void PaintGame(Graphics dbl, Graphics dst) {
        this.GamePlayfield.BuildPlayfield(dbl, dst);
    }

    public final void PaintBorder(Graphics gfx) {
        this.GamePlayfield.PaintBorder(gfx);
    }

    public final void MoveLeft(boolean KeyState) {
        JoyPad.SetLeftKeyState(KeyState);
    }

    public final void MoveRight(boolean KeyState) {
        JoyPad.SetRightKeyState(KeyState);
    }

    public final void MoveUp(boolean KeyState) {
        JoyPad.SetUpKeyState(KeyState);
    }

    public final void MoveDown(boolean KeyState) {
        JoyPad.SetDownKeyState(KeyState);
    }

    public final void StylusRelease() {
        this.GamePlayfield.StylusRelease();
    }

    public final void StylusMove(int StylusX, int StylusY) {
        this.GamePlayfield.StylusMove(StylusX, StylusY);
    }

    public final void ReStartGame() {
        this.GamePlayfield.ReStartLevel(true);
        this.GamePlayfield.ResetSnapShotTable();
        this.WelcomeDirect = 0;
        this.ObjZoom = 0;
        this.ObjRGB = 0;
    }

    private final int CalcTextCheckSum() {
        int CheckSum = 0;
        for (int tline = 0; tline < WelcomeTexts.length; ++tline) {
            int textlen = WelcomeTexts[tline].length();
            while (textlen-- != 0) {
                CheckSum += WelcomeTexts[tline].charAt(textlen);
            }
        }
        return CheckSum;
    }

    private final boolean CheckForManipulation() {
        return this.CalcTextCheckSum() != 13642 || this.TitleImage.getHeight() != this.TitleHeight || !"Dust Digger".endsWith("Digger") || "\nVersion: 1.7.0\nCopyright 2013\nRoy Schneider\nFREEWARE\n".indexOf("Schneider") == -1;
    }

    public final void NotifyGameInterupption() {
        this.GamePlayfield.RestoreAllNotification();
    }

    public final void NextLevel() {
        this.GamePlayfield.NextLevel();
    }

    public final void GiveUpLive() {
        this.GamePlayfield.GiveUpLive();
    }

    public void sizeChanged(int dWidth, int dHeight) {
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.InitGame(dWidth, dHeight);
    }

    public final void ResetSnapShotTable() {
        this.GamePlayfield.ResetSnapShotTable();
    }

    public void SetClrBorder() {
        this.GamePlayfield.SetClrBorder();
    }

    static {
        WelcomeTexts = new String[]{"A classic for", "your mobile.", "Idea and coding", "Roy Schneider", "Copyright \u00a92005", "Roy Schneider", "This game is", "FREEWARE!", "If you like it,", "e-mail me.", "royspa@", "overthehill.de"};
    }
}

