/*
 * Decompiled with CFR 0.152.
 */
package overthehill.dustdigger;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import overthehill.dustdigger.DiggerGame;
import overthehill.dustdigger.DiggerLevels;
import overthehill.dustdigger.JoyPad;

public final class DiggerPlayfield {
    private int BobsPerCol;
    private int BobsPerRow;
    private int LeftBorder;
    private int RightBorder;
    private int TopBorder;
    private int BottomBorder;
    private int LevelNum;
    private int PlayerLives;
    private int PlayerOffset;
    private int Diamonds;
    private int KeyFound;
    private int RestartDelay;
    private int FlickerMode;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private int InternalState;
    private int BlinkCounter;
    private int OverHeight;
    private int PlayerSpdX;
    private int PlayerSpdY;
    private int BobsPerRowClip;
    private int BobsPerColClip;
    private boolean LastPlayerDirection;
    private boolean SoftScrolling;
    private final SimplePoint ScrollOffset = new SimplePoint();
    private final SimplePoint PlayerRel = new SimplePoint();
    private final SimplePoint StylusPos = new SimplePoint();
    private final SimplePoint OldStylusPos = new SimplePoint();
    private final SimplePoint Difference = new SimplePoint();
    private final SimplePoint PlayerFine = new SimplePoint();
    private final SimplePoint ScrollFine = new SimplePoint();
    private final SimplePoint PlayerDirection = new SimplePoint();
    private Image BlockImage;
    private Image SymbImage;
    private Image OverImage;
    private static final int AbsLevelCols = 28;
    private static final int AbsLevelRows = 28;
    private static final int GravSpeed = 200;
    private static final int BlkImgPerRowShift = 2;
    private static final int BlkImgPerRowMask = 3;
    private int BorderVal;
    private int BlockSize;
    private int BlockShift;
    private int SymbXSize;
    private int SymbYSize;
    private int PlayerAnimIdex;
    private char[] Playfield;
    private char[][] SnapShot;
    private int GlenzIndex;
    private static final byte[] GlenzTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0};
    private int LavaIndex;
    private int LavaTimer;
    private static final short[] LavaTable = new short[]{28, 1, 1, 1, 28, 1, 28, 28, 1, 1};

    public DiggerPlayfield(Image dImage, Image dSymbols, Image dOver, int dWidth, int dHeight, int dOverHeight, int pBlkSize, int pXSymSize, int pYSymSize) {
        this.BlockImage = dImage;
        this.SymbImage = dSymbols;
        this.OverImage = dOver;
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.OverHeight = dOverHeight;
        this.SoftScrolling = true;
        String midpver = System.getProperty("microedition.profiles");
        if (midpver != null && (midpver = midpver.toUpperCase().trim()).compareTo("MIDP-1.0") == 0) {
            this.SoftScrolling = false;
        }
        this.Playfield = new char[785];
        if (this.Playfield != null) {
            this.ResetGameVars();
            this.InternalState = 0;
            this.BlockSize = pBlkSize;
            this.BlockShift = this.BlockSize == 64 ? 6 : (this.BlockSize == 32 ? 5 : 4);
            this.SymbXSize = pXSymSize;
            this.SymbYSize = pYSymSize;
            this.BobsPerRow = dWidth >> this.BlockShift;
            if (this.BobsPerRow > 28) {
                this.BobsPerRow = 28;
            }
            this.BobsPerRowClip = this.BobsPerRow << this.BlockShift;
            this.BobsPerCol = dHeight >> this.BlockShift;
            if (this.BobsPerCol > 28) {
                this.BobsPerCol = 28;
            }
            this.BobsPerColClip = this.BobsPerCol << this.BlockShift;
            int i = this.BobsPerRow << this.BlockShift;
            this.LeftBorder = dWidth - i >> 1;
            this.RightBorder = dWidth - (this.LeftBorder + i);
            i = this.BobsPerCol << this.BlockShift;
            this.TopBorder = dHeight - i >> 1;
            this.BottomBorder = dHeight - (this.TopBorder + i);
            if (this.SoftScrolling) {
                ++this.BobsPerRow;
                ++this.BobsPerCol;
            }
            this.PrepareLevel();
            this.SnapShot = new char[this.BobsPerRow][this.BobsPerCol];
            this.ResetSnapShotTable();
        }
    }

    public final void BuildPlayfield(Graphics dbl, Graphics dst) {
        if (dbl != null) {
            dbl.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
            if (++this.BlinkCounter > 8) {
                this.BlinkCounter = 1;
            }
            this.PaintPlayfield(dbl);
            if (this.InternalState != 5) {
                if (this.RestartDelay <= 0) {
                    if (JoyPad.IsAnyKey()) {
                        this.StylusPos.x = this.PlayerOffset % 28 - this.ScrollOffset.x;
                        this.StylusPos.y = this.PlayerOffset / 28 - this.ScrollOffset.y;
                        if (JoyPad.IsLeftKey()) {
                            --this.StylusPos.x;
                            JoyPad.SetLeftKeyState(false);
                        }
                        if (JoyPad.IsRightKey()) {
                            ++this.StylusPos.x;
                            JoyPad.SetRightKeyState(false);
                        }
                        if (JoyPad.IsUpKey()) {
                            --this.StylusPos.y;
                            JoyPad.SetUpKeyState(false);
                        }
                        if (JoyPad.IsDownKey()) {
                            ++this.StylusPos.y;
                            JoyPad.SetDownKeyState(false);
                        }
                    }
                    if (this.PlayerFine.x == 0) {
                        this.CheckGravity();
                    }
                    this.MoveMonster();
                    this.MovePlayer();
                    this.CheckCollision();
                    dst.setClip(this.LeftBorder, this.TopBorder, this.BobsPerRowClip, this.BobsPerColClip);
                } else {
                    if (this.InternalState == 4 && this.OverImage != null) {
                        dbl.drawImage(this.OverImage, this.PlayfieldWidth >> 1, this.PlayfieldHeight - this.OverHeight >> 1, 17);
                    }
                    if (--this.RestartDelay == 0) {
                        this.ReStartLevel(false);
                    }
                    dst.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
                    this.BorderVal = -1;
                }
            } else {
                this.DrawFinalInformation(dbl);
                dst.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
                this.BorderVal = -1;
            }
        }
    }

    public final void PaintBorder(Graphics gfx) {
        gfx.setColor(0);
        if (this.LeftBorder > 0) {
            if (this.BorderVal == -1 || this.BorderVal == 0) {
                gfx.fillRect(0, this.TopBorder, this.LeftBorder, this.PlayfieldHeight - (this.TopBorder + this.BottomBorder));
            }
            if (this.BorderVal == -1 || this.BorderVal == 1) {
                gfx.fillRect(this.PlayfieldWidth - this.RightBorder, this.TopBorder, this.RightBorder, this.PlayfieldHeight - (this.TopBorder + this.BottomBorder));
            }
        }
        if (this.TopBorder > 0) {
            if (this.BorderVal == -1 || this.BorderVal == 2) {
                gfx.fillRect(0, 0, this.PlayfieldWidth, this.TopBorder);
            }
            if (this.BorderVal == -1 || this.BorderVal == 3) {
                gfx.fillRect(0, this.PlayfieldHeight - this.BottomBorder, this.PlayfieldWidth, this.BottomBorder);
            }
        }
        if (++this.BorderVal >= 8) {
            this.BorderVal = 0;
        }
    }

    private final void PaintPlayfield(Graphics gfx) {
        char[] Plf = this.Playfield;
        int PlMax = Plf.length;
        int BlkSze = this.BlockSize;
        int BlkSht = this.BlockShift;
        int PlOrg = this.ScrollOffset.y * 28 + this.ScrollOffset.x;
        int HalfBlk = BlkSze >> 1;
        int YSymbPos = this.TopBorder + 2;
        int bobscol = this.BobsPerCol;
        int bobsrow = this.BobsPerRow;
        int XDestOrg = this.LeftBorder - this.ScrollFine.x;
        int XSymbPos = this.LeftBorder + 2;
        int lives = this.PlayerLives;
        if (gfx == null) {
            return;
        }
        if (this.FlickerMode == 0) {
            int YSourceOff;
            int XSourceOff;
            int SnapId;
            int BlockId;
            int xindex;
            int XDestPos;
            int yindex;
            if (this.SoftScrolling && !this.LastPlayerDirection && (this.PlayerDirection.x != 0 || this.PlayerDirection.y != 0)) {
                this.LastPlayerDirection = true;
            }
            int PlayerId = 0;
            boolean bPlayerVisible = false;
            boolean bInBetween = false;
            boolean bCheckForSnapIgnore = false;
            int xp = 0;
            int yp = 0;
            int idx = this.GlenzIndex;
            int YDestPos = this.TopBorder - this.ScrollFine.y;
            int PlOffset = PlOrg;
            for (yindex = 0; yindex < bobscol; ++yindex) {
                XDestPos = XDestOrg;
                for (xindex = 0; xindex < bobsrow; ++xindex) {
                    BlockId = Plf[PlOffset] - 65;
                    boolean bBackBlit = false;
                    switch (BlockId & 0xFF) {
                        case 0: {
                            if ((BlockId & 0x7700) != 0) {
                                bInBetween = true;
                                BlockId = 6;
                                SnapId = -1;
                                break;
                            }
                            bBackBlit = true;
                            SnapId = BlockId;
                            break;
                        }
                        case 5: {
                            if ((BlockId & 0x100) != 0) {
                                bInBetween = true;
                                BlockId = 6;
                                SnapId = -1;
                                break;
                            }
                            SnapId = BlockId;
                            if (GlenzTable[idx++] != 0) {
                                SnapId = BlockId = 16;
                            }
                            if (idx >= GlenzTable.length) {
                                idx = 0;
                            }
                            bBackBlit = true;
                            break;
                        }
                        case 6: {
                            if ((BlockId & 0x300) != 0) {
                                SnapId = -1;
                                bCheckForSnapIgnore = true;
                                break;
                            }
                            SnapId = BlockId;
                            break;
                        }
                        case 9: 
                        case 10: {
                            SnapId = BlockId;
                            if ((BlockId & 0xF00) != 0) {
                                bInBetween = true;
                                BlockId = 6;
                                break;
                            }
                            bBackBlit = true;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 7: 
                        case 11: {
                            SnapId = -1;
                            PlayerId = BlockId;
                            xp = XDestPos + this.PlayerFine.x;
                            yp = YDestPos + this.PlayerFine.y;
                            bPlayerVisible = true;
                            BlockId = 6;
                            break;
                        }
                        case 18: {
                            if (this.BlinkCounter <= 4) {
                                BlockId = 6;
                            }
                            SnapId = BlockId;
                            break;
                        }
                        default: {
                            SnapId = BlockId;
                        }
                    }
                    if (this.SnapShot[xindex][yindex] != (char)SnapId || this.LastPlayerDirection) {
                        if (bBackBlit) {
                            XSourceOff = 2 << BlkSht;
                            YSourceOff = 1 << BlkSht;
                            gfx.setClip(XDestPos, YDestPos, BlkSze, BlkSze);
                            gfx.drawImage(this.BlockImage, XDestPos - XSourceOff, YDestPos - YSourceOff, 20);
                        }
                        XSourceOff = ((BlockId &= 0xFF) & 3) << BlkSht;
                        YSourceOff = BlockId >> 2 << BlkSht;
                        gfx.setClip(XDestPos, YDestPos, BlkSze, BlkSze);
                        gfx.drawImage(this.BlockImage, XDestPos - XSourceOff, YDestPos - YSourceOff, 20);
                    }
                    if (SnapId < 0) {
                        SnapId = 120;
                    }
                    this.SnapShot[xindex][yindex] = (char)SnapId;
                    XDestPos += BlkSze;
                    if (++PlOffset >= PlMax) break;
                }
                YDestPos += BlkSze;
                if ((PlOffset += 28 - this.BobsPerRow) >= PlMax) break;
            }
            if (bCheckForSnapIgnore || bInBetween) {
                YDestPos = this.TopBorder - this.ScrollFine.y;
                PlOffset = PlOrg;
                for (yindex = 0; yindex < bobscol; ++yindex) {
                    XDestPos = XDestOrg;
                    for (xindex = 0; xindex < bobsrow; ++xindex) {
                        BlockId = Plf[PlOffset] - 65;
                        switch (BlockId & 0xFF) {
                            case 6: {
                                if (!bInBetween && (BlockId & 0x300) != 0) {
                                    int n = PlOffset;
                                    Plf[n] = (char)(Plf[n] - 256);
                                }
                                BlockId = -1;
                                break;
                            }
                            case 9: 
                            case 10: {
                                SnapId = BlockId & 0xF00;
                                if (SnapId == 0) {
                                    BlockId = -1;
                                    break;
                                }
                                XSourceOff = ((BlockId &= 0xFF) & 3) << BlkSht;
                                YSourceOff = BlockId >> 2 << BlkSht;
                                int xg = XDestPos;
                                int yg = YDestPos;
                                if ((SnapId & 0x100) != 0) {
                                    xg += HalfBlk;
                                } else if ((SnapId & 0x200) != 0) {
                                    xg -= HalfBlk;
                                }
                                if ((SnapId & 0x400) != 0) {
                                    yg += HalfBlk;
                                } else if ((SnapId & 0x800) != 0) {
                                    yg -= HalfBlk;
                                }
                                gfx.setClip(xg, yg, BlkSze, BlkSze);
                                gfx.drawImage(this.BlockImage, xg - XSourceOff, yg - YSourceOff, 20);
                                BlockId = -1;
                                break;
                            }
                            case 0: {
                                int yg;
                                int xg;
                                if ((BlockId & 0x100) != 0) break;
                                if ((BlockId & 0x6600) != 0) {
                                    xg = XDestPos;
                                    yg = BlkSze / 3;
                                    if ((BlockId & 0x200) != 0) {
                                        xg += BlkSze - yg;
                                    } else if ((BlockId & 0x400) != 0) {
                                        xg -= BlkSze - yg;
                                    } else if ((BlockId & 0x2000) != 0) {
                                        xg += yg;
                                    } else if ((BlockId & 0x4000) != 0) {
                                        xg -= yg;
                                    }
                                    gfx.setClip(xg, YDestPos, BlkSze, BlkSze);
                                    gfx.drawImage(this.BlockImage, xg, YDestPos, 20);
                                }
                                BlockId = -1;
                                break;
                            }
                            case 5: {
                                if ((BlockId & 0x100) != 0) break;
                            }
                            default: {
                                BlockId = -1;
                            }
                        }
                        if (BlockId >= 0) {
                            XSourceOff = ((BlockId &= 0xFF) & 3) << BlkSht;
                            YSourceOff = BlockId >> 2 << BlkSht;
                            gfx.setClip(XDestPos, YDestPos - HalfBlk, BlkSze, BlkSze);
                            gfx.drawImage(this.BlockImage, XDestPos - XSourceOff, YDestPos - HalfBlk - YSourceOff, 20);
                        }
                        XDestPos += BlkSze;
                        if (++PlOffset >= PlMax) break;
                    }
                    YDestPos += BlkSze;
                    if ((PlOffset += 28 - this.BobsPerRow) >= PlMax) break;
                }
            }
            if (bPlayerVisible) {
                gfx.setClip(xp, yp, BlkSze, BlkSze);
                if (PlayerId != 11) {
                    if (PlayerId == 7) {
                        if ((this.PlayerAnimIdex & 2) != 0) {
                            PlayerId += 15;
                            if ((this.PlayerAnimIdex & 1) != 0) {
                                ++PlayerId;
                            }
                        }
                    } else if ((this.PlayerAnimIdex & 2) != 0) {
                        PlayerId += 17;
                    }
                }
                XSourceOff = (PlayerId & 3) << BlkSht;
                YSourceOff = PlayerId >> 2 << BlkSht;
                gfx.drawImage(this.BlockImage, xp - XSourceOff, yp - YSourceOff, 20);
            }
            if (lives > 0 && this.SymbImage != null) {
                do {
                    gfx.setClip(XSymbPos, YSymbPos, this.SymbXSize, this.SymbYSize);
                    gfx.drawImage(this.SymbImage, XSymbPos, YSymbPos, 20);
                    XSymbPos += this.SymbXSize;
                } while (--lives != 0);
            }
            gfx.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
            if ((this.BlinkCounter & 1) == 0) {
                this.GlenzIndex = idx;
            }
        } else {
            gfx.setColor(0xFFFFFF);
            gfx.fillRect(this.LeftBorder, this.TopBorder, BlkSze * this.BobsPerRow, BlkSze * this.BobsPerCol);
            this.ResetSnapShotTable();
            --this.FlickerMode;
        }
        if (this.LastPlayerDirection && this.PlayerDirection.x == 0 && this.PlayerDirection.y == 0) {
            this.LastPlayerDirection = false;
        }
    }

    private final void CheckGravity() {
        char[] Plf = this.Playfield;
        int nCols = 28;
        int AbsLevelCols2X = nCols << 1;
        int iLen = nCols;
        block16: for (int PlIdx = Plf.length - nCols - 2; PlIdx > iLen; --PlIdx) {
            char nChr = Plf[PlIdx];
            switch (nChr & 0xFF) {
                case 65: {
                    char EId;
                    if ((nChr & 0x6600) != 0) continue block16;
                    switch (Plf[PlIdx + nCols] & 0xFF) {
                        case 78: {
                            int n = PlIdx;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            if (Plf[PlIdx + AbsLevelCols2X] != 'G') continue block16;
                            Plf[PlIdx] = 71;
                            Plf[PlIdx + AbsLevelCols2X] = 70;
                            continue block16;
                        }
                        case 71: {
                            if ((nChr & 0x100) != 0) {
                                int n = PlIdx;
                                Plf[n] = (char)(Plf[n] & 0xFF);
                                continue block16;
                            }
                            Plf[PlIdx] = 839;
                            Plf[PlIdx + nCols] = 321;
                            EId = Plf[PlIdx + AbsLevelCols2X];
                            if (EId != 'D' && EId != 'E' && EId != 'H') continue block16;
                            int n = PlIdx + nCols;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            this.LoseLive();
                            Plf[PlIdx + AbsLevelCols2X] = 76;
                            continue block16;
                        }
                        case 74: 
                        case 75: {
                            int n = PlIdx;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            Plf[PlIdx + nCols] = 70;
                            continue block16;
                        }
                        case 65: 
                        case 70: 
                        case 83: {
                            if ((nChr & 0x100) != 0) {
                                int n = PlIdx;
                                Plf[n] = (char)(Plf[n] & 0xFF);
                                continue block16;
                            }
                            int n = PlIdx;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            if (Plf[PlIdx + nCols - 1] == 'G' && Plf[PlIdx - 1] == 'G') {
                                Plf[PlIdx] = 71;
                                Plf[PlIdx - 1] = 839;
                                Plf[PlIdx + nCols - 1] = 321;
                                EId = Plf[PlIdx + AbsLevelCols2X - 1];
                                if (EId != 'D' && EId != 'E' && EId != 'H') continue block16;
                                int n2 = PlIdx + nCols - 1;
                                Plf[n2] = (char)(Plf[n2] & 0xFF);
                                this.LoseLive();
                                Plf[PlIdx + AbsLevelCols2X - 1] = 76;
                                continue block16;
                            }
                            if (Plf[PlIdx + nCols + 1] != 'G' || Plf[PlIdx + 1] != 'G') continue block16;
                            Plf[PlIdx] = 71;
                            Plf[PlIdx + 1] = 839;
                            Plf[PlIdx + nCols + 1] = 321;
                            EId = Plf[PlIdx + AbsLevelCols2X + 1];
                            if (EId != 'D' && EId != 'E' && EId != 'H') continue block16;
                            int n3 = PlIdx + nCols + 1;
                            Plf[n3] = (char)(Plf[n3] & 0xFF);
                            this.LoseLive();
                            Plf[PlIdx + AbsLevelCols2X + 1] = 76;
                            continue block16;
                        }
                    }
                    int n = PlIdx;
                    Plf[n] = (char)(Plf[n] & 0xFF);
                    continue block16;
                }
                case 70: {
                    char EId;
                    switch (Plf[PlIdx + nCols] & 0xFF) {
                        case 78: {
                            int n = PlIdx;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            if (Plf[PlIdx + AbsLevelCols2X] != 'G') continue block16;
                            Plf[PlIdx] = 71;
                            Plf[PlIdx + AbsLevelCols2X] = 65;
                            continue block16;
                        }
                        case 71: {
                            if ((Plf[PlIdx] & 0x100) != 0) {
                                int n = PlIdx;
                                Plf[n] = (char)(Plf[n] & 0xFF);
                                continue block16;
                            }
                            Plf[PlIdx] = 71;
                            Plf[PlIdx] = 839;
                            Plf[PlIdx + nCols] = 326;
                            EId = Plf[PlIdx + AbsLevelCols2X];
                            if (EId != 'D' && EId != 'E' && EId != 'H') continue block16;
                            int n = PlIdx + nCols;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            this.LoseLive();
                            Plf[PlIdx + AbsLevelCols2X] = 76;
                            continue block16;
                        }
                        case 74: 
                        case 75: {
                            int n = PlIdx;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            Plf[PlIdx + nCols] = 70;
                            continue block16;
                        }
                        case 65: 
                        case 70: 
                        case 83: {
                            int n = PlIdx;
                            Plf[n] = (char)(Plf[n] & 0xFF);
                            if (Plf[PlIdx + nCols - 1] == 'G' && Plf[PlIdx - 1] == 'G') {
                                Plf[PlIdx] = 71;
                                Plf[PlIdx - 1] = 839;
                                Plf[PlIdx + nCols - 1] = 326;
                                EId = Plf[PlIdx + AbsLevelCols2X - 1];
                                if (EId != 'D' && EId != 'E' && EId != 'H') continue block16;
                                int n4 = PlIdx + nCols - 1;
                                Plf[n4] = (char)(Plf[n4] & 0xFF);
                                this.LoseLive();
                                Plf[PlIdx + AbsLevelCols2X - 1] = 76;
                                continue block16;
                            }
                            if (Plf[PlIdx + nCols + 1] != 'G' || Plf[PlIdx + 1] != 'G') continue block16;
                            Plf[PlIdx] = 71;
                            Plf[PlIdx + 1] = 839;
                            Plf[PlIdx + nCols + 1] = 326;
                            EId = Plf[PlIdx + AbsLevelCols2X + 1];
                            if (EId != 'D' && EId != 'E' && EId != 'H') continue block16;
                            int n5 = PlIdx + nCols + 1;
                            Plf[n5] = (char)(Plf[n5] & 0xFF);
                            this.LoseLive();
                            Plf[PlIdx + AbsLevelCols2X + 1] = 76;
                            continue block16;
                        }
                    }
                    int n = PlIdx;
                    Plf[n] = (char)(Plf[n] & 0xFF);
                }
            }
        }
    }

    public final void GiveUpLive() {
        this.Playfield[this.PlayerOffset] = 76;
        this.LoseLive();
    }

    private final void LoseLive() {
        if (this.InternalState != 3) {
            return;
        }
        --this.PlayerLives;
        if (this.PlayerLives <= 0) {
            this.RestartDelay = 35;
            this.InternalState = 4;
        } else {
            this.RestartDelay = 10;
        }
        this.ResetSnapShotTable();
        JoyPad.ResetAllKeys();
    }

    private final void OpenGate() {
        for (int idx = 0; idx < this.Playfield.length; ++idx) {
            if (this.Playfield[idx] != 'O') continue;
            this.Playfield[idx] = 80;
            break;
        }
        this.FlickerMode = 3;
    }

    private final void DiamondCollected() {
        if (--this.Diamonds == 0) {
            this.OpenGate();
        }
    }

    private final void KeyCollected() {
        ++this.KeyFound;
    }

    private final boolean UseKeyOnDoor() {
        if (this.KeyFound > 0) {
            --this.KeyFound;
            return true;
        }
        return false;
    }

    private final void PrepareLevel() {
        this.BorderVal = -1;
        this.KeyFound = 0;
        this.LavaIndex = 0;
        this.LavaTimer = 0;
        this.PlayerAnimIdex = 0;
        if (this.SoftScrolling) {
            this.PlayerSpdX = this.BlockSize >> 2;
            this.PlayerSpdY = this.BlockSize >> 2;
        } else {
            this.PlayerSpdX = this.BlockSize;
            this.PlayerSpdY = this.BlockSize;
        }
        this.PlayerDirection.x = 0;
        this.PlayerDirection.y = 0;
        this.PlayerFine.x = 0;
        this.PlayerFine.y = 0;
        this.ScrollFine.x = 0;
        this.ScrollFine.y = 0;
        this.StylusPos.x = this.BlockSize + (this.BlockSize >> 1);
        this.StylusPos.y = this.BlockSize + (this.BlockSize >> 1);
        this.PlayerOffset = 29;
        if (this.LevelNum <= DiggerLevels.GetLevelCount()) {
            this.Playfield = DiggerLevels.GetLevelCharArray(this.LevelNum);
            this.Diamonds = DiggerLevels.GetLevelDiamonds(this.LevelNum);
            block4: for (int idx = 0; idx < this.Playfield.length; ++idx) {
                switch (this.Playfield[idx]) {
                    case 'D': {
                        this.PlayerOffset = idx;
                        continue block4;
                    }
                    case 'M': {
                        this.LavaTimer = 1;
                        continue block4;
                    }
                }
            }
        }
        this.InternalState = 3;
    }

    private final void MovePlayer() {
        int val;
        boolean bscroll;
        int chr;
        int dy;
        if (this.RestartDelay > 0) {
            return;
        }
        int LevelCol = 28;
        this.PlayerRel.x = this.PlayerOffset % LevelCol;
        this.PlayerRel.y = this.PlayerOffset / LevelCol;
        this.Difference.x = this.StylusPos.x - (this.PlayerRel.x - this.ScrollOffset.x);
        this.Difference.y = this.StylusPos.y - (this.PlayerRel.y - this.ScrollOffset.y);
        int dx = this.Difference.x < 0 ? -this.Difference.x : this.Difference.x;
        if (dx > (dy = this.Difference.y < 0 ? -this.Difference.y : this.Difference.y)) {
            this.Difference.y = 0;
        }
        if (dy > dx) {
            this.Difference.x = 0;
        }
        if (this.PlayerDirection.x == 0) {
            if (this.PlayerDirection.y > 0 || this.Difference.y >= 1 && this.Difference.y <= 3) {
                chr = this.Playfield[this.PlayerOffset + LevelCol];
                this.Playfield[this.PlayerOffset] = 72;
                if (this.PlayerDirection.y < 0) {
                    this.PlayerDirection.y = this.PlayerFine.y < 0 ? 2 : 1;
                } else if (this.PlayerDirection.y != 2) {
                    this.PlayerDirection.y = 1;
                }
                if (chr == 84 && this.UseKeyOnDoor()) {
                    this.Playfield[this.PlayerOffset + LevelCol] = 71;
                }
                if (this.PlayerDirection.y == 2 || chr == 66 || chr == 70 || chr == 71 || chr == 83) {
                    this.PlayerFine.y += this.PlayerSpdY;
                    ++this.PlayerAnimIdex;
                    bscroll = false;
                    val = this.BobsPerCol + (this.SoftScrolling ? 0 : 1);
                    if (this.ScrollOffset.y <= 28 - val && this.PlayerRel.y - this.ScrollOffset.y > (val >> 1) - 1) {
                        bscroll = true;
                        this.ScrollFine.y += this.PlayerSpdY;
                        if (this.ScrollFine.y >= this.BlockSize) {
                            this.ScrollFine.y = 0;
                            if (this.PlayerDirection.y == 2) {
                                ++this.ScrollOffset.y;
                            }
                        }
                    }
                    if (this.PlayerFine.y >= this.BlockSize) {
                        this.PlayerFine.y = 0;
                        switch (chr) {
                            case 70: {
                                this.DiamondCollected();
                                break;
                            }
                            case 83: {
                                this.KeyCollected();
                                break;
                            }
                        }
                        this.Playfield[this.PlayerOffset] = 71;
                        this.PlayerOffset += LevelCol;
                        this.Playfield[this.PlayerOffset] = 72;
                        if (bscroll) {
                            ++this.ScrollOffset.y;
                        }
                        this.PlayerDirection.y = 0;
                    }
                    if (this.PlayerDirection.y == 2 && this.PlayerFine.y == 0) {
                        this.PlayerDirection.y = 0;
                    }
                } else {
                    this.PlayerDirection.y = 0;
                }
            }
            if (this.PlayerDirection.y < 0 || this.Difference.y <= -1 && this.Difference.y >= -3) {
                chr = this.Playfield[this.PlayerOffset - LevelCol] & 0x7F;
                this.Playfield[this.PlayerOffset] = 72;
                if (this.PlayerDirection.y > 0) {
                    this.PlayerDirection.y = this.PlayerFine.y > 0 ? -2 : -1;
                } else if (this.PlayerDirection.y != -2) {
                    this.PlayerDirection.y = -1;
                }
                if (chr == 84 && this.UseKeyOnDoor()) {
                    this.Playfield[this.PlayerOffset - LevelCol] = 71;
                }
                if (this.PlayerDirection.y == -2 || chr == 66 || chr == 70 || chr == 71 || chr == 83) {
                    this.PlayerFine.y -= this.PlayerSpdY;
                    ++this.PlayerAnimIdex;
                    if (this.ScrollOffset.y > 0 && this.PlayerRel.y - this.ScrollOffset.y < (this.BobsPerCol >> 1) + 1 && this.ScrollFine.y == 0 && this.PlayerDirection.y == -1) {
                        --this.ScrollOffset.y;
                        this.ScrollFine.y = this.BlockSize;
                    }
                    if (this.ScrollFine.y > 0) {
                        this.ScrollFine.y -= this.PlayerSpdY;
                    }
                    if (this.PlayerFine.y <= -this.BlockSize) {
                        this.PlayerFine.y = 0;
                        if (this.PlayerDirection.y == -1) {
                            switch (chr) {
                                case 70: {
                                    this.DiamondCollected();
                                    break;
                                }
                                case 83: {
                                    this.KeyCollected();
                                    break;
                                }
                            }
                            this.Playfield[this.PlayerOffset] = 71;
                            this.PlayerOffset -= LevelCol;
                            this.Playfield[this.PlayerOffset] = 72;
                        }
                        this.PlayerDirection.y = 0;
                    }
                    if (this.PlayerDirection.y == -2 && this.PlayerFine.y == 0) {
                        this.PlayerDirection.y = 0;
                    }
                } else {
                    this.PlayerDirection.y = 0;
                }
            }
        }
        if (this.PlayerDirection.y == 0) {
            if (this.PlayerDirection.x < 0 || this.Difference.x <= -1 && this.Difference.x >= -3) {
                chr = this.Playfield[this.PlayerOffset - 1] & 0x7F;
                this.Playfield[this.PlayerOffset] = 69;
                if (this.PlayerDirection.x > 0) {
                    this.PlayerDirection.x = this.PlayerFine.x > 0 ? -2 : -1;
                } else if (this.PlayerDirection.x != -2) {
                    this.PlayerDirection.x = -1;
                }
                if (chr == 84 && this.UseKeyOnDoor()) {
                    this.Playfield[this.PlayerOffset - 1] = 71;
                }
                if (chr == 65 && this.Playfield[this.PlayerOffset - 2] == 'G') {
                    if (this.SoftScrolling) {
                        this.Playfield[this.PlayerOffset - 2] = 577;
                        this.Playfield[this.PlayerOffset - 1] = 839;
                    } else {
                        this.Playfield[this.PlayerOffset - 2] = 65;
                        this.Playfield[this.PlayerOffset - 1] = 71;
                    }
                    chr = 71;
                }
                if (this.PlayerDirection.x == -2 || chr == 66 || chr == 70 || chr == 71 || chr == 83) {
                    this.PlayerFine.x -= this.PlayerSpdX;
                    ++this.PlayerAnimIdex;
                    if (this.ScrollOffset.x > 0 && this.PlayerRel.x - this.ScrollOffset.x < (this.BobsPerRow >> 1) + 1 && this.ScrollFine.x == 0 && this.PlayerDirection.x == -1) {
                        --this.ScrollOffset.x;
                        this.ScrollFine.x = this.BlockSize;
                    }
                    if (this.ScrollFine.x > 0) {
                        this.ScrollFine.x -= this.PlayerSpdX;
                    }
                    if (this.PlayerFine.x <= -this.BlockSize) {
                        this.PlayerFine.x = 0;
                        if (this.PlayerDirection.x == -1) {
                            switch (chr) {
                                case 70: {
                                    this.DiamondCollected();
                                    break;
                                }
                                case 83: {
                                    this.KeyCollected();
                                    break;
                                }
                            }
                            this.Playfield[this.PlayerOffset] = 71;
                            --this.PlayerOffset;
                            this.Playfield[this.PlayerOffset] = 69;
                        }
                        this.PlayerDirection.x = 0;
                    }
                    if (this.PlayerDirection.x == -2 && this.PlayerFine.x == 0) {
                        this.PlayerDirection.x = 0;
                    }
                } else {
                    this.PlayerDirection.x = 0;
                }
            }
            if (this.PlayerDirection.x > 0 || this.Difference.x >= 1 && this.Difference.x <= 3) {
                chr = this.Playfield[this.PlayerOffset + 1] & 0x7F;
                this.Playfield[this.PlayerOffset] = 68;
                if (this.PlayerDirection.x < 0) {
                    this.PlayerDirection.x = this.PlayerFine.x < 0 ? 2 : 1;
                } else if (this.PlayerDirection.x != 2) {
                    this.PlayerDirection.x = 1;
                }
                if (chr == 84 && this.UseKeyOnDoor()) {
                    this.Playfield[this.PlayerOffset + 1] = 71;
                }
                if (chr == 65 && this.Playfield[this.PlayerOffset + 2] == 'G') {
                    if (this.SoftScrolling) {
                        this.Playfield[this.PlayerOffset + 2] = 1089;
                        this.Playfield[this.PlayerOffset + 1] = 839;
                    } else {
                        this.Playfield[this.PlayerOffset + 2] = 65;
                        this.Playfield[this.PlayerOffset + 1] = 71;
                    }
                    chr = 71;
                }
                if (this.PlayerDirection.x == 2 || chr == 66 || chr == 70 || chr == 71 || chr == 83) {
                    this.PlayerFine.x += this.PlayerSpdX;
                    ++this.PlayerAnimIdex;
                    bscroll = false;
                    val = this.BobsPerRow + (this.SoftScrolling ? 0 : 1);
                    if (this.ScrollOffset.x <= LevelCol - val && this.PlayerRel.x - this.ScrollOffset.x >= val >> 1) {
                        bscroll = true;
                        this.ScrollFine.x += this.PlayerSpdX;
                        if (this.ScrollFine.x >= this.BlockSize) {
                            this.ScrollFine.x = 0;
                            if (this.PlayerDirection.x == 2) {
                                ++this.ScrollOffset.x;
                            }
                        }
                    }
                    if (this.PlayerFine.x >= this.BlockSize) {
                        this.PlayerFine.x = 0;
                        switch (chr) {
                            case 70: {
                                this.DiamondCollected();
                                break;
                            }
                            case 83: {
                                this.KeyCollected();
                                break;
                            }
                        }
                        this.Playfield[this.PlayerOffset] = 71;
                        ++this.PlayerOffset;
                        this.Playfield[this.PlayerOffset] = 68;
                        if (bscroll) {
                            ++this.ScrollOffset.x;
                        }
                        this.PlayerDirection.x = 0;
                    }
                    if (this.PlayerDirection.x == 2 && this.PlayerFine.x == 0) {
                        this.PlayerDirection.x = 0;
                    }
                } else {
                    this.PlayerDirection.x = 0;
                }
            }
        }
        if (this.PlayerDirection.x == 0) {
            this.PlayerFine.x = 0;
            this.ScrollFine.x = 0;
        }
        if (this.PlayerDirection.y == 0) {
            this.PlayerFine.y = 0;
            this.ScrollFine.y = 0;
        }
        this.Difference.x = 0;
        this.Difference.y = 0;
        this.StylusPos.x = this.PlayerOffset % LevelCol - this.ScrollOffset.x;
        this.StylusPos.y = this.PlayerOffset / LevelCol - this.ScrollOffset.y;
    }

    private final void MoveMonster() {
        char ochr;
        int cindex;
        int iLen;
        int LevelCol = 28;
        char[] Plf = this.Playfield;
        if ((this.BlinkCounter & 1) != 0) {
            char nchr;
            int cbase;
            iLen = Plf.length - LevelCol - 1;
            block14: for (cindex = LevelCol + 1; cindex < iLen; ++cindex) {
                ochr = Plf[cindex];
                switch (ochr & 0xFF) {
                    case 82: {
                        Plf[cindex] = 77;
                        continue block14;
                    }
                    case 77: {
                        Plf[cindex] = 82;
                        if (this.LavaTimer == 0 || --this.LavaTimer != 0) continue block14;
                        cbase = cindex - LavaTable[this.LavaIndex];
                        nchr = (char)(Plf[cbase] & 0xFF);
                        if (nchr != 'C' && nchr != 'I') {
                            Plf[cbase] = 77;
                        }
                        if (++this.LavaIndex >= LavaTable.length) {
                            this.LavaIndex = 0;
                        }
                        this.LavaTimer = 35000 / (200 + LavaTable[this.LavaIndex]);
                        continue block14;
                    }
                    case 74: {
                        if ((ochr & 0xF00) != 0) {
                            int n = cindex;
                            Plf[n] = (char)(Plf[n] & 0x10FF);
                            continue block14;
                        }
                        int n = cindex;
                        Plf[n] = (char)(Plf[n] & 0xFF);
                        cbase = cindex - LevelCol;
                        nchr = (char)(Plf[cbase] & 0xFF);
                        if (nchr == 'M' || nchr == 'R') {
                            Plf[cindex] = 70;
                            continue block14;
                        }
                        if (nchr == 'G' && (ochr & 0x1000) == 0) {
                            Plf[cindex] = 839;
                            if ((Plf[cbase - 1] & 0xFF) == 71) {
                                Plf[cbase] = 88;
                                continue block14;
                            }
                            Plf[cbase] = 1098;
                            continue block14;
                        }
                        if ((Plf[cindex + 1] & 0xFF) == 71) {
                            Plf[cindex] = 839;
                            Plf[cindex + 1] = 586;
                            ++cindex;
                            continue block14;
                        }
                        Plf[cindex] = 75;
                        continue block14;
                    }
                }
            }
            block15: for (cindex = Plf.length - LevelCol - 2; cindex > LevelCol; --cindex) {
                ochr = Plf[cindex];
                switch (ochr & 0xFF) {
                    case 77: {
                        if (this.LavaTimer == 0 || --this.LavaTimer != 0) continue block15;
                        cbase = cindex + LavaTable[this.LavaIndex];
                        nchr = (char)(Plf[cbase] & 0xFF);
                        if (nchr != 'C' && nchr != 'I') {
                            Plf[cbase] = 77;
                        }
                        if (++this.LavaIndex >= LavaTable.length) {
                            this.LavaIndex = 0;
                        }
                        this.LavaTimer = 35000 / (200 + LavaTable[this.LavaIndex]);
                        continue block15;
                    }
                    case 75: {
                        if ((ochr & 0xF00) != 0) {
                            int n = cindex;
                            Plf[n] = (char)(Plf[n] & 0x10FF);
                            continue block15;
                        }
                        int n = cindex;
                        Plf[n] = (char)(Plf[n] & 0xFF);
                        cbase = cindex + LevelCol;
                        nchr = (char)(Plf[cbase] & 0xFF);
                        if (nchr == 'M' || nchr == 'R') {
                            Plf[cindex] = 70;
                            continue block15;
                        }
                        if (nchr == 'G' && (ochr & 0x1000) == 0) {
                            Plf[cindex] = 839;
                            if ((Plf[cbase + 1] & 0xFF) == 71) {
                                Plf[cbase] = 89;
                                continue block15;
                            }
                            Plf[cbase] = 2123;
                            continue block15;
                        }
                        if ((Plf[cindex - 1] & 0xFF) == 71) {
                            Plf[cindex] = 839;
                            Plf[cindex - 1] = 331;
                            --cindex;
                            continue block15;
                        }
                        Plf[cindex] = 74;
                        continue block15;
                    }
                }
            }
        }
        iLen = Plf.length - LevelCol - 1;
        block16: for (cindex = LevelCol + 1; cindex < iLen; ++cindex) {
            ochr = Plf[cindex];
            switch (ochr & 0xFF) {
                case 88: {
                    Plf[cindex] = 5195;
                    continue block16;
                }
                case 89: {
                    Plf[cindex] = 6218;
                    continue block16;
                }
                case 65: {
                    if ((ochr & 0xFE00) == 0) continue block16;
                    Plf[cindex] = (char)(ochr & 0x1FF | (ochr & 0xFE00) << 4);
                    continue block16;
                }
            }
        }
    }

    private final void CheckCollision() {
        boolean Hunted = false;
        char chr1 = this.Playfield[this.PlayerOffset];
        if (chr1 == 'M' || chr1 == 'R') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset + 1]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset - 1]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset + 28]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if ((chr1 = this.Playfield[this.PlayerOffset - 28]) == 'J' || chr1 == 'K') {
            Hunted = true;
        }
        if (chr1 == 'P') {
            this.NextLevel();
            return;
        }
        if (Hunted) {
            this.Playfield[this.PlayerOffset] = 76;
            this.LoseLive();
        }
    }

    public final void ReStartLevel(boolean ForeRestart) {
        this.ScrollOffset.x = 0;
        this.ScrollOffset.y = 0;
        this.OldStylusPos.x = 0;
        this.OldStylusPos.y = 0;
        this.PlayerRel.x = 0;
        this.PlayerRel.y = 0;
        this.ResetSnapShotTable();
        JoyPad.ResetAllKeys();
        if (this.PlayerLives == 0 || ForeRestart) {
            this.ResetGameVars();
        }
        this.PrepareLevel();
    }

    public final void StylusRelease() {
        this.OldStylusPos.x = (this.PlayerOffset % 28 - this.ScrollOffset.x << this.BlockShift) + (this.BlockSize >> 1);
        this.OldStylusPos.y = (this.PlayerOffset / 28 - this.ScrollOffset.y << this.BlockShift) + (this.BlockSize >> 1);
    }

    public final void StylusMove(int StylusX, int StylusY) {
        if (this.InternalState == 3 && this.RestartDelay == 0) {
            this.StylusPos.x = StylusX - this.LeftBorder;
            this.StylusPos.y = StylusY - this.TopBorder;
            if (this.StylusPos.x > 0 && this.StylusPos.x < this.PlayfieldWidth - this.LeftBorder && this.StylusPos.y > 0 && this.StylusPos.y < this.PlayfieldHeight - this.TopBorder) {
                int StylusXDifference = this.OldStylusPos.x - this.StylusPos.x;
                int StylusYDifference = this.OldStylusPos.y - this.StylusPos.y;
                if (StylusXDifference > this.BlockSize || StylusXDifference < -this.BlockSize || StylusYDifference > this.BlockSize || StylusYDifference < -this.BlockSize) {
                    this.OldStylusPos.x = this.StylusPos.x;
                    this.OldStylusPos.y = this.StylusPos.y;
                    this.StylusPos.x /= this.BlockSize;
                    this.StylusPos.y /= this.BlockSize;
                    int PlayerAbsPosX = this.PlayerRel.x - this.ScrollOffset.x;
                    int PlayerAbsPosY = this.PlayerRel.y - this.ScrollOffset.y;
                    if (StylusXDifference > 0 && this.StylusPos.x <= PlayerAbsPosX || StylusXDifference < 0 && this.StylusPos.x >= PlayerAbsPosX || StylusYDifference > 0 && this.StylusPos.y <= PlayerAbsPosY || StylusYDifference < 0 && this.StylusPos.y >= PlayerAbsPosY) {
                        if (StylusXDifference > 8 && this.StylusPos.x <= PlayerAbsPosX || StylusXDifference < -8 && this.StylusPos.x >= PlayerAbsPosX) {
                            this.StylusPos.y = this.PlayerOffset / 28 - this.ScrollOffset.y;
                        } else if (StylusYDifference > 8 && this.StylusPos.y <= PlayerAbsPosY || StylusYDifference < -8 && this.StylusPos.y >= PlayerAbsPosY) {
                            this.StylusPos.x = this.PlayerOffset % 28 - this.ScrollOffset.x;
                        }
                        if (this.PlayerOffset != this.ScrollOffset.x + this.StylusPos.x + (this.ScrollOffset.y + this.StylusPos.y) * 28) {
                            this.MovePlayer();
                        }
                    }
                }
            }
        }
    }

    private final void DrawFinalInformation(Graphics gfx) {
        int i;
        int[] LTable = new int[]{20, 50, 70};
        String[] STable = new String[]{"*Gratulation*", "Mission", "completed!"};
        gfx.setColor(0);
        if (DiggerGame.GameFont != null) {
            gfx.setFont(DiggerGame.GameFont);
        }
        int c = this.PlayfieldWidth - this.LeftBorder;
        for (i = this.TopBorder + this.PlayfieldHeight - 2; i > this.TopBorder; i -= 2) {
            gfx.drawLine(this.LeftBorder, i, c, i);
        }
        c = this.PlayfieldHeight - this.TopBorder;
        for (i = this.LeftBorder + this.PlayfieldWidth - 2; i > this.LeftBorder; i -= 2) {
            gfx.drawLine(i, this.TopBorder, i, c);
        }
        gfx.setColor(255, 255, 255);
        c = this.PlayfieldWidth >> 1;
        for (i = 0; i < LTable.length; ++i) {
            gfx.drawString(STable[i], c, this.PlayfieldHeight * LTable[i] / 100, 17);
        }
    }

    public final void ResetGameVars() {
        this.GlenzIndex = 0;
        this.FlickerMode = 0;
        this.Diamonds = 0;
        this.LevelNum = 0;
        this.LavaIndex = 0;
        this.LavaTimer = 0;
        this.PlayerLives = 5;
        this.RestartDelay = 0;
        this.KeyFound = 0;
        this.BlinkCounter = 1;
        this.BorderVal = -1;
        JoyPad.ResetAllKeys();
    }

    public final void ResetSnapShotTable() {
        char[][] snap = this.SnapShot;
        int bc = this.BobsPerCol;
        int br = this.BobsPerRow;
        if (snap != null) {
            for (int yindex = 0; yindex < bc; ++yindex) {
                for (int xindex = 0; xindex < br; ++xindex) {
                    snap[xindex][yindex] = 120;
                }
            }
        }
    }

    public final void RestoreAllNotification() {
        this.ResetSnapShotTable();
        JoyPad.ResetAllKeys();
        this.OldStylusPos.x = 0;
        this.OldStylusPos.y = 0;
    }

    public final void NextLevel() {
        if (this.LevelNum >= DiggerLevels.GetLevelCount() - 1) {
            this.InternalState = 5;
        } else {
            ++this.LevelNum;
            this.ScrollOffset.x = 0;
            this.ScrollOffset.y = 0;
            this.PrepareLevel();
        }
    }

    public final void sizeChanged(Image dImage, Image dSymbols, Image dOver, int dWidth, int dHeight, int dOverHeight, int pBlkSize, int pXSymSize, int pYSymSize) {
        this.BlockImage = dImage;
        this.SymbImage = dSymbols;
        this.OverImage = dOver;
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.OverHeight = dOverHeight;
        this.BlockSize = pBlkSize;
        this.BlockShift = this.BlockSize == 64 ? 6 : (this.BlockSize == 32 ? 5 : 4);
        this.SymbXSize = pXSymSize;
        this.SymbYSize = pYSymSize;
        this.BobsPerRow = dWidth >> this.BlockShift;
        if (this.BobsPerRow > 28) {
            this.BobsPerRow = 28;
        }
        this.BobsPerCol = dHeight >> this.BlockShift;
        if (this.BobsPerCol > 28) {
            this.BobsPerCol = 28;
        }
        int i = this.BobsPerRow << this.BlockShift;
        this.LeftBorder = dWidth - i >> 1;
        this.RightBorder = dWidth - (this.LeftBorder + i);
        i = this.BobsPerCol << this.BlockShift;
        this.TopBorder = dHeight - i >> 1;
        this.BottomBorder = dHeight - (this.TopBorder + i);
        this.SnapShot = new char[this.BobsPerRow][this.BobsPerCol];
        this.ResetSnapShotTable();
        if (this.ScrollOffset.x + this.BobsPerRow > 28) {
            this.ScrollOffset.x = 28 - this.BobsPerRow;
        }
        if (this.ScrollOffset.y + this.BobsPerCol > 28) {
            this.ScrollOffset.y = 28 - this.BobsPerCol;
        }
    }

    public void SetClrBorder() {
        this.BorderVal = -1;
    }

    private final class SimplePoint {
        int x = 0;
        int y = 0;

        SimplePoint() {
        }
    }
}

