/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import overthehill.madmaze.DungeonCube;
import overthehill.madmaze.DungeonWall;

public final class DungeonArrow
extends DungeonWall {
    int ArrowDirection;
    int ArrowRed = 255;
    int ArrowGreen = 128;
    int ArrowBlue = 6;
    int ArrowAnim = 32;
    int ArrowColor = 0;
    int ShadeRed = 128;
    int ShadeGreen = 96;
    int ShadeBlue = 255;
    int ShadeColor = 0;

    public DungeonArrow(int direction) {
        this.ArrowDirection = direction;
    }

    public void SetPosition(int x, int y) {
        super.SetPosition(x, y);
        this.ArrowColor = this.ArrowRed * this.ShapeBrightness << 8 & 0xFF0000 | this.ArrowGreen * this.ShapeBrightness & 0xFF00 | this.ArrowBlue * this.ShapeBrightness >> 8;
        this.ShadeColor = this.ShadeRed * this.ShapeBrightness << 8 & 0xFF0000 | this.ShadeGreen * this.ShapeBrightness & 0xFF00 | this.ShadeBlue * this.ShapeBrightness >> 8;
    }

    void PaintFront(int lftcube, int rgtcube) {
        int twidth;
        int xpos;
        int wallwdhalf = this.WallWidth >> 1;
        int wallwdquart = this.WallWidth >> 2;
        int theight = this.WallHeight >> 2;
        int tpos = this.TopPos + (this.WallHeight >> 1);
        super.PaintFront(lftcube, rgtcube);
        if (this.ArrowDirection < 0) {
            xpos = this.LeftPos + wallwdquart;
            twidth = xpos + wallwdquart;
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            this.GfxObj.drawLine(++xpos, tpos - 1, ++twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(++xpos, tpos - 1, ++twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
            xpos = this.LeftPos + wallwdhalf;
            twidth = xpos + wallwdquart;
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            this.GfxObj.drawLine(++xpos, tpos - 1, ++twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(++xpos, tpos - 1, ++twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
        }
        if (this.ArrowDirection > 0) {
            xpos = this.LeftPos + (this.WallWidth * 3 >> 2);
            twidth = xpos - wallwdquart;
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            this.GfxObj.drawLine(--xpos, tpos - 1, --twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(--xpos, tpos - 1, --twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
            xpos = this.LeftPos + wallwdhalf;
            twidth = xpos - wallwdquart;
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            this.GfxObj.drawLine(--xpos, tpos - 1, --twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(--xpos, tpos - 1, --twidth, tpos - 1 - theight);
            this.GfxObj.drawLine(xpos, tpos + 1, twidth, tpos + 1 + theight);
        }
    }

    void PaintWallLeft() {
        int twidth;
        int xpos;
        int theight = this.WallHeight / 6;
        int tpos = this.TopPos + (this.WallHeight >> 1);
        super.PaintWallLeft();
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int pwidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int wdquant1 = pwidth >> 4;
        int wdquant2 = pwidth >> 3;
        if (this.ArrowDirection > 0) {
            xpos = this.LeftPos - wdquant1;
            twidth = xpos - wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos - theight);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            xpos = this.LeftPos - wdquant2;
            twidth = xpos - wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos - theight);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
        }
        if (this.ArrowDirection < 0) {
            xpos = this.LeftPos - (pwidth >> 3);
            twidth = xpos + wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos - theight);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            xpos = this.LeftPos - (pwidth >> 3) - wdquant1;
            twidth = xpos + wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos - theight);
            this.GfxObj.drawLine(xpos - 1, tpos, twidth - 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
        }
    }

    void PaintWallRight() {
        int twidth;
        int xpos;
        int theight = this.WallHeight / 6;
        int tpos = this.TopPos + (this.WallHeight >> 1);
        super.PaintWallRight();
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int pwidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int wdquant1 = pwidth >> 4;
        int wdquant2 = pwidth >> 3;
        if (this.ArrowDirection < 0) {
            xpos = this.LeftPos + this.WallWidth + wdquant1;
            twidth = xpos + wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos - theight);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            xpos = this.LeftPos + this.WallWidth + wdquant2;
            twidth = xpos + wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos - theight);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
        }
        if (this.ArrowDirection > 0) {
            xpos = this.LeftPos + this.WallWidth + wdquant2;
            twidth = xpos - wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos - theight);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
            xpos = this.LeftPos + this.WallWidth + wdquant2 + wdquant1;
            twidth = xpos - wdquant1;
            this.GfxObj.setColor(this.ShadeColor);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos - theight);
            this.GfxObj.drawLine(xpos + 1, tpos, twidth + 1, tpos + theight);
            this.GfxObj.setColor(this.ArrowColor);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos - theight);
            this.GfxObj.drawLine(xpos, tpos, twidth, tpos + theight);
        }
    }

    void AnimateObj() {
        this.ArrowGreen += this.ArrowAnim;
        this.ShadeGreen += this.ArrowAnim >> 1;
        if (this.ArrowGreen > 255) {
            this.ArrowAnim = -this.ArrowAnim;
            this.ArrowGreen += this.ArrowAnim;
            this.ShadeGreen += this.ArrowAnim >> 1;
        }
        if (this.ArrowGreen < 0) {
            this.ArrowAnim = -this.ArrowAnim;
            this.ArrowGreen += this.ArrowAnim;
            this.ShadeGreen += this.ArrowAnim >> 1;
        }
        this.ArrowBlue = this.ArrowGreen >> 2;
        this.ShadeRed = 64 + (this.ArrowGreen >> 1);
    }
}

