/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import overthehill.madmaze.DungeonCube;

public final class DungeonGate
extends DungeonCube {
    public DungeonGate() {
        this.ShapeRed = 255;
        this.ShapeGreen = 255;
        this.ShapeBlue = 255;
    }

    public void SetPosition(int x, int y) {
        this.xp = x;
        this.yp = y;
        int vzoom = this.yp * DungeonCube.Perspective;
        int pfactor = 100 - (this.yp + 1) * DungeonCube.ViewThrought;
        this.WallWidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        this.WallHeight = DungeonCube.Height + DungeonCube.Height * vzoom / pfactor;
        this.LeftPos = (DungeonCube.Width - this.WallWidth * this.MaxVisible >> 1) + (this.xp + 1) * this.WallWidth;
        this.TopPos = DungeonCube.Height - this.WallHeight >> 1;
        this.ShapeBrightness = 256 + (vzoom << 6) / pfactor - 1;
        if (this.ShapeBrightness > 255) {
            this.ShapeBrightness = 255;
        }
        this.FrameBrigthness = this.ShapeBrightness * 80 / 100;
        if (this.FrameBrigthness > 255) {
            this.FrameBrigthness = 255;
        }
        this.ShapeColor = this.ShapeRed * this.ShapeBrightness << 8 & 0xFF0000 | this.ShapeGreen * this.ShapeBrightness & 0xFF00 | this.ShapeBlue * this.ShapeBrightness >> 8;
        this.FrameColor = this.ShapeRed * this.FrameBrigthness << 8 & 0xFF0000 | this.ShapeGreen * this.FrameBrigthness & 0xFF00 | this.ShapeBlue * this.FrameBrigthness >> 8;
    }

    void PaintFront(int lftcube, int rgtcube) {
        int lpos = this.LeftPos;
        int tpos = this.TopPos;
        int width = this.WallWidth;
        int height = this.WallHeight;
        int sizex = this.WallWidth >> 4;
        int sizey = this.WallHeight >> 4;
        for (int i = 0; i < 8; ++i) {
            this.GfxObj.setColor(this.ShapeColor);
            this.ShapeColor = this.ShapeColor > 0x202020 ? (this.ShapeColor -= 0x202020) : 0;
            if (i < 5) {
                this.GfxObj.fillRect(lpos + 1, tpos + 1, width - 1, sizey + 1);
                this.GfxObj.fillRect(lpos + 1, tpos + 1 + height - (sizey + 1), width - 1, sizey + 2);
                this.GfxObj.fillRect(lpos + 1, tpos + 1, sizex + 1, height);
                this.GfxObj.fillRect(lpos + 1 + width - (sizex + 1), tpos + 1, sizex + 2, height);
            } else {
                this.GfxObj.fillRect(lpos + 1, tpos + 1, width - 1, height - 1);
            }
            this.GfxObj.setColor(this.FrameColor);
            this.FrameColor = this.FrameColor > 0x202020 ? (this.FrameColor -= 0x202020) : 0;
            this.GfxObj.drawRect(lpos, tpos, width, height - 1);
            this.GfxObj.drawLine(lpos, tpos, lpos + sizex, tpos + sizey);
            this.GfxObj.drawLine(lpos + width, tpos, lpos + width - sizex, tpos + sizey);
            this.GfxObj.drawLine(lpos, tpos + height, lpos + sizex, tpos + height - sizey);
            this.GfxObj.drawLine(lpos + width, tpos + height, lpos + width - sizex, tpos + height - sizey);
            lpos += sizex;
            tpos += sizey;
            width -= sizex << 1;
            height -= sizey << 1;
        }
    }

    void PaintWallLeft() {
        int lpos = this.LeftPos;
        int tpos = this.TopPos;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = DungeonCube.Height + DungeonCube.Height * vzoom / pfactor;
        int rpos = (DungeonCube.Width - twidth * this.MaxVisible >> 1) + twidth + this.xp * twidth;
        int bpos = DungeonCube.Height - theight >> 1;
        int i = theight;
        vzoom = this.ShapeBlue + i;
        if (vzoom > 255) {
            vzoom = 255;
        }
        int cbcolor = (this.ShapeRed * this.ShapeBrightness << 8 & 0xFF0000) + (this.ShapeGreen * this.ShapeBrightness & 0xFF00);
        pfactor = cbcolor + (vzoom * this.ShapeBrightness >> 8 & 0xFF);
        this.GfxObj.setColor(pfactor);
        while (--i > 0) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos++);
        }
        i = this.TopPos + this.WallHeight;
        while (tpos < i) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos);
        }
        this.GfxObj.setColor(this.FrameColor);
        this.GfxObj.drawLine(lpos, tpos -= this.WallHeight, rpos, bpos -= theight);
        this.GfxObj.drawLine(lpos, tpos + this.WallHeight, rpos, bpos + theight);
        this.GfxObj.drawLine(rpos, bpos, rpos, bpos + theight);
    }

    void PaintWallRight() {
        int lpos = this.LeftPos + this.WallWidth;
        int tpos = this.TopPos;
        int vzoom = (this.yp - 1) * DungeonCube.Perspective;
        int pfactor = 100 - this.yp * DungeonCube.ViewThrought;
        int twidth = DungeonCube.Width + DungeonCube.Width * vzoom / pfactor;
        int theight = DungeonCube.Height + DungeonCube.Height * vzoom / pfactor;
        int rpos = (DungeonCube.Width - twidth * this.MaxVisible >> 1) + (1 + (this.xp + 1)) * twidth;
        int bpos = DungeonCube.Height - theight >> 1;
        int i = theight;
        vzoom = this.ShapeBlue + i;
        if (vzoom > 255) {
            vzoom = 255;
        }
        int cbcolor = (this.ShapeRed * this.ShapeBrightness << 8 & 0xFF0000) + (this.ShapeGreen * this.ShapeBrightness & 0xFF00);
        pfactor = cbcolor + (vzoom * this.ShapeBrightness >> 8 & 0xFF);
        this.GfxObj.setColor(pfactor);
        while (--i > 0) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos++);
        }
        i = this.TopPos + this.WallHeight;
        while (tpos < i) {
            this.GfxObj.drawLine(lpos, tpos++, rpos, bpos);
        }
        this.GfxObj.setColor(this.FrameColor);
        this.GfxObj.drawLine(lpos, tpos -= this.WallHeight, rpos, bpos -= theight);
        this.GfxObj.drawLine(lpos, tpos + this.WallHeight, rpos, bpos + theight);
        this.GfxObj.drawLine(rpos, bpos, rpos, bpos + theight);
    }
}

