/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import overthehill.madmaze.DungeonLevels;
import overthehill.madmaze.DungeonMain;
import overthehill.madmaze.DungeonPlayfield;
import overthehill.madmaze.DungeonPreview;
import overthehill.madmaze.DungeonStrings;
import overthehill.madmaze.Hiscore;
import overthehill.madmaze.JoyPad;
import overthehill.madmaze.Levelcode;
import overthehill.madmaze.LineVector;
import overthehill.madmaze.MadMaze;
import overthehill.madmaze.SoundPlayer;

public final class DungeonGame {
    private Random RandomObj;
    private Hiscore GameHiscore;
    private Levelcode GameLevelcode;
    private boolean ColoredDisplay;
    private long OverMovePause;
    private int TitleHeight;
    private int TitleSpeed;
    private int TitlePosition;
    private int OverPosition;
    private int OverFlightIn;
    private int OverFlightWait;
    private DungeonPlayfield GamePlayfield;
    private DungeonMain BaseCanvas;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private int MadMazeColor;
    private int FontHeight;
    private int WallImageHeight;
    private int IntroTextCnt;
    private int IntroTextColor;
    private int IntroTextIdx;
    private int[] AnimStarX;
    private int[] AnimStarY;
    private int[] AnimStarZ;
    private String GameImageRootPath;
    private String GameSoundRootPath;
    private int X_Angle;
    private int Y_Angle;
    private int Z_Angle;
    private int ObjZoom;
    private int MaxObjZoom;
    private int ObjRGB;
    public Font GameFont;
    private static boolean GameSoundFlag = false;
    private static boolean AudioAvailableFlag = false;
    private static LineVector VectorObj = new LineVector();
    private static SoundPlayer GameSound;
    public static final int WelcomeTextCount;
    public static final int EndOfTextCount;
    public static Image TitleImage;
    public static Image GameImage;
    public static Image OverImage;
    public static Image HiscoreImage;
    public static Image WallImage1;
    public static Image WallImage2;
    public static Image LevelcodeImage;
    public static Image AuthorImage;
    public static Image EndOfGameImage;
    public static Image BonusIconImage;
    public static boolean GameFinallyPassed;

    public DungeonGame(DungeonMain rCanvas, int dWidth, int dHeight, boolean ColoredFlag) {
        this.BaseCanvas = rCanvas;
        this.ColoredDisplay = ColoredFlag;
        this.InitGame(dWidth, dHeight);
    }

    public void InitGame(int dWidth, int dHeight) {
        short LargeInfo;
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.FontHeight = 0;
        this.MadMazeColor = 0;
        this.IntroTextCnt = 0;
        this.IntroTextColor = 0;
        this.IntroTextIdx = 0;
        this.X_Angle = 0;
        this.Y_Angle = 0;
        this.Z_Angle = 0;
        this.ObjZoom = 0;
        this.MaxObjZoom = 0;
        this.ObjRGB = 0;
        this.GameImageRootPath = "/overthehill/madmaze/images/";
        this.GameSoundRootPath = "/overthehill/madmaze/sounds/";
        try {
            if (dWidth >= 320 && dHeight >= 256) {
                this.GameImageRootPath = this.GameImageRootPath + "largest/";
                LargeInfo = 1;
            } else if (dWidth >= 176 && dHeight >= 128) {
                this.GameImageRootPath = this.GameImageRootPath + "large/";
                LargeInfo = 2;
            } else {
                this.GameImageRootPath = this.GameImageRootPath + "small/";
                LargeInfo = 0;
            }
            TitleImage = Image.createImage((String)(this.GameImageRootPath + "title.png"));
            this.TitleHeight = TitleImage.getHeight();
            this.TitlePosition = -(this.TitleHeight - 1);
            this.TitleSpeed = 16;
            AuthorImage = Image.createImage((String)(this.GameImageRootPath + "copyright.png"));
            GameImage = Image.createImage((String)(this.GameImageRootPath + "game.png"));
            this.OverPosition = 0;
            this.OverFlightIn = 0;
            this.OverFlightWait = 0;
            OverImage = Image.createImage((String)(this.GameImageRootPath + "over.png"));
            HiscoreImage = Image.createImage((String)(this.GameImageRootPath + "hiscore.png"));
            LevelcodeImage = Image.createImage((String)(this.GameImageRootPath + "levelcode.png"));
            BonusIconImage = Image.createImage((String)(this.GameImageRootPath + "bonus.png"));
            WallImage1 = Image.createImage((String)(this.GameImageRootPath + "wall1.png"));
            WallImage2 = Image.createImage((String)(this.GameImageRootPath + "wall2.png"));
            this.WallImageHeight = WallImage1.getHeight();
        }
        catch (IOException e) {
            this.ShowAlert(e.getMessage());
            this.BaseCanvas.DestroyGame();
            return;
        }
        this.RandomObj = new Random();
        this.GameFont = this.PlayfieldHeight < 160 ? null : (this.PlayfieldHeight >= 220 ? Font.getFont((int)0, (int)1, (int)16) : Font.getFont((int)0, (int)0, (int)0));
        DungeonPreview.SetDimension(this.PlayfieldWidth, this.PlayfieldHeight);
        if (GameSound == null) {
            GameSound = new SoundPlayer(this.GameSoundRootPath);
            AudioAvailableFlag = GameSound.Create();
            if (AudioAvailableFlag) {
                GameSoundFlag = true;
            }
            if (this.CheckForManipulation()) {
                this.BaseCanvas.DestroyGame();
            }
        }
        if (this.GamePlayfield != null) {
            this.GamePlayfield.sizeChanged(this.GameFont, this.PlayfieldWidth, this.PlayfieldHeight, LargeInfo, this.ColoredDisplay);
            if (this.GetInternalGameState() == 1) {
                this.InitTitle();
            }
        } else {
            this.GamePlayfield = new DungeonPlayfield(this.GameFont, this.PlayfieldWidth, this.PlayfieldHeight, LargeInfo, this.ColoredDisplay);
            this.InitTitle();
        }
        int i = this.PlayfieldWidth / 80 + 1;
        this.AnimStarX = new int[i];
        this.AnimStarY = new int[i];
        this.AnimStarZ = new int[i];
        for (i = 0; i < this.AnimStarZ.length; ++i) {
            this.AnimStarX[i] = this.GetRandomNumber(this.PlayfieldWidth);
            this.AnimStarY[i] = this.GetRandomNumber(this.PlayfieldHeight);
            this.AnimStarZ[i] = (i << 1) + 2;
        }
        this.GameHiscore = new Hiscore(HiscoreImage, this.PlayfieldWidth, this.PlayfieldHeight, "Mad Maze");
        this.GameLevelcode = new Levelcode(LevelcodeImage, this.PlayfieldWidth, this.PlayfieldHeight, "Mad Maze");
    }

    public final void DestroyCore() {
        GameSound.Destroy();
        this.SetInternalGameState(-1);
    }

    public final void InitTitle() {
        this.TitlePosition = -(this.TitleHeight - 1);
        this.TitleSpeed = 16;
        GameFinallyPassed = false;
        this.IntroTextCnt = 0;
        this.IntroTextColor = 0;
        this.IntroTextIdx = 0;
        this.X_Angle = 0;
        this.Y_Angle = 0;
        this.Z_Angle = 0;
        this.ObjZoom = 0;
        this.ObjRGB = 0;
        this.MaxObjZoom = this.PlayfieldHeight > this.PlayfieldWidth ? 512 * this.PlayfieldWidth / 80 : 512 * this.PlayfieldHeight / 80;
        this.SetInternalGameState(1);
    }

    public final void InitEndOfGame() {
        GameFinallyPassed = true;
        OverImage = null;
        LevelcodeImage = null;
        try {
            EndOfGameImage = Image.createImage((String)(this.GameImageRootPath + "final.png"));
        }
        catch (IOException e) {
            this.BaseCanvas.DestroyGame();
            return;
        }
        this.IntroTextCnt = 0;
        this.IntroTextColor = 0;
        this.IntroTextIdx = 0;
        this.BaseCanvas.removeCommand(DungeonMain.cmdBack);
        this.SetInternalGameState(8);
    }

    public final void InitOver(boolean bCheckRank) {
        this.OverMovePause = System.currentTimeMillis();
        if (GameFinallyPassed) {
            try {
                OverImage = Image.createImage((String)(this.GameImageRootPath + "over.png"));
                LevelcodeImage = Image.createImage((String)(this.GameImageRootPath + "levelcode.png"));
            }
            catch (IOException e) {
                this.BaseCanvas.DestroyGame();
                return;
            }
        }
        this.GameHiscore.ReadHiscore();
        if (bCheckRank) {
            int Score = this.GamePlayfield.GetScore();
            int Rank = this.GameHiscore.GetRank(Score);
            if (Rank != 0) {
                this.GameHiscore.SetHiscoreEntry(Rank, Score);
            }
            this.OverPosition = this.PlayfieldHeight - HiscoreImage.getHeight() >> 1;
            this.OverFlightIn = 0;
            this.OverFlightWait = 50;
        } else {
            this.OverPosition = this.PlayfieldHeight >> 3;
            this.OverFlightIn = this.PlayfieldWidth;
            this.OverFlightWait = 0;
        }
        this.BaseCanvas.removeCommand(DungeonMain.cmdBack);
        this.SetInternalGameState(6);
    }

    public final void InitLevelcode() {
        this.GameLevelcode.EnterLevelcode();
    }

    public final boolean isLevelCode() {
        return this.GameLevelcode.isLevelCode();
    }

    public final int getLevelIndex() {
        return this.GameLevelcode.getLevelIndex();
    }

    public final void PaintTitle(Graphics gfx) {
        int CursorLineA;
        int CursorLineB;
        if (this.FontHeight == 0) {
            this.FontHeight = gfx.getFont().getHeight();
        }
        if ((CursorLineB = (this.PlayfieldHeight * 96 >> 7) - (this.FontHeight >> 1)) < (CursorLineA = (this.PlayfieldHeight * 77 >> 7) - (this.FontHeight >> 1)) + this.FontHeight + 2) {
            CursorLineB = CursorLineA + this.FontHeight + 2;
        }
        int part = CursorLineB + this.FontHeight + 2 - CursorLineA;
        int blks = 65536 / part;
        int grady = part + 1 >> 1;
        int plmid = CursorLineA;
        gfx.setColor(0);
        gfx.fillRect(0, 0, this.PlayfieldWidth, plmid);
        int i = plmid + (grady << 1);
        gfx.fillRect(0, i, this.PlayfieldWidth, this.PlayfieldHeight - i);
        for (i = 0; i < grady; ++i) {
            gfx.setColor(0x100000 + 1 * (i * blks >> 8) << ((i & 1) << 4));
            gfx.fillRect(0, plmid++, this.PlayfieldWidth, 1);
        }
        for (i = 0; i < grady; ++i) {
            gfx.setColor(0x100080 - 1 * (i * blks >> 8) << ((i & 1) << 4));
            gfx.fillRect(0, plmid++, this.PlayfieldWidth, 1);
        }
        if (this.GameFont != null) {
            gfx.setFont(this.GameFont);
        }
        if (this.MadMazeColor > 65793) {
            DungeonPreview.DrawSheme(gfx, DungeonLevels.GetLevelCharArray(0), this.MadMazeColor);
        }
        if (this.MadMazeColor < 0x606060) {
            this.MadMazeColor += 65793;
        }
        this.ObjZoom = this.ObjZoom < this.MaxObjZoom ? (this.ObjZoom += 31) : this.MaxObjZoom;
        if (this.ObjRGB < 65280) {
            this.ObjRGB += 4352;
        }
        this.X_Angle += 3;
        if (this.X_Angle >= 360) {
            this.X_Angle -= 360;
        }
        this.Y_Angle += 5;
        if (this.Y_Angle >= 360) {
            this.Y_Angle -= 360;
        }
        this.Z_Angle += 7;
        if (this.Z_Angle >= 360) {
            this.Z_Angle -= 360;
        }
        VectorObj.CalcPolygons(this.X_Angle, this.Y_Angle, this.Z_Angle, this.ObjZoom);
        VectorObj.DrawObject(gfx, this.PlayfieldWidth >> 1, this.PlayfieldHeight * 65 / 100, this.ObjRGB, 64);
        plmid = this.PlayfieldWidth >> 1;
        int madrun = this.IntroTextCnt % 32;
        int madidx = this.IntroTextCnt >> 4 & 0xFE;
        blks = madrun * 3 >> 1;
        part = madrun << 2;
        String curstr1 = DungeonStrings.StrTitle.StrWelcomeTexts[madidx];
        String curstr2 = DungeonStrings.StrTitle.StrWelcomeTexts[madidx + 1];
        if (madidx != this.IntroTextIdx) {
            this.IntroTextIdx = madidx;
            this.IntroTextColor = 0;
        }
        gfx.setColor(0xDADAFA - 460552 * madrun);
        gfx.drawString(curstr1, plmid - 4 - part, CursorLineA - 4 - blks, 17);
        gfx.drawString(curstr1, plmid + 4 + part, CursorLineA + 4 + blks, 17);
        gfx.drawString(curstr2, plmid - 4 - part, CursorLineB - 4 - blks, 17);
        gfx.drawString(curstr2, plmid + 4 + part, CursorLineB + 4 + blks, 17);
        if (this.IntroTextColor < 13301760) {
            this.IntroTextColor += 395264;
        } else {
            this.IntroTextColor |= 0xE0FF00;
            if (this.IntroTextColor < 0xE0FFFF) {
                this.IntroTextColor += 8;
                if (this.IntroTextColor > 14745592) {
                    this.IntroTextColor = 0xE8FFFF;
                }
            }
        }
        gfx.setColor(0xFFFFFF - this.IntroTextColor + 175 - (madrun << 2) & 0xFFFFFF);
        gfx.drawString(curstr2, plmid, CursorLineB, 17);
        gfx.drawString(curstr1, plmid, CursorLineA, 17);
        if (++this.IntroTextCnt >= WelcomeTextCount << 4) {
            this.IntroTextCnt = 0;
        }
        plmid = (this.PlayfieldHeight >> 2) - (this.TitleHeight >> 1);
        i = plmid + this.TitleHeight;
        i += (this.PlayfieldHeight - i) % this.WallImageHeight >> 1;
        blks = 0;
        while (i < this.PlayfieldHeight) {
            gfx.drawImage(WallImage1, blks, i, 20);
            gfx.drawImage(WallImage2, this.PlayfieldWidth - blks, i, 24);
            i += this.WallImageHeight;
            blks ^= 1;
        }
        if (this.TitlePosition < plmid) {
            this.TitlePosition += this.TitleSpeed;
            if (this.TitlePosition > plmid) {
                this.TitlePosition = plmid;
            }
            if (this.TitleSpeed > 2 && (this.IntroTextCnt & 3) == 0) {
                this.TitleSpeed >>= 1;
            }
        }
        gfx.drawImage(TitleImage, this.PlayfieldWidth >> 1, this.TitlePosition, 17);
        this.DrawStarAnim(gfx);
        gfx.drawImage(AuthorImage, this.PlayfieldWidth >> 1, this.PlayfieldHeight, 33);
    }

    public final void PaintEndOfGame(Graphics gfx) {
        int ncol;
        int blks;
        if (this.FontHeight == 0) {
            this.FontHeight = gfx.getFont().getHeight();
        }
        gfx.setColor(0);
        gfx.fillRect(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
        int CursorLineA = (this.PlayfieldHeight * 54 >> 7) - (this.FontHeight >> 1);
        int CursorLineB = (this.PlayfieldHeight * 74 >> 7) - (this.FontHeight >> 1);
        if (CursorLineB < CursorLineA + this.FontHeight + 2) {
            CursorLineB = CursorLineA + this.FontHeight + 2;
        }
        if (this.GameFont != null) {
            gfx.setFont(this.GameFont);
        }
        int wd = EndOfGameImage.getWidth();
        int hg = EndOfGameImage.getHeight();
        int xt = this.PlayfieldWidth - wd >> 1;
        int yt = this.PlayfieldHeight - hg >> 1;
        gfx.drawImage(EndOfGameImage, xt, yt, 20);
        if (xt > 0 && yt > 0) {
            blks = 255 / (yt < xt ? yt : xt);
            for (ncol = 255; ncol > blks && xt > 0 && yt > 0; ncol -= blks) {
                gfx.setColor(ncol);
                gfx.drawRect(--xt, --yt, wd += 2, hg += 2);
            }
        }
        int plmid = this.PlayfieldWidth >> 1;
        int madrun = this.IntroTextCnt % 32;
        int madidx = this.IntroTextCnt >> 4 & 0xFE;
        blks = madrun * 3 >> 1;
        int part = madrun << 2;
        String curstr1 = DungeonStrings.StrEndOfGame.StrOuttroTexts[madidx];
        String curstr2 = DungeonStrings.StrEndOfGame.StrOuttroTexts[madidx + 1];
        if (madidx != this.IntroTextIdx) {
            this.IntroTextIdx = madidx;
            this.IntroTextColor = 0;
        }
        ncol = 0xDADAFF - 460292 * madrun;
        xt = plmid - 4 - part;
        yt = CursorLineA - 4 - blks;
        gfx.setColor(0);
        gfx.drawString(curstr1, xt + 1, yt + 1, 17);
        gfx.setColor(ncol);
        gfx.drawString(curstr1, xt, yt, 17);
        xt = plmid + 4 + part;
        yt = CursorLineA + 4 + blks;
        gfx.setColor(0);
        gfx.drawString(curstr1, xt, yt, 17);
        gfx.setColor(ncol);
        gfx.drawString(curstr1, xt, yt, 17);
        xt = plmid - 4 - part;
        yt = CursorLineB - 4 - blks;
        gfx.setColor(0);
        gfx.drawString(curstr2, xt, yt, 17);
        gfx.setColor(ncol);
        gfx.drawString(curstr2, xt, yt, 17);
        xt = plmid + 4 + part;
        yt = CursorLineB + 4 + blks;
        gfx.setColor(0);
        gfx.drawString(curstr2, xt, yt, 17);
        gfx.setColor(ncol);
        gfx.drawString(curstr2, xt, yt, 17);
        if (this.IntroTextColor < 13301760) {
            this.IntroTextColor += 395264;
        } else {
            this.IntroTextColor |= 0xE0FF00;
            if (this.IntroTextColor < 0xE0FFFF) {
                this.IntroTextColor += 8;
                if (this.IntroTextColor > 14745592) {
                    this.IntroTextColor = 0xE8FFFF;
                }
            }
        }
        gfx.setColor(0);
        gfx.drawString(curstr2, plmid + 1, CursorLineB + 1, 17);
        gfx.drawString(curstr1, plmid + 1, CursorLineA + 1, 17);
        gfx.setColor(0xFFFFFF - this.IntroTextColor + 175 - (madrun << 2) & 0xFFFFFF);
        gfx.drawString(curstr2, plmid, CursorLineB, 17);
        gfx.drawString(curstr1, plmid, CursorLineA, 17);
        if (++this.IntroTextCnt >= EndOfTextCount << 4) {
            this.IntroTextCnt = 0;
        }
        gfx.drawImage(AuthorImage, this.PlayfieldWidth >> 1, this.PlayfieldHeight, 33);
    }

    public final void PaintPreview(Graphics gfx) {
        this.GamePlayfield.BuildPreview(gfx);
    }

    public final void PaintGame(Graphics gfx) {
        this.GamePlayfield.BuildPlayfield(gfx);
    }

    public final void PaintOver(Graphics gfx) {
        int i;
        long CurrentTimeInMillis = System.currentTimeMillis();
        int imghg = HiscoreImage.getHeight();
        int hg = this.PlayfieldHeight >> 1;
        int blks = 65536 / hg;
        int grady = hg + 1 >> 1;
        int plmid = 0;
        for (i = 0; i < grady; ++i) {
            gfx.setColor(0 + 257 * (i * blks >> 7) << ((i & 1) << 4));
            gfx.fillRect(0, plmid++, this.PlayfieldWidth, 1);
        }
        for (i = 0; i < grady; ++i) {
            gfx.setColor(32896 - 257 * (i * blks >> 8) << ((i & 1) << 4));
            gfx.fillRect(0, plmid++, this.PlayfieldWidth, 1);
        }
        gfx.setColor(0);
        i = plmid - 1;
        gfx.fillRect(0, i, this.PlayfieldWidth, this.PlayfieldHeight - i);
        int wd = this.PlayfieldWidth >> 1;
        if (this.OverPosition > this.PlayfieldHeight >> 3) {
            if (GameFinallyPassed) {
                gfx.drawImage(HiscoreImage, wd, this.OverPosition, 17);
            } else {
                gfx.drawImage(OverImage, wd, this.OverPosition, 17);
            }
        } else if (GameFinallyPassed) {
            gfx.drawImage(HiscoreImage, wd, this.OverPosition, 17);
        } else {
            gfx.drawImage(OverImage, wd + this.OverFlightIn, this.OverPosition, 17);
            gfx.drawImage(HiscoreImage, -wd + this.OverFlightIn, this.OverPosition, 17);
            if (this.OverFlightWait > 0) {
                --this.OverFlightWait;
            }
            if (this.OverFlightWait <= 0) {
                if (this.OverFlightIn < this.PlayfieldWidth) {
                    this.OverFlightIn += 3;
                }
                if (this.OverFlightIn > this.PlayfieldWidth) {
                    this.OverFlightIn = this.PlayfieldWidth;
                }
            }
        }
        if (CurrentTimeInMillis - this.OverMovePause > 2000L) {
            if (this.OverPosition > this.PlayfieldHeight >> 3) {
                this.OverPosition -= 4;
            } else {
                int x1 = this.PlayfieldWidth >> 5;
                int y1 = this.OverPosition + imghg + (this.PlayfieldHeight >> 5);
                wd = this.PlayfieldWidth - (this.PlayfieldWidth >> 4);
                hg = this.PlayfieldHeight - y1 - (this.PlayfieldHeight >> 5);
                this.GameHiscore.PaintScore(gfx, x1, y1, wd, hg, this.GameFont != null ? this.GameFont.getSize() : 8);
            }
        }
        gfx.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
        this.DrawStarAnim(gfx);
    }

    private final void DrawStarAnim(Graphics gfx) {
        int y1 = this.AnimStarZ.length;
        for (int star = 0; star < y1; ++star) {
            int n = star;
            this.AnimStarZ[n] = this.AnimStarZ[n] + 1;
            if (this.AnimStarZ[n] < 10) {
                int i;
                int plmid;
                switch (star & 3) {
                    case 1: {
                        plmid = 1318948;
                        break;
                    }
                    case 2: {
                        plmid = 2102304;
                        break;
                    }
                    case 3: {
                        plmid = 1315872;
                        break;
                    }
                    default: {
                        plmid = 2105364;
                    }
                }
                int sx = this.AnimStarX[star];
                int sy = this.AnimStarY[star];
                int x1 = i << 1;
                gfx.setColor(32 + (plmid << 1));
                gfx.drawArc(sx - i, sy - i, x1, x1, 0, 360);
                for (i = this.AnimStarZ[star]; i > 0; --i) {
                    gfx.setColor(plmid * (8 - i));
                    x1 = i >> 1;
                    gfx.drawLine(sx - i, sy - i, sx + i, sy + i);
                    gfx.drawLine(sx - i, sy + i, sx + i, sy - i);
                    gfx.drawLine(sx - i - x1, sy, sx + i + x1, sy);
                    gfx.drawLine(sx, sy - i - x1, sx, sy + i + x1);
                }
                continue;
            }
            this.AnimStarX[star] = this.GetRandomNumber(this.PlayfieldWidth);
            this.AnimStarY[star] = this.GetRandomNumber(this.PlayfieldHeight);
            this.AnimStarZ[star] = 0;
        }
    }

    public final void MoveLeft(boolean KeyState) {
        JoyPad.SetLeftKeyState(KeyState);
        JoyPad.SetRightKeyState(false);
        JoyPad.SetDownKeyState(false);
        JoyPad.SetUpKeyState(false);
        JoyPad.SetFireKeyState(false);
    }

    public final void MoveRight(boolean KeyState) {
        JoyPad.SetRightKeyState(KeyState);
        JoyPad.SetLeftKeyState(false);
        JoyPad.SetDownKeyState(false);
        JoyPad.SetUpKeyState(false);
        JoyPad.SetFireKeyState(false);
    }

    public final void MoveUp(boolean KeyState) {
        JoyPad.SetUpKeyState(KeyState);
        JoyPad.SetLeftKeyState(false);
        JoyPad.SetDownKeyState(false);
        JoyPad.SetRightKeyState(false);
        JoyPad.SetFireKeyState(false);
    }

    public final void MoveDown(boolean KeyState) {
        JoyPad.SetDownKeyState(KeyState);
        JoyPad.SetLeftKeyState(false);
        JoyPad.SetUpKeyState(false);
        JoyPad.SetRightKeyState(false);
        JoyPad.SetFireKeyState(false);
    }

    public final void FireAction(boolean KeyState) {
        JoyPad.SetFireKeyState(KeyState);
        JoyPad.SetDownKeyState(false);
        JoyPad.SetLeftKeyState(false);
        JoyPad.SetUpKeyState(false);
        JoyPad.SetRightKeyState(false);
    }

    public final void TogglePause() {
        JoyPad.SetFireKeyState(false);
        JoyPad.SetDownKeyState(false);
        JoyPad.SetLeftKeyState(false);
        JoyPad.SetUpKeyState(false);
        JoyPad.SetRightKeyState(false);
        JoyPad.TooglePauseKeyState();
    }

    public final void ToggleMap() {
        JoyPad.SetFireKeyState(false);
        JoyPad.SetDownKeyState(false);
        JoyPad.SetLeftKeyState(false);
        JoyPad.SetUpKeyState(false);
        JoyPad.SetRightKeyState(false);
        JoyPad.ToogleMapKeyState();
    }

    public final void StylusRelease(int StylusX, int StylusY) {
        this.GamePlayfield.StylusRelease(StylusX, StylusY);
    }

    public final void StylusMove(int StylusX, int StylusY) {
        this.GamePlayfield.StylusMove(StylusX, StylusY);
    }

    public final int GetInternalGameState() {
        return this.GamePlayfield.GetInternalGameState();
    }

    public final void SetInternalGameState(int GameState) {
        this.GamePlayfield.SetInternalGameState(GameState);
    }

    public final int GetRandomNumber(int scale) {
        return (int)(((long)this.RandomObj.nextInt() & 0xFFFFFFFFL) * (long)scale >> 32);
    }

    public final void SetStartLevel(int LevelNumber) {
        this.GamePlayfield.SetStartLevel(LevelNumber);
    }

    public static final void MusicOnOff(boolean bsound) {
        if (bsound) {
            DungeonGame.ReplaySound(0);
        } else {
            DungeonGame.StopSound(0);
        }
        GameSoundFlag = bsound;
    }

    public static final void SoundOnOff(boolean bsound) {
        if (!bsound) {
            DungeonGame.StopSound(1);
        }
        GameSoundFlag = bsound;
    }

    public static final boolean IsSoundOn() {
        return GameSoundFlag;
    }

    public static final boolean IsAudioAvailable() {
        return AudioAvailableFlag;
    }

    public static final void PlaySound(int SoundIdx, int SoundChannel) {
        if (GameSoundFlag) {
            GameSound.PlaySound(SoundIdx, SoundChannel);
        } else {
            GameSound.SetSound(SoundIdx, SoundChannel);
        }
    }

    public static final void ReplaySound(int SoundChannel) {
        GameSound.ReplaySound(SoundChannel);
    }

    public static final void StopSound(int SoundChannel) {
        GameSound.StopSound(SoundChannel);
    }

    private final int CalcTextCheckSum() {
        int CheckSum = 0;
        for (int tline = 0; tline < WelcomeTextCount; ++tline) {
            int textlen = DungeonStrings.StrTitle.StrWelcomeTexts[tline].length();
            for (int column = 0; column < textlen; ++column) {
                CheckSum += DungeonStrings.StrTitle.StrWelcomeTexts[tline].charAt(column);
            }
        }
        return CheckSum;
    }

    public void ShowAlert(String NotifyText) {
        Alert InfoScreenObj = new Alert("Mad Maze", NotifyText, null, AlertType.INFO);
        InfoScreenObj.setTimeout(-2);
        MadMaze.GameDisplay.setCurrent(InfoScreenObj, MadMaze.GameDisplay.getCurrent());
    }

    private final boolean CheckForManipulation() {
        return this.CalcTextCheckSum() != 15421;
    }

    public void sizeChanged(int dWidth, int dHeight) {
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.InitGame(dWidth, dHeight);
    }

    static {
        WelcomeTextCount = DungeonStrings.StrTitle.StrWelcomeTexts.length;
        EndOfTextCount = DungeonStrings.StrEndOfGame.StrOuttroTexts.length;
        GameFinallyPassed = false;
    }
}

