/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import overthehill.madmaze.DungeonGame;
import overthehill.madmaze.JoyPad;
import overthehill.madmaze.MadMaze;
import overthehill.madmaze.TextUtils;

public final class DungeonMain
extends Canvas
implements Runnable,
CommandListener {
    public static final Command cmdOK = new Command("OK", 8, 1);
    public static final Command cmdStart = new Command("Start", 8, 1);
    public static final Command cmdExit = new Command("Exit", 8, 1);
    public static final Command cmdBack = new Command("Back", 8, 1);
    public static final Command cmdAbout = new Command("About", 8, 1);
    public static final Command cmdLevel = new Command("Level", 8, 1);
    public static final Command cmdHiscore = new Command("Hiscore", 8, 1);
    public static final Command cmdSoundOn = new Command("Sound on", 8, 1);
    public static final Command cmdSoundOff = new Command("Sound off", 8, 1);
    private boolean GameDestroyFlag = false;
    private MIDlet BaseMidlet;
    private DungeonGame GameCore;
    private Image OffScreenImage;
    private int GameState = 1;
    private int GameLoopDelay = 250;
    private int TitleStartMusic = 8;
    private int OverStartMusic;
    private int FinalStartMusic;
    private int ScrImageWidth;
    private int ScrImageHeight;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private long DebounceItemTimer;
    private boolean CmdItemWorkAround = MadMaze.AppPlatform.indexOf("SAMSUNG") != -1;
    private boolean AboutInfoFlag;
    private boolean ClearAllScreen;
    private int AppInfoScroll;
    private int AppInfoDirection;
    private int AppInfoDelay;
    private Image AppImage;

    public DungeonMain(MIDlet rmidlet, boolean ColoredDisp) {
        this.PlayfieldWidth = this.getWidth();
        this.PlayfieldHeight = this.getHeight();
        this.BaseMidlet = rmidlet;
        this.OffScreenImage = Image.createImage((int)this.PlayfieldWidth, (int)this.PlayfieldHeight);
        this.ScrImageWidth = this.OffScreenImage.getWidth();
        this.ScrImageHeight = this.OffScreenImage.getHeight();
        this.addCommand(cmdStart);
        this.addCommand(cmdExit);
        this.addCommand(cmdAbout);
        this.addCommand(cmdLevel);
        this.addCommand(cmdHiscore);
        this.setCommandListener(this);
        this.GameCore = new DungeonGame(this, this.PlayfieldWidth, this.PlayfieldHeight, ColoredDisp);
        if (DungeonGame.IsAudioAvailable()) {
            this.addCommand(cmdSoundOff);
        }
    }

    public void paint(Graphics gfx) {
        if (this.ClearAllScreen) {
            this.ClearAllScreen = false;
            gfx.setColor(0);
            gfx.fillRect(0, 0, gfx.getClipWidth(), gfx.getClipHeight());
            return;
        }
        if (this.OffScreenImage == null) {
            gfx.setColor(0);
            gfx.fillRect(0, 0, this.ScrImageWidth, this.ScrImageHeight);
            return;
        }
        Graphics OffScreenGfx = this.OffScreenImage.getGraphics();
        if (this.AboutInfoFlag) {
            this.GameLoopDelay = 50;
            this.PaintAppInfo(OffScreenGfx);
        } else {
            switch (this.GameState) {
                case 1: {
                    if (this.GameCore.isLevelCode()) {
                        this.HandleStateChanges();
                        break;
                    }
                    if (this.TitleStartMusic > 0 && --this.TitleStartMusic == 0) {
                        DungeonGame.PlaySound(64, 0);
                    }
                    this.GameLoopDelay = 50;
                    this.GameCore.PaintTitle(OffScreenGfx);
                    break;
                }
                case 2: {
                    this.GameLoopDelay = 100;
                    this.GameCore.PaintPreview(OffScreenGfx);
                    break;
                }
                case 3: {
                    this.GameLoopDelay = 333;
                    this.GameCore.PaintGame(OffScreenGfx);
                    break;
                }
                case 4: {
                    this.HandleStateChanges();
                    break;
                }
                case 5: {
                    this.GameCore.InitOver(true);
                    if (DungeonGame.IsAudioAvailable()) {
                        this.addCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
                    }
                    this.OverStartMusic = 8;
                    break;
                }
                case 6: {
                    if (this.OverStartMusic > 0 && --this.OverStartMusic == 0) {
                        DungeonGame.PlaySound(65, 0);
                    }
                    this.GameLoopDelay = 50;
                    this.GameCore.PaintOver(OffScreenGfx);
                    break;
                }
                case 7: {
                    this.FinalStartMusic = 8;
                    this.HandleStateChanges();
                    break;
                }
                case 8: {
                    if (this.FinalStartMusic > 0 && --this.FinalStartMusic == 0) {
                        DungeonGame.PlaySound(66, 0);
                    }
                    this.GameLoopDelay = 50;
                    this.GameCore.PaintEndOfGame(OffScreenGfx);
                    break;
                }
                case -1: {
                    return;
                }
            }
        }
        gfx.setClip(0, 0, this.ScrImageWidth, this.ScrImageHeight);
        gfx.drawImage(this.OffScreenImage, 0, 0, 20);
        this.GameState = this.GameCore.GetInternalGameState();
    }

    public void keyPressed(int code) {
        if (this.AboutInfoFlag) {
            this.HideAboutScreen();
            return;
        }
        int ActionCode = this.getGameAction(code);
        if (this.GameState == 3) {
            switch (ActionCode) {
                case 1: {
                    this.GameCore.MoveUp(true);
                    break;
                }
                case 6: {
                    this.GameCore.MoveDown(true);
                    break;
                }
                case 2: {
                    this.GameCore.MoveLeft(true);
                    break;
                }
                case 5: {
                    this.GameCore.MoveRight(true);
                    break;
                }
                case 8: {
                    this.GameCore.FireAction(true);
                    break;
                }
            }
            switch (code) {
                case 35: 
                case 55: {
                    this.GameCore.TogglePause();
                    break;
                }
                case 42: 
                case 57: {
                    this.GameCore.ToggleMap();
                    break;
                }
                case 10: 
                case 32: 
                case 48: 
                case 53: {
                    this.GameCore.FireAction(true);
                    break;
                }
            }
        }
        if (this.GameState == 2 && (code == 10 || code == 32 || code == 53 || code == 48 || ActionCode == 8 || JoyPad.IsFireKey() || ActionCode == 1 || ActionCode == 6 || ActionCode == 2 || ActionCode == 5)) {
            this.HandleStateChanges();
        }
        if (this.GameState == 1 && (code == 10 || code == 32 || code == 53 || code == 48 || ActionCode == 8 || JoyPad.IsFireKey())) {
            this.HandleStateChanges();
        }
        if (this.GameState == 6 && (code == 10 || code == 32 || code == 53 || code == 48 || ActionCode == 8 || JoyPad.IsFireKey())) {
            this.HandleStateChanges();
        }
        if (this.GameState == 8 && (code == 10 || code == 32 || code == 53 || code == 48 || ActionCode == 8 || JoyPad.IsFireKey())) {
            this.HandleStateChanges();
        }
    }

    public final void keyRepeated(int code) {
        this.keyPressed(code);
    }

    public void pointerDragged(int x, int y) {
        this.GameCore.StylusMove(x, y);
    }

    public void pointerPressed(int x, int y) {
        if (this.AboutInfoFlag) {
            return;
        }
        this.HandleStateChanges();
    }

    public void pointerReleased(int x, int y) {
        if (this.AboutInfoFlag) {
            this.HideAboutScreen();
            return;
        }
        this.GameCore.StylusRelease(x, y);
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void run() {
        while (!this.GameDestroyFlag) {
            long loopEndTime = System.currentTimeMillis() + (long)this.GameLoopDelay;
            this.repaint();
            this.serviceRepaints();
            Thread.yield();
            long loopTime = loopEndTime - System.currentTimeMillis();
            try {
                if (loopTime > 0L) {
                    Thread.sleep(loopTime);
                } else {
                    Thread.sleep(this.GameLoopDelay >> 1);
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Thread.yield();
        }
    }

    public final void DestroyGame() {
        this.GameDestroyFlag = true;
        this.GameCore.DestroyCore();
        this.BaseMidlet.notifyDestroyed();
    }

    public void commandAction(Command ncmd, Displayable ndisp) {
        long CurrentTimeInMillis = System.currentTimeMillis();
        if (CurrentTimeInMillis - this.DebounceItemTimer > 250L) {
            this.DebounceItemTimer = CurrentTimeInMillis;
            if (this.AboutInfoFlag) {
                this.HideAboutScreen();
                return;
            }
            try {
                if (ncmd.equals(cmdStart)) {
                    if (this.GameState == 3) {
                        if (JoyPad.IsPauseKey()) {
                            JoyPad.TooglePauseKeyState();
                        } else if (JoyPad.IsMapKey()) {
                            JoyPad.ToogleMapKeyState();
                        } else {
                            JoyPad.SetFireKeyState(true);
                        }
                    } else {
                        this.HandleStateChanges();
                    }
                }
                if (ncmd.equals(cmdBack)) {
                    this.WorkaroundForMenuBug();
                    this.removeCommand(cmdBack);
                    this.GameState = 6;
                    this.HandleStateChanges();
                }
                if (ncmd.equals(cmdExit)) {
                    try {
                        this.DestroyGame();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ncmd.equals(cmdAbout)) {
                    this.ShowAboutInfo();
                }
                if (ncmd.equals(cmdLevel)) {
                    this.InitLevelcode();
                }
                if (ncmd.equals(cmdHiscore)) {
                    this.ShowHiscore();
                }
                if (ncmd.equals(cmdSoundOff)) {
                    this.WorkaroundForMenuBug();
                    this.removeCommand(cmdSoundOff);
                    this.addCommand(cmdSoundOn);
                    if (this.IsMusicAvailable()) {
                        DungeonGame.MusicOnOff(false);
                    } else {
                        DungeonGame.SoundOnOff(false);
                    }
                }
                if (ncmd.equals(cmdSoundOn)) {
                    this.WorkaroundForMenuBug();
                    this.removeCommand(cmdSoundOn);
                    this.addCommand(cmdSoundOff);
                    if (this.IsMusicAvailable()) {
                        DungeonGame.MusicOnOff(true);
                    } else {
                        DungeonGame.SoundOnOff(true);
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void InitLevelcode() {
        Graphics gfx = this.OffScreenImage.getGraphics();
        gfx.setClip(0, 0, this.ScrImageWidth, this.ScrImageHeight);
        gfx.setColor(0xFFFFFF);
        gfx.fillRect(0, 0, this.ScrImageWidth, this.ScrImageHeight);
        this.GameCore.InitLevelcode();
    }

    public void ShowHiscore() {
        Graphics gfx = this.OffScreenImage.getGraphics();
        gfx.setClip(0, 0, this.ScrImageWidth, this.ScrImageHeight);
        gfx.setColor(0);
        gfx.fillRect(0, 0, this.ScrImageWidth, this.ScrImageHeight);
        this.WorkaroundForMenuBug();
        if (DungeonGame.IsAudioAvailable()) {
            this.removeCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
        }
        this.removeCommand(cmdLevel);
        this.removeCommand(cmdHiscore);
        if (DungeonGame.IsAudioAvailable()) {
            this.addCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
        }
        this.GameCore.InitOver(false);
        this.OverStartMusic = 8;
    }

    private final void HandleStateChanges() {
        JoyPad.SetFireKeyState(false);
        if (this.GameState == 2) {
            DungeonGame.StopSound(0);
            this.GameState = 3;
        }
        if (this.GameState == 4) {
            this.GameState = 2;
        }
        if (this.GameState == 1) {
            this.TitleStartMusic = 0;
            if (this.GameCore.isLevelCode()) {
                this.GameCore.SetStartLevel(this.GameCore.getLevelIndex());
            }
            this.WorkaroundForMenuBug();
            if (DungeonGame.IsAudioAvailable()) {
                this.removeCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
            }
            this.removeCommand(cmdLevel);
            this.removeCommand(cmdHiscore);
            this.addCommand(cmdBack);
            if (DungeonGame.IsAudioAvailable()) {
                this.addCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
            }
            DungeonGame.StopSound(0);
            this.GameState = 2;
        }
        if (this.GameState == 6) {
            this.OverStartMusic = 0;
            DungeonGame.StopSound(0);
            this.GameCore.InitTitle();
            this.GameCore.SetStartLevel(0);
            this.WorkaroundForMenuBug();
            if (DungeonGame.IsAudioAvailable()) {
                this.removeCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
            }
            this.addCommand(cmdLevel);
            this.addCommand(cmdHiscore);
            if (DungeonGame.IsAudioAvailable()) {
                this.addCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
            }
            this.TitleStartMusic = 8;
            this.GameState = 1;
        }
        if (this.GameState == 8) {
            this.GameCore.InitOver(true);
            this.OverStartMusic = 8;
            if (DungeonGame.IsAudioAvailable()) {
                this.addCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
            }
            this.GameState = 6;
        }
        if (this.GameState == 7) {
            this.GameCore.InitEndOfGame();
            this.GameState = 8;
        }
        this.GameCore.SetInternalGameState(this.GameState);
    }

    public final boolean IsMusicAvailable() {
        return this.GameState == 1 || this.GameState == 6 || this.GameState == 7;
    }

    public void ShowAboutInfo() {
        String IconName = this.PlayfieldWidth >= 480 ? "/MadMaze_48.png" : (this.PlayfieldWidth >= 240 ? "/MadMaze_32.png" : "/MadMaze_24.png");
        try {
            this.AppImage = Image.createImage((String)IconName);
        }
        catch (IOException e) {
            this.AppImage = null;
        }
        this.WorkaroundForMenuBug();
        this.removeCommand(cmdStart);
        this.removeCommand(cmdExit);
        this.removeCommand(cmdAbout);
        this.removeCommand(cmdBack);
        this.removeCommand(cmdLevel);
        this.removeCommand(cmdHiscore);
        this.removeCommand(cmdSoundOff);
        this.removeCommand(cmdSoundOn);
        this.addCommand(cmdOK);
        this.AppInfoScroll = 0;
        this.AppInfoDirection = 1;
        this.AppInfoDelay = 10;
        this.AboutInfoFlag = true;
    }

    public final void HideAboutScreen() {
        this.AboutInfoFlag = false;
        this.WorkaroundForMenuBug();
        this.removeCommand(cmdOK);
        this.addCommand(cmdStart);
        this.addCommand(cmdExit);
        this.addCommand(cmdAbout);
        if (this.GameState == 1) {
            this.addCommand(cmdLevel);
            this.addCommand(cmdHiscore);
        } else {
            this.addCommand(cmdBack);
        }
        if (DungeonGame.IsAudioAvailable()) {
            this.addCommand(DungeonGame.IsSoundOn() ? cmdSoundOff : cmdSoundOn);
        }
    }

    protected void sizeChanged(int newWidth, int newHeight) {
        if (this.GameCore != null) {
            this.ClearAllScreen = true;
            this.repaint();
            this.serviceRepaints();
            int wd = this.getWidth();
            int hg = this.getHeight();
            if (this.PlayfieldWidth != wd || this.PlayfieldHeight != hg) {
                this.PlayfieldWidth = wd;
                this.PlayfieldHeight = hg;
                this.OffScreenImage = Image.createImage((int)this.PlayfieldWidth, (int)this.PlayfieldHeight);
                this.GameCore.sizeChanged(this.PlayfieldWidth, this.PlayfieldHeight);
            }
        }
    }

    public final Image Get_AboutImage() {
        return this.AppImage;
    }

    private final void PaintAppInfo(Graphics gfx) {
        int i;
        int hw;
        int hg;
        gfx.setColor(0xFFFFFF);
        gfx.fillRect(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
        int tx = this.PlayfieldWidth >> 5;
        int ty = this.PlayfieldHeight >> 5;
        int dh = gfx.getFont().getHeight();
        int th = ty;
        Image TitleIcon = this.Get_AboutImage();
        if (TitleIcon != null) {
            hg = TitleIcon.getHeight();
            hw = TitleIcon.getWidth();
        } else {
            hg = 16;
            hw = 16;
        }
        int n = (dh << 1) + 2;
        if (n > hg) {
            th += n - hg >> 1;
            hg = n;
        }
        if (TitleIcon != null) {
            gfx.drawImage(TitleIcon, tx, th, 20);
        }
        th = (ty << 1) + hg;
        int cl = 0xFFFFFF;
        for (i = 0; i < this.PlayfieldWidth; ++i) {
            if (i < this.PlayfieldWidth - 51) {
                if (cl > 255) {
                    cl -= 328960;
                }
            } else if (cl < 0xFFFFFF) {
                cl += 328960;
            }
            gfx.setColor(cl);
            gfx.drawRect(i, th, 1, 1);
        }
        int bg = th = (ty << 2) + hg;
        int bt = this.PlayfieldHeight - dh - 2;
        gfx.setClip(0, th, this.PlayfieldWidth, this.PlayfieldHeight - th);
        th -= this.AppInfoScroll;
        gfx.setColor(0);
        String[] WordBreakedText = TextUtils.getWordBreakStringArray("Copyright \u00a92012 Roy Schneider\nFREEWARE\nE-Mail: royspa@overthehill.de\nThree labyrinths build of 32x32 objects each. Release your eyes to the darkness and make your way through the dungeon.", gfx.getFont(), this.PlayfieldWidth - (tx << 1));
        if (WordBreakedText != null) {
            for (i = 0; i < WordBreakedText.length; ++i) {
                if (WordBreakedText[i] != null) {
                    n = 0;
                    if (th < bg) {
                        n = bg - th << 1;
                    }
                    if (th > bt) {
                        n = th - bt << 1;
                    }
                    if (n > 13) {
                        n = 13;
                    }
                    gfx.setColor(0x111111 * n);
                    gfx.drawString(WordBreakedText[i], tx, th, 20);
                }
                if ((th += dh) >= this.PlayfieldHeight) break;
            }
            if (this.AppInfoScroll != 0 && th < this.PlayfieldHeight && i >= WordBreakedText.length) {
                if (this.AppInfoDirection != -1) {
                    this.AppInfoDelay = 15;
                }
                this.AppInfoDirection = -1;
            }
            if (this.AppInfoScroll != 0 || th >= this.PlayfieldHeight) {
                if (this.AppInfoDelay == 0) {
                    this.AppInfoScroll += this.AppInfoDirection;
                } else {
                    --this.AppInfoDelay;
                }
                if (this.AppInfoScroll < 0) {
                    if (this.AppInfoDirection != 1) {
                        this.AppInfoDelay = 15;
                    }
                    this.AppInfoScroll = 0;
                    this.AppInfoDirection = 1;
                }
            }
        }
        gfx.setClip(0, 0, this.PlayfieldWidth, this.PlayfieldHeight);
        tx = (tx << 1) + hw + 1;
        ty = ty + (hg >> 1) - dh;
        gfx.setColor(0);
        String TitleString = "Version 1.2.7 (08-2014)";
        n = gfx.getFont().substringWidth(TitleString, 0, TitleString.length());
        if (tx + n > this.PlayfieldWidth && (n = TitleString.indexOf(40)) >= 0) {
            TitleString = TitleString.substring(0, n - 1);
        }
        gfx.drawString(TitleString, tx, ty + dh + 1, 20);
        gfx.setFont(gfx.getFont());
        gfx.setColor(0xCCCCCC);
        TitleString = "Mad Maze";
        gfx.drawString(TitleString, tx, ty, 20);
        gfx.setColor(0);
        gfx.drawString(TitleString, --tx, --ty, 20);
    }

    private final void WorkaroundForMenuBug() {
        Alert TempDisplay;
        if (this.CmdItemWorkAround && (TempDisplay = new Alert("Please wait...")) != null) {
            TempDisplay.setTimeout(50);
            MadMaze.GameDisplay.setCurrent(TempDisplay, (Displayable)this);
        }
    }

    public final class CoreState {
        public static final int STATE_EXIT = -1;
        public static final int STATE_INIT = 0;
        public static final int STATE_TITLE = 1;
        public static final int STATE_PREVIEW = 2;
        public static final int STATE_GAME = 3;
        public static final int STATE_NEXT = 4;
        public static final int STATE_LOST = 5;
        public static final int STATE_OVER = 6;
        public static final int STATE_DONE = 7;
        public static final int STATE_FINAL = 8;
    }
}

