/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import overthehill.madmaze.DungeonCube;
import overthehill.madmaze.DungeonGame;
import overthehill.madmaze.DungeonItems;

public final class DungeonShot
extends DungeonCube {
    static final short[] ShotField = new short[]{0, 0, 0, 0};
    static final short[] ShotDirection = new short[]{0, 0, 0, 0};
    static final short[] ShotDistance = new short[]{0, 0, 0, 0};
    private char[] Playfield;
    private boolean AnimPhaseFlag = false;

    public DungeonShot() {
        this.ResetShots();
    }

    void PaintFront(int lftcube, int rgtcube) {
        int width = this.WallWidth / 3;
        int height = this.WallHeight / 3;
        int lpos = this.LeftPos + (this.WallWidth - width >> 1);
        int tpos = this.TopPos + (this.WallHeight - height >> 1);
        DungeonItems.Paint_Small_Mode_A(this.GfxObj, this.AnimPhaseFlag ? DungeonItems.ItemShot1 : DungeonItems.ItemShot2, lpos, tpos, width, height, this.ShapeBrightness - 208);
    }

    void PaintWallLeft() {
    }

    void PaintWallRight() {
    }

    void SetPlayfield(char[] CurPlayfield) {
        this.Playfield = CurPlayfield;
        this.ResetShots();
    }

    void ResetShots() {
        for (int i = 0; i < ShotField.length; ++i) {
            DungeonShot.ShotField[i] = -1;
        }
    }

    void SetShot(int position, int direction) {
        for (int i = 0; i < ShotField.length; ++i) {
            if (ShotField[i] != -1) continue;
            DungeonShot.ShotDirection[i] = (short)direction;
            DungeonShot.ShotDistance[i] = 5;
            char chr = this.Playfield[position];
            while (chr == ':' || chr == '@' || chr == '-' || chr == 'y' || chr == 'k' || chr == 'r') {
                if (this.Playfield[position += direction] != ' ') {
                    return;
                }
                chr = this.Playfield[position];
            }
            DungeonShot.ShotField[i] = (short)position;
            DungeonGame.PlaySound(133, 1);
            break;
        }
    }

    void AnimateObj() {
        for (int i = 0; i < ShotField.length; ++i) {
            int position = ShotField[i];
            if (position < 0) continue;
            char chr = this.Playfield[position];
            if (chr == 'p') {
                this.Playfield[position] = 113;
                continue;
            }
            if (chr == 'q') {
                this.Playfield[position] = 32;
                DungeonShot.ShotField[i] = -1;
                continue;
            }
            if (chr != 'o') {
                this.Playfield[position] = 111;
                continue;
            }
            this.Playfield[position] = 32;
            chr = this.Playfield[position += ShotDirection[i]];
            int n = i;
            ShotDistance[n] = (short)(ShotDistance[n] - 1);
            if (ShotDistance[n] <= 0) {
                DungeonShot.ShotField[i] = -1;
                continue;
            }
            if (chr == ':' || chr == '@' || chr == '-' || chr == 'y' || chr == 'k' || chr == 'r') {
                chr = this.Playfield[position += ShotDirection[i]];
            }
            if (chr != ' ') {
                if (chr == '\u00a7') {
                    this.Playfield[position] = 112;
                    DungeonShot.ShotField[i] = (short)position;
                    DungeonGame.PlaySound(131, 1);
                    continue;
                }
                if (chr == 'f') {
                    this.Playfield[position] = 103;
                    DungeonGame.PlaySound(40, 1);
                } else if (chr == 'g') {
                    this.Playfield[position] = 104;
                    DungeonGame.PlaySound(40, 1);
                } else if (chr == 'h') {
                    this.Playfield[position] = 32;
                    DungeonGame.PlaySound(40, 1);
                }
                DungeonShot.ShotField[i] = -1;
                continue;
            }
            DungeonShot.ShotField[i] = (short)position;
            this.Playfield[position] = 111;
        }
    }

    public void SetAnimPhase(int plsum) {
        this.AnimPhaseFlag = (plsum & 1) == 0;
    }
}

