/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import overthehill.madmaze.MadMaze;

public class Hiscore
implements CommandListener,
ItemStateListener {
    private static final String HighScore_Store_Name = "HighScores";
    private int PaintScrollOffset;
    private int PaintScrollDirection;
    private int CurrentRankIndex;
    private boolean EnterNameFlag;
    private HiscoreComparator ScoreCompare;
    private Form EnterNameForm;
    private Displayable MainDisplayable;
    private ImageItem HiscoreLabel;
    private Image EnterNameImage;
    private TextField EnterNameField;
    private Command BtnOk;
    private String GameTitle;
    private boolean HiscoreIsCorrupt;
    private int PlayfieldWidth;
    private int PlayfieldHeight;
    private int ScoreFontColor;
    private int ScoreColorIndex;
    private final String FormTitle;
    private final String InputLabel;
    private final int PlayerNameLength;
    private String[] PlayerNames = new String[]{"Roy.......", "Marvin....", "Chaos.....", "Jan.......", "Zippel....", "..........", "..........", "..........", "..........", ".........."};
    private int[] PlayerScores = new int[]{10000, 7500, 5000, 2500, 1000, 0, 0, 0, 0, 0};
    static final int ScoreFontColorFinal = 16742153;

    public Hiscore(Image TitleImage, int dWidth, int dHeight, String TitleStr) {
        this.FormTitle = "Hiscore";
        this.InputLabel = "Name:";
        this.PlayerNameLength = 10;
        this.PlayfieldWidth = dWidth;
        this.PlayfieldHeight = dHeight;
        this.GameTitle = TitleStr;
        this.ScoreColorIndex = 0;
        this.ScoreFontColor = 986895;
        this.CurrentRankIndex = 0;
        this.EnterNameFlag = false;
        this.EnterNameImage = TitleImage;
        this.HiscoreIsCorrupt = false;
        this.PaintScrollOffset = 0;
        this.PaintScrollDirection = 4;
        this.ScoreCompare = new HiscoreComparator();
    }

    public void ReadHiscore() {
        this.HiscoreIsCorrupt = false;
        this.ScoreFontColor = 986895;
        this.ScoreColorIndex = 0;
        try {
            RecordStore db = RecordStore.openRecordStore((String)HighScore_Store_Name, (boolean)false);
            RecordEnumeration re = db.enumerateRecords(null, (RecordComparator)this.ScoreCompare, false);
            int i = 0;
            while (re.hasNextElement()) {
                byte[] bytearray = re.nextRecord();
                String entrystr = new String(bytearray);
                int delimiteridx = entrystr.indexOf(10);
                if (delimiteridx > 0) {
                    try {
                        this.PlayerScores[i] = Integer.valueOf(entrystr.substring(0, delimiteridx));
                        this.PlayerNames[i] = entrystr.substring(delimiteridx + 1, entrystr.length());
                    }
                    catch (NumberFormatException ex) {
                        this.HiscoreIsCorrupt = true;
                    }
                }
                if (++i < this.PlayerNames.length) continue;
            }
            db.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            this.HiscoreIsCorrupt = true;
        }
    }

    public void SaveHiscore() {
        int curidx = this.CurrentRankIndex;
        try {
            byte[] hsc_data;
            String hsc_entry;
            int i;
            RecordEnumeration re;
            RecordStore db = RecordStore.openRecordStore((String)HighScore_Store_Name, (boolean)true);
            int recnum = db.getNumRecords();
            if (this.HiscoreIsCorrupt || recnum != this.PlayerScores.length) {
                if (recnum > 0) {
                    try {
                        re = db.enumerateRecords(null, null, false);
                        while (re.hasNextElement()) {
                            i = re.nextRecordId();
                            if (i < 0) continue;
                            db.deleteRecord(i);
                            --recnum;
                        }
                    }
                    catch (RecordStoreException ex) {
                        // empty catch block
                    }
                }
                i = 0;
                do {
                    hsc_entry = this.PlayerScores[i] + "\n" + this.PlayerNames[i];
                    hsc_data = hsc_entry.getBytes();
                    db.addRecord(hsc_data, 0, hsc_data.length);
                    ++recnum;
                    if (curidx != i) continue;
                    curidx = -1;
                } while (++i < this.PlayerScores.length);
            }
            if (curidx >= 0) {
                while (recnum >= this.PlayerScores.length) {
                    re = db.enumerateRecords(null, (RecordComparator)this.ScoreCompare, false);
                    i = -1;
                    while (re.hasNextElement()) {
                        i = re.nextRecordId();
                    }
                    if (i < 0) continue;
                    db.deleteRecord(i);
                    --recnum;
                }
                hsc_entry = this.PlayerScores[curidx] + "\n" + this.PlayerNames[curidx];
                hsc_data = hsc_entry.getBytes();
                db.addRecord(hsc_data, 0, hsc_data.length);
            }
            db.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
    }

    public void SetHiscoreEntry(int Rank, int PlayerScore) {
        if (Rank < 1 || Rank > this.PlayerScores.length) {
            return;
        }
        --Rank;
        int i = this.PlayerScores.length - 1;
        do {
            this.PlayerScores[i] = this.PlayerScores[i - 1];
            this.PlayerNames[i] = this.PlayerNames[i - 1];
        } while (--i > Rank);
        this.PlayerScores[Rank] = PlayerScore;
        this.EnterPlayerName(Rank);
    }

    public int GetRank(int Score) {
        if (Score <= 0) {
            return 0;
        }
        int i = 0;
        do {
            if (this.PlayerScores[i] >= Score) continue;
            return i + 1;
        } while (++i < this.PlayerScores.length);
        return 0;
    }

    public void PaintScore(Graphics gfx, int LeftEdge, int TopEdge, int Width, int Height, int FontSize) {
        String entrystr = "";
        String scorestr = "";
        int ccnt = 19;
        if (this.EnterNameFlag) {
            return;
        }
        if (this.ScoreFontColor < 16742153) {
            if ((this.ScoreFontColor & 0xFF) < 5) {
                ++this.ScoreFontColor;
            }
            if ((this.ScoreFontColor & 0xFF00) < 35840) {
                this.ScoreFontColor += 1280;
            }
            if ((this.ScoreFontColor & 0xFF0000) < 0xF80000) {
                this.ScoreFontColor += 983040;
            }
        }
        gfx.setFont(Font.getFont((int)32, (int)0, (int)FontSize));
        int fhgh = gfx.getFont().getHeight() - 1;
        int fwid = Width / 19;
        int fwhf = fwid >> 1;
        int lbrd = LeftEdge + (Width - fwid * 19 + 1 >> 1) + 1;
        int tbrd = Height - fhgh * this.PlayerNames.length >> 1;
        if (tbrd < 0) {
            tbrd = 0;
        }
        int bbrd = Height - (tbrd << 1);
        int ypos = TopEdge + tbrd - (this.PaintScrollOffset >> 2);
        gfx.setClip(LeftEdge, tbrd += TopEdge, Width, bbrd);
        int i = 0;
        do {
            gfx.setColor(this.ScoreColorIndex == i ? 0xFFFFFF : this.ScoreFontColor);
            if (i >= this.PlayerNames.length) continue;
            entrystr = i < 9 ? " " : "";
            entrystr = entrystr + Integer.toString(i + 1);
            entrystr = entrystr + " ";
            scorestr = Integer.toString(this.PlayerScores[i]);
            int slen = scorestr.length();
            while (slen++ < 5) {
                entrystr = entrystr + '0';
            }
            entrystr = entrystr + scorestr + " " + this.PlayerNames[i];
            slen = entrystr.length();
            int xpos = lbrd;
            if (ypos + fhgh + 4 <= tbrd) continue;
            for (int cidx = 0; cidx < slen; ++cidx) {
                gfx.setClip(xpos - fwhf - 2, tbrd, (fwid << 1) + 4, bbrd);
                gfx.drawChar(entrystr.charAt(cidx), xpos, ypos, 17);
                xpos += fwid;
            }
        } while ((ypos += fhgh) + (fhgh >> 1) <= TopEdge + Height && i++ <= this.PlayerNames.length);
        if (Height / fhgh < this.PlayerNames.length) {
            this.PaintScrollOffset += this.PaintScrollDirection;
            if (i >= this.PlayerNames.length && this.PaintScrollDirection != -4 && this.PaintScrollDirection > -4) {
                --this.PaintScrollDirection;
            }
            if (this.PaintScrollOffset <= 3 && this.PaintScrollDirection != 4 && this.PaintScrollDirection < 4) {
                ++this.PaintScrollDirection;
            }
        }
        if (++this.ScoreColorIndex >= 10) {
            this.ScoreColorIndex = 0;
        }
    }

    public void EnterPlayerName(int RankIndex) {
        int i;
        String itemstring;
        this.MainDisplayable = MadMaze.GameDisplay.getCurrent();
        boolean showtitle = this.PlayfieldWidth >= 88 && this.PlayfieldHeight >= 96;
        this.CurrentRankIndex = RankIndex;
        this.EnterNameFlag = true;
        this.EnterNameForm = new Form(showtitle ? this.GameTitle : "Hiscore");
        this.BtnOk = new Command("OK", 1, 1);
        if (showtitle) {
            itemstring = "";
            i = this.PlayfieldHeight / 250;
            while (i-- > 0) {
                itemstring = itemstring + "\n";
            }
            this.HiscoreLabel = new ImageItem(itemstring, this.EnterNameImage, 3, null);
        } else {
            this.HiscoreLabel = null;
        }
        itemstring = "";
        i = this.PlayfieldHeight / 180;
        while (i-- > 0) {
            itemstring = itemstring + "\n";
        }
        itemstring = itemstring + "Name:";
        this.EnterNameField = new TextField(itemstring, null, 10, 0);
        this.EnterNameForm.addCommand(this.BtnOk);
        if (this.HiscoreLabel != null) {
            this.EnterNameForm.append((Item)this.HiscoreLabel);
        }
        this.EnterNameForm.append((Item)this.EnterNameField);
        this.EnterNameForm.setCommandListener((CommandListener)this);
        this.EnterNameForm.setItemStateListener((ItemStateListener)this);
        MadMaze.GameDisplay.setCurrent((Displayable)this.EnterNameForm);
        MadMaze.GameDisplay.setCurrentItem((Item)this.EnterNameField);
    }

    public void itemStateChanged(Item item) {
        if (item == this.EnterNameField) {
            String tmpstring = this.EnterNameField.getString();
            int slen = tmpstring.length();
            boolean bchanged = false;
            for (int i = slen - 1; i >= 0; --i) {
                char chr = tmpstring.charAt(i);
                if (!(chr < ' ' || chr >= '\u007f' && chr <= '\u00a0' || chr >= '\u2400' && chr <= '\u243f' || chr == '\u2028') && chr != '\u2029') continue;
                tmpstring = tmpstring.replace(chr, ' ');
                i = tmpstring.length();
                bchanged = true;
            }
            if (bchanged) {
                this.EnterNameField.setString(tmpstring);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.BtnOk) {
            String tmpstring = this.EnterNameField.getString().trim();
            for (int slen = tmpstring.length(); slen < 10; ++slen) {
                tmpstring = tmpstring + '.';
            }
            this.PlayerNames[this.CurrentRankIndex] = tmpstring;
            this.SaveHiscore();
            this.EnterNameForm.removeCommand(this.BtnOk);
            MadMaze.GameDisplay.setCurrent(this.MainDisplayable);
            this.EnterNameFlag = false;
        }
    }

    public class HiscoreComparator
    implements RecordComparator {
        public int compare(byte[] recA, byte[] recB) {
            int delimiteridx;
            String recstring;
            int valueA = 0;
            int valueB = 0;
            try {
                recstring = new String(recA);
                delimiteridx = recstring.indexOf(10);
                if (delimiteridx > 0) {
                    valueA = Integer.valueOf(recstring.substring(0, delimiteridx));
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            try {
                recstring = new String(recB);
                delimiteridx = recstring.indexOf(10);
                if (delimiteridx > 0) {
                    valueB = Integer.valueOf(recstring.substring(0, delimiteridx));
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            int comp = valueA - valueB;
            if (comp > 0) {
                return -1;
            }
            if (comp < 0) {
                return 1;
            }
            return 0;
        }
    }
}

