/*
 * Decompiled with CFR 0.152.
 */
package overthehill.madmaze;

import javax.microedition.lcdui.Graphics;

public final class LineVector {
    static final short LVC_POLY_MASK = -16;
    static final short LVC_POLY_CMD_MASK = 20464;
    static final short LVC_POLY_CMD_SPLIT = 20465;
    static final short LVC_POLY_CMD_SOLID = 20466;
    static final short LVC_POLY_CMD_DOTTED = 20467;
    static final short LVC_POLY_CMD_COLOR = 20468;
    static final short LVC_POLY_CMD_LINED = 20469;
    static final short LVC_POLY_CMD_FILLED = 20470;
    private int m_len;
    private int m_poly_cnt;
    private short[] m_polygons;
    private short[] m_points;
    public static final short[] m_vec_cube_line_obj = new short[]{20469, -128, 128, 128, 128, 128, 128, 128, -128, 128, -128, -128, 128, -128, 128, 128, -128, 128, -128, 128, 128, -128, 128, -128, -128, -128, -128, -128, -128, 128, -128, -128, -128, -128, -128, -128, 128, 128, -128, 128, 128, -128, -128, 128, 128, -128, 128, 128, 128};
    public static final short[] m_vec_cube_filled_obj = new short[]{20470, 20468, 32, 160, 240, -128, 128, 129, 128, 128, 129, 128, -128, 129, 128, -128, 129, -128, -128, 129, -128, 128, 129, -128, 128, -129, 128, 128, -129, 128, -128, -129, 128, -128, -129, -128, -128, -129, -128, 128, -129, -128, -129, -128, -128, -129, 128, 128, -129, 128, 128, -129, 128, 128, -129, -128, -128, -129, -128, -128, 129, -128, -128, 129, 128, 128, 129, 128, 128, 129, 128, 128, 129, -128, -128, 129, -128, 129, -128, 128, 129, -128, -128, 129, 128, -128, 129, 128, -128, 129, 128, 128, 129, -128, 128, -129, -128, 128, -129, -128, -128, -129, 128, -128, -129, 128, -128, -129, 128, 128, -129, -128, 128, 20469, 20468, 255, 200, 0, -128, 128, 128, 128, 128, 128, 128, -128, 128, -128, -128, 128, -128, 128, 128, -128, 128, -128, 128, 128, -128, 128, -128, -128, -128, -128, -128, -128, 128, -128, -128, -128, -128, -128, -128, 128, 128, -128, 128, 128, -128, -128, 128, 128, -128, 128, 128, 128};
    public static final short[] m_vec_crystal_line_obj = new short[]{20469, 20468, 0, 255, 0, -100, -24, 200, -24, -100, 200, 24, -100, 200, 100, -24, 200, 100, 24, 200, 24, 100, 200, -24, 100, 200, -100, 24, 200, -100, -24, 200, 20468, 255, 255, 0, -100, -24, 200, -200, -48, 100, -48, -200, 100, 20468, 0, 255, 0, -24, -100, 200, -100, -24, 200, 20468, 255, 255, 0, -24, -100, 200, -48, -200, 100, 48, -200, 100, 20468, 0, 255, 0, 24, -100, 200, -24, -100, 200, 20468, 255, 255, 0, 24, -100, 200, 48, -200, 100, 200, -48, 100, 20468, 0, 255, 0, 100, -24, 200, 24, -100, 200, 20468, 255, 255, 0, 100, -24, 200, 200, -48, 100, 200, 48, 100, 20468, 0, 255, 0, 100, 24, 200, 100, -24, 200, 20468, 255, 255, 0, 100, 24, 200, 200, 48, 100, 48, 200, 100, 20468, 0, 255, 0, 24, 100, 200, 100, 24, 200, 20468, 255, 255, 0, 24, 100, 200, 48, 200, 100, -48, 200, 100, 20468, 0, 255, 0, -24, 100, 200, 24, 100, 200, 20468, 255, 255, 0, -24, 100, 200, -48, 200, 100, -200, 48, 100, 20468, 0, 255, 0, -100, 24, 200, -24, 100, 200, 20468, 255, 255, 0, -100, 24, 200, -200, 48, 100, -200, -48, 100, 20468, 0, 255, 0, -100, -24, 200, -100, 24, 200, 20465, 20468, 255, 255, 0, 0, 0, -200, -200, -48, 100, -48, -200, 100, 0, 0, -200, 20468, 0, 255, 0, 0, 0, -200, -48, -200, 100, 48, -200, 100, 0, 0, -200, 20468, 255, 255, 0, 0, 0, -200, 48, -200, 100, 200, -48, 100, 0, 0, -200, 20468, 0, 255, 0, 0, 0, -200, 200, -48, 100, 200, 48, 100, 0, 0, -200, 20468, 255, 255, 0, 0, 0, -200, 200, 48, 100, 48, 200, 100, 0, 0, -200, 20468, 0, 255, 0, 0, 0, -200, 48, 200, 100, -48, 200, 100, 0, 0, -200, 20468, 255, 255, 0, 0, 0, -200, -48, 200, 100, -200, 48, 100, 0, 0, -200, 20468, 0, 255, 0, 0, 0, -200, -200, 48, 100, -200, -48, 100, 0, 0, -200};
    private static final short[] m_sinus_table = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 42, 43, 44, 45, 46, 46, 47, 48, 49, 49, 50, 51, 51, 52, 53, 53, 54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 60, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 63, 63, 63, 63, 63, 62, 62, 62, 62, 61, 61, 61, 60, 60, 60, 59, 59, 58, 58, 57, 57, 56, 56, 55, 55, 54, 53, 53, 52, 51, 51, 50, 49, 49, 48, 47, 46, 46, 45, 44, 43, 42, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 32, 31, 30, 29, 28, 27, 26, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 9, 8, 7, 6, 5, 4, 3, 2, 1, -1, -2, -3, -4, -5, -6, -7, -8, -9, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -26, -27, -28, -29, -30, -31, -32, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -42, -43, -44, -45, -46, -46, -47, -48, -49, -49, -50, -51, -51, -52, -53, -53, -54, -55, -55, -56, -56, -57, -57, -58, -58, -59, -59, -60, -60, -60, -61, -61, -61, -62, -62, -62, -62, -63, -63, -63, -63, -63, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -63, -63, -63, -63, -63, -62, -62, -62, -62, -61, -61, -61, -60, -60, -60, -59, -59, -58, -58, -57, -57, -56, -56, -55, -55, -54, -53, -53, -52, -51, -51, -50, -49, -49, -48, -47, -46, -46, -45, -44, -43, -42, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -32, -31, -30, -29, -28, -27, -26, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -9, -8, -7, -6, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 42, 43, 44, 45, 46, 46, 47, 48, 49, 49, 50, 51, 51, 52, 53, 53, 54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 60, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 63, 63, 63, 63, 63, 62, 62, 62, 62, 61, 61, 61, 60, 60, 60, 59, 59, 58, 58, 57, 57, 56, 56, 55, 55, 54, 53, 53, 52, 51, 51, 50, 49, 49, 48, 47, 46, 46, 45, 44, 43, 42, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 32, 31, 30, 29, 28, 27, 26, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 9, 8, 7, 6, 5, 4, 3, 2, 1, -1, -2, -3, -4, -5, -6, -7, -8, -9, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -26, -27, -28, -29, -30, -31, -32, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -42, -43, -44, -45, -46, -46, -47, -48, -49, -49, -50, -51, -51, -52, -53, -53, -54, -55, -55, -56, -56, -57, -57, -58, -58, -59, -59, -60, -60, -60, -61, -61, -61, -62, -62, -62, -62, -63, -63, -63, -63, -63, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -63, -63, -63, -63, -63, -62, -62, -62, -62, -61, -61, -61, -60, -60, -60, -59, -59, -58, -58, -57, -57, -56, -56, -55, -55, -54, -53, -53, -52, -51, -51, -50, -49, -49, -48, -47, -46, -46, -45, -44, -43, -42, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -32, -31, -30, -29, -28, -27, -26, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -9, -8, -7, -6, -5, -4, -3, -2, -1};

    public LineVector() {
        this.Set_Polygons(m_vec_cube_filled_obj);
    }

    public LineVector(short[] polygons) {
        this.Set_Polygons(polygons);
    }

    public short[] Get_Polygons() {
        return this.m_polygons;
    }

    public void Set_Polygons(short[] polygons) {
        int pntcnt = polygons.length;
        this.m_polygons = polygons;
        this.m_points = null;
        this.m_len = 0;
        this.m_poly_cnt = 0;
        boolean bfill = false;
        boolean bsort = false;
        int m_fill_cnt = 3;
        int m_line_cnt = 0;
        if (pntcnt > 0) {
            this.m_points = new short[pntcnt];
            if (this.m_points != null) {
                int xcnt = pntcnt;
                for (int i = 0; i < pntcnt; ++i) {
                    if ((this.m_polygons[i] & 0xFFFFFFF0) == 20464) {
                        if (this.m_polygons[i] == 20468) {
                            xcnt -= 3;
                            i += 3;
                        }
                        if (this.m_polygons[i] == 20470) {
                            bfill = true;
                            bsort = true;
                        }
                        if (this.m_polygons[i] == 20469) {
                            bfill = false;
                        }
                        --xcnt;
                        continue;
                    }
                    if (bfill) {
                        ++m_fill_cnt;
                        continue;
                    }
                    ++m_line_cnt;
                }
                this.m_len = xcnt / 3;
                this.m_poly_cnt = bsort ? m_fill_cnt / 9 + m_line_cnt / 6 : 1;
            }
        }
    }

    public boolean CalcPolygons(int x_angle, int y_angle, int z_angle, int zoom) {
        if (zoom < 1) {
            zoom = 1;
        }
        if (zoom > 8192) {
            zoom = 8192;
        }
        if (x_angle < 0) {
            x_angle += 360;
        }
        if (y_angle < 0) {
            y_angle += 360;
        }
        if (z_angle < 0) {
            z_angle += 360;
        }
        if (x_angle > 359) {
            x_angle -= 360;
        }
        if (y_angle > 359) {
            y_angle -= 360;
        }
        if (z_angle > 359) {
            z_angle -= 360;
        }
        int sdx = 0;
        int ddx = 0;
        for (int i = 0; i < this.m_len; ++i) {
            short xp = this.m_polygons[sdx++];
            while ((xp & 0xFFFFFFF0) == 20464) {
                this.m_points[ddx++] = xp;
                if (xp == 20468) {
                    this.m_points[ddx++] = this.m_polygons[sdx++];
                    this.m_points[ddx++] = this.m_polygons[sdx++];
                    this.m_points[ddx++] = this.m_polygons[sdx++];
                }
                xp = this.m_polygons[sdx++];
            }
            short yp = this.m_polygons[sdx++];
            short zp = this.m_polygons[sdx++];
            int v1 = m_sinus_table[z_angle + 90];
            v1 *= xp;
            int v2 = m_sinus_table[z_angle];
            int av = (v1 -= (v2 *= yp)) >> 6;
            v1 = m_sinus_table[z_angle];
            v1 *= xp;
            v2 = m_sinus_table[z_angle + 90];
            int bv = (v1 += (v2 *= yp)) >> 6;
            v1 = m_sinus_table[y_angle];
            v1 *= av;
            v2 = m_sinus_table[y_angle + 90];
            int cv = (v1 -= (v2 *= zp)) >> 6;
            v1 = m_sinus_table[x_angle];
            v1 *= bv;
            v2 = m_sinus_table[x_angle + 90];
            int zv = v1 -= (v2 *= cv);
            this.m_points[ddx++] = (short)(-zv + 128 >> 10);
            zv += 262144;
            v1 = m_sinus_table[y_angle + 90];
            v1 *= av;
            v2 = m_sinus_table[y_angle];
            v1 += (v2 *= zp);
            v1 *= zoom;
            this.m_points[ddx++] = (short)(v1 /= zv);
            v1 = m_sinus_table[x_angle];
            v1 *= cv;
            v2 = m_sinus_table[x_angle + 90];
            v1 += (v2 *= bv);
            v1 *= zoom;
            this.m_points[ddx++] = (short)(v1 /= zv);
        }
        return true;
    }

    public void DrawObject(Graphics gfx, int xpos, int ypos, int rgb, int brightness) {
        boolean enb;
        if (this.m_len < 4) {
            return;
        }
        int zst = Integer.MAX_VALUE;
        int zod = Integer.MIN_VALUE;
        int cnt = this.m_poly_cnt;
        boolean pin = enb = cnt == 1;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        do {
            if (enb) {
                --cnt;
                gfx.setStrokeStyle(0);
            }
            int sdx = 0;
            int rt = rgb >> 16 & 0xFF;
            int gr = rgb >> 8 & 0xFF;
            int bl = rgb & 0xFF;
            boolean fs = false;
            boolean fl = false;
            for (int i = 0; i < this.m_len; ++i) {
                int bi = this.m_points[sdx++];
                boolean bd = true;
                boolean pc = false;
                boolean pnt = pin;
                while ((bi & 0xFFFFFFF0) == 20464) {
                    switch (bi) {
                        case 20466: {
                            if (!enb) break;
                            gfx.setStrokeStyle(0);
                            break;
                        }
                        case 20467: {
                            if (!enb) break;
                            gfx.setStrokeStyle(1);
                            break;
                        }
                        case 20468: {
                            rt = this.m_points[sdx++];
                            gr = this.m_points[sdx++];
                            bl = this.m_points[sdx++];
                            pc = true;
                            break;
                        }
                        case 20465: {
                            bd = false;
                            break;
                        }
                        case 20469: {
                            fl = false;
                            break;
                        }
                        case 20470: {
                            fl = true;
                            fs = true;
                            break;
                        }
                    }
                    bi = this.m_points[sdx++];
                }
                if (!fl && cnt > 0) break;
                if (!fs) {
                    fs = true;
                    bd = false;
                }
                int zm = bi;
                if (bd) {
                    x2 = xpos + this.m_points[sdx++];
                    y2 = ypos + this.m_points[sdx++];
                    if (fl) {
                        zm += this.m_points[sdx++];
                        x1 = xpos + this.m_points[sdx++];
                        y1 = ypos + this.m_points[sdx++];
                        zm += this.m_points[sdx++];
                        x3 = xpos + this.m_points[sdx++];
                        y3 = ypos + this.m_points[sdx++];
                        i += 2;
                    }
                }
                if (!pnt) {
                    if (enb) {
                        if (zm == zst) {
                            pnt = true;
                        }
                    } else if (zst > zm && zod < zm) {
                        zst = zm;
                    }
                }
                if (bd) {
                    if (enb && (!fl || pc)) {
                        int rc = rt * (bi += brightness) >> 6;
                        int gc = gr * bi >> 6;
                        int bc = bl * bi >> 6;
                        if (rc < 0) {
                            rc = 0;
                        }
                        if (gc < 0) {
                            gc = 0;
                        }
                        if (bc < 0) {
                            bc = 0;
                        }
                        if (rc > 255) {
                            rc = 255;
                        }
                        if (gc > 255) {
                            gc = 255;
                        }
                        if (bc > 255) {
                            bc = 255;
                        }
                        gfx.setColor(rc, gc, bc);
                    }
                    if (fl) {
                        if (!pnt) continue;
                        gfx.fillTriangle(x1, y1, x2, y2, x3, y3);
                        continue;
                    }
                    gfx.drawLine(x1, y1, x2, y2);
                    x1 = x2;
                    y1 = y2;
                    continue;
                }
                x1 = xpos + this.m_points[sdx++];
                y1 = ypos + this.m_points[sdx++];
            }
            if (enb) {
                zod = zst;
                zst = Integer.MAX_VALUE;
                enb = false;
                continue;
            }
            enb = true;
        } while (cnt > 0);
    }
}

