/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EShape;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.Point;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class ERect
extends EShape {
    private int fillType;
    private int width = 50;
    private int height = 50;

    public ERect(int id) {
        super(id);
    }

    public EShape clone() {
        ERect arc = new ERect(-1);
        this.copyProperties(arc);
        arc.setFillType(this.getFillType());
        arc.setWidth(this.getWidth());
        arc.setHeight(this.getHeight());
        return arc;
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setFillType(int fillType) {
        this.fillType = fillType;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void paint(Graphics g, int _x, int _y, int theta, int zoom, int anchorX, int anchorY, Effect parent) {
        Point p = EffectUtil.pointToRotate;
        p.setPoints(this.getX(), this.getY());
        EffectUtil.rotatePoint(p, anchorX, anchorY, theta, zoom, this);
        int _w = EffectUtil.getScaleValue(this.getWidth(), zoom);
        int _h = EffectUtil.getScaleValue(this.getHeight(), zoom);
        if (this.getFillType() == 1 && this.getBgColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBgColor()));
            g.fillRect(p.getX() + _x, p.getY() + _y, _w, _h);
        }
        if (this.getBorderColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBorderColor()));
            EffectUtil.drawRectangle(g, p.getX() + _x, p.getY() + _y, _w, _h, this.getBorderThickness());
        }
    }

    public String toString() {
        return "Rect: " + this.getId();
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        Util.writeInt(bos, this.fillType, 1);
        Util.writeInt(bos, this.width, 2);
        Util.writeInt(bos, this.height, 2);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.fillType = Util.readInt(bis, 1);
        this.width = Util.readInt(bis, 2);
        this.height = Util.readInt(bis, 2);
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2019;
    }
}

