/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import java.util.Stack;
import javax.microedition.lcdui.Graphics;

public class AshaGraphicsUtil {
    public static void fillPolygon(Graphics g, int[] xPoints, int[] yPoints) {
        Stack stack = new Stack();
        AshaGraphicsUtil.fillPolygon(g, xPoints, yPoints, stack);
        while (!stack.isEmpty()) {
            AshaGraphicsUtil.fillPolygon(g, (int[])stack.pop(), (int[])stack.pop(), stack);
        }
    }

    private static void fillPolygon(Graphics g, int[] xPoints, int[] yPoints, Stack stack) {
        while (xPoints.length > 2) {
            int a = AshaGraphicsUtil.indexOfLeast(xPoints);
            int b = (a + 1) % xPoints.length;
            int c = a <= 0 ? xPoints.length - 1 : a - 1;
            int leastInternalIndex = -1;
            boolean leastInternalSet = false;
            if (xPoints.length > 3) {
                for (int i = 0; i < xPoints.length; ++i) {
                    if (i == a || i == b || i == c || !AshaGraphicsUtil.withinBounds(xPoints[i], yPoints[i], xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]) || leastInternalSet && xPoints[i] >= xPoints[leastInternalIndex]) continue;
                    leastInternalIndex = i;
                    leastInternalSet = true;
                }
            }
            if (!leastInternalSet) {
                AshaGraphicsUtil.fillTriangle(g, xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]);
                int[][] trimmed = AshaGraphicsUtil.trimEar(xPoints, yPoints, a);
                xPoints = trimmed[0];
                yPoints = trimmed[1];
                continue;
            }
            int[][][] split = AshaGraphicsUtil.split(xPoints, yPoints, a, leastInternalIndex);
            int[][] poly1 = split[0];
            int[][] poly2 = split[1];
            stack.push(poly2[1]);
            stack.push(poly2[0]);
            stack.push(poly1[1]);
            stack.push(poly1[0]);
            break;
        }
    }

    static boolean withinBounds(int px, int py, int ax, int ay, int bx, int by, int cx, int cy) {
        if (px < AshaGraphicsUtil.min(ax, bx, cx) || px > AshaGraphicsUtil.max(ax, bx, cx) || py < AshaGraphicsUtil.min(ay, by, cy) || py > AshaGraphicsUtil.max(ay, by, cy)) {
            return false;
        }
        boolean sameabc = AshaGraphicsUtil.sameSide(px, py, ax, ay, bx, by, cx, cy);
        boolean samebac = AshaGraphicsUtil.sameSide(px, py, bx, by, ax, ay, cx, cy);
        boolean samecab = AshaGraphicsUtil.sameSide(px, py, cx, cy, ax, ay, bx, by);
        return sameabc && samebac && samecab;
    }

    static int[][][] split(int[] xPoints, int[] yPoints, int aIndex, int bIndex) {
        int index;
        int i;
        int firstLen = bIndex < aIndex ? xPoints.length - aIndex + bIndex + 1 : bIndex - aIndex + 1;
        int secondLen = xPoints.length - firstLen + 2;
        int[][] first = new int[2][firstLen];
        int[][] second = new int[2][secondLen];
        for (i = 0; i < firstLen; ++i) {
            index = (aIndex + i) % xPoints.length;
            first[0][i] = xPoints[index];
            first[1][i] = yPoints[index];
        }
        for (i = 0; i < secondLen; ++i) {
            index = (bIndex + i) % xPoints.length;
            second[0][i] = xPoints[index];
            second[1][i] = yPoints[index];
        }
        int[][][] result = new int[][][]{first, second};
        return result;
    }

    static int[][] trimEar(int[] xPoints, int[] yPoints, int earIndex) {
        int[] newXPoints = new int[xPoints.length - 1];
        int[] newYPoints = new int[yPoints.length - 1];
        int[][] newPoly = new int[][]{newXPoints, newYPoints};
        int p = 0;
        for (int i = 0; i < xPoints.length; ++i) {
            if (i == earIndex) continue;
            newXPoints[p] = xPoints[i];
            newYPoints[p] = yPoints[i];
            ++p;
        }
        return newPoly;
    }

    static int indexOfLeast(int[] elements) {
        int index = 0;
        int least = elements[0];
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i] >= least) continue;
            index = i;
            least = elements[i];
        }
        return index;
    }

    private static boolean sameSide(int p1x, int p1y, int p2x, int p2y, int l1x, int l1y, int l2x, int l2y) {
        long lhs = (p1x - l1x) * (l2y - l1y) - (l2x - l1x) * (p1y - l1y);
        long rhs = (p2x - l1x) * (l2y - l1y) - (l2x - l1x) * (p2y - l1y);
        long product = lhs * rhs;
        boolean result = product >= 0L;
        return result;
    }

    private static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    private static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static void fillTriangle(Graphics g, int X1, int Y1, int X2, int Y2, int X3, int Y3) {
        AshaGraphicsUtil.fillAshatriangle(g, X1, Y1, X2, Y2, X3, Y3);
    }

    private static void fillAshatriangle(Graphics g, int X1, int Y1, int X2, int Y2, int X3, int Y3) {
        int edge3Y;
        int edge3X;
        int edge2Y;
        int edge2X;
        int edge1Y;
        int edge1X;
        if (Y1 > Y2) {
            X1 += X2;
            X2 = X1 - X2;
            X1 -= X2;
            Y1 += Y2;
            Y2 = Y1 - Y2;
            Y1 -= Y2;
        }
        if (Y2 > Y3) {
            X2 += X3;
            X3 = X2 - X3;
            X2 -= X3;
            Y2 += Y3;
            Y3 = Y2 - Y3;
            Y2 -= Y3;
        }
        if (Y1 > Y2) {
            X1 += X2;
            X2 = X1 - X2;
            X1 -= X2;
            Y1 += Y2;
            Y2 = Y1 - Y2;
            Y1 -= Y2;
        }
        if (Y2 - Y1 > 0) {
            edge1X = X2 - X1;
            edge1Y = Y2 - Y1;
        } else {
            edge1X = X2 - X1;
            edge1Y = 1;
        }
        if (Y3 - Y1 > 0) {
            edge2X = X3 - X1;
            edge2Y = Y3 - Y1;
        } else {
            edge2X = 0;
            edge2Y = 1;
        }
        if (Y3 - Y2 > 0) {
            edge3X = X3 - X2;
            edge3Y = Y3 - Y2;
        } else {
            edge3X = 0;
            edge3Y = 1;
        }
        if (X1 < X2) {
            int i;
            for (i = 0; i < Y2 - Y1; ++i) {
                g.drawLine(X1 + ((edge2X << 1) * i + edge2Y) / (edge2Y << 1), Y1 + i, X1 + ((edge1X << 1) * i + edge1Y) / (edge1Y << 1), Y1 + i);
            }
            for (i = 0; i < Y3 - Y2; ++i) {
                g.drawLine(X1 + ((edge2X << 1) * (Y2 - Y1 + i) + edge2Y) / (edge2Y << 1), Y2 + i, X2 + ((edge3X << 1) * i + edge3Y) / (edge3Y << 1), Y2 + i);
            }
        } else {
            int i;
            for (i = 0; i < Y2 - Y1; ++i) {
                g.drawLine(X1 + ((edge1X << 1) * i + edge1Y) / (edge1Y << 1), Y1 + i, X1 + ((edge2X << 1) * i + edge2Y) / (edge2Y << 1), Y1 + i);
            }
            for (i = 0; i < Y3 - Y2; ++i) {
                g.drawLine(X2 + ((edge3X << 1) * i + edge3Y) / (edge3Y << 1), Y2 + i, X1 + ((edge2X << 1) * (Y2 - Y1 + i) + edge2Y) / (edge2Y << 1), Y2 + i);
            }
        }
    }
}

