/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

public class MathFP {
    public static final int DEFAULT_PRECISION = 12;
    private static int precision = 0;
    private static int fracMask = 0;
    private static final int maxPrecision = 30;
    private static final int ePrecision = 29;
    private static final int e = 1459366444;
    private static final int piPrecision = 29;
    private static final int pi = 1686629713;
    private static int oneEightyOverPi;
    private static int piOverOneEighty;
    private static int maxDigitsCount;
    private static int maxDigitsMul;
    public static int ONE;
    public static int HALF;
    public static int TWO;
    public static int E;
    public static int PI;
    public static int PI_HALF;
    public static int PI_TWO;
    public static final int INFINITY = Integer.MAX_VALUE;
    private static final int skPrecision = 31;
    private static final int[] sk;
    private static int[] SK;
    private static final int asPrecision = 30;
    private static final int[] as;
    private static int[] AS;
    private static final int ln2Precision = 30;
    private static final int ln2 = 744261117;
    private static final int ln2_inv = 1549082004;
    private static int LN2;
    private static int LN2_INV;
    private static final int lgPrecision = 31;
    private static final int[] lg;
    private static int[] LG;
    private static final int expPPrecision = 31;
    private static final int[] expP;
    private static int[] EXP_P;
    private static int ATAN2_ZERO_ERROR;

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int precision) {
        int i;
        if (precision > 30 || precision < 0) {
            return;
        }
        MathFP.precision = precision;
        ONE = 1 << precision;
        HALF = ONE >> 1;
        TWO = ONE << 1;
        PI = precision <= 29 ? 1686629713 >> 29 - precision : 1686629713 << precision - 29;
        PI_HALF = PI >> 1;
        PI_TWO = PI << 1;
        E = precision <= 29 ? 1459366444 >> 29 - precision : 1459366444 >> precision - 29;
        for (i = 0; i < sk.length; ++i) {
            MathFP.SK[i] = precision <= 31 ? sk[i] >> 31 - precision : sk[i] << precision - 31;
        }
        for (i = 0; i < as.length; ++i) {
            MathFP.AS[i] = precision <= 30 ? as[i] >> 30 - precision : as[i] << precision - 30;
        }
        LN2 = precision <= 30 ? 744261117 >> 30 - precision : 744261117 << precision - 30;
        LN2_INV = precision <= 30 ? 1549082004 >> 30 - precision : 1549082004 << precision - 30;
        for (i = 0; i < lg.length; ++i) {
            MathFP.LG[i] = precision <= 31 ? lg[i] >> 31 - precision : lg[i] << precision - 31;
        }
        for (i = 0; i < expP.length; ++i) {
            MathFP.EXP_P[i] = precision <= 31 ? expP[i] >> 31 - precision : expP[i] << precision - 31;
        }
        fracMask = ONE - 1;
        piOverOneEighty = MathFP.div(PI, MathFP.toFP(180));
        oneEightyOverPi = MathFP.div(MathFP.toFP(180), PI);
        maxDigitsMul = 1;
        maxDigitsCount = 0;
        i = ONE;
        while (i != 0) {
            i /= 10;
            maxDigitsMul *= 10;
            ++maxDigitsCount;
        }
    }

    public static int convert(int fp, int precision) {
        int xabs = Math.abs(fp);
        if (precision > 30 || precision < 0) {
            return fp;
        }
        int num = precision > MathFP.precision ? xabs >> precision - MathFP.precision : xabs << MathFP.precision - precision;
        if (fp < 0) {
            num = -num;
        }
        return num;
    }

    public static int toFP(int i) {
        return i < 0 ? -(-i << precision) : i << precision;
    }

    public static int toFP(String s) {
        int integer;
        int index;
        int frac = 0;
        String fracString = null;
        boolean neg = false;
        if (s.charAt(0) == '-') {
            neg = true;
            s = s.substring(1);
        }
        if ((index = s.indexOf(46)) < 0) {
            integer = Integer.parseInt(s);
        } else if (index == 0) {
            integer = 0;
            fracString = s.substring(1);
        } else if (index == s.length() - 1) {
            integer = Integer.parseInt(s.substring(0, index));
        } else {
            integer = Integer.parseInt(s.substring(0, index));
            fracString = s.substring(index + 1);
        }
        if (fracString != null) {
            if (fracString.length() > maxDigitsCount) {
                fracString = fracString.substring(0, maxDigitsCount);
            }
            if (fracString.length() > 0) {
                frac = Integer.parseInt(fracString);
                for (int i = maxDigitsCount - fracString.length(); i > 0; --i) {
                    frac *= 10;
                }
            }
        }
        int fp = (integer << precision) + (frac << precision) / maxDigitsMul;
        if (neg) {
            fp = -fp;
        }
        return fp;
    }

    public static int toInt(int fp) {
        return fp < 0 ? -(-fp >> precision) : fp >> precision;
    }

    public static String toString(int fp) {
        int len;
        boolean neg = false;
        if (fp < 0) {
            neg = true;
            fp = -fp;
        }
        int integer = fp >> precision;
        String fracString = String.valueOf((fp & fracMask) * maxDigitsMul >> precision);
        for (int i = len = maxDigitsCount - fracString.length(); i > 0; --i) {
            fracString = "0" + fracString;
        }
        if (neg && integer != 0) {
            integer = -integer;
        }
        return String.valueOf(integer) + "." + fracString.toString();
    }

    public static int ceil(int fp) {
        boolean neg = false;
        if (fp < 0) {
            fp = -fp;
            neg = true;
        }
        if ((fp & fracMask) == 0) {
            return neg ? -fp : fp;
        }
        if (neg) {
            return -(fp & ~fracMask);
        }
        return (fp & ~fracMask) + ONE;
    }

    public static int floor(int fp) {
        boolean neg = false;
        if (fp < 0) {
            fp = -fp;
            neg = true;
        }
        if ((fp & fracMask) == 0) {
            return neg ? -fp : fp;
        }
        if (neg) {
            return -(fp & ~fracMask) - ONE;
        }
        return fp & ~fracMask;
    }

    public static int trunc(int fp) {
        return fp < 0 ? -(-fp & ~fracMask) : fp & ~fracMask;
    }

    public static int frac(int fp) {
        return fp < 0 ? -(-fp & fracMask) : fp & fracMask;
    }

    public static int fracAsInt(int fp) {
        if (fp < 0) {
            fp = -fp;
        }
        return maxDigitsMul * (fp & fracMask) >> precision;
    }

    public static int round(int fp) {
        boolean neg = false;
        if (fp < 0) {
            fp = -fp;
            neg = true;
        }
        fp += HALF;
        return neg ? -fp : (fp &= ~fracMask);
    }

    public static int mul(int fp1, int fp2) {
        return (int)((long)fp1 * (long)fp2 >> precision);
    }

    public static int div(int fp1, int fp2) {
        if (fp1 == 0) {
            return 0;
        }
        if (fp2 == 0) {
            return fp1 < 0 ? -2147483647 : Integer.MAX_VALUE;
        }
        boolean xneg = false;
        boolean yneg = false;
        if (fp1 < 0) {
            xneg = true;
            fp1 = -fp1;
        }
        if (fp2 < 0) {
            yneg = true;
            fp2 = -fp2;
        }
        int msb = 0;
        int lsb = 0;
        while ((fp1 & 1 << 30 - msb) == 0) {
            ++msb;
        }
        while ((fp2 & 1 << lsb) == 0) {
            ++lsb;
        }
        int shifty = precision - (msb + lsb);
        int res = (fp1 << msb) / (fp2 >> lsb);
        res = shifty > 0 ? (res <<= shifty) : (res >>= -shifty);
        if (xneg ^ yneg) {
            res = -res;
        }
        return res;
    }

    public static int sqrt(int fp) {
        int s = fp + ONE >> 1;
        for (int i = 0; i < 8; ++i) {
            s = s + MathFP.div(fp, s) >> 1;
        }
        return s;
    }

    public static int sin(int fp) {
        int sign = 1;
        if ((fp %= PI * 2) < 0) {
            fp = PI * 2 + fp;
        }
        if (fp > PI_HALF && fp <= PI) {
            fp = PI - fp;
        } else if (fp > PI && fp <= PI + PI_HALF) {
            fp -= PI;
            sign = -1;
        } else if (fp > PI + PI_HALF) {
            fp = (PI << 1) - fp;
            sign = -1;
        }
        int sqr = MathFP.mul(fp, fp);
        int result = SK[0];
        result = MathFP.mul(result, sqr);
        result -= SK[1];
        result = MathFP.mul(result, sqr);
        result += ONE;
        result = MathFP.mul(result, fp);
        return sign * result;
    }

    public static int cos(int fp) {
        return MathFP.sin(PI_HALF - fp);
    }

    public static int tan(int fp) {
        return MathFP.div(MathFP.sin(fp), MathFP.cos(fp));
    }

    public static int asin(int fp) {
        boolean neg = false;
        if (fp < 0) {
            neg = true;
            fp = -fp;
        }
        int fRoot = MathFP.sqrt(ONE - fp);
        int result = AS[0];
        result = MathFP.mul(result, fp);
        result += AS[1];
        result = MathFP.mul(result, fp);
        result -= AS[2];
        result = MathFP.mul(result, fp);
        result += AS[3];
        result = PI_HALF - MathFP.mul(fRoot, result);
        if (neg) {
            result = -result;
        }
        return result;
    }

    public static int acos(int fp) {
        return PI_HALF - MathFP.asin(fp);
    }

    public static int atan(int fp) {
        return MathFP.asin(MathFP.div(fp, MathFP.sqrt(ONE + MathFP.mul(fp, fp))));
    }

    public static int atan2(int fpX, int fpY) {
        if (fpX == 0) {
            if (fpY >= 0) {
                return 0;
            }
            if (fpY < 0) {
                return PI;
            }
        } else if (fpY >= -ATAN2_ZERO_ERROR && fpY <= ATAN2_ZERO_ERROR) {
            return fpX > 0 ? PI_HALF : -PI_HALF;
        }
        int z = MathFP.atan(Math.abs(MathFP.div(fpX, fpY)));
        if (fpY > 0) {
            return fpX > 0 ? z : -z;
        }
        return fpX > 0 ? PI - z : z - PI;
    }

    public static int exp(int fp) {
        if (fp == 0) {
            return ONE;
        }
        int xabs = Math.abs(fp);
        int k = MathFP.mul(xabs, LN2_INV);
        k += HALF;
        k &= ~fracMask;
        if (fp < 0) {
            k = -k;
        }
        int z = MathFP.mul(fp -= MathFP.mul(k, LN2), fp);
        int R = TWO + MathFP.mul(z, EXP_P[0] + MathFP.mul(z, EXP_P[1] + MathFP.mul(z, EXP_P[2] + MathFP.mul(z, EXP_P[3] + MathFP.mul(z, EXP_P[4])))));
        int xp = ONE + MathFP.div(MathFP.mul(TWO, fp), R - fp);
        k = k < 0 ? ONE >> (-k >> precision) : ONE << (k >> precision);
        return MathFP.mul(k, xp);
    }

    public static int log(int x) {
        if (x < 0) {
            return 0;
        }
        if (x == 0) {
            return -2147483647;
        }
        int log2 = 0;
        int xi = x;
        while (xi >= TWO) {
            xi >>= 1;
            ++log2;
        }
        int f = xi - ONE;
        int s = MathFP.div(f, TWO + f);
        int z = MathFP.mul(s, s);
        int w = MathFP.mul(z, z);
        int R = MathFP.mul(w, LG[1] + MathFP.mul(w, LG[3] + MathFP.mul(w, LG[5]))) + MathFP.mul(z, LG[0] + MathFP.mul(w, LG[2] + MathFP.mul(w, LG[4] + MathFP.mul(w, LG[6]))));
        return MathFP.mul(LN2, log2 << precision) + f - MathFP.mul(s, f - R);
    }

    public static int log(int fp, int base) {
        return MathFP.div(MathFP.log(fp), MathFP.log(base));
    }

    public static int pow(int fp1, int fp2) {
        if (fp2 == 0) {
            return ONE;
        }
        if (fp1 < 0) {
            return 0;
        }
        return MathFP.exp(MathFP.mul(MathFP.log(fp1), fp2));
    }

    public static int toRadians(int fp) {
        return MathFP.mul(fp, piOverOneEighty);
    }

    public static int toDegrees(int fp) {
        return MathFP.mul(fp, oneEightyOverPi);
    }

    static {
        sk = new int[]{16342350, 356589659};
        SK = new int[sk.length];
        as = new int[]{-20110432, 79737141, 227756102, 1686557206};
        AS = new int[as.length];
        lg = new int[]{0x55555555, 0x33333333, 613566760, 477218077, 390489238, 328862160, 317788895};
        LG = new int[lg.length];
        expP = new int[]{0x15555555, -5965232, 142029, -3550, 88};
        EXP_P = new int[expP.length];
        MathFP.setPrecision(12);
        ATAN2_ZERO_ERROR = 65;
    }
}

