/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

public class LineWalkerWithZ {
    private int initialX;
    private int initialY;
    private int initialZ;
    private int finalX;
    private int finalY;
    private int finalZ;
    private int currentX;
    private int currentY;
    private int currentZ;
    private int xAdder;
    private int yAdder;
    private int zAdder;
    private static final int FP = 12;
    private int steps;
    private int totalPoints;

    public void init(int intialX, int intialY, int initailZ, int finalX, int finalY, int finalZ) {
        this.initialX = intialX;
        this.initialY = intialY;
        this.finalX = finalX;
        this.finalY = finalY;
        this.initialZ = initailZ;
        this.finalZ = finalZ;
        this.init();
    }

    private void init() {
        this.steps = 0;
        this.currentZ = 0;
        this.currentX = 0;
        this.currentY = 0;
        int xDiff = Math.abs(this.initialX - this.finalX);
        int yDiff = Math.abs(this.initialY - this.finalY);
        int zDiff = Math.abs(this.initialZ - this.finalZ);
        this.totalPoints = xDiff > yDiff && xDiff > zDiff ? xDiff : (yDiff > xDiff && yDiff > zDiff ? yDiff : zDiff);
        if (this.totalPoints == 0) {
            this.steps = this.totalPoints + 1;
            return;
        }
        this.xAdder = (xDiff << 12) / this.totalPoints;
        this.yAdder = (yDiff << 12) / this.totalPoints;
        this.zAdder = (zDiff << 12) / this.totalPoints;
        if (this.finalX < this.initialX) {
            this.xAdder = -this.xAdder;
        }
        if (this.finalY < this.initialY) {
            this.yAdder = -this.yAdder;
        }
        if (this.finalZ < this.initialZ) {
            this.zAdder = -this.zAdder;
        }
    }

    public int getX() {
        return this.initialX + (this.currentX >> 12);
    }

    public int getY() {
        return this.initialY + (this.currentY >> 12);
    }

    public int getZ() {
        return this.initialZ + (this.currentZ >> 12);
    }

    public void update(int speed) {
        this.currentX += this.xAdder * speed;
        this.currentY += this.yAdder * speed;
        this.currentZ += this.zAdder * speed;
        this.steps += speed;
    }

    public boolean isOver() {
        return this.steps >= this.totalPoints;
    }
}

