/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.EdgeSweep;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.collide.Intersection;
import net.phys2d.raw.collide.IntersectionGatherer;
import net.phys2d.raw.collide.PolygonPolygonCollider;
import net.phys2d.raw.shapes.Line;
import net.phys2d.raw.shapes.Polygon;

public class LinePolygonCollider
extends PolygonPolygonCollider {
    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        boolean isLeftOf;
        Line line = (Line)bodyA.getShape();
        Polygon poly = (Polygon)bodyB.getShape();
        Vector2f[] vertsA = line.getVertices(bodyA.getPosition(), bodyA.getRotation());
        Vector2f[] vertsB = poly.getVertices(bodyB.getPosition(), bodyB.getRotation());
        Vector2f pos = poly.getCentroid(bodyB.getPosition(), bodyB.getRotation());
        boolean bl = isLeftOf = 0.0f > (pos.x - vertsA[0].x) * (vertsA[1].y - vertsA[0].y) - (vertsA[1].x - vertsA[0].x) * (pos.y - vertsA[0].y);
        if (isLeftOf) {
            Vector2f tmp = vertsA[0];
            vertsA[0] = vertsA[1];
            vertsA[1] = tmp;
        }
        Vector2f normal = new Vector2f(vertsA[1]);
        normal.sub(vertsA[0]);
        normal.set(normal.y, -normal.x);
        EdgeSweep sweep = new EdgeSweep(normal);
        sweep.insert(0, true, vertsA[0].dot(normal));
        sweep.insert(0, true, vertsA[1].dot(normal));
        sweep.addVerticesToSweep(false, vertsB);
        int[][] collEdgeCands = sweep.getOverlappingEdges();
        IntersectionGatherer intGath = new IntersectionGatherer(vertsA, vertsB);
        for (int i = 0; i < collEdgeCands.length; ++i) {
            intGath.intersect(collEdgeCands[i][0], collEdgeCands[i][1]);
        }
        Intersection[] intersections = intGath.getIntersections();
        return this.populateContacts(contacts, vertsA, vertsB, intersections);
    }

    public int populateContacts(Contact[] contacts, Vector2f[] vertsA, Vector2f[] vertsB, Intersection[] intersections) {
        if (intersections.length == 0) {
            return 0;
        }
        int noContacts = 0;
        if (!intersections[0].isIngoing) {
            this.setLineEndContact(contacts[noContacts], intersections[intersections.length - 1], vertsA, vertsB);
            if (contacts[noContacts].getSeparation() < -10.0f) {
                System.out.println("first " + contacts[noContacts].getSeparation());
            }
            ++noContacts;
        }
        int i = noContacts;
        while (i < intersections.length - 1) {
            if (noContacts > contacts.length - 2) {
                return noContacts;
            }
            if (!intersections[i].isIngoing || intersections[i + 1].isIngoing) {
                this.setContact(contacts[noContacts], intersections[i], vertsA, vertsB);
                ++i;
                ++noContacts;
                continue;
            }
            this.setContactPair(contacts[noContacts], contacts[noContacts + 1], intersections[i], intersections[i + 1], vertsA, vertsB);
            if (contacts[noContacts].getSeparation() < -10.0f) {
                System.out.println("m " + contacts[noContacts].getSeparation());
            }
            noContacts += 2;
            i += 2;
        }
        if (i < intersections.length && intersections[intersections.length - 1].isIngoing && noContacts < contacts.length) {
            this.setLineEndContact(contacts[noContacts], intersections[intersections.length - 1], vertsA, vertsB);
            if (contacts[noContacts].getSeparation() < -10.0f) {
                System.out.println(" last " + contacts[noContacts].getSeparation());
            }
            ++noContacts;
        }
        return noContacts;
    }

    public void setLineEndContact(Contact contact, Intersection intersection, Vector2f[] vertsA, Vector2f[] vertsB) {
        Vector2f separation = new Vector2f(intersection.position);
        if (intersection.isIngoing) {
            separation.sub(vertsA[1]);
        } else {
            separation.sub(vertsA[0]);
        }
        float depthA = 0.0f;
        contact.setSeparation(-depthA);
        contact.setNormal(MathUtil.getNormal(vertsB[(intersection.edgeB + 1) % vertsB.length], vertsB[intersection.edgeB]));
        contact.setPosition(intersection.position);
        contact.setFeature(new FeaturePair(0, 0, intersection.edgeA, intersection.edgeB));
    }
}

