/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.util.Utility;

public class ParabolicPath {
    int _iInitialX = 400;
    int _iInitialY = 200;
    private int _iFinalX = 200;
    int _iFinalY = 200;
    int _iInitialHeight = 0;
    int _iMaxHeight = 30;
    int _iFinalHeight = 0;
    int _iCurrentX = this._iInitialX;
    int _iCurrentY = this._iInitialY;
    int _iCurrentHeight = this._iInitialHeight;
    int iCoordinateXAdder = 0;
    int iCoordinateYAdder = 0;
    int iCoordinateZAdder1 = 0;
    int iCoordinateZAdder2 = 0;
    int iTotalPoints = 0;
    int iReductionFactor1 = 0;
    int iReductionFactor2 = 0;
    int _iAngularAngle = 0;
    int _iVerticalAngle = 0;
    int _iVelocity = 0;
    int shadowX;
    int shadowY;
    int mShadow;
    int cShadow;
    boolean onFirstHalf = true;
    int iStep;
    int iHalf;
    boolean hasFall = false;

    public int getX() {
        if (this.hasFall()) {
            return this.getiFinalX();
        }
        return this._iInitialX + (this._iCurrentX >> 14);
    }

    public int getY() {
        int tmpY = this._iInitialY + (this._iCurrentY >> 14) - (this._iCurrentHeight >> 14) - this._iInitialHeight;
        if (!this.onFirstHalf && tmpY >= this._iFinalY) {
            return this._iFinalY;
        }
        return tmpY;
    }

    public int getiVelocity() {
        return this._iVelocity;
    }

    public void ballInit(int iInitialX, int iInitialY, int finalX, int finalY, int iFinalHeight) {
        this.onFirstHalf = true;
        this.hasFall = false;
        this.shadowX = this._iInitialX = iInitialX;
        this.shadowY = this._iInitialY = iInitialY;
        this._iCurrentX = iInitialX;
        this._iCurrentY = iInitialY;
        this._iVelocity = 0;
        this._iInitialHeight = 0;
        if (Math.abs(iInitialY - finalY) > iFinalHeight) {
            iFinalHeight = Math.abs(iInitialY - finalY) + 5;
        }
        this._iFinalHeight = iFinalHeight;
        int[] iBallFinalXY = new int[]{finalX, finalY};
        if (finalX == iInitialX) {
            ++finalX;
        }
        this.mShadow = (iInitialY - finalY << 14) / (iInitialX - finalX);
        this.cShadow = finalY - (this.mShadow * finalX >> 14);
        this._iMaxHeight = this._iInitialHeight + this._iFinalHeight;
        this.setiFinalX(iBallFinalXY[0]);
        this._iFinalY = iBallFinalXY[1];
        this.calDiff(this._iInitialX, this.getiFinalX(), this._iInitialY, this._iFinalY, this._iInitialHeight, this._iMaxHeight, this._iFinalHeight);
    }

    public void ballInit(int iInitialX, int iInitialY, int iAngularAngle, int iVerticalAngle, int iVelocity, int iInitialHeight, int iFinalHeight) {
        this.onFirstHalf = true;
        this.hasFall = false;
        this._iInitialX = iInitialX;
        this._iInitialY = iInitialY;
        this._iCurrentX = iInitialX;
        this._iCurrentY = iInitialY;
        this._iAngularAngle = iAngularAngle;
        this._iVerticalAngle = iVerticalAngle;
        this._iVelocity = iVelocity;
        this._iInitialHeight = iInitialHeight;
        this._iFinalHeight = iFinalHeight;
        this._iMaxHeight = this._iInitialHeight + this._iFinalHeight;
        this.FinalPoint(this._iInitialX, this._iInitialY, this._iAngularAngle, this._iVerticalAngle, this._iVelocity);
        this.calDiff(this._iInitialX, this.getiFinalX(), this._iInitialY, this._iFinalY, this._iInitialHeight, this._iMaxHeight, this._iFinalHeight);
    }

    public void calDiff(int iInitialX, int iFinalX, int iInitialY, int iFinalY, int iInitialHeight, int iMaxHeight, int iFinalHeight) {
        iFinalHeight = 2 * iFinalHeight - this._iInitialHeight;
        iMaxHeight += iMaxHeight - iInitialHeight;
        int iDiffX = Math.abs(iFinalX - iInitialX);
        int iDiffY = Math.abs(iFinalY - iInitialY);
        int iDiffZ1 = Math.abs(iMaxHeight - iInitialHeight);
        int iDiffZ2 = Math.abs(iMaxHeight - iInitialHeight);
        int iDiffZ = iDiffZ1 + iDiffZ2;
        if (iDiffX >= iDiffY && iDiffX >= iDiffZ) {
            this.iTotalPoints = iDiffX;
            this.iCoordinateXAdder = (iDiffX << 14) / iDiffX;
            this.iCoordinateYAdder = (iDiffY << 14) / iDiffX;
            this.iCoordinateZAdder1 = (iDiffZ1 << 14) / (iDiffX / 2);
            this.iCoordinateZAdder2 = (iDiffZ2 << 14) / (iDiffX / 2);
            this.iReductionFactor1 = 2 * this.iCoordinateZAdder1 / this.iTotalPoints;
            this.iReductionFactor2 = 2 * this.iCoordinateZAdder2 / this.iTotalPoints;
        } else if (iDiffY >= iDiffX && iDiffY >= iDiffZ) {
            this.iTotalPoints = iDiffY;
            this.iCoordinateXAdder = (iDiffX << 14) / iDiffY;
            this.iCoordinateYAdder = (iDiffY << 14) / iDiffY;
            this.iCoordinateZAdder1 = (iDiffZ1 << 14) / (iDiffY / 2);
            this.iCoordinateZAdder2 = (iDiffZ2 << 14) / (iDiffY / 2);
            this.iReductionFactor1 = 2 * this.iCoordinateZAdder1 / this.iTotalPoints;
            this.iReductionFactor2 = 2 * this.iCoordinateZAdder2 / this.iTotalPoints;
        } else if (iDiffZ >= iDiffX && iDiffZ >= iDiffY) {
            this.iTotalPoints = iDiffZ;
            this.iCoordinateXAdder = (iDiffX << 14) / iDiffZ;
            this.iCoordinateYAdder = (iDiffY << 14) / iDiffZ;
            this.iCoordinateZAdder1 = (iDiffZ1 << 14) / (iDiffZ / 2);
            this.iCoordinateZAdder2 = (iDiffZ2 << 14) / (iDiffZ / 2);
            this.iReductionFactor1 = 2 * this.iCoordinateZAdder1 / this.iTotalPoints;
            this.iReductionFactor2 = 2 * this.iCoordinateZAdder2 / this.iTotalPoints;
        }
        if (iFinalX < iInitialX) {
            this.iCoordinateXAdder = 0 - this.iCoordinateXAdder;
        }
        if (iFinalY < iInitialY) {
            this.iCoordinateYAdder = 0 - this.iCoordinateYAdder;
        }
        this.iHalf = this.iTotalPoints / 2;
        this.iStep = 0;
    }

    public boolean isFalling() {
        return !this.onFirstHalf;
    }

    public void update(int speed) {
        int iSpeedFactor = speed;
        for (int j = 2; j < 6; ++j) {
            for (int i = 0; i < iSpeedFactor; ++i) {
                this._iCurrentX += this.iCoordinateXAdder;
                this._iCurrentY += this.iCoordinateYAdder;
                this.shadowX = this.getX();
                this.shadowY = (this.mShadow * this.shadowX >> 14) + this.cShadow;
                if (this.iStep < this.iHalf && this.onFirstHalf) {
                    this._iCurrentHeight += this.iCoordinateZAdder1;
                    this.iCoordinateZAdder1 -= this.iReductionFactor1;
                } else {
                    this.onFirstHalf = false;
                    this._iCurrentHeight -= this.iCoordinateZAdder1;
                    this.iCoordinateZAdder1 += this.iReductionFactor2;
                }
                --this.iTotalPoints;
                ++this.iStep;
            }
        }
    }

    public int getShadowX() {
        if (this.hasFall()) {
            this.shadowX = this.getX();
        }
        return this.shadowX;
    }

    public int getShadowY() {
        if (this.hasFall()) {
            this.shadowY = this.getY();
        }
        return this.shadowY;
    }

    public boolean hasFall() {
        return !this.onFirstHalf && this.getY() >= this._iFinalY;
    }

    public void FinalPoint(int iInitialX, int iInitialY, int iAngularAngle, int iVerAngle, int iVelocity) {
        int iTmpX = 0;
        int iTmpY = 0;
        int iFinalX = 0;
        int iFinalY = 0;
        int iRange = iVelocity * iVelocity * Utility.sin(2 * iVerAngle) / 10;
        iTmpX = (iRange >> 16) * Utility.cos(iAngularAngle);
        iTmpY = (iRange >> 16) * Utility.sin(iAngularAngle);
        iFinalX = Math.abs(iTmpX) >> 16;
        iFinalY = Math.abs(iTmpY) >> 16;
        if (iTmpX < 0) {
            iFinalX = 0 - iFinalX;
        }
        if (iTmpY < 0) {
            iFinalY = 0 - iFinalY;
        }
        this.setiFinalX(iInitialX + iFinalX);
        this._iFinalY = iInitialY + iFinalY;
    }

    public int getiInitialY() {
        return this._iInitialY;
    }

    public int getiCurrentHeight() {
        return this._iCurrentHeight;
    }

    public int getiCurrentX() {
        return this._iCurrentX;
    }

    public int getiCurrentY() {
        return this._iCurrentY;
    }

    public int getiInitialX() {
        return this._iInitialX;
    }

    public int getiFinalHeight() {
        return this._iFinalHeight;
    }

    public int getiFinalX() {
        return this._iFinalX;
    }

    public void setiFinalX(int iFinalX) {
        this._iFinalX = iFinalX;
    }
}

