/*
 * Decompiled with CFR 0.152.
 */
import org.j4me.util.MathFunc;

public class Coordinates {
    public double lon;
    public double lat;
    public double e;
    public float altitude;
    public long time = System.currentTimeMillis();
    public static final double METERS_PER_RADIAN = 6371000.0;
    public static final double RADIUS = 6372795.0;

    public static double distance(Coordinates coordinates, Coordinates coordinates2) {
        double d = Math.toRadians(coordinates.lat);
        double d2 = Math.toRadians(coordinates.lon);
        double d3 = Math.toRadians(coordinates2.lat);
        double d4 = Math.toRadians(coordinates2.lon);
        double d5 = Math.sin((d - d3) / (double)2);
        d5 *= d5;
        double d6 = Math.cos(d) * Math.cos(d3);
        double d7 = Math.sin((d2 - d4) / (double)2);
        d7 *= d7;
        double d8 = 1.2742E7;
        double d9 = Math.sqrt(d5 + d6 * d7);
        return d8 * MathFunc.asin(d9);
    }

    public static float curse(Coordinates coordinates, Coordinates coordinates2) {
        double d = Math.toRadians(coordinates.lat);
        double d2 = Math.toRadians(coordinates.lon);
        double d3 = Math.toRadians(coordinates2.lat);
        double d4 = Math.toRadians(coordinates2.lon);
        double d5 = d4 - d2;
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d5) * d6;
        double d8 = Math.cos(d) * Math.sin(d3) - Math.sin(d) * d6 * Math.cos(d5);
        double d9 = MathFunc.atan2(d7, d8);
        double d10 = Math.toDegrees(d9);
        d10 = (360.0 + d10) % 360.0;
        return (float)d10;
    }

    public static double speed(Coordinates coordinates, Coordinates coordinates2) {
        double d = Math.abs(coordinates2.time - coordinates.time);
        double d2 = Coordinates.distance(coordinates, coordinates2) * 1000.0;
        double d3 = d2 / (d /= 3600000.0);
        return d3;
    }

    public String toString() {
        String string;
        if (!(this.lat < 0.0)) {
            string = String.valueOf(new Double(this.lat));
            string = String.valueOf(string).concat("\u00b0N ");
        } else {
            string = String.valueOf(new Double((double)-1 * this.lat));
            string = String.valueOf(string).concat("\u00b0S ");
        }
        if (!(this.lon < 0.0)) {
            string = String.valueOf(string).concat(String.valueOf(String.valueOf(new Double(this.lon))));
            string = String.valueOf(string).concat("\uffc2");
        } else {
            string = String.valueOf(string).concat(String.valueOf(String.valueOf(new Double((double)-1 * this.lon))));
            string = String.valueOf(string).concat("\uffc2");
        }
        if (!Float.isNaN(this.altitude)) {
            string = String.valueOf(string).concat(String.valueOf(" ".concat(String.valueOf(this.altitude)).concat("m")));
        }
        return string;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public void setAltitude(float f) {
        this.altitude = f;
    }

    public void setLatitude(double d) {
        if (Double.isNaN(d) || d < -90.0 || !(d < 90.0)) {
            throw new IllegalArgumentException("Latitude (".concat(String.valueOf(d)).concat(") is invalid."));
        }
        this.lat = d;
    }

    public void setLongitude(double d) {
        if (Double.isNaN(d) || d < -180.0 || !(d < 180.0)) {
            throw new IllegalArgumentException("Longitude (".concat(String.valueOf(d)).concat(") is invalid."));
        }
        this.lon = d;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLongitude() {
        return this.lon;
    }

    public boolean equals(Object object) {
        double d = 1.0E-6;
        if (object == null) {
            return false;
        }
        if (!(object instanceof Coordinates)) {
            return false;
        }
        Coordinates coordinates = (Coordinates)object;
        if (this.lat < coordinates.lat - d || !(this.lat <= coordinates.lat + d)) {
            return false;
        }
        if (this.lon < coordinates.lon - d || !(this.lon <= coordinates.lon + d)) {
            return false;
        }
        if (Float.isNaN(this.altitude) && !Float.isNaN(coordinates.altitude)) {
            return false;
        }
        if (!Float.isNaN(this.altitude) && Float.isNaN(coordinates.altitude)) {
            return false;
        }
        if (Float.isNaN(this.altitude) && Float.isNaN(coordinates.altitude)) {
            return true;
        }
        return !((double)this.altitude < (double)coordinates.altitude - d) && (double)this.altitude <= (double)coordinates.altitude + d;
    }

    public int hashCode() {
        int n = 7;
        n = 23 * n + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
        n = 23 * n + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32);
        return n;
    }

    public Coordinates(double d, double d2, float f) {
        this.setLatitude(d);
        this.setLongitude(d2);
        this.setAltitude(f);
    }

    public Coordinates(double d, double d2) {
        this.setLatitude(d);
        this.setLongitude(d2);
        this.setAltitude(0.0f);
    }

    public Coordinates() {
        this.setLatitude(0.0);
        this.setLongitude(0.0);
        this.setAltitude(0.0f);
    }
}

