/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.io.Connector;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class SensorApi
implements DataListener {
    public int[] channels;
    public String[] channelNames;
    public SensorConnection sensor;
    public String URL;
    public int numChannels;
    public int dataType;
    public double minValue;
    public double maxValue;

    public static String getSensor(int n) {
        String string = "battery_charge";
        switch (n) {
            case 1: {
                string = "network_field_intensity";
                break;
            }
            case 2: {
                string = "com.sonyericsson.io.sensor.steps_per_minute";
                break;
            }
            case 3: {
                string = "step_count";
                break;
            }
            case 4: {
                string = "acceleration";
                break;
            }
        }
        try {
            SensorInfo[] sensorInfoArray = SensorManager.findSensors((String)string, null);
            SensorConnection sensorConnection = (SensorConnection)Connector.open((String)sensorInfoArray[0].getUrl());
            Data[] dataArray = sensorConnection.getData(1);
            return String.valueOf(dataArray[0].getIntValues()[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "0";
        }
    }

    public void getInfo() {
        SensorInfo[] sensorInfoArray = SensorManager.findSensors(null, null);
        if (sensorInfoArray == null || sensorInfoArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < sensorInfoArray.length) {
            String string = sensorInfoArray[n].getQuantity().toLowerCase();
            if (string.startsWith("accel")) {
                SensorInfo sensorInfo = sensorInfoArray[n];
                this.URL = sensorInfo.getUrl();
                ChannelInfo[] channelInfoArray = sensorInfo.getChannelInfos();
                this.numChannels = channelInfoArray.length;
                this.channels = new int[this.numChannels];
                this.channelNames = new String[this.numChannels];
                this.dataType = channelInfoArray[0].getDataType();
                MeasurementRange measurementRange = channelInfoArray[0].getMeasurementRanges()[0];
                this.minValue = measurementRange.getSmallestValue();
                this.maxValue = measurementRange.getLargestValue();
                int n2 = 0;
                while (n2 < this.numChannels) {
                    this.channelNames[n2] = channelInfoArray[n2].getName();
                    ++n2;
                }
            }
            ++n;
        }
        try {
            this.sensor = (SensorConnection)Connector.open((String)this.URL);
            this.sensor.setDataListener((DataListener)this, 1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void dataReceived(SensorConnection sensorConnection, Data[] dataArray, boolean bl) {
        int n = 0;
        while (n < dataArray.length) {
            int n2 = 0;
            while (n2 < this.numChannels) {
                String string = dataArray[n].getChannelInfo().getName();
                if (string.equals(this.channelNames[n2])) {
                    this.channels[n2] = this.getValue(dataArray[n]);
                }
                ++n2;
            }
            ++n;
        }
    }

    public int getValue(Object object) {
        int n = 0;
        double d = 0.0;
        if (this.dataType == 2) {
            d = ((Data)object).getIntValues()[0];
        } else if (this.dataType == 1) {
            d = ((Data)object).getDoubleValues()[0];
        }
        n = !(d < 0.0) ? (int)(d * (double)1024 / this.maxValue) : (int)(d * (double)-1024 / this.minValue);
        return n;
    }

    public SensorApi() {
        this.getInfo();
    }
}

