/*
 * Decompiled with CFR 0.152.
 */
package gps.tracker;

import gps.Debug;
import gps.tracker.FileIOListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

class Write
implements Runnable {
    private String filePath;
    private static FileConnection fc = null;
    private static PrintStream dos = null;
    private Vector coordVector = new Vector();
    private FileIOListener listener;

    Write(String filePath, FileIOListener listener) {
        this.listener = listener;
        this.filePath = filePath;
    }

    void save(Vector coord) {
        this.coordVector = coord;
        Thread t = new Thread(this);
        t.start();
    }

    private void saveData() throws IOException {
        try {
            Debug.setDebug("tracker saving in " + this.filePath, 1);
            fc = (FileConnection)Connector.open((String)("file://" + this.filePath), (int)3);
            if (!fc.exists()) {
                fc.create();
                Debug.setDebug("file created", 2);
            } else {
                Debug.setDebug(this.filePath + " overwritten", 1);
                fc.delete();
                fc.create();
            }
            dos = new PrintStream(fc.openOutputStream());
            dos.print("site,long,lat,time,altitude\r\n");
            for (int i = 0; i <= this.coordVector.size() - 1; ++i) {
                dos.print(this.coordVector.elementAt(i).toString());
                dos.print("\r\n");
            }
        }
        catch (Exception e) {
            throw new IOException("Error, can't record in " + this.filePath);
        }
        finally {
            if (dos != null) {
                dos.flush();
                dos.close();
            }
            if (fc != null) {
                fc.close();
            }
            Debug.setDebug("File has finished to be saved", 1);
            this.listener.fileWritten(0);
        }
    }

    public void run() {
        try {
            this.saveData();
        }
        catch (IOException ex) {
            this.listener.fileWritten(1);
        }
    }
}

