/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.DeviceScreen;
import com.gui.GUIChoice;
import com.gui.GUICommand;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GUIList
extends DeviceScreen
implements GUIChoice {
    private String[] items;
    private int totalItem;
    private int maxItem;
    private int showItem;
    private int startIndex;
    private int cursorY;
    private int cursorPosition;
    private int runnerY;
    private int runnerHeight;
    private int runnerMinHeight = 15;
    private int runnerWidth = 5;
    private double rs;
    private double ss;
    private boolean flagHideAll = false;
    private boolean[] hideFlags;
    private Image[] icons;
    public static final GUICommand SELECT_COMMAND = new GUICommand("OK", 1);
    private int type;
    private boolean[] selectedFlags;

    public GUIList(String titleName, int type, String[] stringParts, Image[] imageParts) {
        this.title = titleName;
        this.setType(type);
        this.setAppend(stringParts, imageParts, null, null);
        if (type == 3) {
            this.addCommand(SELECT_COMMAND);
        }
    }

    void showNotifyScreen() {
    }

    void hideNotifyScreen() {
    }

    private void setType(int t) {
        this.type = t == 2 ? 2 : (t == 1 ? 1 : 3);
    }

    private boolean[] flagReset(boolean b) {
        int s = this.totalItem;
        if (s > 0) {
            boolean[] ar = new boolean[s];
            for (int i = 0; i < s; ++i) {
                ar[i] = b;
            }
            return ar;
        }
        return null;
    }

    private void resetIcons() {
        int s = this.totalItem;
        if (s > 0) {
            this.icons = new Image[s];
            for (int i = 0; i < s; ++i) {
                this.icons[i] = null;
            }
        }
    }

    private void cursorFlag() {
        int s = this.totalItem;
        int sh = this.hideFlags == null ? 0 : this.hideFlags.length;
        if (s > 0) {
            for (int i = 0; i < sh && !this.hideFlags[i]; ++i) {
                if (this.cursorPosition == s - 1) {
                    this.cursorPosition = -1;
                    this.cursorY = this.HEIGHT + 10;
                    this.runnerY = 0;
                    this.rs = 0.0;
                    break;
                }
                if (this.cursorPosition > this.showItem - 1) {
                    ++this.cursorPosition;
                    ++this.startIndex;
                    this.rs += this.ss;
                    this.runnerY = (int)this.rs + 0;
                    continue;
                }
                ++this.cursorPosition;
                this.cursorY += this.itemHeight;
            }
        }
    }

    private void setScroll() {
        int s = this.totalItem;
        if (s > 0) {
            this.runnerHeight = this.clipHeight - this.itemHeight * (s - this.showItem);
            if (this.runnerHeight <= this.runnerMinHeight) {
                this.runnerHeight = this.runnerMinHeight;
                this.ss = (double)(this.clipHeight - this.runnerHeight) / (double)(s - this.showItem + 1);
            } else {
                this.ss = this.itemHeight;
            }
        }
    }

    void reset() {
        this.maxItem = this.clipHeight / this.itemHeight;
        this.showItem = this.totalItem >= this.maxItem ? this.maxItem : this.totalItem;
        this.cursorY = 0;
        this.runnerY = 0;
        this.cursorPosition = 0;
        this.startIndex = 0;
        this.rs = 0.0;
        this.setScroll();
        this.cursorFlag();
    }

    final void paintScreen(Graphics g, int width, int height) {
        int s = this.totalItem;
        int ith = this.itemHeight;
        if (s > 0) {
            if (s > this.showItem) {
                GUIManager.getTheme().gradientFill(g, 0, this.cursorY, width - this.runnerWidth - 1, ith, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                g.setColor(GUIManager.getTheme().cursorFrameRGB);
                g.drawRect(0, this.cursorY, width - this.runnerWidth - 1, ith);
            } else {
                GUIManager.getTheme().gradientFill(g, 0, this.cursorY, width - 1, ith, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                g.setColor(GUIManager.getTheme().cursorFrameRGB);
                g.drawRect(0, this.cursorY, width - 1, ith);
            }
        }
        int ys = 0;
        int js = 0;
        int xs = 2;
        g.setFont(this.itemFont);
        Image[] w_img = GUIManager.getImages();
        for (int i = this.startIndex; i < s; ++i) {
            int ih;
            int iw;
            boolean b = this.selectedFlags[i];
            Image img = this.icons[i];
            int yss = ys + ith / 2;
            if (this.type == 1) {
                if (w_img != null) {
                    iw = w_img[2].getWidth();
                    ih = w_img[2].getHeight();
                    if (iw <= 30 && ih <= ith) {
                        if (b) {
                            GUIGraphics.drawImage(g, w_img[3], xs, yss, 6);
                        } else {
                            GUIGraphics.drawImage(g, w_img[2], xs, yss, 6);
                        }
                        xs = xs + iw + 2;
                    }
                }
            } else if (this.type == 2 && w_img != null) {
                iw = w_img[0].getWidth();
                ih = w_img[0].getHeight();
                if (iw <= 30 && ih <= ith) {
                    if (b) {
                        GUIGraphics.drawImage(g, w_img[1], xs, yss, 6);
                    } else {
                        GUIGraphics.drawImage(g, w_img[0], xs, yss, 6);
                    }
                    xs = xs + iw + 2;
                }
            }
            if (img != null) {
                iw = img.getWidth();
                ih = img.getHeight();
                if (iw <= 30 && ih <= ith + 5) {
                    GUIGraphics.drawImage(g, img, xs, yss, 6);
                    xs = xs + iw + 2;
                }
            }
            g.setColor(GUIManager.getTheme().itemRGB);
            if (!this.hideFlags[i]) {
                g.setColor(GUIManager.getTheme().itemHideRGB);
            }
            if (i == this.cursorPosition) {
                g.setColor(GUIManager.getTheme().itemPasteRGB);
            }
            GUIGraphics.drawString(g, this.items[i], xs, ys + 2, 0);
            ys += ith;
            xs = 2;
            if (++js == this.showItem) break;
        }
        this.scroll(g, width, height);
    }

    final void keyPress(int key) {
        if (key == GUIManager.DOWN || GUIManager.isDuplicationOfKeysOfNavigation() && key == 56) {
            this.down();
        }
        if (key == GUIManager.UP || GUIManager.isDuplicationOfKeysOfNavigation() && key == 50) {
            this.up();
        }
        if (key == GUIManager.FIRE || GUIManager.isDuplicationOfKeysOfNavigation() && key == 53) {
            switch (this.type) {
                case 2: {
                    if (this.selectedFlags[this.getSelectedIndex()]) {
                        this.setSelectedFlag(this.getSelectedIndex(), false);
                        break;
                    }
                    this.setSelectedFlag(this.getSelectedIndex(), true);
                    break;
                }
                case 1: {
                    this.setSelectedFlag(this.getSelectedIndex(), true);
                    break;
                }
                default: {
                    this.guicl.commandAction(SELECT_COMMAND, this);
                }
            }
        }
    }

    final void keyRepeat(int key) {
        this.keyPress(key);
    }

    private void down() {
        int s = this.totalItem;
        int ih = this.itemHeight;
        int si = this.showItem - 1;
        if (s > 1 && !this.flagHideAll) {
            if (this.cursorPosition == s - 1) {
                this.cursorY = 0;
                this.runnerY = 0;
                this.rs = 0.0;
                this.cursorPosition = 0;
                this.startIndex = 0;
            } else if (this.cursorPosition >= si && this.cursorY == si * ih) {
                ++this.startIndex;
                ++this.cursorPosition;
                this.rs += this.ss;
                this.runnerY = (int)this.rs;
            } else {
                this.cursorY += ih;
                ++this.cursorPosition;
            }
            if (s > 0) {
                while (!this.hideFlags[this.cursorPosition]) {
                    if (this.cursorPosition == s - 1) {
                        this.cursorPosition = 0;
                        this.startIndex = 0;
                        this.cursorY = 0;
                        this.runnerY = 0;
                        this.rs = 0.0;
                        continue;
                    }
                    if (this.cursorPosition >= si && this.cursorY == si * ih) {
                        ++this.cursorPosition;
                        ++this.startIndex;
                        this.rs += this.ss;
                        this.runnerY = (int)this.rs;
                        continue;
                    }
                    ++this.cursorPosition;
                    this.cursorY += ih;
                }
            }
        }
    }

    private void up() {
        int s = this.totalItem;
        int ih = this.itemHeight;
        int si = this.showItem;
        if (s > 1 && !this.flagHideAll) {
            if (this.cursorPosition == 0) {
                this.cursorPosition = s - 1;
                this.cursorY = (si - 1) * ih;
                this.runnerY = this.clipHeight - this.runnerHeight;
                this.rs = this.runnerY;
                this.startIndex = s - si;
            } else if (this.cursorY == 0) {
                --this.cursorPosition;
                --this.startIndex;
                this.rs -= this.ss;
                this.runnerY = (int)this.rs;
            } else {
                --this.cursorPosition;
                this.cursorY -= ih;
            }
            if (s > 0) {
                while (!this.hideFlags[this.cursorPosition]) {
                    if (this.cursorPosition == 0) {
                        this.cursorPosition = s - 1;
                        this.cursorY = (si - 1) * ih;
                        this.runnerY = this.clipHeight - this.runnerHeight - 1;
                        this.rs = this.runnerY;
                        this.startIndex = s - si;
                        continue;
                    }
                    if (this.cursorY == 0) {
                        --this.cursorPosition;
                        --this.startIndex;
                        this.rs -= this.ss;
                        this.runnerY = (int)this.rs;
                        continue;
                    }
                    --this.cursorPosition;
                    this.cursorY -= ih;
                }
            }
        }
    }

    private void scroll(Graphics g, int width, int height) {
        int s = this.totalItem;
        int rw = this.runnerWidth;
        if (s > this.showItem) {
            if (this.cursorPosition == 0) {
                this.runnerY = 0;
            }
            if (this.cursorPosition == s - 1) {
                this.runnerY = height - this.runnerHeight - 1;
            }
            GUIManager.getTheme().gradientFill(g, width - rw, 0, rw, height - 1, false, GUIManager.getTheme().scrollFieldFonRGB1, GUIManager.getTheme().scrollFieldFonRGB2);
            GUIManager.getTheme().gradientFill(g, width - rw + 1, this.runnerY, rw - 1, this.runnerHeight - 1, false, GUIManager.getTheme().scrollRGB1, GUIManager.getTheme().scrollRGB2);
            g.setColor(GUIManager.getTheme().scrollFrameRGB);
            g.drawRect(width - rw + 1, this.runnerY, rw - 1, this.runnerHeight - 1);
        }
    }

    private void setAppend(String[] stringParts, Image[] imageParts, boolean[] hide, boolean[] select) {
        this.setItems(stringParts);
        this.setIcons(imageParts);
        this.setHideFlags(hide);
        this.setSelectedFlags(select);
        this.reset();
    }

    public final void append(String stringPart, Image imagePart) {
        int sz = this.totalItem;
        if (stringPart != null) {
            String[] a = new String[sz + 1];
            Image[] imgs = new Image[sz + 1];
            boolean[] b = new boolean[sz + 1];
            boolean[] s = new boolean[sz + 1];
            for (int i = 0; i < sz; ++i) {
                a[i] = this.items[i];
                imgs[i] = this.icons[i];
                b[i] = this.hideFlags[i];
                s[i] = this.selectedFlags[i];
            }
            a[sz] = stringPart;
            imgs[sz] = imagePart;
            b[sz] = true;
            s[sz] = false;
            this.setAppend(a, imgs, b, s);
        }
    }

    public final void set(int index, String stringPart, Image imagePart) {
        if (index >= 0 && index < this.totalItem && stringPart != null && stringPart.equals("")) {
            this.items[index] = stringPart;
            this.icons[index] = imagePart;
            this.reset();
        }
    }

    public final void setHideFlag(int index, boolean b) {
        if (index >= 0 && index < this.totalItem) {
            this.hideFlags[index] = b;
            this.reset();
        }
    }

    private void setItems(String[] stringParts) {
        if (stringParts == null) {
            this.totalItem = 0;
            this.hideFlags = this.flagReset(true);
            this.selectedFlags = this.flagReset(false);
            this.resetIcons();
        } else {
            this.totalItem = stringParts.length;
        }
        this.items = stringParts;
    }

    private void setIcons(Image[] imgs) {
        if (imgs != null && imgs.length == this.totalItem) {
            this.icons = imgs;
        } else {
            this.resetIcons();
        }
    }

    private void setHideFlags(boolean[] b) {
        if (b == null || b.length != this.totalItem) {
            this.hideFlags = this.flagReset(true);
            return;
        }
        this.hideFlags = b;
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            if (b[i]) continue;
            ++j;
        }
        this.flagHideAll = j == b.length;
    }

    public final void setSelectedFlags(boolean[] b) {
        if (b == null || b.length != this.totalItem || this.type == 3) {
            this.selectedFlags = this.flagReset(false);
            if (this.type == 1) {
                this.setSelectedFlag(0, true);
            }
        } else if (this.type == 1) {
            for (int i = 0; i < this.totalItem; ++i) {
                b[i] = false;
            }
            b[0] = true;
            this.selectedFlags = b;
        } else {
            this.selectedFlags = b;
        }
    }

    public final boolean[] getSelectedFlags() {
        return this.selectedFlags;
    }

    public final Image getImage(int index) {
        if (index >= 0 && index < this.totalItem) {
            return this.icons[index];
        }
        return null;
    }

    public final Image[] getImages() {
        return this.icons;
    }

    public final int getSelectedIndex() {
        if (this.size() > 0) {
            return this.cursorPosition;
        }
        return -1;
    }

    public final String getString(int index) {
        if (index >= 0 && index < this.totalItem) {
            return this.items[index];
        }
        return null;
    }

    public final boolean[] getFlagsHide() {
        return this.hideFlags;
    }

    public final boolean getFlagHide(int index) {
        return this.hideFlags[index];
    }

    public final String[] getItems() {
        return this.items;
    }

    public final int size() {
        return this.totalItem;
    }

    public void delete(int elementNum) {
        int sz = this.totalItem;
        if (elementNum >= 0 && elementNum < sz) {
            String[] a = new String[sz - 1];
            Image[] imgs = new Image[sz - 1];
            boolean[] b = new boolean[sz - 1];
            boolean[] s = new boolean[sz - 1];
            int j = 0;
            for (int i = 0; i < sz; ++i) {
                if (i == elementNum) continue;
                a[j] = this.items[i];
                imgs[j] = this.icons[i];
                b[j] = this.hideFlags[i];
                s[j] = this.selectedFlags[i];
                ++j;
            }
            this.setAppend(a, imgs, b, s);
        }
    }

    public final void deleteAll() {
        this.setAppend(null, null, null, null);
    }

    public final int getType() {
        return this.type;
    }

    public final void setSelectedFlag(int elementNum, boolean flag) {
        int sz = this.totalItem;
        if (elementNum >= 0 && elementNum < sz) {
            if (this.type == 2) {
                this.selectedFlags[elementNum] = flag;
            } else if (this.type == 1) {
                for (int i = 0; i < sz; ++i) {
                    this.selectedFlags[i] = false;
                }
                this.selectedFlags[elementNum] = flag;
            }
        }
    }

    public final boolean isSelected(int elementNum) {
        if (elementNum >= 0 && elementNum < this.size()) {
            return this.selectedFlags[elementNum];
        }
        return false;
    }

    public final void insert(int elementNum, String stringPart, Image imagePart) {
        this.set(elementNum - 1, stringPart, imagePart);
    }

    public final void setSelectedIndex(int elementNum, boolean selected) {
        if (elementNum >= 0 && elementNum < this.totalItem) {
            this.cursorPosition = elementNum;
            this.setSelectedFlag(elementNum, selected);
        }
    }
}

