/*
 * Decompiled with CFR 0.152.
 */
package gps;

import gps.BluetoothConnection;

class SIRFMessages {
    private BluetoothConnection bt = null;
    private final int CHECKSUM_15BIT_LIMIT = Short.MAX_VALUE;
    private int[] SWITCH_SIRF_TO_NMEA_PAYLOAD = new int[]{129, 2, 1, 1, 0, 1, 5, 1, 5, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 18, 192};

    public SIRFMessages(BluetoothConnection bluetoothManager) {
        this.bt = bluetoothManager;
    }

    public void sendSIRFMessageToNMEAProtocol() {
        int[] sirfMessage = this.SWITCH_SIRF_TO_NMEA_PAYLOAD;
        this.bt.sendSIRFMessage(this.createSIRFMessage(sirfMessage));
    }

    public void sendSIRFMessageToNMEAProtocol(int GGARate, int GLLRate, int GSARate, int GSVRate, int MSSRate, int RMCRate, int VTGRate, int baud) {
        String temp = Integer.toHexString(baud);
        if (temp.length() == 3) {
            temp = '0' + temp;
        }
        int[] sirfMessage = new int[]{129, 2, 0 + Integer.parseInt(Integer.toHexString(GGARate), 16), 1, 0 + Integer.parseInt(Integer.toHexString(GLLRate), 16), 1, 0 + Integer.parseInt(Integer.toHexString(GSARate), 16), 1, 0 + Integer.parseInt(Integer.toHexString(GSVRate), 16), 1, 0 + Integer.parseInt(Integer.toHexString(MSSRate), 16), 1, 0 + Integer.parseInt(Integer.toHexString(RMCRate), 16), 1, 0 + Integer.parseInt(Integer.toHexString(VTGRate), 16), 1, 0, 1, 0, 1, 0, 1, '\u0000' + temp.charAt(0) + temp.charAt(1), '\u0000' + temp.charAt(2) + temp.charAt(3)};
        this.bt.sendSIRFMessage(this.createSIRFMessage(sirfMessage));
    }

    private int calculateSIRFChecksum(int[] message) {
        int checksum = 0;
        for (int index = 0; index < message.length; ++index) {
            checksum += message[index];
        }
        return checksum &= Short.MAX_VALUE;
    }

    private int[] createSIRFMessage(int[] payload) {
        int message_length = payload.length + 8;
        int[] message = new int[message_length];
        message[0] = 160;
        message[1] = 162;
        message[2] = (payload.length & 0xFF00) >> 8;
        message[3] = payload.length & 0xFF;
        System.arraycopy(payload, 0, message, 4, payload.length);
        int checksum = this.calculateSIRFChecksum(payload);
        message[message_length - 4] = (checksum & 0xFF00) >> 8;
        message[message_length - 3] = checksum & 0xFF;
        message[message_length - 2] = 176;
        message[message_length - 1] = 179;
        return message;
    }
}

